#include "ptexlib.h"
#include <kpathsea/c-vararg.h>
#include <kpathsea/c-proto.h>

integer pdfbufmax = pdfbufsize;

extern void epdf_check_mem(void);

int is_subsetable(int i)
{
    fm_entry *fm = fm_tab + i;
    return is_included(fm) && is_subsetted(fm) && get_enc(fm);
}

int is_ttf(int i)
{
    return is_truetype(fm_tab + i);
}

void mark_glyphs(int i, char *charset)
{
    char *new_charset = fm_tab[i].charset;
    if (charset == 0)
        return;
    if (new_charset == 0)
        new_charset = xstrdup(charset);
    else {
        new_charset = xretalloc(new_charset, 
                                strlen(new_charset) + strlen(charset) + 1,
                                char);
        strcat(new_charset, charset);
    }
    fm_tab[i].charset = new_charset;
}

void embed_whole_font(int i)
{
    fm_tab[i].all_glyphs = true;
}

integer get_fontfile(int i)
{
    return fm_tab[i].ff_objnum;
}

integer get_fontname(int i)
{
    if (fm_tab[i].fn_objnum == 0)
        fm_tab[i].fn_objnum = pdfnewobjnum();
    return fm_tab[i].fn_objnum;
}

void epdf_free(void)
{
    epdf_check_mem();
}
