#include <png.h>
#include <tiff.h>
#include <tiffio.h>

/* JPG_IMAGE_INFO is main structure for interchange of image data */

#define JPG_UINT16      unsigned int
#define JPG_UINT32      unsigned long
#define JPG_UINT8       unsigned char

typedef struct {
    int color_space;    /* used color space. See JPG_ constants */
    JPG_UINT8  bits_per_component; /* bits per component                         */
    JPG_UINT32 length;             /* length of file/data                        */
    FILE *file;                    /* jpg file                                   */
} JPG_IMAGE_INFO;

typedef struct {
    png_structp png_ptr;
    png_infop info_ptr;
} png_image_struct;

typedef struct {
    int orig_x;
    int orig_y;
    int selected_page;
    void *doc;
    void *xref;
} pdf_image_struct;

typedef struct {
    char *image_name;
    int image_type;
    int color_type;
    int width;
    int height;
    int x_res;
    int y_res;
    union {
        pdf_image_struct *pdf;
        png_image_struct png;
        JPG_IMAGE_INFO *jpg;
        TIFF *tif;
    } image_struct;
} image_entry;

extern image_entry *image_ptr, *image_tab;
extern integer image_max;

#define IMAGE_TYPE_NONE 0
#define IMAGE_TYPE_PDF  1
#define IMAGE_TYPE_PNG  2
#define IMAGE_TYPE_JPG  3
#define IMAGE_TYPE_TIF  4

#define IMAGE_COLOR_B   1
#define IMAGE_COLOR_C   2
#define IMAGE_COLOR_I   4

#define img_ptr(N)      (image_tab + (N))
#define img_name(N)     (img_ptr(N)->image_name)
#define img_type(N)     (img_ptr(N)->image_type)
#define img_color(N)    (img_ptr(N)->color_type)
#define img_width(N)    (img_ptr(N)->width)
#define img_height(N)   (img_ptr(N)->height)
#define img_xres(N)     (img_ptr(N)->x_res)
#define img_yres(N)     (img_ptr(N)->y_res)
#define png_ptr(N)      (img_ptr(N)->image_struct.png.png_ptr)
#define png_info(N)     (img_ptr(N)->image_struct.png.info_ptr)
#define pdf_ptr(N)      (img_ptr(N)->image_struct.pdf)
#define jpg_ptr(N)      (img_ptr(N)->image_struct.jpg)
#define tif_ptr(N)      (img_ptr(N)->image_struct.tif)

extern void read_pdf_info(char*, integer);
extern void write_epdf(void);
extern void epdf_delete(void);
extern void read_png_info(integer);
extern void write_png(integer);
extern void read_jpg_info(integer);
extern void write_jpg(integer);
extern void read_tif_info(integer);
extern void write_tif(integer);
