/* -----------------------------------------------------------------------
 * This is TIFF support to pdfTeX.
 * -----------------------------------------------------------------------
 */

#ifdef HAVE_TIFF

#include "ptexlib.h"
#include "image.h"

void read_tiff_info(integer img)
{
    float xres = 72.0, 
          yres = 72.0; /* default resolution */
    unsigned short units;
    tif_ptr(img) = TIFFOpen(img_name(img), FOPEN_RBIN_MODE);
    if (tif_ptr(img) == 0)
        pdftex_fail("reading TIFF image failed");
    TIFFGetField(tif_ptr(img), TIFFTAG_IMAGELENGTH, &(img_ptr(img)->height));
    TIFFGetField(tif_ptr(img), TIFFTAG_IMAGEWIDTH, &(img_ptr(img)->width));
    TIFFGetField(tif_ptr(img), TIFFTAG_XRESOLUTION, &xres);
    TIFFGetField(tif_ptr(img), TIFFTAG_YRESOLUTION, &yres);
    TIFFGetField(tif_ptr(img), TIFFTAG_RESOLUTIONUNIT, &units);
    switch (units) {
    case RESUNIT_INCH: /* pixels per inch */
        break;
    case RESUNIT_CENTIMETER: /* pixels per cm */
        xres *= 2.54;
        yres *= 2.54;
        break;
    case RESUNIT_NONE: /* no resolution */
        xres = 0;
        yres = 0; 
        break;
    }
    img_ptr(img)->x_res = xres;
    img_ptr(img)->y_res = yres;
    img_color(img) = IMAGE_COLOR_C;
}

void write_tiff(integer img)
{
    /*
    long unsigned row, col;
    unsigned long int *raster = (unsigned long int *) 
        _TIFFmalloc(img_ptr(img)->height*img_ptr(img)->width*
                    sizeof(unsigned long int));
    pdf_printf("/Type /XObject\n/Subtype /Image\n/Width %i\n/Height %i\n/BitsPerComponent 8\n",
               (int)img_ptr(img)->width,
               (int)img_ptr(img)->height);
    pdf_puts("/ColorSpace /DeviceRGB\n");
    TIFFReadRGBAImage(tif_ptr(img), img_ptr(img)->width, img_ptr(img)->height, raster, 0);
    pdfbeginstream();
    for (row = 0; row<tif_ptr(img)->height; row++)
        for (col = 0; col<tif_ptr(img)->width; col++)
        {
            pdfroom(3);
            pdfbuf[pdfptr++] = TIFFGetR(*(raster+col+tif_ptr(img)->width*(tif_ptr(img)->height-1-row)));
            pdfbuf[pdfptr++] = TIFFGetG(*(raster+col+tif_ptr(img)->width*(tif_ptr(img)->height-1-row)));
            pdfbuf[pdfptr++] = TIFFGetB(*(raster+col+tif_ptr(img)->width*(tif_ptr(img)->height-1-row)));
        }
    pdfflush();
    pdfendstream();
    */
}
#endif
