#ifndef PDFTEXLIB
#define PDFTEXLIB

/* WEB2C macros and prototypes */
#if !defined(PDFTEXCOERCE) && !defined(PDFETEXCOERCE)
#ifdef pdfTeX
#undef pdfTeX /* to avoid warning about redefining pdfTeX in pdftexd.h */
#endif /* pdfTeX */
#define EXTERN extern
#include "pdftexd.h"
#endif

/* pdftexlib macros */
#include "ptexmac.h"

/* pdftexlib type declarations */
typedef struct {
    char *pdfname;
    char *t1name;
    union {
        float num;
        char *string;
    } value;
    boolean valid;
} key_entry;

typedef struct {
    boolean loaded;     /* the encoding has been loaded? */
    boolean mapped;     /* 0--32 chars have been mapped to higher area? */
    boolean updated;    /* glyph names have been updated for 0--32 chars? */
    internalfontnumber firstfont;   /* first font that has accessed to this
                                       encoding; move chars 0--32 to higher
                                       area according to this font */
    char *name;         /* encoding file name */
    integer objnum;     /* object number */
    char **glyph_names;
} enc_entry;

typedef struct {
    char *tfm_name;         /* TFM file name */
    char *ps_name;          /* PostScript name */
    integer flags;          /* font flags */
    char *ff_name;          /* font file name */
    char *ex_name;          /* expanded font file name */
    char *subset_tag;       /* pseudoUniqueTag for subsetted font */
    int encoding;           /* index to table of encoding vectors */
    internalfontnumber tfm; /* base TFM font */
    int type;               /* font type (T1/TTF/...) */
    integer slant;          /* SlantFont */
    integer extend;         /* ExtendFont */
    integer ff_objnum;      /* font file object number */
    integer fn_objnum;      /* font name object number */
    char *charset;          /* string containing used glyphs */
    boolean found;          /* to avoid researching fonts that have been found */
    boolean all_glyphs;     /* embed all glyphs */
} fm_entry;

typedef short shalfword ;
typedef short Boolean ;
typedef struct {
   integer charcode,
           cwidth, 
           cheight,
           xoff, 
           yoff, 
           xescape,
           rastersize;
   halfword *raster;
} chardesc;

/* pdftexlib variable declarations */
extern strnumber last_tex_string;
extern fm_entry *fm_cur, *fm_ptr, *fm_tab;
extern enc_entry *enc_ptr, *enc_tab;
extern char *cur_file_name;
extern char *mapfiles;
extern internalfontnumber tex_font;
extern integer t1_length1, t1_length2, t1_length3;
extern char **t1_glyph_names, *t1_builtin_glyph_names[];
extern integer ttf_length;
extern char notdef[];
extern boolean fontfile_found;
extern boolean last_true_dimen;
extern key_entry font_keys[];

/* pdftexlib function prototypes */

/* config.c */
extern integer cfgpar(integer);
extern void magnifycfgdimens(scaled);
extern void readconfigfile(void);

/* mapfile.c */
extern fm_entry *fm_ext_entry(internalfontnumber, fm_entry *);
extern int lookup_fontmap(char *);
extern integer fmlookup(strnumber, internalfontnumber);
extern void fix_ffname(fm_entry *, char *);
extern void fm_free(void);
extern void fm_read_info(void);
extern void setcharmap(internalfontnumber);

/* papersiz.c */
extern integer myatodim(char **);
extern integer myatol(char **);

/* pkin.c */
extern int readchar(boolean, chardesc *);

/* utils.c */
extern boolean str_eq_cstr(strnumber, char *);
extern char *makecstring(integer);
extern int xfflush(FILE *);
extern int xputc(int, FILE *);
extern int xgetc(FILE *);
extern integer ff_offset(void);
extern size_t xfwrite(void *, size_t size, size_t nmemb, FILE *);
extern strnumber getresnameprefix(int, int, int, int);
extern strnumber maketexstring(char *);
extern void ff_flush(void);
extern void ff_putchar(eightbits b);
extern void ff_seek(integer);
extern void libpdffinish(void);
extern void pdf_printf(char *,...);
extern void pdf_puts(char *);
extern void pdftex_fail(char *,...);
extern void pdftex_warn(char *,...);
extern void tex_printf(char *, ...);
extern void writestreamlength(integer, integer);

/* vfpacket.c */
extern eightbits packetbyte(void);
extern integer newvfpacket(internalfontnumber);
extern void poppacketstate(void);
extern void pushpacketstate(void);
extern void startpacket(internalfontnumber, integer);
extern void storepacket(integer, integer, integer);
extern void vf_free(void);

/* writeenc.c */
extern boolean get_enc(fm_entry *);
extern integer add_enc(char *);
extern void enc_free(void);
extern void read_enc(integer);
extern void update_enc(internalfontnumber, char **);
extern void write_enc(char **, integer);

/* writefont.c */
extern void dopdffont(integer, internalfontnumber);

/* writeimg.c */
extern boolean checkimageb(integer);
extern boolean checkimagec(integer);
extern boolean checkimagei(integer);
extern boolean ispdfimage(integer);
extern integer epdforigx(integer);
extern integer epdforigy(integer);
extern integer imageheight(integer);
extern integer imagetype(integer);
extern integer imagewidth(integer);
extern integer imagexres(integer);
extern integer imageyres(integer);
extern integer readimage(integer);
extern void deleteimage(integer);
extern void img_free(void) ;
extern void updateimageprocset(integer);
extern void writeimage(integer);

/* writet1.c */
extern boolean t1_read_enc(fm_entry *);
extern boolean t1_subset(char *, char *, unsigned char *);
extern void load_enc(char *, char **);
extern void writet1(void);

/* writet3.c */
extern void writet3(int, internalfontnumber);

/* writettf.c */
extern void writettf(void);

/* writezip.c */
extern void writezip(boolean);

#endif  /* PDFTEXLIB */
