/* WEB2C macros and prototypes */
#define EXTERN extern
#ifdef pdfTeX /* pdfTeX is undefined when ptexlib.h is used with dvips */
#undef pdfTeX /* to avoid warning about redefining pdfTeX in pdftexd.h */
#endif
#include "pdftexd.h"

/* pdftexlib macros */
#include "ptexmac.h"

/* pdftexlib type declarations */
typedef struct {
    char *pdfname;
    char *t1name;
    union {
        float num;
        char *string;
    } value;
    boolean valid;
} key_entry;

typedef struct {
    boolean loaded;     /* the encoding has been loaded? */
    boolean mapped;     /* 0--32 chars have been mapped to higher area? */
    boolean updated;    /* glyph names have been updated for 0--32 chars? */
    internalfontnumber firstfont;   /* first font that has accessed to this
                                       encoding; move chars 0--32 to higher
                                       area according to this font */
    char *name;         /* encoding file name */
    integer objnum;     /* object number */
    char **glyph_names;
} enc_entry;

typedef struct {
    char *tfm_name;         /* TFM file name */
    char *base_name;        /* PostScript name */
    integer flags;          /* font flags */
    char *ff_name;          /* font file name */
    char *ex_name;          /* expanded font file name */
    char *subset_tag;       /* pseudoUniqueTag for subsetted font */
    int encoding;           /* index to table of encoding vectors */
    internalfontnumber texfont; /* inverse of pdffontmap */
    int type;               /* font type (T1/TTF/...) */
    integer slant;          /* SlantFont */
    integer extend;         /* ExtendFont */
    integer ff_objnum;      /* font file object number */
    integer fn_objnum;      /* font name object number */
    char *charset;          /* string containing used glyphs */
    boolean found;          /* to avoid researching fonts that have been found */
    boolean all_glyphs;     /* embed all glyphs */
} fm_entry;

typedef short shalfword ;
typedef short Boolean ;
typedef struct {
   integer charcode,
           cwidth, 
           cheight,
           xoff, 
           yoff, 
           xescape,
           designsize,
           checksum,
           tfm_width,
           rastersize;
   halfword *raster;
} chardesc;


/* pdftexlib variable declarations */
extern fm_entry *fm_cur, *fm_ptr, *fm_tab;
extern enc_entry *enc_ptr, *enc_tab;
extern char *cur_file_name;
extern char *mapfiles;
extern internalfontnumber tex_font;
extern integer t1_length1, t1_length2, t1_length3;
extern char **t1_glyph_names, *t1_builtin_glyph_names[];
extern integer ttf_length;
extern char notdef[];
extern char nontfm[];
extern boolean fontfile_found;
extern key_entry font_keys[];


/* pdftexlib function prototypes */

/* prototypes for functions from config.c */
extern integer cfgpar(integer code);
extern void magnifycfgdimens(scaled mag);
extern void readconfigfile();

/* prototypes for functions from epdf.c */
extern int is_subsetable(int i);
extern integer get_fontfile_num(int i);
extern integer get_fontname_num(int i);
extern void embed_whole_font(int i);
extern void epdf_free(void);
extern void mark_glyphs(int i, char *charset);

/* prototypes for functions from mapfile.c */
mapfile.c	/^fm_entry *fm_ext_entry(internalfontnumber f, fm_en/
extern int lookup_fontmap(char *bname);
mapfile.c	/^integer fmlookup(strnumber s, internalfontnumber f/
extern void fix_ffname(fm_entry *fm, char *name);
extern void fm_free(void);
extern void fm_read_info(void);
extern void setcharmap(internalfontnumber f);

/* prototypes for functions from papersiz.c */
extern integer myatodim(char **s);
extern integer myatol(char **s);

/* prototypes for functions from pkin.c */
extern getbit(void);
extern getnyb(void);
pkin.c	/^int readchar(boolean check_preamble, chardesc *cd)/
extern pkbyte(void);
extern pkduo(void);
extern pkquad(void);
extern pktrio(void);

/* prototypes for functions from utils.c */
extern boolean str_eq_cstr(strnumber n, char *s);
extern char *makecstring(integer s);
extern int xfflush(FILE *stream);
extern int xputc(int c, FILE *stream);
extern integer ff_offset(void);
utils.c	/^size_t xfwrite(void *ptr, size_t size, size_t nmem/
utils.c	/^strnumber getresnameprefix(integer year, integer m/
extern strnumber maketexstring(char *s);
extern void ff_flush(void);
extern void ff_putchar(eightbits b);
extern void ff_seek(integer offset);
extern void libpdffinish();
extern void pdf_printf(char *fmt,...);
extern void pdf_puts(char *s);
extern void pdftex_fail(char *fmt,...);
extern void pdftex_warn(char *fmt,...);
extern void tex_printf(char *fmt, ...);
utils.c	/^void writestreamlength(integer length, integer off/

/* prototypes for functions from vfpacket.c */
extern eightbits packetbyte();
extern integer newvfpacket(internalfontnumber f);
extern void poppacketstate();
extern void pushpacketstate();
extern void startpacket(internalfontnumber f, integer c);
extern void storepacket(integer f, integer c, integer s);
extern void vf_free(void);

/* prototypes for functions from writeenc.c */
extern boolean get_enc(fm_entry *fm);
writeenc.c	/^integer add_enc(char *s) \/* built-in encodings hav/
extern void enc_free();
extern void read_enc(integer encoding);
writeenc.c	/^void update_enc(internalfontnumber f, char **glyph/
extern void write_enc(char **glyph_names, integer n);

/* prototypes for functions from writefont.c */
writefont.c	/^void dopdffont(integer font_objnum, internalfontnu/

/* prototypes for functions from writeimg.c */
extern boolean checkimageb(integer procset);
extern boolean checkimagec(integer procset);
extern boolean checkimagei(integer procset);
extern boolean ispdfimage(integer img);
extern integer epdforigx(integer img);
extern integer epdforigy(integer img);
extern integer imageheight(integer img);
extern integer imagetype(integer img);
extern integer imagewidth(integer img);
extern integer imagexres(integer img);
extern integer imageyres(integer img);
extern integer readimage(integer page_num);
extern void deleteimage(integer img);
extern void img_free() ;
extern void updateimageprocset(integer procset);
extern void writeimage(integer img);

/* prototypes for functions from writejpg.c */
extern integer read_jpg_info(integer img);
extern void write_jpg(integer img);

/* prototypes for functions from writepng.c */
extern integer read_png_info(integer img);
extern void write_png(integer img);

/* prototypes for functions from writet1.c */
extern boolean t1_read_enc(fm_entry *fm);
writet1.c	/^boolean t1_subset(char *fontfile, char *encfile, u/
extern void load_enc(char *enc_name, char **glyph_names);
extern void writet1(void);

/* prototypes for functions from writet3.c */
extern void writet3(int objnum, internalfontnumber f);

/* prototypes for functions from writetiff.c */
extern integer read_tiff_info(integer img);
extern void write_tiff(integer img);

/* prototypes for functions from writettf.c */
extern void static ttf_select_cmap(void);
extern void writettf();

/* prototypes for functions from writezip.c */
extern void writezip(boolean finish);

/*
extern int xgetc(FILE *);
extern int xputc(int, FILE *);
extern size_t xfwrite(void *, size_t, size_t, FILE *);
extern int xfflush(FILE *);
extern integer ff_offset(void);
extern void ff_seek(integer);
extern void ff_putchar(eightbits);
extern void ff_flush(void);
extern void pdftex_fail(char *, ...);
extern void pdftex_warn(char *, ...);
extern void pdf_printf(char *, ...);
extern void pdf_puts(char *);
extern void tex_printf(char *, ...);
extern strnumber maketexstring(char *);
extern char *makecstring(integer);
extern boolean str_eq_cstr(strnumber, char *);
extern void fm_read_info(void);
extern fm_entry *fm_ext_entry(internalfontnumber, fm_entry *);
extern void fix_ffname(fm_entry *, char *);
extern integer myatol(char **);
extern integer myatodim(char **);
extern boolean t1_read_enc(fm_entry *);
extern void writet1(void);
extern void writettf(void);
extern void writet3(int, internalfontnumber);
extern int readchar(boolean , chardesc *cd);
extern integer add_enc(char *);
extern boolean get_enc(fm_entry *);
extern void read_enc(integer);
extern void load_enc(char *, char **);
extern void write_enc(char **, integer);
extern void update_enc(internalfontnumber, char**);
extern void enc_free(void);
extern void epdf_free(void);
extern void fm_free(void);
extern void img_free(void);
extern void vf_free(void);
*/
