#include "png.h"

/*
    Old versions of libpng do not contain some functions that pdfTeX uses, so
    we must use correct library.
    Fri Sep  4 23:40:11 CEST 1998 (pj)

    If your compiler can not eat this, you should use ANSI-C compliant one.
    Please report it to pdfTeX@tug.org too.
    Thu Sep 10 22:18:29 CEST 1998 (pj)
*/

#if PNG_LIBPNG_VER < 10001
#error "Your system libpng is too old for pdfTeX, please use pdfTeX's one."
#endif /* PNG_LIBPNG_VER < 10001 */

#include "jpg.h"
#include "tiffx.h"

#define pdf_info(N)               ((image_tab + (N))->image_struct.pdf)
#define png_ptr(N)                ((image_tab + (N))->image_struct.png.png_ptr)
#define png_info(N)               ((image_tab + (N))->image_struct.png.info_ptr)
#define jpg_info(N)               ((image_tab + (N))->image_struct.jpg)
#define tiff_info(N)              ((image_tab + (N))->image_struct.tiff)
#define img_name(N)               ((image_tab + (N))->image_name)
#define img_type(N)               ((image_tab + (N))->image_type & 0xFF)
#define set_img_type(N, T)        (image_tab + (N))->image_type |= (T) & 0xFF
#define set_img_color_type(N, C)  (image_tab + (N))->image_type |= (C)

#define IMAGE_TYPE_PDF  0
#define IMAGE_TYPE_PNG  1
#define IMAGE_TYPE_JPG  2
#define IMAGE_TYPE_TIFF 3

#define IMAGE_COLOR_B   0x100
#define IMAGE_COLOR_C   0x200
#define IMAGE_COLOR_I   0x400

typedef struct {
    png_structp png_ptr;
    png_infop info_ptr;
} png_image_struct;

typedef struct {
    int width;
    int height;
    int orig_x;
    int orig_y;
    int selected_page;
    void *doc;
    void *xref;
} pdf_image_struct;

typedef struct {
    short image_type;
    char *image_name;
    union {
        pdf_image_struct *pdf;
        png_image_struct png;
        JPG_IMAGE_INFO *jpg;
        TIFF_IMAGE_INFO *tiff;
    } image_struct;
} image_entry;

extern image_entry *image_ptr, *image_tab;
extern integer image_max;

extern integer read_pdf_info(char*, integer);
extern void write_epdf(integer);
extern void epdf_delete(void);
extern void epdf_free(void);
extern integer read_png_info(integer);
extern void write_png(integer);
extern integer read_jpg_info(integer);
extern void write_jpg(integer);
extern integer read_tiff_info(integer);
extern void write_tiff(integer);
