#include "ptexlib.h"

#define NO_ZIP      0
#define WRITE_ZIP   1
#define FINISH_ZIP  2

static char print_buf[PRINTF_BUF_SIZE];
static integer write_zip_stage = NO_ZIP;
static integer stream_length_obj;
static boolean flushing_stream_buf = false;
static boolean writing_stream = false;
integer stream_length;


static void set_text_buf()
{
    if (pdfbuf == pdftextbuf)
        pdftex_fail("invalid call of set_text_buf()");
    pdfbuf = pdftextbuf;
    pdfbufsize = pdftextsize;
}

static void set_stream_buf()
{
    if (pdfbuf == pdfstreambuf)
        pdftex_fail("invalid call of set_stream_buf()");
    pdfbuf = pdfstreambuf;
    pdfbufsize = pdfstreamsize;
}

static void pdf_stream_head()
{
    if (stream_length_obj == 0)
        pdf_printf("/Length %i\n",  (int)stream_length);
    else
        pdf_printf("/Length %i 0 R\n",  (int)stream_length_obj);
    if (fixedcompresslevel() > 0)
        pdf_puts("/Filter /FlateDecode\n");
    pdf_puts(">>\n");
    pdf_puts("stream\n");
}

static void pdf_stream_tail()
{
    pdf_puts("endstream\nendobj\n");
    if (stream_length_obj != 0) {
        pdfbeginobj(stream_length_obj);
        pdf_printf("%i\nendobj\n", stream_length);
    }
}

void write_pdfbuf(integer zip_stage)
{
    switch (zip_stage) {
    case NO_ZIP:
        if (pdfptr > 0)
            writepdf(0, pdfptr - 1);
        pdfgone += pdfptr;
        if (writing_stream)
            stream_length += pdfptr;
        pdfptr = 0;
        break;
    case WRITE_ZIP:
        if (pdfptr > 0)
            writezip(false);
        break;
    case FINISH_ZIP:
        writezip(true);
        write_zip_stage = NO_ZIP;
        break;
    }
}

void buf_flush(eightbits *buf, eightbits *ptr)
{
    eightbits *p;
    integer n;
    for (p = buf; p < ptr;) {
        n = pdfbufsize - pdfptr;
        if (ptr - p < n)
            n = ptr - p;
        memcpy(pdfbuf + pdfptr, p, n);
        pdfptr += n;
        if (pdfptr == pdfbufsize)
            write_pdfbuf(write_zip_stage);
        p += n;
    }
}

void pdfflush()
{
    ensurepdfopen();
    /* check whether we must write use indirect object for stream length */
    if (writing_stream && pdfptr == pdfstreamsize && stream_length_obj == 0) {
        stream_length_obj = pdfnewobjnum();
        set_text_buf();
        pdfptr = pdftextptr;
        pdf_stream_head();
        write_pdfbuf(NO_ZIP);
        set_stream_buf();
        pdfptr = pdfstreamsize;
    }
    write_pdfbuf(write_zip_stage);
}

void pdfbeginstream()
{
    write_pdfbuf(NO_ZIP);
    stream_length_obj = 0;
    stream_length = 0;
    if (fixedcompresslevel() > 0)
        write_zip_stage = WRITE_ZIP;
    writing_stream = true;
    set_stream_buf();
    pdfptr = 0;
}

void pdfendstream()
{
    if (stream_length_obj == 0) {
        pdfstreamptr = pdfptr;
        set_text_buf();
        pdfptr = pdftextptr;
        pdf_stream_head();
        write_pdfbuf(NO_ZIP);
        set_stream_buf();
        pdfptr = pdfstreamptr;
    }
    if (fixedcompresslevel() > 0)
        write_zip_stage = FINISH_ZIP;
    write_pdfbuf(write_zip_stage);
    writing_stream = false;
    set_text_buf();
    pdf_stream_tail();
}
