#include "ptexlib.h"
#include <kpathsea/c-vararg.h>
#include <kpathsea/c-proto.h>

extern void epdf_check_mem(void);

int is_subsetable(int);
void mark_glyphs(int, char *);
void embed_whole_font(int);
integer fontfile_objnum(int);
integer fontname_objnum(int);

int is_subsetable(int font)
{
    fm_entry *fm = fm_tab + pdffontmap[font];
    return is_included(fm) && is_subsetted(fm) && get_enc(fm);
}

void mark_glyphs(int texfont, char *charset)
{
    char *new_charset = fm_tab[pdffontmap[texfont]].charset;
    if (charset == 0)
        return;
    if (new_charset == 0)
        new_charset = xstrdup(charset);
    else {
        new_charset = xretalloc(new_charset, 
                                strlen(new_charset) + strlen(charset) + 1,
                                char);
        strcat(new_charset, charset);
    }
    fm_tab[pdffontmap[texfont]].charset = new_charset;
}

void embed_whole_font(int font)
{
    fm_tab[pdffontmap[font]].all_glyphs = true;
}

integer get_fontfile_num(int font)
{
    return fm_tab[pdffontmap[font]].ff_objnum;
}

integer get_fontname_num(int font)
{
    fm_entry *p = fm_tab + pdffontmap[font];
    if (p->fn_objnum == 0)
        p->fn_objnum = pdfnewobjnum();
    return p->fn_objnum;
}

void epdf_free(void)
{
    epdf_check_mem();
}
