#include "ptexlib.h"
#include "image.h"

integer read_png_info(integer img)
{
    FILE *png_file = xfopen(img_name(img), FOPEN_RBIN_MODE);
    if ((png_ptr(img) = png_create_read_struct(PNG_LIBPNG_VER_STRING, 
        NULL, NULL, NULL)) == NULL)
        pdftex_fail("png_create_read_struct() failed");
    if ((png_info(img) = png_create_info_struct(png_ptr(img))) == NULL)
        pdftex_fail("png_create_info_struct() failed");
    if (setjmp(png_ptr(img)->jmpbuf))
        pdftex_fail("setjmp() failed");
    png_init_io(png_ptr(img), png_file);
    png_read_info(png_ptr(img), png_info(img));
    if (png_info(img)->color_type & PNG_COLOR_MASK_ALPHA) {
/*
   Before pdftex-0.12o-1 we failed when touching png with alpha channel, now we
   strip this channel. 09/06/1998 Pavel Jank ml.
*/
        png_set_strip_alpha(png_ptr(img));
        pdftex_warn("can't handle alpha channel correctly, stripped (please report bugs to pdftex@tug.org)");
    }
    if (png_info(img)->interlace_type != 0) {
/*
   Before pdftex-0.12o-1 we failed when touching interlaced png, now it's ok.
   09/06/1998 Pavel Jank ml.
*/
        png_bytep row = xtalloc(png_info(img)->rowbytes, png_byte);
        int i, number_of_passes = png_set_interlace_handling(png_ptr(img));
        while (number_of_passes-->1) {
            for (i = 0; i < png_info(img)->height; i++)
                png_read_row(png_ptr(img), row, NULL);
        }
        xfree(row);
        pdftex_warn("experimental support for interlaced png (please report bugs to pdftex@tug.org)");
    }
    if (png_info(img)->bit_depth == 16) {
        png_set_strip_16(png_ptr(img));
        pdftex_warn("can't handle 16 bits per channel, strip down to 8 bits");
    }
    png_read_update_info(png_ptr(img), png_info(img));
    switch (png_info(img)->color_type) {
    case PNG_COLOR_TYPE_PALETTE:
        set_img_color_type(img, IMAGE_COLOR_C);
        set_img_color_type(img, IMAGE_COLOR_I);
        break;
    case PNG_COLOR_TYPE_GRAY:
    case PNG_COLOR_TYPE_GRAY_ALPHA:
        set_img_color_type(img, IMAGE_COLOR_B);
        break;
    case PNG_COLOR_TYPE_RGB:
    case PNG_COLOR_TYPE_RGB_ALPHA:
        set_img_color_type(img, IMAGE_COLOR_C);
        break;
    default:
        pdftex_fail("unsupported type of color_type <%i>", png_info(img)->color_type);
    }
    return 0;
}

void write_png(integer img)
{
    int i, j;
    integer palette_objnum = 0;
    png_bytep row = xtalloc(png_info(img)->rowbytes, png_byte);
    pdf_puts("/Type /XObject\n/Subtype /Image\n");
    pdf_printf("/Width %i\n/Height %i\n/BitsPerComponent %i\n",
               (int)png_info(img)->width,
               (int)png_info(img)->height,
               (int)png_info(img)->bit_depth);
    pdf_puts("/ColorSpace ");
    switch (png_info(img)->color_type) {
    case PNG_COLOR_TYPE_PALETTE:
        pdfcreateobj(0, 0);
        palette_objnum = objptr;
        pdf_printf("[/Indexed /DeviceRGB %i %i 0 R]\n",
                   (int)(png_info(img)->num_palette - 1),
                   (int)palette_objnum);
        break;
    case PNG_COLOR_TYPE_GRAY:
    case PNG_COLOR_TYPE_GRAY_ALPHA:
        pdf_puts("/DeviceGray\n");
        break;
    case PNG_COLOR_TYPE_RGB:
    case PNG_COLOR_TYPE_RGB_ALPHA:
        pdf_puts("/DeviceRGB\n");
        break;
    default:
        pdftex_fail("unsupported type of color_type <%i>", png_info(img)->color_type);
    }
    pdfbeginstream();
    for (i = 0; i < png_info(img)->height; i++) {
    	png_read_row(png_ptr(img), row, NULL);
        for (j = 0; j < png_info(img)->rowbytes; j++) {
            pdfbuf[pdfptr++] = row[j];
            if (pdfptr == pdfbufsize)
                pdfflush();
        }
    }
    pdfendstream();
    if (palette_objnum > 0) {
        pdfbegindict(palette_objnum);
        pdfbeginstream();
        for (i = 0; i < png_info(img)->num_palette; i++) {
            if (pdfptr + 3 >= pdfbufsize)
                pdfflush();
            pdfbuf[pdfptr++] = png_info(img)->palette[i].red;
            pdfbuf[pdfptr++] = png_info(img)->palette[i].green;
            pdfbuf[pdfptr++] = png_info(img)->palette[i].blue;
        }
        pdfendstream();
    }
    xfree(row);
    pdfflush();
}
