#include "ptexlib.h"
#include "zlib.h"

key_entry font_keys[FONT_KEYS_NUM] = {
    {"Ascent",       "Ascender",     {0}, false},
    {"CapHeight",    "CapHeight",    {0}, false},
    {"Descent",      "Descender",    {0}, false},
    {"FontName",     "FontName",     {0}, false},
    {"ItalicAngle",  "ItalicAngle",  {0}, false},
    {"StemV",        "StdVW",        {0}, false},
    {"XHeight",      "XHeight",      {0}, false},
    {"FontBBox",     "FontBBox",     {0}, false},
    {"",             "",             {0}, false},
    {"",             "",             {0}, false},
    {"",             "",             {0}, false}
};

internalfontnumber tex_font;
boolean fontfile_found;
static int first_char, last_char;
static integer char_widths[MAX_CHAR_CODE + 1];
static boolean write_fontfile_only;
static int char_widths_objnum,
           encoding_objnum,
           fontfile_objnum,
           fontname_objnum,
           fontdesc_objnum,
           length_objnum,
           length1_objnum,
           length2_objnum,
           length3_objnum;
static char **cur_glyph_names;


static void print_key(integer code, integer v)
{
    pdf_printf("/%s ", font_keys[code].pdfname);
    if (!font_keys[code].valid) {
        pdf_printf("%i",
                   (code == ITALIC_ANGLE_CODE) ? (int)v :
                   (int)dividescaled(v, pdffontsize[tex_font], 3));
    }
    else 
        pdf_printf("%i", (int)font_keys[code].value.i);
    pdf_puts("\n");
}

static integer getitalicangle(void)
{
    return -atan(getslant(tex_font)/65536.0)*(180/M_PI);
}

static integer getstemv(void)
{
    return getcharwidth(tex_font, '!')/3;
}

static void getbbox(void)
{
    font_keys[FONTBBOX1_CODE].value.i = 0;
    font_keys[FONTBBOX2_CODE].value.i = 
        dividescaled(-getchardepth(tex_font, 'g'), pdffontsize[tex_font], 3);
    font_keys[FONTBBOX3_CODE].value.i =
        dividescaled(getquad(tex_font), pdffontsize[tex_font], 3);
    font_keys[FONTBBOX4_CODE].value.i =
        dividescaled(getcharheight(tex_font, 'H'), pdffontsize[tex_font], 3);
}

static char *make_subset_tag(void)
{
    integer w;
    int i, k;
    unsigned long w_crc;
    static char crc_buf[2*(MAX_CHAR_CODE + 1)], tag[7];
    char *p = tag;
    unsigned char b;
    for (i = 0; i < 2*(MAX_CHAR_CODE + 1); i += 2) {
        w = char_widths[i/2];
        if (w == 0)
            w = 1000;
        crc_buf[i] = (w >> 8) & 0xFF;
        crc_buf[i + 1] = w & 0xFF;
    }
    w_crc = adler32(1L, crc_buf, 2*(MAX_CHAR_CODE + 1)) & 
            (unsigned long)((1 << 30) - 1);
    for (i = 0; i < 6; i++) {
        k = 5*(5 - i); 
        *p++ = 'A' + (w_crc >> k)/6; /* 'A' + <highest 5 bits>/6 ==> A-F */
        w_crc &= (unsigned long)((1 << k) - 1);
    }
    *p = 0;
    return xstrdup(tag);
}

static void update_char_widths(void)
{
    int i;
    first_char = fontbc[tex_font];
    last_char = MAX_CHAR_CODE; /* N.B.: not fontec[tex_font] */
    for (i = first_char; i <= last_char && !pdfcharmarked(tex_font, i); i++);
    if (i > last_char) { /* no char is used, write font file only */
        write_fontfile_only = true;
        return;
    }
    first_char = i; 
    write_fontfile_only = false;
    for (i = last_char; !pdfcharmarked(tex_font, i); i--);
    last_char = i; 
    for (i = 0; i <= MAX_CHAR_CODE; i++)
        if (charvalid(tex_font, i))
            char_widths[i] = getcharwidth(tex_font, i);
        else
            char_widths[i] = 0;
    for (i = fontbc[tex_font]; i < 32; i++)
        char_widths[pdfcharmap[tex_font][i]] = char_widths[i];
    for (i = 0; i <= MAX_CHAR_CODE; i++)
        if (!pdfcharmarked(tex_font, i))
            char_widths[i] = 0;
    for (i = first_char; i <= last_char; i++)
        if (char_widths[i] != 0)
            char_widths[i] = dividescaled(char_widths[i], 
                                          pdffontsize[tex_font], 3);
}

static void write_char_widths(void)
{
    int i;
    pdfbeginobj(char_widths_objnum); 
    pdf_puts("[ ");
    for (i = first_char; i <= last_char; i++)
        pdf_printf("%i ", char_widths[i]);
    pdf_puts("]\nendobj\n");
}

static void write_fontobj(integer font_objnum)
{
    int i;
    encoding_objnum = 0;
    if ((is_reencoded(fm_cur))) {
        read_enc(fm_cur->encoding);
        if (!is_truetype(fm_cur)) {
            write_enc(0, fm_cur->encoding);
            encoding_objnum = enc_tab[fm_cur->encoding].objnum;
        }
    }
    else if (!is_basefont(fm_cur) && !is_truetype(fm_cur))
        encoding_objnum = pdfnewobjnum();
    pdfbegindict(font_objnum);
    pdf_puts("/Type /Font\n");
    if (pdfexpandfont[tex_font] != 0)
        pdf_printf("%% expand ratio = %i\n", (int)pdfexpandfont[tex_font]);
    pdf_printf("/Subtype /%s\n", is_truetype(fm_cur) ? "TrueType" : "Type1");
    if (encoding_objnum != 0)
        pdf_printf("/Encoding %i 0 R\n", (int)encoding_objnum);
    if (is_basefont(fm_cur)) {
        pdf_printf("/BaseFont /%s\n>> endobj\n", fm_cur->base_name);
        return;
    }
    char_widths_objnum = pdfnewobjnum();
    pdf_printf("/FirstChar %i\n/LastChar %i\n/Widths %i 0 R\n",
               first_char, last_char, char_widths_objnum);
    if (is_noparsing(fm_cur))
        pdf_printf("/BaseFont /%s\n", fm_cur->base_name);
    else {
        fontdesc_objnum = pdfnewobjnum();
        pdf_printf("/BaseFont %i 0 R\n/FontDescriptor %i 0 R\n",
                   fontname_objnum, fontdesc_objnum);
    }
    pdf_puts(">> endobj\n");
}

static void write_fontfile(void)
{
    int i;
    if (is_included(fm_cur)) {
        fontfile_objnum = fm_cur->ff_objnum;
        if (fontfile_objnum == 0)
            pdftex_fail("font file object number for `%s' not initialized",
                        fm_cur->tfm_name);
        pdfbegindict(fontfile_objnum); /* font file stream */
        length1_objnum = pdfnewobjnum();
        if (is_truetype(fm_cur))
            pdf_printf("/Length1 %i 0 R\n", length1_objnum);
        else {
            length2_objnum = pdfnewobjnum();
            length3_objnum = pdfnewobjnum();
            pdf_printf("/Length1 %i 0 R\n/Length2 %i 0 R\n/Length3 %i 0 R\n",
                       length1_objnum, length2_objnum, length3_objnum);
        }
        if (!is_truetype(fm_cur))
            ensurecompress(1);
        pdfbeginstream();
    }
    for (i = 0; i < FONT_KEYS_NUM; i++)
        font_keys[i].valid = false;
    fontfile_found = false;
    if (is_truetype(fm_cur))
        writettf();
    else
        writet1();
    if (is_included(fm_cur)) {
        pdfendstream();
        if (!is_truetype(fm_cur))
            restorecompresslevel();
        if (!fontfile_found)
            return;
        pdfbeginobj(length1_objnum);
        if (is_truetype(fm_cur))
            pdf_printf("%i\nendobj\n", (int)ttf_length);
        else {
            pdf_printf("%i\nendobj\n", (int)t1_length1);
            pdfbeginobj(length2_objnum);
            pdf_printf("%i\nendobj\n", (int)t1_length2);
            pdfbeginobj(length3_objnum);
            pdf_printf("%i\nendobj\n", (int)t1_length3);
        }
    }
}

static void write_fontname(void)
{
    pdfbeginobj(fontname_objnum);
    pdf_puts("/");
    if (fm_cur->subset_tag != 0)
        pdf_printf("%s+", fm_cur->subset_tag);
    if (font_keys[FONTNAME_CODE].valid) {
        pdf_printf("%s", font_keys[FONTNAME_CODE].value.s);
        xfree(font_keys[FONTNAME_CODE].value.s);
    }
    else if (fm_cur->base_name != 0)
        pdf_printf("%s", fm_cur->base_name);
    else
        pdf_printf("%s", fm_cur->tfm_name);
    if (pdfexpandfont[tex_font] != 0 && !is_included(fm_cur))
        pdf_printf("%+li", pdfexpandfont[tex_font]);
    pdf_puts("\nendobj\n");
}

static void write_fontdescriptor(void)
{
    int i;
    pdfbegindict(fontdesc_objnum); /* font descriptor */
    print_key(ASCENT_CODE, getcharheight(tex_font, 'h'));
    print_key(CAPHEIGHT_CODE, getcharheight(tex_font, 'H'));
    print_key(DESCENT_CODE, -getchardepth(tex_font, 'q'));
    pdf_printf("/FontName %i 0 R\n", fontname_objnum);
    print_key(ITALIC_ANGLE_CODE, getitalicangle());
    print_key(STEMV_CODE, getstemv());
    print_key(XHEIGHT_CODE, getxheight(tex_font));
    if (!font_keys[FONTBBOX1_CODE].valid) {
        getbbox();
    }
    pdf_printf("/%s [%i %i %i %i]\n",
               font_keys[FONTBBOX1_CODE].pdfname,
               (int)font_keys[FONTBBOX1_CODE].value.i,
               (int)font_keys[FONTBBOX2_CODE].value.i,
               (int)font_keys[FONTBBOX3_CODE].value.i,
               (int)font_keys[FONTBBOX4_CODE].value.i);
    if (!fontfile_found)
        pdf_puts("/Flags 34\n");
    else
        pdf_printf("/Flags %i\n", (int)fm_cur->flags);
    if (is_included(fm_cur) && fontfile_found) {
        if (is_subsetted(fm_cur) && !is_truetype(fm_cur)) {
            cur_glyph_names = t1_glyph_names;
            pdf_puts("/CharSet (");
            for (i = 0; i <= MAX_CHAR_CODE; i++)
                if (pdfcharmarked(tex_font, i) && cur_glyph_names[i] != notdef)
                    pdf_printf("/%s", cur_glyph_names[i]);
            pdf_puts(")\n");
        }
        if (is_truetype(fm_cur))
            pdf_printf("/FontFile2 %i 0 R\n", fontfile_objnum);
        else
            pdf_printf("/FontFile %i 0 R\n", fontfile_objnum);
    }
    pdf_puts(">> endobj\n");
}

void dopdffont(integer font_objnum, internalfontnumber f)
{
    int i, e = 0;
    char *p, *r, buf[1024];
    tex_font = f;
    if (pdffontmap[tex_font] == -1) {
        if (pdfexpandfont[tex_font] != 0) {
            strcpy(buf, makecstring(fontname[tex_font]));
            p = strend(buf);
            for (r = p - 1; r > buf && isdigit(*r); r--);
            if (r == buf || r == p - 1 || (*r != '+' && *r != '-'))
                pdftex_fail("invalid name of expanded font (%s)", buf);
            *r = 0;
            pdffontmap[tex_font] = fmlookup(maketexstring(buf), tex_font);
            flushstring();
        }
        else
            pdftex_fail("pdffontmap[%i] not initialized", (int)tex_font);
    }
    if (pdffontmap[tex_font] >= 0)
        fm_cur = fm_tab + pdffontmap[tex_font];
    else
        fm_cur = 0;
    if (fm_cur == 0 || (fm_cur->base_name == 0 && fm_cur->ff_name == 0)) {
        writet3(font_objnum, tex_font);
        return;
    }
    update_char_widths();
    if (is_subsetted(fm_cur) && fm_cur->subset_tag == 0)
        fm_cur->subset_tag = make_subset_tag();
    if (pdfexpandfont[tex_font] != 0) {
        if (!is_included(fm_cur) || is_truetype(fm_cur))
            pdftex_warn("font `%s' has been used as expanded font, but only embedded Type 1 font can be expanded", 
                        fm_cur->tfm_name);
        else
            fm_cur = fm_ext_entry(tex_font, fm_cur);
    }
    if (!is_noparsing(fm_cur) && !is_basefont(fm_cur) && fm_cur->fn_objnum == 0)
        fm_cur->fn_objnum = pdfnewobjnum();
    fontname_objnum = fm_cur->fn_objnum;
    cur_glyph_names = 0;
    if (!write_fontfile_only)
        write_fontobj(font_objnum);
    if (is_basefont(fm_cur) || is_noparsing(fm_cur))
        return;
    write_fontfile();
    write_fontname();
    if (!write_fontfile_only) {
        write_fontdescriptor();
        write_char_widths();
    }
    if (cur_glyph_names == t1_builtin_glyph_names) {
        for (i = 0; i <= MAX_CHAR_CODE; i++)
            if (!pdfcharmarked(tex_font, i) && cur_glyph_names[i] != notdef) {
                xfree(cur_glyph_names[i]);
                cur_glyph_names[i] = notdef;
            }
        write_enc(cur_glyph_names, encoding_objnum);
        for (i = 0; i <= MAX_CHAR_CODE; i++)
            if (cur_glyph_names[i] != notdef)
                xfree(cur_glyph_names[i]);
    }
}
