#include "ptexlib.h"
#include "zlib.h"

#define ZIP_BUF_SIZE  0x10000

#define check_err(f, fn)                                   \
    if (f != Z_OK)                                         \
        pdftex_fail("zlib: %s() failed", fn)

static char zip_buf[ZIP_BUF_SIZE];
static boolean zip_init = false;
static z_stream c_stream; /* compression stream */

integer writezip()
{
    int err;
    cur_file_name = NULL;
    if (!zip_init) {
        c_stream.zalloc = (alloc_func)0;
        c_stream.zfree = (free_func)0;
        c_stream.opaque = (voidpf)0;
        check_err(deflateInit(&c_stream, fixedcompresslevel()), "deflateInit");
        c_stream.next_out = zip_buf;
        c_stream.avail_out = ZIP_BUF_SIZE;
        zip_init = true;
    }
    c_stream.next_in = pdfbuf;
    c_stream.avail_in = pdfptr;
    for(;;) {
        if (c_stream.avail_out == 0) {
            pdfgone += xfwrite(zip_buf, 1, ZIP_BUF_SIZE, pdffile);
            c_stream.next_out = zip_buf;
            c_stream.avail_out = ZIP_BUF_SIZE;
        }
        err = deflate(&c_stream, 
                      write_stream == FINISH_STREAM ? Z_FINISH : Z_NO_FLUSH);
        if (finish && err == Z_STREAM_END)
            break;
        check_err(err, "deflate");
        if (write_stream != FINISH_STREAM && c_stream.avail_in == 0)
            break;
    }
    if (write_stream == FINISH_STREAM) {
        if (c_stream.avail_out < ZIP_BUF_SIZE) /* at least one byte has been output */
            pdfgone += xfwrite(zip_buf, 1, ZIP_BUF_SIZE - c_stream.avail_out, pdffile);
        check_err(deflateEnd(&c_stream), "deflateEnd");
        xfflush(pdffile);
        zip_init = false;
    }
    pdfptr = 0;
    return c_stream.total_out;
}
