#include "ptexlib.h"
#include "zlib.h"
#include <kpathsea/c-vararg.h>
#include <kpathsea/c-proto.h>
#include "pdftexextra.h" /* define BANNER */

char *cur_file_name = 0;
static char print_buf[PRINTF_BUF_SIZE];
static integer write_stream = NO_STREAM;
static integer stream_length, stream_length_obj;
static integer save_text_ptr; /* to save pdf_ptr for pdf_text */
static integer save_stream_ptr; /* to save pdf_ptr for pdf_stream */

void pdf_puts(char *s)
{
    if (sizeof(pdfbuf) - pdfptr <= strlen(s))
        pdfflush();
    while (*s)
        pdfbuf[pdfptr++] = *s++;
}

void pdf_printf(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(print_buf, fmt, args);
    pdf_puts(print_buf);                                    
    va_end(args);
}

strnumber maketexstring(char *s)
{
    int l;
    if (s == 0 || *s == 0)
        return getnullstr();
    l = strlen(s);
    check_buf(poolptr + l, poolsize);
    while (l-- > 0)
        strpool[poolptr++] = *s++;
    return makestring();
}

void tex_printf(char *fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstring();
    xfflush(stdout);
    va_end(args);
}

void pdftex_fail(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    println();
    tex_printf("Error: %s", program_invocation_name);
    if (cur_file_name)
        tex_printf(" (file %s)", cur_file_name);
    tex_printf(": ");
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstring();
    va_end(args);
    println();
    exit(-1);
}

void pdftex_warn(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    println();
    tex_printf("Warning: %s", program_invocation_name);
    if (cur_file_name)
        tex_printf(" (file %s)", cur_file_name);
    tex_printf(": ");
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstring();
    va_end(args);
    println();
}

char *makecstring(integer s)
{
    static char cstrbuf[1024];
    char *p = cstrbuf;
    int i, l = strstart[s + 1] - strstart[s];
    check_buf(l, 1024);
    for (i = 0; i < l; i++)
        *p++ = strpool[i + strstart[s]];
    *p = 0;
    return cstrbuf;
}

static void select_stream_output()
{
    if (pdfbuf == pdfstreambuf || write_stream != NO_STREAM)
        pdftex_fail("invalid call of set_stream_output()");
    save_text_ptr = pdfptr;
    pdfptr = save_stream_ptr;
    pdfbuf = pdfstreambuf;
    write_stream = WRITE_STREAM;
}

static void select_text_output()
    if (pdfbuf != pdfstreambuf || write_stream == NO_STREAM)
        pdftex_fail("invalid call of set_text_output()");
    save_stream_ptr = pdfptr;
    pdfptr = save_text_ptr;
    pdfbuf = pdftextbuf;
    write_stream = NO_STREAM;
}

static void pdf_stream_head()
{
    if (stream_length_obj == 0)
        pdf_printf("/Length %i\n",  (int)stream_length);
    else
        pdf_printf("/Length %i 0 R\n",  (int)stream_length_obj);
    if (fixedcompresslevel() > 0)
        pdf_puts("/Filter /FlateDecode\n");
    pdf_puts(">>");
    pdf_puts("stream");
}

static void pdf_stream_tail()
{
    pdf_puts("endstream\nendobj\n");
    if (stream_length_obj != 0) {
        pdfbeginobj(stream_length_obj);
        pdf_printf("%i\nendobj\n", stream_length);
    }
}

#define writepdf()  { write_pdf(0, pdfptr - 1); pdfptr = 0; }

void pdfflush()
{
    ensurepdfopen();
    if (write_stream == NO_STREAM) {
        writepdf();
        pdf_gone += pdfptr;
        pdfptr = 0;
        return;
    }
    if (write_stream == WRITE_STREAM) {
    /* stream length too length; must write stream length as indirect object */
        stream_length_obj = pdfnewobjnum();
        select_text_output();
        pdf_stream_head();
        pdfflush(); /* flush text buf */
        select_stream_output();
        if (fixedcompresslevel() > 0)
            writezip();
        else
            writepdf();
    }
    else {
        if (stream_length_obj == 0) {
            select_text_output();
            pdf_stream_head();
            pdfflush(); /* flush text buf */
            select_stream_output();
        }
        if (fixedcompresslevel() > 0)
            writezip();
        else
            writepdf();
        pdf_stream_tail();
    }
}

void pdfbeginstream()
{
    if (write_stream != NO_STREAM)
        pdftex_fail("invalid call of pdfbeginstream()");
    save_pdftext_ptr = pdfptr;
    pdfptr = 0;
    write_stream = WRITE_STREAM;
    pdfbuf = pdfstream;
    pdfbufsize = pdfstreamsize;
    stream_length_obj = 0;
}

void pdfendstream()
{
    if (write_stream == NO_STREAM)
        pdftex_fail("invalid call of pdfendstream()");
    write_stream = FINISH_STREAM;
    pdfflush();
    write_stream = NO_STREAM;
    pdfbuf = pdftext;
    pdfbufsize = pdftextsize;
}

boolean str_eq_cstr(strnumber n, char *s)
{
    int l;
    if (s == 0 || n == 0)
        return false;
    l = strstart[n];
    while (*s && l < strstart[n + 1] && *s == strpool[l])
        l++, s++;
    return !*s && l == strstart[n + 1];
}

strnumber getresnameprefix(integer year, integer month, integer day, integer time)
{
    char tag_digits[] =
        "@0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz*";
    char prefix[7], *p = prefix;
    unsigned long u;
    int i, k;
    extern string versionstring;           /* from web2c/lib/version.c */         
    extern KPSEDLL string kpathsea_version_string;/* from kpathsea/version.c */
    char *name_string = xstrdup(makecstring(jobname)),
         *format_string = xstrdup(makecstring(formatident));
    char *info_string = xtalloc(30 + 
                             strlen(name_string) + 
                             strlen(format_string) + 
                             strlen(BANNER) + 
                             strlen(versionstring) + 
                             strlen(kpathsea_version_string), char);
    sprintf(info_string, "%.4d/%.2d/%.2d %.2d:%.2d %s %s %s %s %s",
                   year, month, day, time/60, time%60, 
                   name_string, format_string, BANNER, 
                   versionstring, kpathsea_version_string);
    /*
    fputs(info_string, stderr);
    */
    u = adler32(1L, info_string, strlen(info_string)) & 
        (unsigned long)((1 << 30) - 1);
    for (i = 0; i < 6; i++) {
        k = 6*(5 - i); 
        *p++ = tag_digits[(u >> k) % 64];
        u &= (unsigned long)((1 << k) - 1);
    }
    *p = 0;
    xfree(name_string);
    xfree(format_string);
    xfree(info_string);
    return maketexstring(prefix);
}

size_t xfwrite(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
    if (fwrite(ptr, size, nmemb, stream) != nmemb)
        pdftex_fail("fwrite() failed");
    return nmemb;
}

int xfflush(FILE *stream)
{
    if (fflush(stream) != 0)
        pdftex_fail("fflush() failed");
    return 0;
}

int xgetc(FILE *stream)
{
    int c = getc(stream);
    if (c < 0 && c != EOF)
        pdftex_fail("getc() failed");
    return c;
}

int xputc(int c, FILE *stream)
{
    int i = putc(c, stream);
    if (i < 0)
        pdftex_fail("putc() failed");
    return i;
}

void libpdffinish()
{
    fm_free();
    enc_free();
    img_free();
    vf_free();
    epdf_free();
}
