/* Additions to texmfmp.h for pdfTeX */

/* mark a char in font */
#define pdfmarkchar(f, c) pdfcharused[f][c/8] |= (1<<(c%8))

/* test whether a char in font is marked */
#define pdfcharmarked(f, c) (boolean)(pdfcharused[f][c/8] & (1<<(c%8)))

/* writepdf() always writes by fwrite() */
#define       writepdf(a, b) \
  (void) fwrite ((char *) &pdfbuf[a], sizeof (pdfbuf[a]), \
                 (int) ((b) - (a) + 1), pdffile)

#define texbopenin(f) \
    open_input (&(f), kpse_tex_format, FOPEN_RBIN_MODE)
#define vfbopenin(f) \
    open_input (&(f), kpse_vf_format, FOPEN_RBIN_MODE)

extern boolean checkimageb(integer);
extern boolean checkimagec(integer);
extern boolean checkimagei(integer);
extern boolean ispdfimage(integer);
extern eightbits packetbyte(void);
extern integer cfgvalue(integer);
extern integer epdforigx(integer);
extern integer epdforigy(integer);
extern integer fmlookup(strnumber, internalfontnumber);
extern integer imageheight(integer);
extern integer imagetype(integer);
extern integer imagewidth(integer);
extern integer imagexres(integer);
extern integer imageyres(integer);
extern integer newvfpacket(internalfontnumber);
extern integer readimage(integer);
extern strnumber getresnameprefix(integer, integer, integer, integer);
extern void deleteimage(integer);
extern void dopdffont(integer, integer);
extern void libpdffinish(void);
extern void magnifycfgdimens(scaled);
extern void poppacketstate(void);
extern void pushpacketstate(void);
extern void readconfig(void);
extern void setcharmap(internalfontnumber);
extern void startpacket(internalfontnumber, integer);
extern void storepacket(integer, integer, integer);
extern void updateimageprocset(integer);
extern void writeimage(integer);
extern void writezip(boolean, integer);
