
/* -----------------------------------------------------------------------
 * This is TIFF support to pdfTeX.
 * -----------------------------------------------------------------------
 */

#ifdef HAVE_TIFF

#include "ptexlib.h"
#include "image.h"

/* Function tiff_read_image_info opens specified file and reads informations
 * into TIFF_IMAGE_INFO structure.
 *
 * Return value: 0 - OK
 *               1 - Cannot open file for read or not a TIFF file
 */

integer read_tiff_info(integer img)
{
    TIFF_IMAGE_INFO *image_info = tiff_info(img);
    float xres=72.0, yres=72.0; /* default resolution */
    unsigned short units;
    image_info->file = (FILE *) TIFFOpen(img_name(img), FOPEN_RBIN_MODE);
    if (!image_info->file)
        return 1; /* This is not a TIFF file */
    image_info->x_res=image_info->y_res=0;
    TIFFGetField((TIFF *) image_info->file, TIFFTAG_IMAGELENGTH, &image_info->height);
    TIFFGetField((TIFF *) image_info->file, TIFFTAG_IMAGEWIDTH, &image_info->width);
    TIFFGetField((TIFF *) image_info->file, TIFFTAG_XRESOLUTION, &xres);
    TIFFGetField((TIFF *) image_info->file, TIFFTAG_YRESOLUTION, &yres);
    TIFFGetField((TIFF *) image_info->file, TIFFTAG_RESOLUTIONUNIT, &units);
    switch (units) {
        case RESUNIT_INCH: break; /* pixels per inch */
        case RESUNIT_CENTIMETER: xres*=2.54; yres*=2.54;
                                 break; /* pixels per cm */
        case RESUNIT_NONE: xres=0;yres=0; break; /* no resolution */
    }
    image_info->x_res=xres; image_info->y_res=yres;
    image_info->length=3*image_info->height*image_info->width;
    image_info->color_space=0;
    image_info->bits_per_component=8;
    set_img_color_type(img, IMAGE_COLOR_C);
    return 0;
}

void write_tiff(integer img)
{
    long unsigned row, col;
    unsigned long int *raster=(unsigned long int *) _TIFFmalloc(tiff_info(img)->height*tiff_info(img)->width*sizeof(unsigned long int));
    pdf_printf("/Type /XObject\n/Subtype /Image\n/Width %i\n/Height %i\n/BitsPerComponent %i\n",
               (int)tiff_info(img)->width,
               (int)tiff_info(img)->height,
               (int)tiff_info(img)->bits_per_component);
    pdf_puts("/ColorSpace /DeviceRGB\n");
    TIFFReadRGBAImage((TIFF *) tiff_info(img)->file, tiff_info(img)->width, tiff_info(img)->height, raster,0);
    pdfbeginstream();
    for (row = 0; row<tiff_info(img)->height; row++)
        for (col = 0; col<tiff_info(img)->width; col++)
        {
            if (pdfptr + 3 >= pdfbufsize)
                pdfflush();
            pdfbuf[pdfptr++] = TIFFGetR(*(raster+col+tiff_info(img)->width*(tiff_info(img)->height-1-row)));
            pdfbuf[pdfptr++] = TIFFGetG(*(raster+col+tiff_info(img)->width*(tiff_info(img)->height-1-row)));
            pdfbuf[pdfptr++] = TIFFGetB(*(raster+col+tiff_info(img)->width*(tiff_info(img)->height-1-row)));
        }
    pdfflush();
    pdfendstream();
}
#endif
