/* WEB2C macros and prototypes */
#define EXTERN extern
#ifdef pdfTeX /* pdfTeX is undefined when ptexlib.h is used with dvips */
#undef pdfTeX /* to avoid warning about redefining pdfTeX in pdftexd.h */
#endif
#include "pdftexd.h"

/* pdftexlib macros */
#include "ptexmac.h"

/* pdftexlib type declarations */
typedef struct {
    char *pdfname;
    char *t1name;
    union {
        integer i;
        char *s;
    } value;
    boolean valid;
} key_entry;

typedef struct {
    boolean loaded;     /* encoding is already loaded? */
    boolean updated;    /* encoding is already updated for 0--32 chars? */
    internalfontnumber firstfont;   /* first font that has accessed to this
                                       encoding; move chars 0--32 to higher
                                       area according to this font */
    char *name;         /* encoding file name */
    integer objnum;     /* object number */
    char **glyph_names;
} enc_entry;

typedef struct {
    char *tfm_name;         /* TFM file name */
    char *base_name;        /* PostScript name */
    integer flags;          /* font flags */
    char *ff_name;          /* font file name */
    char *ex_name;          /* expanded font file name */
    char *subset_tag;       /* pseudoUniqueTag for subsetted font */
    int encoding;           /* index to table of encoding vectors */
    internalfontnumber texfont; /* inverse of pdffontmap */
    int type;               /* font type (T1/TTF/...) */
    integer slant;          /* SlantFont */
    integer extend;         /* ExtendFont */
    boolean found;          /* to avoid researching fonts that have been found */
    integer ff_objnum;      /* font file object number */
    integer fn_objnum;      /* font name object number */
    char *charset;          /* string containing used glyphs */
} fm_entry;

typedef short shalfword ;
typedef short Boolean ;
typedef struct {
   integer charcode,
           cwidth, 
           cheight,
           xoff, 
           yoff, 
           xescape;
   halfword *raster;
} chardesc;


/* pdftexlib variable declarations */
extern fm_entry *fm_cur, *fm_ptr, *fm_tab;
extern enc_entry *enc_ptr, *enc_tab;
extern char *cur_file_name;
extern char *mapfiles;
extern internalfontnumber tex_font;
extern integer t1_length1, t1_length2, t1_length3;
extern char **t1_glyph_names, *t1_builtin_glyph_names[];
extern integer ttf_length;
extern char notdef[];
extern char nontfm[];
extern boolean fontfile_found;
extern key_entry font_keys[];


/* pdftexlib prototypes */
extern int xgetc(FILE *);
extern int xputc(int, FILE *);
extern size_t xfwrite(void *, size_t, size_t, FILE *);
extern int xfflush(FILE *);
extern void pdftex_fail(char *, ...);
extern void pdftex_warn(char *, ...);
extern void pdf_printf(char *, ...);
extern void pdf_puts(char *);
extern void tex_printf(char *, ...);
extern strnumber maketexstring(char *);
extern char *makecstring(integer);
extern boolean str_eq_cstr(strnumber, char *);
extern void fm_read_info(void);
extern fm_entry *fm_ext_entry(internalfontnumber);
extern void fix_ffname(fm_entry *, char *);
extern integer myatol(char **);
extern integer myatodim(char **);
extern boolean t1_read_enc(fm_entry *);
extern void writet1(void);
extern void writettf(void);
extern void writet3(int, internalfontnumber);
extern int readchar(boolean , chardesc *cd);
extern integer add_enc(char *);
extern boolean get_enc(fm_entry *);
extern void read_enc(integer);
extern void load_enc(char *, char **);
extern void write_enc(char **, integer);
extern void update_enc(internalfontnumber, char**);
extern void enc_free(void);
extern void epdf_free(void);
extern void fm_free(void);
extern void img_free(void);
extern void vf_free(void);
