#include "ptexlib.h"

#define FM_BUF_SIZE     1024

static FILE *fm_file;

#define fm_open()       \
    open_input (&fm_file, kpse_tex_ps_header_format, FOPEN_RBIN_MODE)
#define fm_close()      xfclose(fm_file, cur_file_name)
#define fm_getchar()    xgetc(fm_file)
#define fm_eof()        feof(fm_file)

fm_entry *fm_cur, *fm_ptr, *fm_tab = 0;
static int fm_max;
char *mapfiles;
char nontfm[] = "<nontfm>";

static char *basefont_names[14] = {
    "Courier",
    "Courier-Bold",
    "Courier-Oblique",
    "Courier-BoldOblique",
    "Helvetica",
    "Helvetica-Bold",
    "Helvetica-Oblique",
    "Helvetica-BoldOblique",
    "Symbol",
    "Times-Roman",
    "Times-Bold",
    "Times-Italic",
    "Times-BoldItalic",
    "ZapfDingbats"
};

#define read_field(r, q, buf) do {                         \
    for (q = buf; *r != ' ' && *r != 10; *q++ = *r++);     \
    *q = 0;                                                \
    skip(r, ' ');                                          \
} while (0)

#define set_field(F) do {                                  \
    if (q > buf)                                           \
        fm_ptr->F = xstrdup(buf);                          \
    if (*r == 10)                                          \
        goto done;                                         \
} while (0)

int lookup_fbname(char *);

static void fm_new_entry(void)
{
    entry_room(fm, 256);
    fm_ptr->tfm_name        = 0;
    fm_ptr->base_name       = 0;
    fm_ptr->flags           = 0;
    fm_ptr->ff_name         = 0;
    fm_ptr->ex_name         = 0;
    fm_ptr->subset_tag      = 0;
    fm_ptr->encoding        = -1;
    fm_ptr->texfont         = getnullfont();
    fm_ptr->type            = 0;
    fm_ptr->slant           = 0;
    fm_ptr->extend          = 0;
    fm_ptr->found           = false;
    fm_ptr->ff_objnum       = 0;
    fm_ptr->fn_objnum       = 0;
    fm_ptr->charset         = 0;
}

void fm_read_info(void)
{
    float d;
    int i, a, b, c, tex_font_num;
    char fm_line[FM_BUF_SIZE], buf[FM_BUF_SIZE];
    fm_entry *e;
    char *p, *q, *r, *s, *n = mapfiles;
    for (;;) {
        if (fm_file == 0) {
            if (*n == 0) {
                xfree(mapfiles);
                cur_file_name = 0;
                return;
            }
            s = strchr(n, '\n');
            *s = 0;
            set_cur_file_name(n);
            n = s + 1;
            if (!fm_open()) {
                pdftex_warn("cannot open font map file");
                continue;
            }
            cur_file_name = nameoffile + 1;
            tex_printf("{%s", cur_file_name);
        }
        if (fm_eof()) {
            fm_close();
            tex_printf("}");
            fm_file = 0;
            continue;
        }
        fm_new_entry();
        p = fm_line;
        do {
            c = fm_getchar();
            append_char_to_buf(c, p, fm_line, FM_BUF_SIZE);
        } while (c != 10);
        append_eol(p, fm_line, FM_BUF_SIZE);
        c = *fm_line;
        if (p - fm_line == 1 || c == '*' || c == '#' || c == ';' || c == '%')
            continue;
        r = fm_line;
        read_field(r, q, buf);
        if (strcmp(buf, nontfm) == 0)
            fm_ptr->tfm_name = nontfm;
        else {
            for (e = fm_tab; e < fm_ptr; e++)
                if (e->tfm_name != nontfm && strcmp(e->tfm_name, buf) == 0) {
                    pdftex_warn("entry for `%s' already exists, duplicates ignored", buf);
                    goto bad_line;
                }
            set_field(tfm_name);
        }
        p = r;
        read_field(r, q, buf);
        if (*buf != '<' && *buf != '"')
            set_field(base_name);
        else
            r = p; /* unget the field */
        if (isdigit(*r)) { /* font flags given */
            fm_ptr->flags = atoi(r);
            while (isdigit(*r))
                r++;
        }
        else
            fm_ptr->flags = 4; /* treat as Symbol font */
reswitch:
        skip(r, ' ');
        a = b = 0;
        if (*r == '!')
            a = *r++;
        else {
            if (*r == '<')
                a = *r++;
            if (*r == '<' || *r == '[')
                b = *r++;
        }
        switch (*r) {
        case 10:
            goto done;
        case '"':
            r++;
parse_next:
            skip(r, ' ');
            if (sscanf(r, "%f", &d) > 0) {
                for (s = r; *s != ' ' && *s != '"' && *s != 10; s++);
                skip(s, ' ');
                if (strncmp(s, "SlantFont", strlen("SlantFont")) == 0) {
                    fm_ptr->slant = (integer)((d+0.0005)*1000);
                    r = s + strlen("SlantFont");
                }
                else if (strncmp(s, "ExtendFont", strlen("ExtendFont")) == 0) {
                    fm_ptr->extend = (integer)((d+0.0005)*1000);
                    r = s + strlen("ExtendFont");
                }
                else {
                    pdftex_warn("invalid entry for `%s': unknown name `%s' ignored", fm_ptr->tfm_name, s);
                    for (r = s; *r != ' ' && *r != '"' && *r != 10; r++);
                }
            }
            else
                for (; *r != ' ' && *r != '"' && *r != 10; r++);
            if (*r == '"') {
                r++;
                goto reswitch;
            }
            else if (*r == ' ')
                goto parse_next;
            else {
                pdftex_warn("invalid entry for `%s': unknown line format", fm_ptr->tfm_name);
                goto bad_line;
            }
        default:
            read_field(r, q, buf);
            if ((a == '<' && b == '[') ||
                (a != '!' && b == 0 && (strlen(buf) > 4) &&
                 !strcasecmp(strend(buf) - 4, ".enc"))) {
                fm_ptr->encoding = add_enc(buf);
                goto reswitch;
            }
            if (a == '<') {
                set_included(fm_ptr);
                if (b == 0)
                    set_subsetted(fm_ptr);
            }
            else if (a == '!')
                set_noparsing(fm_ptr);
            set_field(ff_name);
            goto reswitch;
        }
done:
        if (fm_ptr->base_name != 0) {
            for (i = 0; i < 14; i++)
                if (!strcmp(basefont_names[i], fm_ptr->base_name))
                    break;
            if (i < 14) {
                set_basefont(fm_ptr);
                unset_included(fm_ptr);
                unset_subsetted(fm_ptr);
                unset_truetype(fm_ptr);
                unset_fontfile(fm_ptr);
            }
            else if (fm_ptr->ff_name == 0) {
                pdftex_warn("invalid entry for `%s': font file missing", fm_ptr->tfm_name);
                goto bad_line;
            }
        }
        if (fm_fontfile(fm_ptr) != 0 && 
            !strcasecmp(strend(fm_fontfile(fm_ptr)) - 4, ".ttf"))
            set_truetype(fm_ptr);
        if (((fm_slant(fm_ptr) != 0) || (fm_extend(fm_ptr) != 0)) &&
            (is_basefont(fm_ptr) || is_truetype(fm_ptr) || 
             fm_fontfile(fm_ptr) == 0)) {
            pdftex_warn("invalid entry for `%s': SlantFont/ExtendFont can be used only with embedded T1 fonts", fm_ptr->tfm_name);
            goto bad_line;
        }
        if (is_truetype(fm_ptr) && (is_reencoded(fm_ptr)) &&
            !is_subsetted(fm_ptr)) {
            pdftex_warn("invalid entry for `%s': only subsetted TrueType font can be reencoded", fm_ptr->tfm_name);
            goto bad_line;
        }
        fm_ptr++;
        continue;
bad_line:
        if (fm_ptr->tfm_name != nontfm)
            xfree(fm_ptr->tfm_name);
        xfree(fm_ptr->base_name);
        xfree(fm_ptr->ff_name);
    }
}

fm_entry *fm_ext_entry(internalfontnumber f)
{
    char *p, *q, *r, buf[1024];
    fm_new_entry();
    if (fm_cur->subset_tag != 0)
        fm_ptr->subset_tag = xstrdup(fm_cur->subset_tag);
    else
        fm_ptr->subset_tag = 0;
    fm_ptr->flags = fm_cur->flags;
    fm_ptr->encoding = fm_cur->encoding;
    fm_ptr->type = fm_cur->type;
    fm_ptr->slant = fm_cur->slant;
    fm_ptr->extend = fm_cur->extend;
    fm_ptr->ff_name = xstrdup(fm_cur->ff_name);
    p = fm_cur->ff_name;
    if ((r = strrchr(p, '.')) == 0)
        r = strend(p);
    strncpy(buf, p, r - p);
    sprintf(buf + (r - p), "%+i", (int)pdfexpandfont[f]);
    for (q = strend(buf); *r != 0; *q++ = *r++);
    *q = 0;
    fm_ptr->ex_name = xstrdup(buf);
    return fm_ptr++;
}

int lookup_fbname(char *bname)
{
    fm_entry *p;
    char *s = bname;
    int i;
    if (fm_tab == 0)
        fm_read_info();
    if (bname == 0)
        return -1;
    if (strlen(s) > 7) { /* check for subsetted name tag */
        for (i = 0; i < 6; i++, s++)
            if (*s < 'A' && *s > 'Z')
                break;
        if (i == 6 && *s == '+')
            bname = s + 1;
    }
    for (p = fm_tab; p < fm_ptr; p++)
        if (p->base_name != 0 && strcmp(p->base_name, bname) == 0) {
            if (is_basefont(p) || is_noparsing(p))
                return -1;
            if (p->texfont == getnullfont()) {
                if (p->tfm_name == nontfm)
                    i = newnullfont();
                else
                    i = readfontinfo(getnullcs(), maketexstring(p->tfm_name),
                                     getnullstr(), -1000);
                p->texfont = i;
            }
            else
                i = p->texfont;
            if (pdffontmap[i] == -1)
                pdffontmap[i] = p - fm_tab;
            if (p->ff_objnum == 0 && is_included(p))
                p->ff_objnum = pdfnewobjnum();
            if (p->fn_objnum == 0)
                p->fn_objnum = pdfnewobjnum();
            if (!fontused[i])
                zpdfcreatefontobj(i);
            return i;
        }
    return -1;
}

integer fmlookup(strnumber s, internalfontnumber f)
{
    fm_entry *p;
    if (fm_tab == 0)
        fm_read_info();
    for (p = fm_tab; p < fm_ptr; p++)
        if (p->tfm_name != nontfm && str_eq_cstr(s, p->tfm_name)) {
            if (p->ff_objnum == 0 && is_included(p))
                p->ff_objnum = pdfnewobjnum();
            if (p->fn_objnum == 0)
                p->fn_objnum = pdfnewobjnum();
            p->texfont = f;
            return p - fm_tab;
        }
    return -2;
}

void setcharmap(internalfontnumber f)
{
    fm_entry *fm;
    enc_entry *e;
    char **glyph_names;
    int i, k;
    if (pdffontmap[f] < 0) /* no entry in map files, suppose bitmap */
        return;
    if (fontec[f] < 128) {
        for (i = fontbc[f]; i <= 32; i++)
            pdfcharmap[f][i] = i + MOVE_CHARS_OFFSET;
        return;
    }
    fm = fm_tab + pdffontmap[f];
    if (getmovechars() < 2 || !get_enc(fm))
        return;
    e = enc_tab + fm->encoding;
    if (e->firstfont != getnullfont()) {
        for (i = fontbc[f]; i <= 32; i++)
            pdfcharmap[f][i] = pdfcharmap[e->firstfont][i];
        return;
    }
    if (e->name != 0) /* the encoding is external */
        e->firstfont = f;
    glyph_names = e->glyph_names;
    for (i = 32, k = MAX_CHAR_CODE; i >= fontbc[f] && k >= 128; i--) {
        if (glyph_names[i] == notdef)
            continue;
        while (glyph_names[k] != notdef && k >= 128)
            k--;
        if (k < 128)
            return;
        /*
        glyph_names[k] = xstrdup(glyph_names[i]);
        */
        glyph_names[k] = glyph_names[i];
        glyph_names[i] = notdef;
        pdfcharmap[f][i] = k;
    }
}

void fix_ffname(fm_entry *fm, char *name)
{
    xfree(fm->ff_name);
    fm->ff_name = xstrdup(name);
    fm->found   = true;     /* avoid next searching for the same file */
}

void fm_free(void)
{
    fm_entry *fm;
    for (fm = fm_tab; fm < fm_ptr; fm++) {
        if (fm_ptr->tfm_name != nontfm)
            xfree(fm_ptr->tfm_name);
        xfree(fm->base_name);
        xfree(fm->ff_name);
        xfree(fm->ex_name);
        xfree(fm->subset_tag);
        xfree(fm->charset);
    }
    xfree(fm_tab);
}
