#include "ptexlib.h"
#include <kpathsea/c-vararg.h>
#include <kpathsea/c-proto.h>

integer pdfbufmax = pdfbufsize;

extern void epdf_check_mem(void);

int is_subsetable(int);
void mark_glyphs(int, char *);
void embed_whole_font(int);
integer fontfile_objnum(int);
integer fontname_objnum(int);

int is_subsetable(int font)
{
    fm_entry *fm = fm_tab + pdffontmap[font];
    return is_included(fm) && is_subsetted(fm) && get_enc(fm);
}

void mark_glyphs(int texfont, char *charset)
{
    char *new_charset = fm_tab[pdffontmap[texfont]].charset;
    if (charset == 0)
        return;
    if (new_charset == 0)
        new_charset = xstrdup(charset);
    else {
        new_charset = xretalloc(new_charset, 
                                strlen(new_charset) + strlen(charset) + 1,
                                char);
        strcat(new_charset, charset);
    }
    fm_tab[pdffontmap[texfont]].charset = new_charset;
}

void embed_whole_font(int font)
{
    unset_subsetted(fm_tab + pdffontmap[font]);
}

integer fontfile_objnum(int font)
{
    return fm_tab[pdffontmap[font]].ff_objnum;
}

integer fontname_objnum(int font)
{
    return fm_tab[pdffontmap[font]].fn_objnum;
}

void epdf_free(void)
{
    epdf_check_mem();
}
