#include "ptexlib.h"

#define ENC_BUF_SIZE    1024

static FILE *enc_file;

#define enc_open()      \
    open_input(&enc_file, kpse_tex_ps_header_format, FOPEN_RBIN_MODE)
#define enc_getchar()   xgetc(enc_file)
#define enc_close()     xfclose(enc_file, cur_file_name)
#define enc_eof()       feof(enc_file)

enc_entry *enc_ptr, *enc_tab = 0;
int enc_max;
char enc_line[ENC_BUF_SIZE];

static void enc_getline(void)
{
    char *p;
    int c;
restart:
    if (enc_eof())
        pdftex_fail("unexpected end of file");
    p = enc_line;
    do {
        c = enc_getchar();
        append_char_to_buf(c, p, enc_line, ENC_BUF_SIZE);
    } while (c != 10);
    append_eol(p, enc_line, ENC_BUF_SIZE);
    if (p - enc_line <= 2 || *enc_line == '%')
        goto restart;
}

void load_enc_file(char *enc_file, char **glyph_names)
{
    char buf[ENC_BUF_SIZE], *p, *r;
    int names_count;
    get_texname(e->name);
    if (!enc_open()) {
        pdftex_warn("cannot open encoding file for reading");
        cur_file_name = 0;
        return;
    }
    tex_printf("{%s", cur_file_name = nameoffile + 1);
    enc_getline();
    if (*enc_line != '/' || (r = strchr(enc_line, '[')) == NULL) {
        remove_eol(r, enc_line);
        pdftex_fail("invalid encoding vector (a name or `[' missing): `%s'", enc_line);
    }
    names_count = 0;
    r++; /* skip '[' */
    skip(r, ' ');
    for (;;) {
        while (*r == '/') {
            for (p = buf, r++; *r != ' ' && *r != 10 && *r != ']' && *r != '/'; *p++ = *r++);
            *p = 0;
            skip(r, ' ');
            if (names_count > MAX_CHAR_CODE)
                pdftex_fail("encoding vector contains more than %i names",
                            (int)(MAX_CHAR_CODE + 1));
            if (strcmp(buf, notdef) != 0)
                glyph_names[names_count] = xstrdup(buf);
            names_count++;
        }
        if (*r != 10 && *r != '%') {
            if (strncmp(r, "] def", strlen("] def")) == 0) 
                goto done;
            else {
                remove_eol(r, enc_line);
                pdftex_fail("invalid encoding vector: a name or `] def' expected: `%s'", enc_line);
            }
        }
        enc_getline();
        r = enc_line;
    }
done:
    enc_close();
    tex_printf("}");
    cur_file_name = 0;
}

void read_enc(integer encoding)
{
    enc_entry *e = enc_tab + encoding;
    if (e->loaded)
        return;
    load_enc_file(e->name, e->glyph_names);
    e->loaded = true;
}

/* write_enc is used to write either internal or external encoding;
 * when glyph_names is non null the second argument will be treated as
 * the number of the Encoding object; otherwise the second argument
 * will be treated as index of encoding in enc_tab
 */
void write_enc(char **glyph_names, integer n)
{
    boolean is_notdef;
    int i;
    enc_entry *e;
    char **g;
    if (glyph_names == 0) {
        e = enc_tab + n;
        if (e->objnum != 0)
            return;
        pdfnewdict(0, 0);
        e->objnum = objptr;
        g = e->glyph_names;
    }
    else {
        pdfbegindict(n);
        g = glyph_names;
    }
    pdf_printf("/Type /Encoding\n/Differences [ 0 /%s", g[0]);
    is_notdef = (g[0] == notdef);
    for (i = 1; i <= MAX_CHAR_CODE; i++) {
        if (g[i] == notdef) {
            if (!is_notdef) {
                pdf_printf(" %i/%s", i, notdef);
                is_notdef = true;
            }
        }
        else {
            if (is_notdef) {
                pdf_printf(" %i", i);
                is_notdef = false;
            }
            pdf_printf("/%s", g[i]);
        }
    }
    pdf_puts("]\n>> endobj\n");
}

integer add_enc(char *s) /* built-in encodings have s == 0 */
{
    int i;
    enc_entry *e;
    if (enc_tab != 0 && s != 0) {
        for (e = enc_tab; e < enc_ptr; e++)
            if (e->name != 0) /* don't check built-in encodings */
                if  (strcmp(s, e->name) == 0)
                    return e - enc_tab;
    }
    entry_room(enc, 256);
    if (s != 0)
        enc_ptr->name = xstrdup(s);
    else
        enc_ptr->name = 0;
    enc_ptr->loaded = false;
    enc_ptr->updated = false;
    enc_ptr->firstfont = getnullfont();
    enc_ptr->objnum = 0;
    enc_ptr->glyph_names = xtalloc(MAX_CHAR_CODE + 1, char *);
    for (i = 0; i <= MAX_CHAR_CODE; i++)
        enc_ptr->glyph_names[i] = notdef;
    return enc_ptr++ - enc_tab;
}

/* get encoding for map entry fm. When encoding vector is not given, try to
 * get it from T1 font file, in this case t1_read_enc sets the font being
 * reencoded, so next calls for the same entry doesn't cause reading the font
 * again
 */
boolean get_enc(fm_entry *fm)
{
    int i;
    char **glyph_names;
    if (is_reencoded(fm)) { /* external encoding vector available */
        read_enc(fm->encoding);
        return true;
    }
    if (!is_t1fontfile(fm)) /* get built-in encoding for T1 fonts only */
        return false;
    if (t1_read_enc(fm)) { /* encoding read into t1_builtin_glyph_names */
        fm->encoding = add_enc(0);
        glyph_names = enc_tab[fm->encoding].glyph_names;
        for (i = 0; i <= MAX_CHAR_CODE; i++)
            glyph_names[i] = t1_builtin_glyph_names[i];
        enc_tab[fm->encoding].loaded = true;
        return true;
    }
    return false;
}

void update_enc(internalfontnumber f, char **glyph_names)
{
    int i;
    fm_entry *fm = fm_tab + pdffontmap[f];
    if (is_reencoded(fm))
        read_enc(fm->encoding);
    if (getmovechars() < 1 || fontec[f] >= 128 || 
        (is_reencoded(fm) && enc_tab[fm->encoding].updated))
        return;
    for (i = fontbc[f]; i < 32; i++)
        if (pdfcharmap[f][i] != i) {
            if (glyph_names[i + MOVE_CHARS_OFFSET] != notdef)
                xfree(glyph_names[i + MOVE_CHARS_OFFSET]);
            if (glyph_names[i] != notdef)
                glyph_names[i + MOVE_CHARS_OFFSET] = xstrdup(glyph_names[i]);
            else
                glyph_names[i + MOVE_CHARS_OFFSET] = notdef;
        }
    if (is_reencoded(fm))
        enc_tab[fm->encoding].updated = true;
}

void enc_free()
{
    enc_entry *e;
    int k;
    for (e = enc_tab; e < enc_ptr; e++) {
        xfree(e->name);
        if (e->loaded != 0) { /* encoding has been loaded */
            for (k = 0; k <= MAX_CHAR_CODE; k++)
                if (e->glyph_names[k] != notdef)
                    xfree(e->glyph_names[k]);
        }
        xfree(e->glyph_names);
    }
    xfree(enc_tab);
}
