#include "ptexlib.h"
#include <kpathsea/c-vararg.h>
#include <kpathsea/c-proto.h>

char *cur_file_name = 0;
static char print_buf[PRINTF_BUF_SIZE];

void pdf_puts(char *s)
{
    if (sizeof(pdfbuf) - pdfptr <= strlen(s))
        pdfflush();
    while (*s)
        pdfbuf[pdfptr++] = *s++;
}

void pdf_printf(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(print_buf, fmt, args);
    pdf_puts(print_buf);                                    
    va_end(args);
}

/*
static void t1_puts(char *s)
{
    if (s != t1_line)
        strcpy(t1_line, s);
    t1_line_ptr = strend(t1_line);
    t1_putline();
}

static void t1_printf(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(t1_line, fmt, args);
    t1_puts(t1_line);                                    
    va_end(args);
}
*/

strnumber maketexstring(char *s)
{
    int l;
    if (s == 0 || *s == 0)
        return getnullstr();
    l = strlen(s);
    check_buf(poolptr + l, poolsize);
    while (l-- > 0)
        strpool[poolptr++] = *s++;
    return makestring();
}

void tex_printf(char *fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstring();
    xfflush(stdout);
    va_end(args);
}

void pdftex_fail(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    println();
    tex_printf("Error: %s", program_invocation_name);
    if (cur_file_name)
        tex_printf(" (file %s)", cur_file_name);
    tex_printf(": ");
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstring();
    va_end(args);
    println();
    exit(-1);
}

void pdftex_warn(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    println();
    tex_printf("Warning: %s", program_invocation_name);
    if (cur_file_name)
        tex_printf(" (file %s)", cur_file_name);
    tex_printf(": ");
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstring();
    va_end(args);
    println();
}

char *makecstring(integer s)
{
    static char cstrbuf[1024];
    char *p = cstrbuf;
    int i, l = strstart[s + 1] - strstart[s];
    check_buf(l, 1024);
    for (i = 0; i < l; i++)
        *p++ = strpool[i + strstart[s]];
    *p = 0;
    return cstrbuf;
}

boolean str_eq_cstr(strnumber n, char *s)
{
    int l;
    if (s == 0 || n == 0)
        return false;
    l = strstart[n];
    while (*s && l < strstart[n + 1] && *s == strpool[l])
        l++, s++;
    return !*s && l == strstart[n + 1];
}

size_t xfwrite(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
    if (fwrite(ptr, size, nmemb, stream) != nmemb)
        pdftex_fail("fwrite() failed");
    return nmemb;
}

int xfflush(FILE *stream)
{
    if (fflush(stream) != 0)
        pdftex_fail("fflush() failed");
    return 0;
}

int xgetc(FILE *stream)
{
    int c = getc(stream);
    if (c < 0 && c != EOF)
        pdftex_fail("getc() failed");
    return c;
}

int xputc(int c, FILE *stream)
{
    int i = putc(c, stream);
    if (i < 0)
        pdftex_fail("putc() failed");
    return i;
}

void libpdffinish()
{
    fm_free();
    enc_free();
    img_free();
    vf_free();
    epdf_free();
}
