#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <GString.h>
#include <gmem.h>
#include <gfile.h>
#include <config.h>
#include "Object.h"
#include "Stream.h"
#include "Array.h"
#include "Dict.h"
#include "XRef.h"
#include "Catalog.h"
#include "Page.h"
#include "GfxFont.h"
#include "PDFDoc.h"
#include "Params.h"
#include "Error.h"

GBool printCommands = gFalse;

int main(int argc, char *argv[])
{
    PDFDoc *doc;
    GString *fileName;
    Stream *s;
    Object srcStream, srcName, catalogDict;
    FILE *outfile;
    char *outname;
    int c;
    fprintf(stderr, "pdftosrc version %s\n", xpdfVersion);
    if (argc < 2) {
        fprintf(stderr, "Usage: pdftosrc <PDF-file>\n");
        exit(1);
    }
    fileName = new GString(argv[1]);
    errorInit();
    initParams(xpdfConfigFile);
    xref = NULL;
    doc = new PDFDoc(fileName);
    if (!doc->isOk()) {
        fprintf(stderr, "Invalid PDF file\n");
        exit(1);
    }
    catalogDict.initNull();
    xref->getCatalog(&catalogDict);
    if (!catalogDict.isDict("Catalog")) {
        fprintf(stderr, "No Catalog found\n");
        exit(1);
    }
    srcStream.initNull();
    catalogDict.dictLookup("SourceObject", &srcStream);
    if (!srcStream.isStream("SourceFile")) {
        fprintf(stderr, "No SourceObject found\n");
        exit(1);
    }
    srcName.initNull();
    srcStream.getStream()->getDict()->lookup("SourceName", &srcName);
    if (!srcName.isString()) {
        fprintf(stderr, "No SourceName found\n");
        exit(1);
    }
    outname = srcName.getString()->getCString();
    if (!(outfile = fopen(outname, "wb"))) {
        fprintf(stderr, "Cannot open file for writting\n");
        exit(1);
    }
    s = srcStream.getStream();
    s->reset();
    while ((c = s->getChar()) != EOF)
        fputc(c, outfile);
    fprintf(stderr, "Source file extracted to %s\n", outname);
    fclose(outfile);
    catalogDict.free();
    srcStream.free();
    srcName.free();
    freeParams();
}
