#include "ptexlib.h"
#include "zlib.h"
#include <kpathsea/c-vararg.h>
#include <kpathsea/c-proto.h>
#include "pdftexextra.h" /* define BANNER */

char *cur_file_name = 0;
strnumber last_tex_string;
static char print_buf[PRINTF_BUF_SIZE];
static char *jobname_cstr = 0;
char *job_id_string = 0;
long int last_tab_index;

typedef eightbits   ff_buf_entry;
ff_buf_entry        *ff_buf_ptr, *ff_buf_tab = 0;
integer             ff_buf_max;

typedef char    fnstr_entry;
fnstr_entry     *fnstr_ptr, *fnstr_tab;
integer         fnstr_max;

integer ff_offset(void)
{
    return ff_buf_ptr - ff_buf_tab;
}

void ff_seek(integer offset)
{
     ff_buf_ptr = ff_buf_tab + offset;
}

void ff_putchar(eightbits b)
{
    entry_room(ff_buf, 1, FF_BUF_SIZE);
    *ff_buf_ptr++ = b;
}

void ff_flush(void)
{
    ff_buf_entry *p;
    integer n;
    for (p = ff_buf_tab; p < ff_buf_ptr;) {
        n = pdfbufsize - pdfptr;
        if (ff_buf_ptr - p < n)
            n = ff_buf_ptr - p;
        memcpy(pdfbuf + pdfptr, p, (unsigned)n);
        pdfptr += n;
        if (pdfptr == pdfbufsize)
            pdfflush();
        p += n;
    }
    ff_buf_ptr = ff_buf_tab;
}

void make_subset_tag(fm_entry *fm_cur, integer fn_offset)
{
    int i, l;
    unsigned long crc;
    char tag[7];
    eightbits *fontname_ptr = ff_buf_tab + fn_offset;
    fnstr_tab = 0;
    l = strlen(job_id_string);
    entry_room(fnstr, l, l + SMALL_BUF_SIZE);
    strcpy(fnstr_tab, job_id_string);
    fnstr_ptr = strend(fnstr_tab);
    for (i = 0; i <= MAX_CHAR_CODE; i++)
        if (pdfcharmarked(tex_font, i) && t1_glyph_names[i] != notdef) {
            entry_room(fnstr, strlen(t1_glyph_names[i]), SMALL_BUF_SIZE);
            sprintf(fnstr_ptr, "/%s", t1_glyph_names[i]);
            fnstr_ptr = strend(fnstr_ptr);
        }
    if (fm_cur->charset != 0) {
        l =  strlen(fm_cur->charset);
        entry_room(fnstr, l, l);
        sprintf(fnstr_ptr, "%s", fm_cur->charset);
        fnstr_ptr = strend(fnstr_ptr);
    }
    crc = crc32(0L, Z_NULL, 0);
    crc = crc32(crc, fnstr_tab, strlen(fnstr_tab));
    xfree(fnstr_tab);
    /* we need to fit a 32-bit number into a string of 6 uppercase chars long;
     * there are 26 uppercase chars ==> each char represents a number in range
     * 0..25. The maximal number that can be represented by the tag is
     * 26^6 - 1, which is a number between 2^28 and 2^29. Thus the bits 29..31
     * of the CRC must be dropped out.
     */
    for (i = 0; i < 6; i++) {
        fontname_ptr[i] = tag[i] = 'A' + crc % 26;
        crc /= 26;
    }
    tag[6] = 0;
    fm_cur->subset_tag = xstrdup(tag);
}

void pdf_puts(char *s)
{
    pdfroom(strlen(s) + 1);
    while (*s)
        pdfbuf[pdfptr++] = *s++;
}

void pdf_printf(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(print_buf, fmt, args);
    pdf_puts(print_buf);                                    
    va_end(args);
}

strnumber maketexstring(char *s)
{
    int l;
    if (s == 0 || *s == 0)
        return getnullstr();
    l = strlen(s);
    check_buf(poolptr + l, poolsize);
    while (l-- > 0)
        strpool[poolptr++] = *s++;
    last_tex_string = makestring();
    return last_tex_string;
}

void tex_printf(char *fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstr(last_tex_string);
    xfflush(stdout);
    va_end(args);
}

void pdftex_fail(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    println();
    tex_printf("Error: %s", program_invocation_name);
    if (cur_file_name)
        tex_printf(" (file %s)", cur_file_name);
    tex_printf(": ");
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstr(last_tex_string);
    va_end(args);
    println();
    exit(-1);
}

void pdftex_warn(char *fmt,...)
{
    va_list args;
    va_start(args, fmt);
    println();
    tex_printf("Warning: %s", program_invocation_name);
    if (cur_file_name)
        tex_printf(" (file %s)", cur_file_name);
    tex_printf(": ");
    vsprintf(print_buf, fmt, args);
    print(maketexstring(print_buf));
    flushstr(last_tex_string);
    va_end(args);
    println();
}

char *makecstring(integer s)
{
    static char cstrbuf[MAX_CSTRING_LEN];
    char *p = cstrbuf;
    int i, l = strstart[s + 1] - strstart[s];
    check_buf(l, 1024);
    for (i = 0; i < l; i++)
        *p++ = strpool[i + strstart[s]];
    *p = 0;
    return cstrbuf;
}

boolean str_eq_cstr(strnumber n, char *s)
{
    int l;
    if (s == 0 || n == 0)
        return false;
    l = strstart[n];
    while (*s && l < strstart[n + 1] && *s == strpool[l])
        l++, s++;
    return !*s && l == strstart[n + 1];
}

void setjobid(int year, int month, int day, int time)
{
    extern string versionstring; /* from web2c/lib/version.c */         
    extern KPSEDLL string kpathsea_version_string; /* from kpathsea/version.c */
    char *name_string = xstrdup(makecstring(jobname)),
         *format_string = xstrdup(makecstring(formatident));
    job_id_string = xtalloc(30 + 
                            strlen(name_string) + 
                            strlen(format_string) + 
                            strlen(BANNER) + 
                            strlen(versionstring) + 
                            strlen(kpathsea_version_string), char);
    sprintf(job_id_string, "%.4d/%.2d/%.2d %.2d:%.2d %s %s %s %s %s",
            year, month, day, time/60, time%60, 
            name_string, format_string, BANNER, 
            versionstring, kpathsea_version_string);
    xfree(name_string);
    xfree(format_string);
}

strnumber getresnameprefix(void)
{
    static char name_str[] =
        "@ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789*";
        /* 64 chars ==> each char represents a number in range 0..63 */
    char prefix[7]; /* make a tag of 6 chars long */
    char *p = prefix; 
    unsigned long crc;
    int i, k;
    crc = crc32(0L, Z_NULL, 0);
    crc = crc32(crc, job_id_string, strlen(job_id_string));
    for (i = 0; i < 6; i--) {
        prefix[i] = name_str[crc % 64];
        crc /= 64;
    }
    prefix[6] = 0;
    return maketexstring(prefix);
}

size_t xfwrite(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
    if (fwrite(ptr, size, nmemb, stream) != nmemb)
        pdftex_fail("fwrite() failed");
    return nmemb;
}

int xfflush(FILE *stream)
{
    if (fflush(stream) != 0)
        pdftex_fail("fflush() failed");
    return 0;
}

int xgetc(FILE *stream)
{
    int c = getc(stream);
    if (c < 0 && c != EOF)
        pdftex_fail("getc() failed");
    return c;
}

int xputc(int c, FILE *stream)
{
    int i = putc(c, stream);
    if (i < 0)
        pdftex_fail("putc() failed");
    return i;
}

void writestreamlength(integer length, integer offset)
{
    integer save_offset;
    if (jobname_cstr == 0)
        jobname_cstr = xstrdup(makecstring(jobname));
    save_offset = xftell(pdffile, jobname_cstr);
    xfseek(pdffile, offset, SEEK_SET, jobname_cstr);
    fprintf(pdffile, "%li", (long int)length);
    xfseek(pdffile, pdfoffset(), SEEK_SET, jobname_cstr);
}

scaled extxnoverd(scaled x, scaled n, scaled d)
{
    double r = (((double)x)*((double)n))/((double)d);
    if (r > 0)
        r += 0.5;
    else
        r -= 0.5;
    if (r >= (double)maxinteger || r <= -(double)maxinteger)
        pdftex_warn("arithmetic: number too big");
    return r;
}

void libpdffinish()
{
    xfree(ff_buf_tab);
    xfree(job_id_string);
    fm_free();
    enc_free();
    img_free();
    vf_free();
    epdf_free();
}
