#include "ptexlib.h"
#include "image.h"
#include <kpathsea/c-memstr.h>

#define bp2integer(p)    p*dim100bp/100.0 + 0.5

image_entry *image_ptr, *image_tab = 0;
integer image_max;

float epdf_width;
float epdf_height;
float epdf_orig_x;
float epdf_orig_y;
integer epdf_selected_page;
integer epdf_num_pages;
void *epdf_doc;
void *epdf_xref;

static integer new_image_entry(void)
{
    entry_room(image, 256);
    image_ptr->image_type = IMAGE_TYPE_NONE;
    image_ptr->color_type = 0;
    image_ptr->num_pages = 0;
    image_ptr->x_res = 0;
    image_ptr->y_res = 0;
    image_ptr->width = 0;
    image_ptr->height = 0;
    return image_ptr++ - image_tab;
}

integer imagecolor(integer img)
{
    return img_color(img);
}

integer imagewidth(integer img)
{
    return img_width(img);
}

integer imageheight(integer img)
{
    return img_height(img);
}

integer imagexres(integer img)
{
    return img_xres(img);
}

integer imageyres(integer img)
{
    return img_yres(img);
}

boolean ispdfimage(integer img)
{
    return img_type(img) == IMAGE_TYPE_PDF;
}

boolean checkimageb(integer procset)
{
    return procset & IMAGE_COLOR_B;
}

boolean checkimagec(integer procset)
{
    return procset & IMAGE_COLOR_C;
}

boolean checkimagei(integer procset)
{
    return procset & IMAGE_COLOR_I;
}

void updateimageprocset(integer img)
{
    pdfimageprocset |= img_color(img);
}

integer epdforigx(integer img)
{
    return pdf_ptr(img)->orig_x;
}

integer epdforigy(integer img)
{
    return pdf_ptr(img)->orig_y;
}

integer imagepages(integer img)
{
    return img_pages(img);
}

integer readimage(strnumber s, integer page_num)
{
    char *image_suffix;
    integer img = new_image_entry();
    cur_file_name = makecstring(s);
    img_name(img) = kpse_find_file(cur_file_name, kpse_tex_format, true);
    if (img_name(img) == 0)
        pdftex_fail("cannot find image file");
    if ((image_suffix = rindex(cur_file_name, '.')) == 0)
        pdftex_fail("cannot find image file name extension");
    if (strcasecmp(image_suffix, ".pdf") == 0) {
        img_type(img) = IMAGE_TYPE_PDF;
        pdf_ptr(img) = xtalloc(1, pdf_image_struct);
        read_pdf_info(img_name(img), page_num);
        img_width(img) = bp2integer(epdf_width);
        img_height(img) = bp2integer(epdf_height);
        img_pages(img) = epdf_num_pages;
        pdf_ptr(img)->orig_x = bp2integer(epdf_orig_x);
        pdf_ptr(img)->orig_y = bp2integer(epdf_orig_y);
        pdf_ptr(img)->selected_page = page_num;
        pdf_ptr(img)->xref = epdf_xref;
        pdf_ptr(img)->doc = epdf_doc;
    }
    else if (strcasecmp(image_suffix, ".png") == 0) {
        img_type(img) = IMAGE_TYPE_PNG;
        img_pages(img) = 1;
        read_png_info(img);
    }
    else if (strcasecmp(image_suffix, ".jpg") == 0 ||
             strcasecmp(image_suffix, ".jpeg") == 0) {
        jpg_ptr(img) = xtalloc(1, JPG_IMAGE_INFO);
        img_type(img) = IMAGE_TYPE_JPG;
        img_pages(img) = 1;
        read_jpg_info(img);
    }
#ifdef HAVE_TIFF
    else if (strcasecmp(image_suffix, ".tif") == 0 ||
             strcasecmp(image_suffix, ".tiff") == 0) {
        img_type(img) = IMAGE_TYPE_TIF;
        img_pages(img) = 1;
        read_tif_info(img);
    }
#endif
    else 
        pdftex_fail("unknown type of image");
    cur_file_name = 0;
    return img;
}

void writeimage(integer img)
{
    tex_printf(" <%s", img_name(img));
    switch (img_type(img)) {
    case IMAGE_TYPE_PNG:
        write_png(img);
        break;
    case IMAGE_TYPE_JPG:
        write_jpg(img);
        break;
#ifdef HAVE_TIFF
    case IMAGE_TYPE_TIF:
        write_tif(img);
        break;
#endif
    case IMAGE_TYPE_PDF:
        epdf_xref = pdf_ptr(img)->xref;
        epdf_doc = pdf_ptr(img)->doc;
        epdf_selected_page = pdf_ptr(img)->selected_page;
        write_epdf();
        break;
    default:
        pdftex_fail("unknown type of image");
    }
    tex_printf(">");
}

void deleteimage(integer img)
{
    switch (img_type(img)) {
    case IMAGE_TYPE_PDF:
        epdf_xref = pdf_ptr(img)->xref;
        epdf_doc = pdf_ptr(img)->doc;
        epdf_delete();
        break;
    case IMAGE_TYPE_PNG:
        xfclose(png_ptr(img)->io_ptr, cur_file_name);
        png_destroy_read_struct(&(png_ptr(img)), &(png_info(img)), NULL);
        break;
    case IMAGE_TYPE_JPG:
        xfclose(jpg_ptr(img)->file, cur_file_name);
        break;
#ifdef HAVE_TIFF
    case IMAGE_TYPE_TIF:
        TIFFClose(tif_ptr(img));
        break;
#endif
    default:
        pdftex_fail("unknown type of image");
    }
    xfree(img_name(img));
    return;
}

void img_free() 
{
    xfree(image_tab);
}
