# Makefile for the Metafont window support library.
INCLUDE=$(INCLUDE);../../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include "../kpathsea.mk"

LN = copy
DEFS = $(DEFS) -DHAVE_CONFIG_H
x_cppflags = -I../..
library = window

# Extra library-specific compiler options.
prog_cflags = -I.. -I$(srcdir)/.. $(x_cppflags)

#objects = $(objdir)\amiga.obj $(objdir)\hp2627.obj $(objdir)\mftalk.obj $(objdir)\next.obj $(objdir)\regis.obj $(objdir)\suntools.obj \
#	$(objdir)\tek.obj $(objdir)\trap.obj $(objdir)\uniterm.obj $(objdir)\x11.obj 
objects = $(objdir)\epsf.obj $(objdir)\win32.obj $(objdir)\trap.obj

default all: $(objdir) $(objdir)\$(library).lib

$(objdir)\$(library).lib: $(objects)
	-@$(RM) $@
	$(AR) /OUT:$@ $(objects)

$(objdir)\epsf.obj: $(objdir) epsf.c

$(objdir)\win32.obj: $(objdir) win32.c

$(objdir)\trap.obj: $(objdir) trap.c

# It doesn't matter much what this default is, since if anything was
# enabled configure would hopefully have found it.
x11.c:
	-@$(RM) $@
	$(LN) $(srcdir)/x11-Xt.c $@

#Makefile: Makefile.in ../config.status
#	cd ..; $(SHELL) config.status

!include <make/clean.mak>
!include <make/tkpathsea.mak>

distclean::
	-@$(RM) -f x11.c

!include <make/rdepend.mak>
!include "./depend.mak"

# Local Variables:
# mode: Makefile
# End:
