# Makefile for TeX-project WEB sources to C conversion programs.
INCLUDE=$(INCLUDE);../../win32

# These get expanded from the parent directory, not this one.
!include <make/paths.mak>
!include <make/common.mak>
!include <make/programs.mak>
!include "../kpathsea.mk"

# LEX = flex
LEXLIB = 
LEX_OUTPUT_ROOT = lex_yy
# YACC = bison -y

DEFS = $(DEFS) -DHAVE_CONFIG_H

proglib = ../lib/$(objdir)/lib.lib
programs = $(objdir)\web2c.exe $(objdir)\fixwrites.exe $(objdir)\splitup.exe

web2c_objects = $(objdir)\main.obj $(objdir)\y_tab.obj $(objdir)\$(LEX_OUTPUT_ROOT).obj

all: $(objdir) $(programs)

$(objdir)\web2c.exe:: $(web2c_objects) $(objdir)\web2c.res
	$(kpathsea_link) $(web2c_objects) $(objdir)\web2c.res $(LEXLIB) $(LOADLIBES) 

# We use y_tab.* for the sake of MS-DOS.
$(objdir)\main.obj: main.c y_tab.h
y_tab.c y_tab.h: web2c.y
	@echo Expect one shift/reduce conflict.
#	@set BISON_SIMPLE=$(gnushare)/bison.simple
	$(YACC) -d -v $(srcdir)/web2c.y -o y_tab.c
$(objdir)\$(LEX_OUTPUT_ROOT).obj: y_tab.h
$(LEX_OUTPUT_ROOT).c: web2c.l
	$(LEX) -t $(srcdir)/web2c.l | $(SED) "/^extern int isatty YY/d" > $(LEX_OUTPUT_ROOT).c

$(objdir)\fixwrites.exe:: $(objdir) $(objdir)\fixwrites.obj
	$(kpathsea_link) $(objdir)\fixwrites.obj $(LOADLIBES)
$(objdir)\splitup.exe:: $(objdir)\splitup.obj
	$(kpathsea_link) $(objdir)\splitup.obj $(LOADLIBES)
$(objdir)\regfix.exe:: $(objdir)\regfix.obj
	$(kpathsea_link) $(objdir)\regfix.obj $(LOADLIBES)

$(programs):: $(proglib) $(kpathsea)

##ifdef HOSTNAME
### It's really not worth srcdir etc. here.
##lib_sources = $(addprefix ../lib/,alloca.c basechsuffix.c chartostring.c \
##  eofeoln.c fprintreal.c input2int.c inputint.c main.c openclose.c \
##  uexit.c usage.c version.c zround.c)
##$(proglib): $(lib_sources)
##	cd ../lib && $(MAKE)
##always:
##endif

#Makefile: Makefile.in ../config.status
#	cd ..; $(SHELL) config.status

!include <make/tkpathsea.mak>
!include <make/version.mak>
!include <make/clean.mak>

clean::
	-@$(RM) y_tab.c y_tab.h y.output yacc.* $(LEX_OUTPUT_ROOT).c

!include <make/rdepend.mak>
!include "./depend.mak"

# Local Variables:
# mode: Makefile
# End:
