# Makefile for the MetaPost support programs.
INCLUDE=$(INCLUDE);../../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/programs.mak>
!include "../kpathsea.mk"

DEFS = $(DEFS) -DHAVE_CONFIG_H
proglib = ../lib/$(objdir)/lib.lib
programs = $(objdir)\dmp.exe $(objdir)\mpto.exe $(objdir)\newer.exe

default: $(objdir) all
all: $(programs) 

$(objdir)\dmp.exe: $(objdir)\dmp.obj $(objdir)\dmp.res $(kpathsea)
	$(kpathsea_link) $(objdir)\dmp.obj $(objdir)\dmp.res $(LOADLIBES)
$(objdir)\mpto.exe: $(objdir)\mpto.obj $(objdir)\mpto.res
	$(link_command) $(objdir)\mpto.obj $(proglib) $(objdir)\mpto.res $(LIBS) $(XLOADLIBES)
$(objdir)\newer.exe: $(objdir)\newer.obj
	$(link_command) $(objdir)\newer.obj $(proglib) $(LIBS) $(XLOADLIBES)

$(objdir)\newer.obj $(objdir)\dmp.obj: $(objdir) ../c-auto.h

checkdir = $(srcdir)/../tests
check: $(objdir)\mpto.exe $(objdir)\newer.exe $(objdir)\dmp.exe
	pushd $(top_srcdir)\contrib & $(MAKE) $(makeflags) $(objdir)\makempx.exe & popd
	$(top_srcdir)\contrib\$(objdir)\makempx $(checkdir)/label.mp $(checkdir)/xlabel.mpx
	.\$(objdir)\mpto -tex $(checkdir)/testex.mp | diff $(checkdir)/testex.tex -
	sed '16s/^%//' <$(checkdir)/testex.mp >testex1
	-.\$(objdir)\mpto -tex testex1 >nul 2>testex2
	sed '17s/^%//' <$(checkdir)/testex.mp >testex1
	-.\$(objdir)\mpto -tex testex1 >nul 2>>testex2
	sed '18s/^%//' <$(checkdir)/testex.mp >testex1
	-.\$(objdir)\mpto -tex testex1 >nul 2>>testex2
	sed '19s/^%//' <$(checkdir)/testex.mp >testex1
	-.\$(objdir)\mpto -tex testex1 >nul 2>>testex2
	sed '20s/^%//' <$(checkdir)/testex.mp >testex1
	-.\$(objdir)\mpto -tex testex1 >nul 2>>testex2
	diff $(checkdir)/testex.err testex2

#Makefile: Makefile.in ../config.status
#	(cd ..; sh config.status)

install: install-exec install-data
install-exec: $(programs)
	$(mktexdir) $(bindir) $(scriptdir)
	for %%p in (mpto.exe newer.exe dmp.exe) do \
	$(INSTALL_PROGRAM) $(objdir)\%%p $(bindir)\%%p
install-data:

!include <make/tkpathsea.mak>
!include <make/version.mak>
!include <make/clean.mak>

mostlyclean::
	-@$(RM) testex1 testex2

!include <make/rdepend.mak>
!include "./depend.mak"

# Local Variables:
# mode: Makefile
# End:
