# Makefile for Web2c documentation.
INCLUDE=$(INCLUDE);../../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/programs.mak>
!include <make/texi.mak>

all: web2c.info web2c.dvi web2c.pdf 

web2c.info: install.texi ref.txi

web2c_toc.html: web2c.texi
	$(TEXI2HTML) $(TEXI2HTML_FLAGS) $**

!if 0
INSTALL: install.texi
	$(MAKEINFO) $(one_info) $(MAKEINFO_FLAGS) $** -o $@
	$(PERL) $(win32)/add-info-toc $@
doc: info INSTALL

ref.txi: ref.bbl
	sed -f $(win32seddir)/web2c-doc.sed < $** >$@

ref.bbl: ref.aux texinfo.bst
	-bibtex ref

ref.aux: ref.tex
	rm -f ref.bbl
	tex "\nonstopmode \input ref"
!endif

!include <make/man.mak>
!include <make/tkpathsea.mak>

install:: install-info install-doc

install-info:: $(mktexdir) web2c.info
	$(mktexdir) $(infodir)
	if EXIST web2c.info \
	  cd $(srcdir) && for %%i in (web2c.info*) do \
	    $(INSTALL_DATA) %%i $(infodir)\%%i
	-install-info --version > nul
	if ERRORLEVEL 0 \
          install-info --info-dir=$(infodir) $(infodir)/web2c.info

install-doc:: $(mktexdir) web2c_toc.html web2c.pdf
	$(mktexdir) $(docdir)/html/web2c $(docdir)/web2c
	-$(CP) *.html $(docdir)\html\web2c & $(RM) *.html
	-$(CP) *.pdf $(docdir)\web2c & $(RM) *.pdf

clean::
	-@$(RM) web2c.info* web2c.pdf *.html web2c.ps

extraclean::
	-@$(RM) web2c.pdf web2c.log web2c.aux
	-echo $(verbose) & for %%i in (cm cp fl fn ky op pg toc tp vr) do \
		$(RM) web2c.%%i web2c.%%is

!include <make/clean.mak>

#
# Local Variables:
# mode: makefile
# End:

