# Makefile for kpathsea --kb@mail.tug.org.  Public domain.
INCLUDE=$(INCLUDE);../win32

version = KPSEVERSION

# Add -DNO_DEBUG to disable debugging, for vanishingly better performance.

!include <make/paths.mak>
!include <make/makevars.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>
!include <make/texi.mak>

{../win32/lib}.c{$(objdir)}.obj:
	$(compile) $<

warn_more = -Wmissing-prototypes -Wwrite-strings -Wshadow
MAKEINFO_FLAGS = $(MAKEINFO_FLAGS) --no-split

# Install these header files (except acconfig.h).
install_headers = *.h $(srcdir)/*.h

DEFS = $(DEFS) -DMAKE_KPSE_DLL -DHAVE_CONFIG_H \
	-DNO_MULTIPLE_EXTENSIONS

# Put $(objdir)\tex-file.obj first, because it's what depends on the paths, and may
# reduce frustration if the paths are wrong by doing it first.

objects = $(objdir)\tex-file.obj $(objdir)\absolute.obj $(objdir)\atou.obj $(objdir)\cnf.obj             \
	$(objdir)\concat.obj $(objdir)\concat3.obj $(objdir)\concatn.obj                                 \
	$(objdir)\db.obj                                                                                 \
	$(objdir)\debug.obj $(objdir)\dir.obj $(objdir)\elt-dirs.obj $(objdir)\expand.obj                \
	$(objdir)\extend-fname.obj $(objdir)\find-suffix.obj $(objdir)\fn.obj $(objdir)\fontmap.obj      \
	$(objdir)\getopt.obj $(objdir)\getopt1.obj                                                       \
	$(objdir)\hash.obj $(objdir)\kdefault.obj                                                        \
	$(objdir)\line.obj $(objdir)\magstep.obj $(objdir)\make-suffix.obj $(objdir)\path-elt.obj        \
	$(objdir)\pathsearch.obj $(objdir)\proginit.obj $(objdir)\progname.obj $(objdir)\readable.obj    \
	$(objdir)\rm-suffix.obj $(objdir)\str-list.obj $(objdir)\str-llist.obj $(objdir)\tex-glyph.obj   \
	$(objdir)\tex-hush.obj $(objdir)\tex-make.obj $(objdir)\tilde.obj $(objdir)\truncate.obj         \
	$(objdir)\uppercasify.obj $(objdir)\variable.obj $(objdir)\version.obj $(objdir)\xbasename.obj   \
	$(objdir)\xcalloc.obj $(objdir)\xdirname.obj $(objdir)\xfopen.obj $(objdir)\xfseek.obj           \
	$(objdir)\xftell.obj  $(objdir)\xgetcwd.obj                                                      \
	$(objdir)\xmalloc.obj                                                                            \
	$(objdir)\xputenv.obj $(objdir)\xrealloc.obj                                                     \
	$(objdir)\xstrdup.obj                                                                            \
	$(liblobjs) $(malloc)
liblobjs = 	\
	$(objdir)\error.obj  	\
	$(objdir)\lookcmd.obj  	\
	$(objdir)\ghostscr.obj  \
	$(objdir)\stat.obj 		\
	$(objdir)\system.obj    \
	$(objdir)\popen.obj		\
	$(objdir)\dirent.obj	\
	$(objdir)\user.obj		\
	$(objdir)\time.obj		\
	$(objdir)\volume.obj	\
	$(objdir)\filename.obj	\
	$(objdir)\home.obj	

library = kpathsea

# We want to compile almost everything with libtool ...
KPATHSEA_CC = $(LIBTOOL) compile "$(CC)"
.SUFFIXES: .lo
.c.lo:
	$(KPATHSEA_CC) $< $(ALL_CFLAGS)

default all: $(objdir) $(gnuw32lib) $(objdir)\kpsewhich.exe $(objdir)\kpsestat.exe \
	$(objdir)\access.exe $(library).info manfiles

$(objdir)\kpsewhich.exe: $(kpathsea) $(objdir)\kpsewhich.obj $(objdir)\kpsewhich.res
	$(kpathsea_link) $(objdir)\kpsewhich.obj $(objdir)\kpsewhich.res $(LOADLIBES)

$(objdir)\kpsestat.exe: $(objdir)\kpsestat.obj
	$(link_command) $(objdir)\kpsestat.obj $(LIBS)

$(objdir)\access.exe: $(objdir)\access.obj
	$(link_command) $(objdir)\access.obj $(LIBS)

$(kpathsea): $(objdir)\kpathsea.lib

!IFDEF KPSE_DLL
$(kpathsea): $(objdir)\kpathsea.lib $(objdir)\kpathsea.dll

$(objdir)\kpathsea.lib: $(objdir) $(objects)
	$(archive_command) /DEF $(objects)

$(objdir)\kpathsea.dll: $(objdir) $(objdir)\kpathsea.lib \
	$(objects) $(objdir)\kpathsea.res
	$(dll_command) $(objdir)\kpathsea.exp $(objects) $(objdir)\kpathsea.res $(libc) user32.lib $(XLIBS)
!ELSE
$(kpathsea): $(objdir)\kpathsea.lib

$(objdir)\kpathsea.lib: $(objdir) $(objects)
	$(archive_command) $(objects)
!ENDIF

#$(kpathsea): $(objects) klibtool.version
#	$(LIBTOOL) archive $(AR) $(ARFLAGS) $@ $(objects)

# All the objects depend on the klibtool configuration file.
# $(objects): ../klibtool.config

# Create klibtool.version in the build tree
# klibtool.version:
# 	$(LN) $(srcdir)/kpathsea.version $@

# Make variable substitutions for paths.h.
texmf.cnf: texmf.in texmf.sed
	$(SED) -e "/^[^%]/s/:/;/g" $(srcdir)/texmf.in \
	| $(SED) -e "/^TEXMFMAIN/s/@texmf@/$$SELFAUTOPARENT\/texmf/" \
	| $(SED) -e "/^TEXMFCNF/s/\(.*\);[^;]*;\([^;]*\);@web2c@/\1;\2;@web2c@/" \
	| $(SED) -f texmf.sed \
# Better to ensure c:/TeX is choosen, instead of e:/...
	| $(SED) -e "s%$(prefix:\=/)%c:/TeX%g" \
	>$@

# The idea is to turn each var=value into s%@var@%value%g. Seems simpler
# to put the substitutions in a file than to play shell quoting games.
texmf.sed: $(win32makedir)/makevars.mak $(win32makedir)/paths.mak
	$(RM) texmf.sed
	@echo <<makevars.txt
$(makevars)
<<KEEP 
	type makevars.txt \
	| $(SED) -e "s/ [ ]*/ /g" -e "s@\\@/@g" \
	| $(TR) " " "\012" \
	| $(SED) -f $(win32seddir)/texmfsed.sed \
#	| $(SED)  -e "s/^/s%@/" -e "s/=/@%/" -e "s/$$/%/" -e "s/$$/g/" \
	> $@
# Insert $TEXMF in as many of the hardwired paths as possible.  We could
# use the slightly different rule 's%$(texmf)/%\$$TEXMF/%g' and avoid
# the need for the corrections below.  But if texmf.in is edited
# the heuristic may no longer work.
	echo s%$(texmf:\=/)%$$TEXMF%g>>$@
# Now we repair the damage this may have caused.  Don't replace the rhs of
# the TEXMFMAIN assignment itself, then we'd end up with TEXMFMAIN = $TEXMF
# and TEXMF = $TEXMFMAIN.  The (commented) assignment of TEXMFLOCAL is
# likely to have been mangled as well.
	echo /^ *TEXMFMAIN[ =]/s%\$$TEXMF%$(texmf:\=/)%>>$@
	echo /^[% ]*TEXMFLOCAL[ =]/s%\$$TEXMF%$(texmf:\=/)%>>$@
#	echo /^[% ]*TEXMF_CNF[ =]/s%\$$TEXMF%$(texmf:\=/)%>>$@
#	echo /^[% ]*TEXMFCNF[ =]/s%\$$TEXMF%$(texmf:\=/)%>>$@
# And fill in the last clause of TEXMFCNF with an absolute path.
	echo /^ *TEXMFCNF[ =]/s%@web2c@%$(web2cdir:\=/)%>>$@
	-@$(RM) makevars.txt

# First null out comments and leading/trailing whitespace, then remove
# lines that define invalid C identifiers, then remove blank lines and
# lines that define lowercase values (those are never path values). Each
# line remaining looks like
# <name> = <value>
# (but = and surrounding spaces are optional, hence can't remove all spaces).
# Change this to #ifndef DEFAULT_name@#define DEFAULT_name "value"@#endif,
# then change the @'s to newlines (sed isn't good at multiline replacements).
# 
# No backslash-newline escapes in the long sed replacement because that
# will turn into a space in the output.
# 
# Without the $TEXMF/prefix/etc. substitutions, if the cnf file was
# not found, the compile-time paths would be of little use, since TEXMF
# (etc.) wouldn't be defined. Alternatively, we could have a way to
# specify compile-time default values for variables in general, but I
# think it's better to keep the last-resort paths as simple as possible.
# 
# The definition of DEFAULT_TEXMF (and other variables)
# that winds up in the final paths.h will not be used.
#
# We don't want to rewrite paths.h when we have only changed comments
# in texmf.in that have no effect on paths.h, since that would cause
# almost everything to be rebuilt.
#
# We also replace all semicolons with colons in the paths.  Ultimately
# the path-splitting code should be changed to understand both.
$(kpathsea_dir)/paths.h: stamp-paths
stamp-paths: texmf.cnf
	echo /* paths.h: Generated from texmf.cnf.  */ > paths.tmp
	$(SED) -e "s/%.*//" -e "s/^[ 	]*//" -e "s/[ 	]*$$//" texmf.cnf \
	| $(GREP) "^[ 	]*[A-Z0-9_]*[ 	=]" \
	| $(SED) "/^$$/d" \
	| $(SED) "s/^\([^ 	=]*\)[ 	]*=*[ 	]*\(.*\)/#ifndef DEFAULT_\1@#define DEFAULT_\1 \"\2\"@#endif/" \
	| $(TR) @ "\012" \
	| $(SED) -e "s@\$$TEXMFMAIN@$(texmf:\=/)@g" \
	      -e "s@\$$TEXMF@$(texmf:\=/)@g" \
	      -e "s@\$$VARTEXFONTS@c:/tex/fonts@g" \
	      -e "s@\$$web2cdir@$(web2cdir:\=/)@g" \
	      -e "s@\$$prefix@$(prefix:\=/)@g" \
# Better to ensure c:/TeX is choosen, instead of e:/...
	      -e "s@$(prefix:\=/)@c:/TeX@g" \
#	| $(SED) -e "s%;%:%g" \
	>>paths.tmp
#	fc paths.h paths.tmp > nul
#	if %ERRORLEVEL% NEQ 0 \
#	  echo copying paths.tmp paths.h\
#	  & $(CP) paths.tmp paths.h
#	$(RM) paths.tmp
	$(CP) paths.tmp paths.h & $(RM) paths.tmp
	date /t > stamp-paths
	time /t >> stamp-paths

# Need an extra definition for this. Dependencies included below.
$(objdir)\tex-file.obj:
	$(compile) -DDEFAULT_FONT_SIZES=\"$(default_texsizes)\" \
	$(srcdir)/tex-file.c

check: $(objdir)\kpsewhich.exe
	.\$(objdir)\kpsewhich -expand-var $$TEXMF

!ifndef MAINT
install:: install-exec install-data
!endif
uninstall: uninstall-exec uninstall-data

install-exec:: $(mktexdir) $(objdir)\kpsewhich.exe $(objdir)\kpsestat.exe $(objdir)\access.exe
	$(mktexdir) $(bindir) $(scriptdir) \
	  $(libdir) $(web2cdir)
#	if grep 'original mktexpk --' $(scriptdir)/mktexpk >/dev/null 2>&1\
#	   || test ! -r $(scriptdir)/mktexpk; then \
#	  $(INSTALL_SCRIPT) $(srcdir)/mktexpk $(scriptdir)/mktexpk; \
#	else true; fi
#	if grep 'original mktexmf --' $(scriptdir)/mktexmf >/dev/null 2>&1\
#	   || test ! -r $(scriptdir)/mktexmf; then \
#	  $(INSTALL_SCRIPT) $(srcdir)/mktexmf $(scriptdir)/mktexmf; \
#	else true; fi
#	if grep 'original mktextfm --' $(scriptdir)/mktextfm >/dev/null 2>&1\
#	   || test ! -r $(scriptdir)/mktextfm; then \
#	  $(INSTALL_SCRIPT) $(srcdir)/mktextfm $(scriptdir)/mktextfm; \
#	else true; fi
#	if grep 'original mktexlsr --' $(scriptdir)/mktexlsr >/dev/null 2>&1\
#	   || test ! -r $(scriptdir)/mktexlsr; then \
#	  $(INSTALL_SCRIPT) $(srcdir)/mktexlsr $(scriptdir)/mktexlsr; \
#	else true; fi
#	$(INSTALL_SCRIPT) $(srcdir)/mktex.opt $(web2cdir)/mktex.opt
#	$(INSTALL_SCRIPT) $(srcdir)/mktexdir $(web2cdir)/mktexdir
#	$(INSTALL_SCRIPT) $(srcdir)/mktexdir.opt $(web2cdir)/mktexdir.opt
#	$(INSTALL_SCRIPT) $(srcdir)/mktexnam $(web2cdir)/mktexnam
#	$(INSTALL_SCRIPT) $(srcdir)/mktexnam.opt $(web2cdir)/mktexnam.opt
#	$(INSTALL_SCRIPT) $(srcdir)/mktexupd $(web2cdir)/mktexupd
	$(INSTALL_PROGRAM) $(objdir)\kpathsea.dll $(bindir)
	$(INSTALL_PROGRAM) $(objdir)\kpathsea.lib $(libdir)
#	$(INSTALL_LIBTOOL_PROG) $(bindir) kpsewhich
	$(INSTALL_PROGRAM) $(objdir)\kpsewhich.exe $(bindir)
	$(INSTALL_PROGRAM) $(objdir)\kpsestat.exe $(bindir)
	$(INSTALL_PROGRAM) $(objdir)\access.exe $(bindir)
#	$(INSTALL_PROGRAM) $(objdir)\readlink.exe $(bindir)
uninstall-exec:
	-@$(RM) $(bindir)\kpsewhich.exe

install-data:: $(mktexdir) texmf.cnf kpathsea.info install-info install-man install-doc
	$(mktexdir) $(texmf) $(infodir) $(web2cdir)
	$(SED) -e "s@$(prefix:\=/)@$$SELFAUTOPARENT@" < texmf.cnf > $(web2cdir)\texmf.cnf
#	if $(GREP) 'original texmf.cnf --' $(web2cdir)/texmf.cnf >/dev/null 2>&1 \
#	   || test ! -r $(web2cdir)/texmf.cnf; then
#	$(SED) -e "s@$(prefix:\=/)@$$SELFAUTOPARENT@" < texmf.cnf > $(web2cdir)\texmf.cnf
#	else true; fi
# Should we install the headers?  They are not just system-dependent,
# which is bad enough, but even compiler-dependent.
	$(mktexdir) $(includedir)\kpathsea
	for %%f in ($(install_headers)) do \
	  $(INSTALL_DATA) %%f $(includedir)\kpathsea
	-@$(RM) $(includedir)\kpathsea\acconfig.h
	-@if NOT EXIST $(temxf)\ls-R \
		$(mktexlsr) $(texmf)

install-info:: $(mktexdir) $(library).info
	$(mktexdir) $(infodir)
	$(INSTALL_DATA) $(srcdir)\kpathsea.info $(infodir)\kpathsea.info
# installing base $(infodir)/dir file
	if NOT EXIST $(infodir)\dir \
	  if EXIST $(top_srcdir)\dir-example \
	    $(INSTALL_DATA) $(top_srcdir)\dir-example $(infodir)\dir
	-install-info --version > nul
# installing base $(infodir)/dir file
	if ERRORLEVEL 0 \
          install-info --info-dir=$(infodir) $(infodir)/kpathsea.info
#	if $(SHELL) -c 'install-info --version' >/dev/null 2>&1; then \
#	  install-info --info-dir=$(infodir) $(infodir)/kpathsea.info; \
#	else true; fi

install-doc:: $(library).pdf # $(library).ps
	$(mktexdir) $(texmf)/doc/html/kpathsea $(texmf)/doc/kpathsea
#	$(INSTALL_DATA) $(library).ps $(prefix)\doc\ps
	$(INSTALL_DATA) $(library).pdf $(texmf)\doc\kpathsea\kpathsea.pdf
	$(TEXI2HTML) $(TEXI2HTML_FLAGS) $(library).texi
	-$(CP) *.html $(texmf)\doc\html\kpathsea

uninstall-data:
	-@$(RM) $(infodir)\kpathsea.info*
	for %%f in ($(install_headers)) do -@$(RM) $(includedir)\%%f

# distdir is used by other distributions; they define $(distdir).
distdir: doc $(library).dvi $(library).h
	rm -rf $(distdir)
	mkdir -p $(distdir)
	ln $(ln_files) kpathsea.version $(distdir)
	touch *.info*
	ln mktex* *.info* *.texi $(library).aux $(library).cps $(distdir)
	rm -f $(distdir)/*.1 $(distdir)/*.man
	ln *.man $(distdir)
	ln BUGS README.CONFIGURE HIER PROJECTS *.ac $(distdir)
	touch kpathsea.h # to avoid .cps.h rule on Solaris
	cd $(distdir) && rm -f paths.h

# I don't use this, but other programmers want it.  acconfig.h is an
# autoheader input file, not an includable C header. Bad name.
$(library).h: always
	rm -f $@
	@echo <<$@
#include <kpathsea/config.h>
<<KEEP
	dir /b *.h | grep -v "\(acconfig\|config\|kpathsea\|win32lib\|c-auto\)\.h" \
	  | $(SED) -e "s,^,#include <kpathsea/," -e s",$$,>," >>$@	  
#	touch -r `ls -1t *.h | tail +2 | head -1` $@ 
always:
.PHONY: always

!include <make/libsrul.mak>
!include <make/config.mak>

info: $(library).info
dvi: $(library).dvi
ps: $(library).ps

$(library).info: kpathsea.texi bugs.texi hier.texi install.texi unixtex.texi
	-$(MAKEINFO) $(MAKEINFO_FLAGS) kpathsea.texi -o $@

!IFDEF MAINT
INSTALL: install.texi
	$(MAKEINFO) $(one_info) $(MAKEINFO_FLAGS) install.texi -o $@
	$(PERL) $(win32perldir)\add-info-toc.pl $@
BUGS: bugs.texi
	$(MAKEINFO) $(one_info) $(MAKEINFO_FLAGS) bugs.texi -o $@
	$(PERL) $(win32perldir)\add-info-toc.pl $@
HIER: hier.texi
	$(MAKEINFO) $(one_info) $(MAKEINFO_FLAGS) hier.texi -o $@
unixtex.ftp: unixtex.texi
	$(MAKEINFO) $(one_info) $(MAKEINFO_FLAGS) unixtex.texi -o $@
doc: info dvi ps HIER BUGS INSTALL unixtex.ftp
!endif

# This is to avoid redundancy 
KPATHSEA_MAKE=1
!include <make/tkpathsea.mak>
!include <make/version.mak>

!include <make/clean.mak>

mostlyclean::
	-@$(RM) $(objdir)\kpsewhich.exe $(objdir)\kpsestat.exe \
	$(objdir)\access.exe $(objdir)\*.obj klibtool.version
	-@$(RM) PROF PROF_SHARED SHARED STATIC

extraclean::
	-@echo $(verbose) & for %%i in (cm cp fl fn ky op pg toc tp vr) do \
	$(RM) $(library).%%i
	-@echo $(verbose) & $(RM) $(library)*.html $(library)*.pdf

distclean::
	-@$(RM) -f c-auto.h paths.h texmf.cnf texmf.sed stamp-paths

# Beware: we are not building the dll anymore

$(objdir)\kpsewhich.obj: kpsewhich.c
	$(compile) -UMAKE_KPSE_DLL kpsewhich.c

# These 2 can be linked statically with gnuw32

$(objdir)\kpsestat.obj: $(gnuw32lib) kpsestat.c
	$(compile) -DMAKE_GNUW32_STATIC kpsestat.c

$(objdir)\access.obj: $(gnuw32lib) access.c
	$(compile) -DMAKE_GNUW32_STATIC access.c

$(objdir)\lookcmd.obj:	..\win32\lib\lookcmd.c
$(objdir)\ghostscr.obj:	..\win32\lib\ghostscr.c
$(objdir)\stat.obj:	..\win32\lib\stat.c
$(objdir)\system.obj:	..\win32\lib\system.c
$(objdir)\popen.obj:	..\win32\lib\popen.c
$(objdir)\dirent.obj:	..\win32\lib\dirent.c
$(objdir)\user.obj:	..\win32\lib\user.c
$(objdir)\time.obj:	..\win32\lib\time.c
$(objdir)\volume.obj:	..\win32\lib\volume.c
$(objdir)\filename.obj:	..\win32\lib\filename.c
$(objdir)\home.obj:	..\win32\lib\home.c

# The manual pages
manfiles = access.1 kpsestat.1 kpsewhich.1 \
           mktexlsr.1 mktexmf.1 mktextfm.1 mktexpk.1

!include <make/man.mak>

!include <make/rdepend.mak>
!include "./depend.mak"

# Local Variables:
# mode: Makefile
# End:
