# Makefile for MkTeX... programs which emulate the shell scripts.
INCLUDE=$(INCLUDE);../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

DEFS = $(DEFS) -DKPATHSEA -DHAVE_CONFIG_H \
	-I.. -I../kpathsea -I$(REGEXLIBDIR)

c_auto_h_dir = $(kpathsea_srcdir)

!IFDEF MKTEX_DLL
DEFS = -DMAKE_MKTEX_DLL $(DEFS) 
MKTEX = $(objdir)\mktex.lib $(objdir)\mktex.dll
!ELSE
MKTEX = $(objdir)\mktex.lib
!ENDIF
mktex_objs = $(objdir)\fileutils.obj $(objdir)\mktex.obj \
#	$(objdir)\regex.obj \
	$(objdir)\variables.obj $(objdir)\stackenv.obj

mktex_progs = $(objdir)\mktexlsr.exe $(objdir)\mktexnam.exe \
	$(objdir)\mktexupd.exe $(objdir)\mktexpk.exe         \
	$(objdir)\mktexdir.exe $(objdir)\mktexmf.exe         \
	$(objdir)\mktextfm.exe

programs = $(objdir)\dvihp.exe $(objdir)\makempx.exe $(objdir)\mktex.exe \
	$(objdir)\fmtutil.exe 

!IFDEF MKTEX_DLL
default: $(objdir) $(kpathsea) $(objdir)\mktex.dll $(programs)

$(objdir)\mktex.lib: $(objdir) $(kpathsea) $(mktex_objs) 
	$(archive_command) /DEF $(mktex_objs)

$(objdir)\mktex.dll: $(objdir) $(kpathsea) $(mktex_objs) $(objdir)\mktex.lib $(objdir)\mktex.res $(regexlib)
	$(dll_command) $(mktex_objs) $(objdir)\mktex.exp $(objdir)\mktex.res $(LOADLIBES) $(regexlib)
!ELSE
default: $(objdir) $(kpathsea) $(programs)

$(objdir)\mktex.lib: $(objdir) $(kpathsea) $(mktex_objs) $(regexlib)
	$(archive_command) $(mktex_objs) $(regexlib)
!ENDIF

all: default
	for %%i in ($(mktex_progs)) \
		do $(CP) $(objdir)\mktex.exe $(objdir)\%%~nxi

$(objdir)\makempx.exe: $(objdir) $(kpathsea) $(objdir)\makempx.obj $(objdir)\mktex.lib $(objdir)\makempx.res 
	$(link_command) $(objdir)\makempx.obj $(objdir)\mktex.lib $(objdir)\makempx.res $(LOADLIBES)

$(objdir)\fmtutil.exe: $(objdir) $(kpathsea) $(objdir)\fmtutil.obj $(objdir)\mktex.lib
	$(link_command) $(objdir)\fmtutil.obj $(objdir)\mktex.lib $(LOADLIBES)

$(objdir)\dvihp.exe: $(objdir) $(kpathsea) $(objdir)\dvihp.obj \
	$(objdir)\mktex.lib $(objdir)\dvihp.res
	$(kpathsea_link) $(objdir)\dvihp.obj $(objdir)\mktex.lib           \
	$(objdir)\dvihp.res $(LOADLIBES)

$(objdir)\mktex.exe: $(objdir) $(objdir)\main.obj $(MKTEX)
	$(link_command) $(objdir)\main.obj $(objdir)\mktex.lib $(LOADLIBES)
	$(CP) $(objdir)\mktex.exe $(objdir)\mktexdir.exe

$(objdir)\makempx.obj:	makempx.c
	$(compile) -UMAKE_MKTEX_DLL makempx.c

$(objdir)\fmtutil.obj:	fmtutil.c
	$(compile) -UMAKE_MKTEX_DLL fmtutil.c

$(objdir)\main.obj: main.c
	$(compile) -UMAKE_MKTEX_DLL main.c

$(objdir)\dvihp.obj: dvihp.c
	$(compile) -UMAKE_MKTEX_DLL dvihp.c

!include <make/libsrul.mak>
!include <make/tkpathsea.mak>
!include <make/version.mak>
!include <make/man.mak>
!include <make/clean.mak>

install: all
!IFDEF MKTEX_DLL
	$(CP) $(objdir)\mktex.dll $(bindir)\mktex.dll
!ENDIF
	for %%i in ($(programs)) \
		do $(CP) %%i $(bindir)\%%~nxi
	for %%i in ($(mktex_progs)) \
		do $(CP) $(objdir)\mktex.exe $(bindir)\%%~nxi

check:

!include <make/rdepend.mak>
!include "./depend.mak"

#Local Variables:
#mode: Makefile
#End:
