#========================================================================
#
# Goo library Makefile
#
# Copyright 1996 Derek B. Noonburg
#
#========================================================================
INCLUDE=$(INCLUDE);../../../texk/win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

DEFS = $(DEFS) -I. -I$(kpathsea_srcdir)

c_auto_h_dir = $(kpathsea_srcdir)

#------------------------------------------------------------------------

GOO_CXX_OBJS = $(objdir)\GString.obj $(objdir)\gmempp.obj $(objdir)\gfile.obj
GOO_C_OBJS = $(objdir)\gmem.obj $(objdir)\parseargs.obj
GOO_OBJS = $(GOO_CXX_OBJS) $(GOO_C_OBJS)

!IFDEF XPDFEXTRA_DLL
LIBPDFTOEPDF=$(objdir)\libGoo.lib $(objdir)\libGoo.dll
!ELSE
LIBPDFTOEPDF=$(objdir)\libGoo.lib
!ENDIF

all: lib

default: all

!IFDEF XPDFEXTRA_DLL
DEFS= $(DEFS) -DXPDFEXTRA_DLL

lib: $(objdir) $(objdir)\libGoo.lib $(objdir)\libGoo.dll

$(objdir)\libGoo.lib: $(objdir) $(GOO_OBJS) $(win32defdir)/libGoo.def
	$(archive_command) /DEF:$(win32defdir)/libGoo.def $(GOO_OBJS)

$(objdir)\libGoo.dll: $(objdir) $(GOO_OBJS) $(objdir)\libGoo.lib $(objdir)\libGoo.res
	$(dll_command) $(GOO_OBJS)  $(objdir)\libGoo.exp $(objdir)\libGoo.res $(LIBS)

!ELSE
lib: $(objdir) $(objdir)\libGoo.lib

$(objdir)\libGoo.lib: $(objdir) $(GOO_OBJS)
	$(archive_command) $(GOO_OBJS)

!ENDIF


install: $(LIBGOO)
!IFDEF XPDF_DLL
	$(CP) $(objdir)\libGoo.dll $(toolsprefix)\bin
	$(CP) $(objdir)\libGoo.dll $(bindir)
!ENDIF

!include <make/man.mak>
!include <make/clean.mak>
!include <make/tkpathsea.mak>
!include <make/version.mak>

mostlyclean clean::
	-@$(RM) $(objdir)\libGoo.lib  $(objdir)\libGoo.dll

!include <make/rdepend.mak>
!include "./depend.mak"

#
# Local Variables:
# mode: makefile
# End:
