# makefile for libpng
INCLUDE=$(INCLUDE);../../texk/win32
# Copyright (C) 1995 Guy Eric Schalnat, Group 42, Inc.
# For conditions of distribution and use, see copyright notice in png.h
!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

DEFS= $(DEFS) -DMAKE_TIFF_DLL -I. -I../.. \
	-I$(kpathsea_srcdir) -I$(ZLIBDIR) -I$(JPGLIBDIR)

c_auto_h_dir = $(kpathsea_srcdir)

OBJS = \
	$(objdir)\tif_aux.obj \
	$(objdir)\tif_close.obj \
	$(objdir)\tif_codec.obj \
	$(objdir)\tif_compress.obj \
	$(objdir)\tif_dir.obj \
	$(objdir)\tif_dirinfo.obj \
	$(objdir)\tif_dirread.obj \
	$(objdir)\tif_dirwrite.obj \
	$(objdir)\tif_dumpmode.obj \
	$(objdir)\tif_error.obj \
	$(objdir)\tif_fax3.obj \
	$(objdir)\tif_fax3sm.obj \
	$(objdir)\tif_getimage.obj \
	$(objdir)\tif_jpeg.obj \
	$(objdir)\tif_flush.obj \
	$(objdir)\tif_luv.obj \
	$(objdir)\tif_lzw.obj \
	$(objdir)\tif_next.obj \
	$(objdir)\tif_open.obj \
	$(objdir)\tif_packbits.obj \
	$(objdir)\tif_pixarlog.obj \
	$(objdir)\tif_predict.obj \
	$(objdir)\tif_print.obj \
	$(objdir)\tif_read.obj \
	$(objdir)\tif_swab.obj \
	$(objdir)\tif_strip.obj \
	$(objdir)\tif_thunder.obj \
	$(objdir)\tif_tile.obj \
	$(objdir)\tif_win32.obj \
	$(objdir)\tif_version.obj \
	$(objdir)\tif_warning.obj \
	$(objdir)\tif_write.obj \
	$(objdir)\tif_zip.obj \
	$(NULL)

!IFDEF TIFF_DLL
LIBTIFF = $(objdir)\libtiff.lib $(objdir)\libtiff.dll

all: $(objdir) $(objdir)\libtiff.lib $(objdir)\libtiff.dll

$(objdir)\libtiff.lib: $(zlib) $(jpglib) $(objdir) $(OBJS) $(win32defdir)\libtiff.def
	$(archive_command) /DEF:$(win32defdir)\libtiff.def $(OBJS)

$(objdir)\libtiff.dll: $(zlib) $(jpglib) $(OBJS) $(objdir)\libtiff.lib  $(objdir)\libtiff.res $(gnuw32lib)
	$(dll_command) $(**) $(objdir)\libtiff.exp $(XLDFLAGS) $(LIBS) $(jpglib) $(zlib)
!ELSE
LIBTIFF = $(objdir)\libtiff.lib

all: $(objdir) $(objdir)\libtiff.lib

$(objdir)\libtiff.lib: $(zlib) $(jpglib) $(objdir) $(OBJS) $(jpglib) $(zlib)
	$(archive_command) $(OBJS) $(jpglib) $(zlib)
!ENDIF

ALPHA	= ./win32/tiff.alpha
VERSION	= ./win32/tiff.version

version.h: $(VERSION) $(ALPHA) $(objdir) ./mkversion.c
	$(CC) /Fe$(objdir)/mkversion.exe ./mkversion.c
	$(RM) mkversion.obj
	$(RM) -f version.h && .\$(objdir)\mkversion -v $(VERSION) -a $(ALPHA) version.h
$(objdir)\tif_version.obj: version.h

#
# The finite state machine tables used by the G3/G4 decoders
# are generated by the mkg3states program.  On systems without
# make these rules have to be manually carried out.
#
tif_fax3sm.c: $(objdir) ./mkg3states.c ./tif_fax3.h
	$(CC) /Fe$(objdir)/mkg3states.exe ./mkg3states.c $(kpathsea_srcdir)/getopt.c
	$(RM) getopt.obj mkg3states.obj
	$(RM) -f tif_fax3sm.c && .\$(objdir)\mkg3states -c const tif_fax3sm.c

#VERSION.h: nt\VERSION.h
#	$(CP) $** $@

#tiff.spec: nt\tiff.spec
#	$(CP) $** $@

#tiff.version: nt\tiff.version
#	$(CP) $** $@

install: $(LIBTIFF)
	set TEXMFCNF=$(TEXMFCNF)
	$(mktexdir) $(toolsprefix)\bin $(toolsprefix)\lib $(toolsprefix)\include \
	$(bindir) $(includedir) $(libdir)
	$(CP) tiff.h $(toolsprefix)\include
	$(CP) tiffconf.h $(toolsprefix)\include
	$(CP) $(objdir)\libtiff.lib $(toolsprefix)\lib
	$(CP) tiff.h $(includedir)
	$(CP) tiffconf.h $(includedir)
	$(CP) $(objdir)\libtiff.lib $(libdir)
!IFDEF TIFF_DLL
	$(CP) $(objdir)\libtiff.dll $(toolsprefix)\bin
	$(CP) $(objdir)\libtiff.dll $(bindir)
!ENDIF

!include <make/libsrul.mak>
!include <make/man.mak>
!include <make/clean.mak>
!include <make/tkpathsea.mak>
!include <make/version.mak>

clean::
	-@$(RM) *.obj
	-@$(RM) $(objdir)\libtiff.lib $(objdir)\libtiff.dll

distclean::
	-@$(RM) .\mkg3states.exe .\mkg3states.obj .\tif_fax3sm.c
	-@$(RM) .\mkversion.exe .\mkversion.obj .\VERSION.h
	-@$(RM) .\getopt.obj

!include <make/rdepend.mak>
!include "./depend.mak"

# 
# Local Variables:
# mode: makefile
# End:
