
/* The comments in *.c are only in Czech language, sorry */

/* program xpexeso -- hra s 64 kartickami, viz pexdoc-cz nebo pexdoc-eng */
/*************************************************************************/
/* 7.7.1999                                                   Petr Olsak */
/* 18.7.1999 */

/* Tento program je voln en software; mete jej redistribuovat
   anebo modifikovat za podmnek GNU General Public License, kterou 
   publikovala Free Software Foundation. Pouijte verzi 2 tto licence
   nebo (dle vlastnho uven) libovolnou pozdj verzi.

   Tento program je distribuovn s pnm, aby byl uiten, ale
   BEZ DN ZRUKY. Podrobnji viz GNU General Public License.

   Mete dostat kopii GNU General Public License spolen s tmto programem 
   (viz soubor COPYING). Pokud se tak nestalo, napite Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Tento modul implementuje na prostredi (X Window System) zavisle funkce */
/**************************************************************************/

#include "config.h"
#include "common.h"
#include TEXTY

/* globalni promenne sdilene s modulem base.c */
/**********************************************/

struct MEMPAIR {
  int poloha, hodnota ;
} MEMPAIR;            /* pole pro pamatovane karticky */
extern struct MEMPAIR mem[MAXMEM];  
extern int numM;  
extern int stav[MAXPOCETKARET], hodnota[MAXPOCETKARET];  
extern int deepM[2], deepH[2], pretimewait, timewait, longtimewait;
extern int kecani, zlomyslny[2], odebrat;        /* prepinace */
extern int body[MAXPLAYER], bodyS, cislotahu;  /* body hrace, body celkem */
extern int ng, cg,   /* pocet hracu, aktualne hrajici hrac */ 
   lock, hrajepocitac, reset, state;   /* stavove promenne */
extern int pocetkaret, pocetsloupcu, pocetradku;  /* pocty karet */

/* potrebne hlavickove soubory */
/*******************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <glob.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/xpm.h>

#include ATRIBUTY

/* globalni promenne pouze pro modul xpexeso */
/*********************************************/

static int loguj = 0;    /* implicitne neloguje */
static int fixdimen = 0; /* implicitne jsou rozmery obrazku zavisle na sade */
static int defaultset=DEFAULTSET-1;
static int znova = 0;

static Widget hlavni, obalka, nabidka, konec,  /* pripravky a pratele */
              status, cislo_tahu, hlaseni, karticky,
              zo_nastaveni, o_nastaveni, tl_nastaveni,
              zo_napovedy, okno_napovedy, z_cekejte,
              hraci, o_ppt, ppt1, ppt2, o_vpt, 
              vpt1, vpt2, o_kecy, o_zpusob, o1_zpusob, o_odebrat,
              o_p1, p1, o_p2, p2, o_p3, p3,
              zo_sady, o_sady, tl_sady, seznam_sad,
              rolovatko, obsah_napovedy;

static Widget karta[MAXPOCETKARET], hrac[MAXPLAYER], sadaw[MAXSADA],
       kectg[4], zpusobtg[4], odebrattg[2];

static XtAppContext kontext_apl;

static Display *displej;
static Pixmap pic[MAXPOCETKARET/2 + 1];
static int pici[MAXPOCETKARET/2+1];  /* obrazek pic[i] je inicializovan */

static int jenapoveda=0;              /* otevreno okno napovedy */
static int kecani0, zlomyslny0, 
           zlomyslny00, odebrat0;  /* pomocne prepinace */

static XpmAttributes   attributes;

char buff[DELKABUFF], buffdir[DELKABUFF];  /* pracovni buffery */
char *shrac[MAXPLAYER];       /* pointery na stringy se jmeny hracu */
char seznamhracu[DELKABUFF], shraci[DELKABUFF],  /* zde jsou jmena hracu */
  napoveda[DELKABUFF], seznamsad[DELKABUFF],   /* jmena souboru doc a set */
  xpmjmena[VSECHNYSOUBORY], /* jmena xpm souboru pouzite sady */
  pripona[DELKAPRIPONY];    /* pripona xpm souboru */

char errh0[] = "For more information try:  xpexeso -log -";
char *errhint = errh0;

FILE *fs, *fp, *fn, *logfile;
/* nasedujici stringy budeme alokovat dynamicky */
char *ps;             /* string pro set-file */
char *pp = NULL;      /* string pro prekladovy soubor */
char *pn = NULL;      /* string pro napovedu */
glob_t gl;

struct TYPSADA {
  char *jmeno, *adresar, *rub, *preklady; 
} sada[MAXSADA];      /* udaje ze souboru pexset */
struct PREKLAD {
  char *xpm, *obr;
} preklad[MAXPOCETKARET/2];  /* udaje z prekladoveho souboru */
int pocetprekladu, pocetsad;

char *logpic[MAXPOCETKARET/2+1];  /* jmena obrazku pouzite sady */

int nxpmjmena, numfile, dirkonec, usedglob, globnum, 
  novesady, cekam, picW, picH;

int puvodnisada, novasada, konecradku;


/* Funkce, pouzite z modulu base.c */
/***********************************/

void VolbaKarty PP(int p), HrajePocitac PP(int hrac), RozdejHru ();

/* Implementace funkci, ktere vyzaduje modul base.c */
/****************************************************/

void Pockej (dsec)
int dsec;
{
  int i;
  XEvent e;
 
  while (XtAppPending(kontext_apl)) {  /* musime v prubehu cekani */
    XtAppNextEvent(kontext_apl, &e);   /* vyrizovat udalosti */
    XtDispatchEvent(&e);
  }
  for (i=0; i<2*dsec; i++) {
    if (znova) return;
    usleep (50000);
    while (XtAppPending(kontext_apl)) {
      XtAppNextEvent(kontext_apl, &e);
      XtDispatchEvent(&e);
    }
  }
} 

void Kecej (level, s)
int level;
char *s;
{
  Arg atributy[1];

  if (loguj && s[0]) fprintf (logfile, "\"%s\"\n", s); 
  if (kecani < level) return;
  XtSetArg (atributy[0], XtNlabel, s);
  XtSetValues (hlaseni, atributy, XtNumber(atributy));  
}

void UkazStav ()
{
  sprintf (buff, KECY00,  deepH[0]/2, deepM[0]/2, deepH[1]/2, deepM[1]/2);
  Kecej (0, buff);
}

void Piskni ()
{
  XBell (displej, 100);
  return;
}

void KonecHry ()
{
  int i, maxbody, vyhral;
  Arg atributy[1];

  if (ng <= 1) Kecej (0, KECY01);
  else {
    maxbody = 0; vyhral = -1;
    for (i=0; i<ng; i++)  if (body[i] > maxbody) {
      maxbody = body[i];
      vyhral = i;
    }
    for (i=0; i<ng; i++)  if (body[i]==maxbody && i!=vyhral) {
      vyhral = -1;
      break;
    }
    if (vyhral >= 0) {
      sprintf (buff, KECY02, shrac[vyhral]);
      Kecej (0, buff);
    }
    else Kecej (0, KECY03);
  }
  hrajepocitac = lock = 0;
  if (loguj) {
    fprintf (logfile, LOG01);
    for (i=0; i<ng; i++) fprintf (logfile, LOG02, shrac[i], body[i]);
    fprintf (logfile, "\n"); fflush (logfile);
  }
  for (i=0; i<pocetkaret; i++) {
    XtSetArg (atributy[0], XtNbitmap, pic[hodnota[i]]);
    XtSetValues (karta[i], atributy, XtNumber(atributy));
  }  
}

void UkazBody ()
{
  Arg atributy[1];
  int i;

  for (i=0; i<ng; i++) {
    sprintf (buff, HRAC00, shrac[i], body[i]);
    XtSetArg (atributy[0], XtNlabel, buff);
    XtSetValues (hrac[i], atributy, XtNumber(atributy));  
  }
}  

void Jmenuj (p)
int p;
{
  Kecej (0, logpic[hodnota[p]]);
}

void Ukaz (p)
int p;
{
  Arg atributy[1];
  int j;

  if (loguj) fprintf (logfile, LOG03, 
	      p/pocetsloupcu+1, p%pocetsloupcu+1, p, logpic[hodnota[p]]); 
  j = hodnota[p];
  XtSetArg (atributy[0], XtNbitmap, pic[j]);
  XtSetValues (karta[p], atributy, XtNumber(atributy));  
  stav[p] = VIDITELNA;
  if (kecani == NAZVYKARET) Kecej (0, logpic[hodnota[p]]);
}

void Zakryj (p)
int p;
{
  Arg atributy[1];

  XtSetArg (atributy[0], XtNbitmap, pic[0]);
  XtSetValues (karta[p], atributy, XtNumber(atributy));  
  stav[p] = ZAKRYTA;
  /*  while (XtAppPeekEvent(kontext_apl, &event)) {
    XtAppNextEvent (kontext_apl, &event);
    XtDispatchEvent (&event);
  } */
}

void Odstran (p)
int p;
{
  Arg atributy[2];

  stav[p] = ODSTRANENA;
  if (!odebrat) return;
  XtSetArg (atributy[0], XtNbitmap, NULL);
  XtSetArg (atributy[1], XtNlabel, "");
  XtSetValues (karta[p], atributy, XtNumber(atributy));  
}

void NovyHrac (h)
int h;
{
  Arg atributy[1];
  Pixel barva;
  int i;

  if (h >= 0) cg = h;
  else {
    cg++;
    if (cg >= ng) cg = 0;
  }
  if (loguj) fprintf (logfile, LOG04, shrac[cg]);
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) &barva);
  XtGetValues (nabidka, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) barva);
  for (i=0; i<ng; i++) XtSetValues (hrac[i], atributy, 1);
  XtSetArg (atributy[0], XtNbackground, &barva);
  XtGetValues (konec, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, barva);
  XtSetValues (hrac[cg], atributy, 1); 
}

void TiskPameti ()
{
  int i, deep;
  
  deep = MIN (numM, deepM[0]);
  fprintf (logfile, LOG05, deep);
  for (i=1; i<=deep; i++) {
    if (i == deepH[0]+1) fprintf (logfile, LOG06);
    if (mem[numM-i].hodnota) 
      fprintf(logfile, "%d[%s] ",  
	      mem[numM-i].poloha, logpic[mem[numM-i].hodnota]);
    else fprintf(logfile, "%d[] ", mem[numM-i].poloha);
  }
  fprintf (logfile, "\n");
}

void NovyTah ()
{
  Arg atributy[1];
  int i;

  cislotahu++;
  if (loguj) {
    fprintf (logfile, LOG07, cislotahu);
    for (i=0; i<ng; i++) fprintf (logfile, LOG02, shrac[i], body[i]);
    fprintf (logfile, LOG08, bodyS);
    TiskPameti ();
    fflush (logfile);
  }
  sprintf (buff, TAH00, cislotahu);
  XtSetArg (atributy[0], XtNlabel, buff);
  XtSetValues (cislo_tahu, atributy, XtNumber(atributy));  
}  

void NoviHraci ()
{
  int i=0, j=0;
  
  while (seznamhracu[i] == ' ') i++;
  if (seznamhracu[i]==0) strcpy (shraci, HRAC01);
  else strcpy (shraci, seznamhracu);
  i = 0;
  while (j<MAXPLAYER) {
    while (shraci[i] == ' ') i++;
    if (shraci[i] == 0) break;
    shrac[j++] = &shraci[i];
    while (shraci[i] != ' ' && shraci[i] != 0) i++;
    if (shraci[i] == 0) break;
    shraci[i++] = 0;
  }
  for (i=0; i< ng; i++)  XtUnmanageChild (hrac[i]);
  ng = j;
  for (i=0; i<ng; i++)  XtManageChild (hrac[i]); 
}


/* Implementace samotneho programu */
/***********************************/

void Usage ()
{
  fprintf (stderr, 
"usage: xpexeso [X11-options] [program-options]\n\
  program options: [-log logfile | -log -]\n\
                   [-set setfile] [-defaultset number] [-doc docfile]\n\
                   [-cards CxR] [-picgeometry WxH]\n\
                   [-players \"list of players\"]\n\
                   [-m1 good_memory] [-m2 all_memory] [-close-game]\n\
                   [-second] [-m1 good_memory] [-m2 all_memory] [-close-game]\n\
                   [-t1 pretimewait] [-t2 btimewait] [-t3 ltimewait]\n\
                   [-talk level] [-no-move-out]\n");
  exit (1);
}

void Error (f, s)
char *f, *s;
{
  if (!loguj) logfile = stderr;
  else fprintf (logfile, "Error!\n");
  fprintf (logfile, "xpexeso: ");
  fprintf (logfile, f, s);
  fprintf (logfile, "\n");
  if (!loguj) fprintf (logfile, "  %s\n", errhint); 
  exit (2);
}

void CtiArgumenty (argc, argv)
int argc;
char **argv;
{
  int i, hrac;
  char errh[] = "You can try:  xpexeso -log -";

  hrac = 0;
  for (i=1; i<argc; i++) {
    if (strcmp (argv[i], "-log")==0) {  /* -log logfile */
      i++;  if (i >= argc || loguj) Usage ();
      if (strcmp (argv[i], "-")==0) logfile = stdout;
      else logfile = fopen (argv[i], "w");
      if (logfile == NULL) {
	errhint = errh;
	Error ("I cannot write to log file %s", argv[i]);
      }
      loguj = 1;
    }
    else if (strcmp (argv[i], "-set")==0) {    /* -set setfile */
      i++;  if (i >= argc) Usage ();
      strcpy (seznamsad, argv[i]);
    }
    else if (strcmp (argv[i], "-doc")==0) {    /* -doc docfile */
      i++;  if (i >= argc) Usage ();
      strcpy (napoveda, argv[i]);
    }
    else if (strcmp (argv[i], "-players")==0) { /* -players "list" */
      i++;  if (i >= argc) Usage ();
      strcpy (seznamhracu, argv[i]);
    }
    else if (strcmp (argv[i], "-m1")==0) { /* -m1 good_memory */
      i++;  if (i >= argc) Usage ();
      deepH[hrac] = 2 * atoi (argv[i]);
    }
    else if (strcmp (argv[i], "-m2")==0) { /* -m2 all_memory */
      i++;  if (i >= argc) Usage ();
      deepM[hrac] = 2 * atoi (argv[i]);
    }
    else if (strcmp (argv[i], "-t1")==0) { /* -t1 pretimewait */
      i++;  if (i >= argc) Usage ();
      pretimewait = atoi (argv[i]);
    }
    else if (strcmp (argv[i], "-t2")==0) { /* -t2 stimewait */
      i++;  if (i >= argc) Usage ();
      timewait = atoi (argv[i]);
    }
    else if (strcmp (argv[i], "-t3")==0) { /* -t3 ltimewait */
      i++;  if (i >= argc) Usage ();
      longtimewait = atoi (argv[i]);
    }
    else if (strcmp (argv[i], "-defaultset")==0) { /* -defaultset num */
      i++;  if (i >= argc) Usage ();
      defaultset = atoi (argv[i]) - 1;
    }
    else if (strcmp (argv[i], "-talk")==0) { /* -talk level */
      i++;  if (i >= argc) Usage ();
      kecani = atoi (argv[i]);
    }
    else if (strcmp (argv[i], "-close-game")==0) { /* -close-game */
      zlomyslny[hrac] = 1;
    }
    else if (strcmp (argv[i], "-second")==0)     { /* -second */
      hrac = 1;
    }
    else if (strcmp (argv[i], "-no-move-out")==0) { /* -no-move-out */
      odebrat = 0;
    }
    else if (strcmp (argv[i], "-cards")==0) {      /* -cards */
      i++;  if (i >= argc) Usage ();
      pocetsloupcu = atoi (argv[i]);
      while (argv[i][0] && argv[i][0] != 'x') (argv[i])++;
      if (!argv[i][0]) Usage ();
      pocetradku = atoi (++(argv[i]));
      pocetkaret = pocetsloupcu * pocetradku;
      if (pocetkaret < 2 || pocetkaret > MAXPOCETKARET) {
	sprintf (buff, "%d", MAXPOCETKARET);
	Error ("The number of cards is not in interval <2, %s>", buff);
      }
    }
    else if (strcmp (argv[i], "-picgeometry")==0) { /* -picgeometry */
      i++;  if (i >= argc) Usage ();
      picW = atoi (argv[i]);
      while (argv[i][0] && argv[i][0] != 'x') (argv[i])++;
      if (!argv[i][0]) Usage ();
      picH = atoi (++(argv[i]));
      fixdimen = 1;
    }
    else Usage ();
  }
  if (deepH[0] < 0) deepH[0] = 0;
  if (deepM[0] < deepH[0])  deepM[0] = deepH[0];
  if (deepH[1] < 0) deepH[1] = 0;
  if (deepM[1] < deepH[1])  deepM[1] = deepH[1];
  if (pretimewait < 0) pretimewait = PRETIMEWAIT;
  if (timewait < 0) timewait = TIMEWAIT;
  if (longtimewait < 0) longtimewait = LONGTIMEWAIT;
  if (kecani < 0) kecani = 0;
  if (kecani > 3) kecani = 3;
  if (loguj) {
    fprintf (logfile, LOG09, deepH[0], deepM[0], deepH[1], deepM[1]);
    fprintf (logfile, LOG10, pretimewait, timewait, longtimewait);
    fprintf (logfile, LOG11, zlomyslny[0], zlomyslny[1], kecani, odebrat);
    fprintf (logfile, LOG12, seznamhracu);
  }
}

static void Cekejte (i)
int i;
{
  Arg atributy[2];
  Dimension x, y;

  if (i) {
    if (cekam) return;
    Pockej (0);
    XtSetArg (atributy[0], XtNx, (XtArgVal) &x);
    XtSetArg (atributy[1], XtNy, (XtArgVal) &y);
    XtGetValues (hlavni, atributy, 2);
    x += 100; y += 100;

    XtSetArg (atributy[0], XtNx, (XtArgVal) x);
    XtSetArg (atributy[1], XtNy, (XtArgVal) y);
    XtSetValues (z_cekejte, atributy, 2);

    XtPopup (z_cekejte, XtGrabNone);
    Pockej (0);    /* aby se zrealizovala udalost */
  }
  else XtPopdown (z_cekejte);
  cekam = i;
}

char * NactiSoubor (f)   /* alokuje pamet a nacte cely soubor do ni */
FILE *f;
{
  char *s;
  int i;
  fseek (f, 0, SEEK_END);
  i = ftell (f);
  rewind (f);
  s = XtMalloc (i+1);
  fread (s, 1, i, f);
  s[i] = 0;
  return s;
}

char * DalsiObjekt (p, ai)  /* vrati dalsi nemezerovy objekt ve stringu p */
char *p;
int *ai;
{
  int i;

  if (konecradku || p[*ai] == '\n' || p[*ai] == 0)  return NULL;
  while (p[*ai] == ' ' || p[*ai] == '\t') (*ai)++;
  if (p[*ai] == 0)  return NULL;
  if (p[*ai] == '\n') {
    konecradku = 1;
    return NULL;
  }
  if (p[*ai] == '\"') {   /* objekt je v uvozovkach */
    (*ai)++;
    i = *ai;
    while (p[*ai] != '\"' && p[*ai] != '\n' && p[*ai] != 0) (*ai)++;
    if (p[*ai] != '\"') return NULL;
    else {
      p[(*ai)++] = 0;
      return &p[i];
    }
  }
  else {                   /* objekt neni v uvozovkach */
    i = *ai;
    while (p[*ai]!=' ' && p[*ai]!='\t' && p[*ai]!='\n' 
	   && p[*ai]!='=' && p[*ai]!=0) (*ai)++;
    if (p[(*ai)] == '\n') konecradku = 1;
    p[(*ai)++] = 0;
    return &p[i];
  }
}

static void CtiSady ()    /* cteni souboru se seznamem sad */
{
  int i;
  char errh[] = "If you did not make install, try:  ./xpexeso -set pexset-cz";

  fs = fopen (seznamsad, "r");
  if (fs == NULL) {
    errhint = errh;
    Error ("I cannot open set-file: %s", seznamsad);
  }
  if (loguj) fprintf (logfile, LOG14, seznamsad);
  ps = NactiSoubor (fs);
  fclose (fs);
  i = 0; 
  konecradku = 1;
  pocetsad = 0;
  while (1) {
    if (ps[i] == 0) break;
    if (konecradku && ps[i] == '>') {
      i++; 
      konecradku = 0;
      if (pocetsad >= MAXSADA) 
	Error ("Maximal count of picture sets reached in %s", seznamsad); 
      sada[pocetsad].jmeno    = DalsiObjekt (ps, &i);
      sada[pocetsad].adresar  = DalsiObjekt (ps, &i);
      sada[pocetsad].rub      = DalsiObjekt (ps, &i);
      sada[pocetsad].preklady = DalsiObjekt (ps, &i);
      if (loguj) 
	fprintf (logfile, LOG15,
		 sada[pocetsad].jmeno, sada[pocetsad].adresar, 
		 sada[pocetsad].rub, sada[pocetsad].preklady);
      if (sada[pocetsad].rub == NULL) 
	Error ("The set: %s has uncomplete information", 
	       sada[pocetsad].jmeno);
      pocetsad++;
    }
    else {
      if (ps[i] == '\n') konecradku = 1;
      else konecradku = 0;
      i++;
    }
  }
  if (pocetsad == 0)
    Error ("No picture set declared in: %s", seznamsad);
  if (defaultset == -1) { 
    RANDOMIZE;  
    defaultset = RANDOM(pocetsad); 
  }
  if (defaultset < 0 || defaultset >= pocetsad) defaultset = 0;
}

static void NoveRozmery (x, y)  /* nove rozmery okna pro aplikaci */
int x, y;  /* rozmery jedne karticky; funkce prepocita cele okno */
{
  Arg atributy[3];
  Dimension orix, oriy, oriw, 
            kw, mx, my, mw, px, py, pw, sx, sy, sw, nx, ny, nw;
  int i, dx, dy; 
  
  XtSetArg (atributy[0], XtNwidth,  (XtArgVal) &orix);
  XtSetArg (atributy[1], XtNheight, (XtArgVal) &oriy);
  XtSetArg (atributy[2], XtNborderWidth, (XtArgVal) &oriw);
  XtGetValues (karta[0], atributy, 3);

  dx = pocetsloupcu * (x - orix);  
  dy = pocetradku * (y - oriy);  kw = oriw;
  if (dx == 0 && dy == 0) return;
  if (loguj) fprintf (logfile, LOG16, x, y);
  XtGetValues (hlavni, atributy, 3);
  mx = orix + dx;  my = oriy + dy;  mw = oriw;
  XtGetValues (karticky, atributy, 3);
  px = orix + dx;  py = oriy + dy;  pw = oriw;
  XtGetValues (nabidka, atributy, 3);
  nx = orix;  ny = oriy;  nw = oriw;
  XtGetValues (status, atributy, 3);
  sx = orix;  sy = oriy;  sw = oriw;

  XtResizeWidget (hlavni, mx, my, mw);
  XtResizeWidget (nabidka, nx, ny, nw);
  XtResizeWidget (status, sx, sy, sw); 
  XtResizeWidget (karticky, px, py, pw);
  for (i=0; i<pocetkaret; i++)
    XtResizeWidget (karta[i], x, y, kw);
}

static void PolozRubemNahoru ()  /* zobrazi opakovane rubovy obrazek */
{
  Arg atributy[1];
  int i;

  XtSetArg (atributy[0], XtNbitmap, pic[0]);
  for (i=0; i<pocetkaret; i++) 
    XtSetValues (karta[i], atributy, XtNumber(atributy));
}

static char *JenJmeno(s, pripona)   
char *s;               /* vytahne z uplneho jmena souboru jen basename */
int pripona;    /* pripona = 0 ... odebere priponu */
{
  int i, j;

  i = 0; j = -1;
  while (s[i]) {
    if (s[i]=='/') j = i;
    i++;
  }
  j++; i = j;
  if (!pripona) 
    while (s[i]) {
      if (s[i]=='.') {
	s[i] = 0;
	break;
      }
      i++;
    }
  return &s[j];
}

static int Existuje (s, l) /* vrati 1, pokud nazev s existuje v xpmnazvy */
char *s;
int l;    /* je-li l>0, pak ukazuje na posledni slash */
{
  int i=0, j, r;

  while (i < nxpmjmena) {
    if (l) {              /* srovname to bez pripony */
      j = l;  r = 1;
      while (s[j] && s[j] != '.') {
	if (s[j] != xpmjmena[i+j-l]) {
	  r = 0;
	  break;
	}
	j++;
      }
      if (r) return 1;
    }
    else if (strcmp (s, &xpmjmena[i]) == 0)  return 1;
    i += strlen(&xpmjmena[i]) + 1;
  }
  return 0;
}

static char * PodejDalsi (cislo)  /* vrati dalsi nazev xpm k nacteni */ 
int cislo;
{
  int i, j, c;
  char *p;

  if (numfile == -1) {  /* provedeme inicializaci */
    strcpy (buffdir, seznamsad);  
    i = 0;  j = -1;
    while (buffdir[i]) {
      if (buffdir[i] == '/') j = i;
      i++;
    }
    if (j == -1) strcpy (buffdir, sada[cislo].adresar);
    else {
      buffdir[j+1] = 0;
      if (sada[cislo].adresar[0] == '.' && sada[cislo].adresar[1] == '/') 
	strcat (buffdir, &(sada[cislo].adresar[2]));
      else strcpy (buffdir, sada[cislo].adresar);
    }
    i = 0;
    while (sada[cislo].rub[i] && sada[cislo].rub[i] != '.') i++;
    if (!sada[cislo].rub[i])  pripona[0] = 0;
    else {
      p = &(sada[cislo].rub[i]);
      if (strlen (p) >= DELKAPRIPONY) p[DELKAPRIPONY-1] = 0;
      strcpy (pripona, p);
    }
    if (loguj)  fprintf (logfile, LOG17, buffdir, pripona);
    usedglob = 0;
    dirkonec = strlen (buffdir);
    buffdir[dirkonec++] = '/';
    buffdir[dirkonec] = 0;
    numfile++;
    return buffdir;
  }
  if (numfile == 0) {             /* vratime rubovou kartu v buffdir */
    buffdir[dirkonec] = 0;
    strcat (buffdir, sada[cislo].rub);
    numfile++;
    return buffdir;
  }
  if (numfile <= pocetprekladu) {  /* vratime buffdir se jmenem */
    i = 0;
    while (numfile <= pocetprekladu && Existuje (preklad[numfile-1].xpm, 0)) 
      numfile++;
    if (numfile <= pocetprekladu) {
      buffdir[dirkonec] = 0;
      strcat (buffdir, preklad[numfile-1].xpm);
      strcat (buffdir, pripona);
      numfile++;
      return buffdir;
    }
  }
  if (numfile == pocetprekladu + 1) {
    buffdir[dirkonec] = 0;
    strcat (buffdir, "*");  
    strcat (buffdir, pripona);
    c = glob (buffdir, GLOB_ERR, NULL, &gl);
    if (c != 0) return NULL;
    globnum = 0;
    usedglob = 1;
    numfile++;
  }
  while (globnum < gl.gl_pathc && Existuje (gl.gl_pathv[globnum], dirkonec))
    globnum++;
  if (globnum < gl.gl_pathc) {
    return gl.gl_pathv[globnum++];
  }
  else return NULL;
}

static void InicializujPixmapy PP(int cislo);  /* deklarace pro rekurzi */

static void NouzovaInicializace (cislo, s) /* natahne defaulsett pri havarii */
int cislo;
char *s;
{
  if (loguj) fprintf (logfile, LOG18, sada[cislo].jmeno, s);
  if (usedglob) globfree (&gl);
  puvodnisada = cislo;
  if (cislo != defaultset) InicializujPixmapy (defaultset);
  else Error ("I cannot read default picture set: %s", sada[defaultset].jmeno);
  Kecej (0, KECY04);
}

static void InicializujPixmapy (cislo)  /* natahne sadu "cislo" */
int cislo;
{
  Arg atributy[1];
  int i, j, c, x, y;
  char *p;

  if (cislo == puvodnisada) {
    PolozRubemNahoru ();
    return;
  }
  if (loguj) fprintf (logfile, LOG19, sada[cislo].jmeno);

  numfile = -1;
  PodejDalsi (cislo);  /* inicializace buffdir */

  pocetprekladu = 0;
  if (sada[cislo].preklady == NULL) {
    if (loguj) fprintf (logfile, LOG20);
  }
  else {  /* nacteme prekladovy soubor */
    if (pp != NULL) { /* uvolnime pamet z predchoziho */
      XtFree (pp);
      pp = NULL;
    }
    strcat (buffdir, sada[cislo].preklady);
    fp = fopen (buffdir, "r");
    if (fp == NULL) {
      if (loguj) fprintf (logfile, LOG21, buffdir);
    }
    else {  /* podivame se do prekladoveho souboru */
      pp =  NactiSoubor (fp);
      fclose (fp);
      i = 0; konecradku = 1;
      while (1) {
	if (pp[i] == 0) break;
	if (konecradku && pp[i] == '>') {
	  i++; 
	  konecradku = 0;
	  if (pocetprekladu >= (pocetkaret+1)/2) break;
	  preklad[pocetprekladu].xpm = DalsiObjekt (pp, &i); 
	  if (konecradku) continue;
	  while (pp[i] == ' ' || pp[i] == '=' || pp[i] == '\t') i++;
	  if (pp[i] == '\n') {
	    konecradku = 1;
	    i++;
	    continue;
	  }
	  preklad[pocetprekladu].obr = &pp[i];
	  while (pp[i] && pp[i] != '\n') i++;
	  if (!pp[i]) break;
	  i--;              /* odmazeme zbytecne mezery na konci */
	  while (pp[i] == ' ' || pp[i] == '\t') i--;
	  i++;
	  if (pp[i] == '\n') konecradku = 1;
	  else konecradku = 0;
	  pp[i] = 0;
	  pocetprekladu++;
	  i++;
	  continue;
	}
	if (pp[i] == '\n') konecradku = 1;
	else konecradku = 0;
	i++;
      }
      if (loguj) fprintf (logfile, LOG22, buffdir, pocetprekladu); 
    }
  }
  if (novesady) {
    for (j=0; j<=(pocetkaret+1)/2; j++) { /* uvolnime pamet X serveru */
      if (pici[j]) XFreePixmap (displej, pic[j]);
      pici[j] = 0;
    }
  }
  p = PodejDalsi (cislo);   /* vrati rubovou kartu */
  if (p == NULL)  {
    NouzovaInicializace (cislo, "nelze cist *.xpm soubory");
    return;
  }
  if (loguj)  fprintf (logfile, "0. %s\n", p);
  c = XpmReadFileToPixmap (displej, XtWindow(hlavni), p,
			   &pic[0], NULL, &attributes);
  if (c != 0)  {
    if (loguj) fprintf (logfile, LOG23, c);
    NouzovaInicializace (cislo, LOG24);
    return;
  }
  pici[0] = 1;
  x = attributes.width;  y = attributes.height;

  PolozRubemNahoru ();   /* aby nebylo BadDrawable pri Pockej (0) */
  lock = 1;
  Cekejte (1);           /* zobrazime cekaci okenko */
  if (!fixdimen) NoveRozmery (x, y);

  p = JenJmeno (p, 0);
  strcpy (xpmjmena, p);
  nxpmjmena = strlen(p) + 1;
  j = 1; 
  while (j < (pocetkaret+1)/2 + 1) {
    p = PodejDalsi (cislo);
    if (p == NULL) {
      NouzovaInicializace (cislo, LOG25);
      return;
    }
    if (loguj) {
      fprintf (logfile, "%d. %s", j, p);
      fflush (logfile);
    }
    Pockej (0);   /* behem cteni obrazku vyrizujeme udalosti */
    c = XpmReadFileToPixmap (displej, XtWindow(hlavni), p,
			     &pic[j], NULL, &attributes);
    if (c==XpmSuccess) {
      pici[j] = 1;
      i = (p==buffdir);
      p = JenJmeno(p, 0);
      if (nxpmjmena + strlen (p) >= VSECHNYSOUBORY)
	Error ("Buffer overflow during reading %s set", sada[cislo].jmeno);
      strcpy (&xpmjmena[nxpmjmena], p);
      logpic[j] = &xpmjmena[nxpmjmena];
      nxpmjmena += strlen (p) + 1;
      if (i) logpic[j] = preklad[numfile-2].obr;
      if (loguj) fprintf (logfile, "  [%s]\n", logpic[j]);
      j++;
    }
    else if (loguj) fprintf (logfile, LOG23, c);
  }
  if (usedglob) globfree (&gl);
  usedglob = 0;
  puvodnisada = cislo;
  
  XtSetArg (atributy[0], XtNiconPixmap, pic[0]);
  XtSetValues (hlavni, atributy, XtNumber(atributy));
  XtSetValues (zo_napovedy, atributy, XtNumber(atributy));
  XtSetValues (zo_nastaveni, atributy, XtNumber(atributy));
  XtSetValues (zo_sady, atributy, XtNumber(atributy));

  if (cekam) Cekejte (0);
  Kecej (0, sada[cislo].jmeno);
}

/* zde zacinaji funkce implementujici jednotliva tlacitka */
/**********************************************************/

static void Akce (w, client_data, call_data)  /* klik na karticce */
Widget w;
XtPointer client_data, call_data;
{
  VolbaKarty ((int) client_data);
  return;
}

static void Konec (w, client_data, call_data)  /* tlacitko Konec */
Widget w;
XtPointer client_data, call_data;
{
   exit (0);
}

static void KonecZnova (w, client_data, call_data)  /* potvrzeni sady */
Widget w;
XtPointer client_data, call_data;
{
  int k;
  
  k = (int) client_data;
  if (!znova) XtPopdown (zo_sady);
  if (k == 0) {
    novesady = 0;  
    return;            /* ustup, nepotvrdit nove nastaveni */
  }
  znova = 1;
  if (hrajepocitac) return;
  znova = 0;
  UkazStav ();
  InicializujPixmapy (novasada);
  novesady = 0;
  RozdejHru ();
}

static void PrepniSadu (w, client_data, call_data)  /* prepinac sady */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[1];
  Pixel barva;
  int i;

  novasada = (int) client_data;
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) &barva);
  XtGetValues (nabidka, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) barva);
  for (i=0; i<pocetsad; i++) XtSetValues (sadaw[i], atributy, 1);
  XtSetArg (atributy[0], XtNbackground, &barva);
  XtGetValues (konec, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, barva);
  XtSetValues (sadaw[novasada], atributy, 1); 
}

static void Znova (w, client_data, call_data)  /* tlacitko Znova */
Widget w;
XtPointer client_data, call_data;
{
  if (novesady) { Piskni ();  return; }

  novesady = 1;
  PrepniSadu (NULL, puvodnisada, NULL);
  XtPopup (zo_sady, XtGrabNone);
}

static void HrejHraci (w, client_data, call_data)  /* bude hrat jiny hrac */
Widget w;
XtPointer client_data, call_data;
{
  int i;

  if (hrajepocitac || state) { Piskni ();  return; }
  reset = 1;
  i = (int) client_data;
  state = 0;
  NovyHrac(i);
  lock = 0;
}

static void Napoveda (w, client_data, call_data)  /* tlacitko "Napovedy" */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[2];

  if (jenapoveda) { Piskni (); return; }
  if (pn == NULL) {
    fn = fopen (napoveda, "r");
    if (fn == NULL) {
      pn = XtMalloc (2*DELKABUFF);
      strcpy (pn, HELP00);  strcat (pn, napoveda);  
      strcat (pn, HELP01);  strcat (pn, HELP02);  strcat (pn, HELP03);
    }
    else {
      pn = NactiSoubor (fn);
      fclose (fn);
    }
    XtSetArg (atributy[0], XtNlabel, pn);
    XtSetValues (obsah_napovedy, atributy, 1);
  }
  XtPopup (zo_napovedy, XtGrabNone);
  jenapoveda = 1;
}

static void KonecNapovedy (w, client_data, call_data) /* konec napovedy */
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown (zo_napovedy);
  jenapoveda = 0;
}

static void KonecNastaveni (w, client_data, call_data) /* potrdit nastaveni */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[1];
  String input;
  int k;
  
  k = (int) client_data;
  if (k == 0) {               /* ustup, nepotvrdit nove nastaveni */
    XtPopdown (zo_nastaveni);
    return;
  }
  
  XtSetArg (atributy[0], XtNstring, (XtArgVal) &input);
  XtGetValues (hraci, atributy, XtNumber(atributy));
  strcpy (seznamhracu, input);
  NoviHraci ();
  UkazBody ();
  XtGetValues (ppt1, atributy, XtNumber(atributy));
  deepH[0] = atoi(input) * 2 ;
  XtGetValues (ppt2, atributy, XtNumber(atributy));
  deepH[1] = atoi(input) * 2 ;
  XtGetValues (vpt1, atributy, XtNumber(atributy));
  deepM[0] = atoi(input) * 2 ;
  XtGetValues (vpt2, atributy, XtNumber(atributy));
  deepM[1] = atoi(input) * 2 ;
  XtGetValues (p1, atributy, XtNumber(atributy));
  pretimewait = atoi(input);
  XtGetValues (p2, atributy, XtNumber(atributy));
  timewait = atoi(input);
  XtGetValues (p3, atributy, XtNumber(atributy));
  longtimewait = atoi(input);
  zlomyslny[0] = zlomyslny0;
  zlomyslny[1] = zlomyslny00-2;
  kecani = kecani0;
  odebrat = odebrat0;
  if (deepH[0] < 0)  deepH[0] = 0;
  if (deepH[1] < 0)  deepH[1] = 0;
  if (deepM[0] < deepH[0]) deepM[0] = deepH[0]; 
  if (deepM[1] < deepH[1]) deepM[1] = deepH[1]; 
  if (loguj) {
    fprintf (logfile, LOG13, deepH[0], deepM[0], deepH[1], deepM[1]);
    fprintf (logfile, LOG10, pretimewait, timewait, longtimewait);
    fprintf (logfile, LOG11, zlomyslny[0], zlomyslny[1], kecani, odebrat);
    fprintf (logfile, LOG12, seznamhracu);
  }
  UkazStav ();
  if (k < 2) XtPopdown (zo_nastaveni);
}

static void PrepniKecani (w, client_data, call_data)  /* prepinac kecani */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[1];
  Pixel barva;
  int i;

  kecani0 = (int) client_data;
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) &barva);
  XtGetValues (nabidka, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) barva);
  for (i=0; i<4; i++) XtSetValues (kectg[i], atributy, 1);
  XtSetArg (atributy[0], XtNbackground, &barva);
  XtGetValues (konec, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, barva);
  XtSetValues (kectg[kecani0], atributy, 1); 
}

static void PrepniZpusob (w, client_data, call_data)  /* prepinac zlomyslny */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[1];
  Pixel barva;
  int i;

  i = (int) client_data;
  if (i<2) {
    zlomyslny0 = i;
    XtSetArg (atributy[0], XtNbackground, (XtArgVal) &barva);
    XtGetValues (nabidka, atributy, 1); 
    XtSetArg (atributy[0], XtNbackground, (XtArgVal) barva);
    for (i=0; i<2; i++) XtSetValues (zpusobtg[i], atributy, 1);
    XtSetArg (atributy[0], XtNbackground, &barva);
    XtGetValues (konec, atributy, 1); 
    XtSetArg (atributy[0], XtNbackground, barva);
    XtSetValues (zpusobtg[zlomyslny0], atributy, 1); 
  }
  else {
    zlomyslny00 = i;
    XtSetArg (atributy[0], XtNbackground, (XtArgVal) &barva);
    XtGetValues (nabidka, atributy, 1); 
    XtSetArg (atributy[0], XtNbackground, (XtArgVal) barva);
    for (i=2; i<4; i++) XtSetValues (zpusobtg[i], atributy, 1);
    XtSetArg (atributy[0], XtNbackground, &barva);
    XtGetValues (konec, atributy, 1); 
    XtSetArg (atributy[0], XtNbackground, barva);
    XtSetValues (zpusobtg[zlomyslny00], atributy, 1); 
  }    
}

static void PrepniOdebrat (w, client_data, call_data)  /* prepinac odebrat */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[1];
  Pixel barva;
  int i;

  odebrat0 = (int) client_data;
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) &barva);
  XtGetValues (nabidka, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, (XtArgVal) barva);
  for (i=0; i<2; i++) XtSetValues (odebrattg[i], atributy, 1);
  XtSetArg (atributy[0], XtNbackground, &barva);
  XtGetValues (konec, atributy, 1); 
  XtSetArg (atributy[0], XtNbackground, barva);
  XtSetValues (odebrattg[odebrat0], atributy, 1); 
}

static void Nastaveni (w, client_data, call_data)  /* start okna nastaveni */
Widget w;
XtPointer client_data, call_data;
{
  Arg atributy[1];

  XtSetArg (atributy[0], XtNstring, (XtArgVal) seznamhracu);
  XtSetValues (hraci, atributy, 1); 
  sprintf (buff, "%d", deepH[0]/2);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (ppt1, atributy, XtNumber(atributy));
  sprintf (buff, "%d", deepH[1]/2);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (ppt2, atributy, XtNumber(atributy));
  sprintf (buff, "%d", deepM[0]/2);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (vpt1, atributy, XtNumber(atributy));
  sprintf (buff, "%d", deepM[1]/2);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (vpt2, atributy, XtNumber(atributy));
  sprintf (buff, "%d", pretimewait);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (p1, atributy, XtNumber(atributy));
  sprintf (buff, "%d", timewait);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (p2, atributy, XtNumber(atributy));
  sprintf (buff, "%d", longtimewait);
  XtSetArg (atributy[0], XtNstring, (XtArgVal) buff);
  XtSetValues (p3, atributy, XtNumber(atributy));
  PrepniKecani (NULL, kecani, NULL);
  PrepniZpusob (NULL, zlomyslny[0], NULL);
  PrepniZpusob (NULL, zlomyslny[1]+2, NULL);
  PrepniOdebrat (NULL, odebrat, NULL);

  XtPopup (zo_nastaveni, XtGrabNone);
}

static void RozmistiPripravky ()  /* vytvori vazby fromVert, fromHoriz */
{
  Arg atributy[1];
  int i, j;

  for (i=pocetsloupcu; i<pocetkaret; i++) {
    XtSetArg (atributy[0], XtNfromVert, (XtArgVal) karta[i-pocetsloupcu]);
    XtSetValues (karta[i], atributy, 1);
  }    
  for (j=0; j<pocetradku; j++) 
    for (i=1; i<pocetsloupcu; i++) {
      XtSetArg (atributy[0], XtNfromHoriz, 
		(XtArgVal) karta[j*pocetsloupcu+i-1]);
      XtSetValues (karta[j*pocetsloupcu+i], atributy, 1);
    }
}

static Widget VytvorTlacitko (rodic, jmeno, funkce, apl_data) /* pomocna */
Widget rodic;
String jmeno;
XtCallbackProc funkce;
XtPointer apl_data;
{
  Widget pripravek;  
  pripravek = XtCreateManagedWidget (jmeno, commandWidgetClass,
					    rodic, (Arg *) NULL, ZERO);
  XtAddCallback (pripravek, XtNcallback, funkce, apl_data);
  return pripravek;
}

static void VytvorRozhrani (rodic)  /* struktura pripravku programu */
Widget rodic;
{
  Arg atributy[2];
  int i;

  obalka = XtCreateManagedWidget ("hlavniSchranka", formWidgetClass,
					   rodic, (Arg *) NULL, ZERO);
  nabidka = XtCreateManagedWidget ("nabidka", boxWidgetClass,
                                           obalka, (Arg *) NULL, ZERO);
  konec = VytvorTlacitko (nabidka, "konec", Konec, (XtPointer) NULL); 
  VytvorTlacitko (nabidka, "znova", Znova, (XtPointer) NULL);
  VytvorTlacitko (nabidka, "nastaveni", Nastaveni, (XtPointer) NULL);
  VytvorTlacitko (nabidka, "napoveda", Napoveda, (XtPointer) NULL);
  hlaseni = XtCreateManagedWidget ("hlaseni", labelWidgetClass,
				   obalka, (Arg *) NULL, ZERO);
  status = XtCreateManagedWidget ("status", boxWidgetClass,
				  obalka, (Arg *) NULL, ZERO);
  cislo_tahu =  XtCreateManagedWidget ("cislo_tahu", labelWidgetClass,
				       status, (Arg *) NULL, ZERO);
  for (i=0; i<MAXPLAYER; i++) {
    hrac[i] = XtCreateWidget ("hrac", commandWidgetClass,
			      status, (Arg *) NULL, ZERO);
    XtAddCallback (hrac[i], XtNcallback, HrejHraci, (XtPointer)i);
  }
  karticky = XtCreateManagedWidget ("karticky", formWidgetClass,
                                 obalka, (Arg *) NULL, ZERO);

  for (i=0; i<pocetkaret; i++) {
    karta[i] = XtCreateManagedWidget ("karta", commandWidgetClass,
				      karticky, velikost_karticky, 2);
    XtAddCallback (karta[i], XtNcallback, Akce, (XtPointer) i);

    if (fixdimen) {
      XtSetArg (atributy[0], XtNwidth, picW);
      XtSetArg (atributy[1], XtNheight, picH);
      XtSetValues (karta[i], atributy, 2);  
    }
  }
  RozmistiPripravky ();

  /* napoveda */
  zo_napovedy = XtCreatePopupShell ("xpexeso_napoveda", wmShellWidgetClass, 
				    obalka, (Arg *) NULL, ZERO);
  okno_napovedy = XtCreateManagedWidget ("okno_napovedy", boxWidgetClass, 
					 zo_napovedy, (Arg *) NULL, ZERO);
  VytvorTlacitko (okno_napovedy, "ukoncit_napovedu", 
		  KonecNapovedy, (XtPointer) NULL);
  rolovatko = XtCreateManagedWidget ("rolovatko", viewportWidgetClass,
				     okno_napovedy, (Arg *) NULL, ZERO);
  obsah_napovedy = XtCreateManagedWidget ("obsah_napovedy", labelWidgetClass,
				     rolovatko, (Arg *) NULL, ZERO);

  /* nastaveni */
  zo_nastaveni = XtCreatePopupShell ("xpexeso_nastaveni", 
				     wmShellWidgetClass, obalka, 
				     (Arg *) NULL, ZERO);
  o_nastaveni = XtCreateManagedWidget ("o_nastaveni", 
				       boxWidgetClass,  zo_nastaveni, 
				       (Arg *) NULL, ZERO);
  tl_nastaveni = XtCreateManagedWidget ("tl_nastaveni", boxWidgetClass,  
				        o_nastaveni,  (Arg *) NULL, ZERO);
  VytvorTlacitko (tl_nastaveni, "potvrdit",  KonecNastaveni, (XtPointer) 1);
  VytvorTlacitko (tl_nastaveni, "potvrdit0",  KonecNastaveni, (XtPointer) 2);
  VytvorTlacitko (tl_nastaveni, "ustup", KonecNastaveni, (XtPointer) 0);
  XtCreateManagedWidget ("n_hraci", labelWidgetClass,  
				   o_nastaveni,  (Arg *) NULL, ZERO);
  hraci = XtCreateManagedWidget ("hraci", asciiTextWidgetClass,
				 o_nastaveni, (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_automat", labelWidgetClass,  
			 o_nastaveni,  (Arg *) NULL, ZERO);
  o_ppt = XtCreateManagedWidget ("o_ppt", boxWidgetClass,  o_nastaveni,
				 (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_ppt", labelWidgetClass,  
			 o_ppt,  (Arg *) NULL, ZERO); 
  ppt1 = XtCreateManagedWidget ("ppt", asciiTextWidgetClass,
				o_ppt, (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("hvezda", labelWidgetClass,  
			 o_ppt,  (Arg *) NULL, ZERO); 
  ppt2 = XtCreateManagedWidget ("ppt", asciiTextWidgetClass,
				o_ppt, (Arg *) NULL, ZERO);
  o_vpt = XtCreateManagedWidget ("o_vpt", boxWidgetClass,  o_nastaveni,
				 (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_vpt", labelWidgetClass,  
			 o_vpt,  (Arg *) NULL, ZERO); 
  vpt1 = XtCreateManagedWidget ("vpt", asciiTextWidgetClass,
				o_vpt, (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("hvezda", labelWidgetClass,  
			 o_vpt,  (Arg *) NULL, ZERO); 
  vpt2 = XtCreateManagedWidget ("vpt", asciiTextWidgetClass,
				o_vpt, (Arg *) NULL, ZERO);
  o_zpusob = XtCreateManagedWidget ("o_zpusob", boxWidgetClass,  o_nastaveni,
				 (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_zpusob", labelWidgetClass,  
			 o_zpusob,  (Arg *) NULL, ZERO); 
  zpusobtg[0] = VytvorTlacitko (o_zpusob, "otevrena", 
				PrepniZpusob, (XtPointer) 0);
  zpusobtg[1] = VytvorTlacitko (o_zpusob, "zlomyslna", 
				PrepniZpusob, (XtPointer) 1);
  o1_zpusob = XtCreateManagedWidget ("o_zpusob", boxWidgetClass,  o_nastaveni,
				 (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n1_zpusob", labelWidgetClass,  
			 o1_zpusob,  (Arg *) NULL, ZERO); 
  zpusobtg[2] = VytvorTlacitko (o1_zpusob, "otevrena", 
				PrepniZpusob, (XtPointer) 2);
  zpusobtg[3] = VytvorTlacitko (o1_zpusob, "zlomyslna", 
				PrepniZpusob, (XtPointer) 3);
  o_kecy = XtCreateManagedWidget ("o_kecy", boxWidgetClass,  o_nastaveni,
				 (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_kecy", labelWidgetClass,  
			 o_kecy,  (Arg *) NULL, ZERO); 
  kectg[0] = VytvorTlacitko (o_kecy, "mlci", 
			     PrepniKecani, (XtPointer) 0);
  kectg[1] = VytvorTlacitko (o_kecy, "jmenuje", 
			     PrepniKecani, (XtPointer) 1);
  kectg[2] = VytvorTlacitko (o_kecy, "komentuje", 
			     PrepniKecani, (XtPointer) 2);
  kectg[3] = VytvorTlacitko (o_kecy, "kibicuje", 
			     PrepniKecani, (XtPointer) 3);
  XtCreateManagedWidget ("n_prodlevy", labelWidgetClass,  
			 o_nastaveni,  (Arg *) NULL, ZERO); 
  o_p1 = XtCreateManagedWidget ("o_p1", boxWidgetClass,  o_nastaveni,
				(Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_p1", labelWidgetClass,  
			 o_p1,  (Arg *) NULL, ZERO); 
  p1 = XtCreateManagedWidget ("p1", asciiTextWidgetClass,
			      o_p1, (Arg *) NULL, ZERO);
  o_p2 = XtCreateManagedWidget ("o_p2", boxWidgetClass,  o_nastaveni,
				(Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_p2", labelWidgetClass,  
			 o_p2,  (Arg *) NULL, ZERO); 
  p2 = XtCreateManagedWidget ("p2", asciiTextWidgetClass,
			      o_p2, (Arg *) NULL, ZERO);
  o_p3 = XtCreateManagedWidget ("o_p3", boxWidgetClass,  o_nastaveni,
				(Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_p3", labelWidgetClass,  
			 o_p3,  (Arg *) NULL, ZERO); 
  p3 = XtCreateManagedWidget ("p3", asciiTextWidgetClass,
			      o_p3, (Arg *) NULL, ZERO);
  o_odebrat = XtCreateManagedWidget ("o_odebrat", boxWidgetClass, o_nastaveni,
				     (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("n_odebrat", labelWidgetClass,  
			 o_odebrat,  (Arg *) NULL, ZERO); 
  odebrattg[1] = VytvorTlacitko (o_odebrat, "odebrat", 
				 PrepniOdebrat, (XtPointer) 1);
  odebrattg[0] = VytvorTlacitko (o_odebrat, "ponechat", 
				PrepniOdebrat, (XtPointer) 0);

  /* nove sady */
  zo_sady = XtCreatePopupShell ("xpexeso_sady", 
				wmShellWidgetClass, obalka, 
				(Arg *) NULL, ZERO);
  o_sady = XtCreateManagedWidget ("o_sady", 
				  boxWidgetClass,  zo_sady, 
				  (Arg *) NULL, ZERO);
  tl_sady = XtCreateManagedWidget ("tl_sady", boxWidgetClass,  
				   o_sady,  (Arg *) NULL, ZERO);
  VytvorTlacitko (tl_sady, "potvrdit_sady",  KonecZnova, (XtPointer) 1);
  VytvorTlacitko (tl_sady, "ustup_sady",  KonecZnova, (XtPointer) 0);

  XtCreateManagedWidget ("napis_sady", labelWidgetClass,  o_sady,
			 (Arg *) NULL, ZERO);
  seznam_sad = XtCreateManagedWidget ("seznam_sad", boxWidgetClass,  o_sady,
				      (Arg *) NULL, ZERO);
  for (i=0; i<pocetsad; i++) {
    sadaw[i] = XtCreateManagedWidget ("sada", commandWidgetClass,
				      seznam_sad, (Arg *) NULL, ZERO);
    sprintf (buff, "%d. %s", i+1, sada[i].jmeno);
    XtAddCallback (sadaw[i], XtNcallback, PrepniSadu, (XtPointer)i);
    XtSetArg (atributy[0], XtNlabel, buff);
    XtSetValues (sadaw[i], atributy, 1);  
  }
  /* cekejte */
  
  z_cekejte = XtCreatePopupShell ("z_cekejte", transientShellWidgetClass, 
				  obalka, (Arg *) NULL, ZERO);
  XtCreateManagedWidget ("cekejte", labelWidgetClass,  z_cekejte, 
			 (Arg *) NULL, ZERO);
}

int main (argc, argv)                     /* hlavni program */
int argc;
char **argv;
{
  XEvent e;

  hlavni = XtAppInitialize (&kontext_apl, "Xpexeso",
			    (XrmOptionDescRec *) NULL, ZERO, &argc, argv,
			    implicitni_atributy, (Arg *) NULL, ZERO);
  logfile = stdout;
  strcpy (seznamhracu, HRACI);
  strcpy (napoveda, NAPOVEDA);
  strcpy (seznamsad, SADY);
  if (argc != 1)  CtiArgumenty (argc, argv);
  pocetkaret = pocetradku * pocetsloupcu;  /* to je ale objev */

  CtiSady ();
  
  VytvorRozhrani (hlavni);
  XtRealizeWidget (hlavni);
  
  displej = XtDisplay (hlavni);
  attributes.valuemask = XpmColormap;
  attributes.colormap = XDefaultColormap(displej, 0);
  puvodnisada = -1;
  novesady = 0;  cekam = 0;
  InicializujPixmapy (defaultset);

  ng = 0;
  NoviHraci ();
  RozdejHru ();
  UkazStav ();

  while (1) {  /* Hlavni cyklus */
    if ((shrac[cg][0] == '@' || shrac[cg][0] == '*') && bodyS < pocetkaret/2) {
      lock = 1;
      if (shrac[cg][0] == '@') HrajePocitac (0);
      else HrajePocitac (1); 
      if (lock && shrac[cg][0] != '@' && shrac[cg][0] != '*') lock = 0;
      if (znova) KonecZnova (NULL, 1, NULL);
    }
    XtAppNextEvent(kontext_apl, &e);
    XtDispatchEvent(&e);
  }
  /*  XtAppMainLoop (kontext_apl); */
  return 0;
}
