/* config.h for the program xpexeso */

/* 
 * You can change the "language" of the program. You can prepare the
 * translation of files pexdoc-eng, attribs-eng and phrases-eng into
 * (say) pexdoc-mylang, attribs-mylang.h and phrases-mylang.h. You can set:
 * #define NAPOVEDA "/usr/local/lib/pexdoc-mylang" ,  
 * #define ATRIBUTY "attribs-mylang.h" and #define TEXTY "phrases-mylang.h".
 * The #define HRACI includes the default list of gamers. You can translate
 * this list to your language.
 */

#if 1  /* default is Czech (change "1" to "0" if you need not it) */

#define SADY     "/usr/local/lib/xpexeso/pexset-cz"
#define NAPOVEDA "/usr/local/lib/xpexeso/pexdoc-cz"
#define ATRIBUTY "attribs-cz.h"
#define TEXTY    "phrases-cz.h"
#define HRACI    "Ty @Automat"   

#else /* the alternative for English language, not by default */

#define SADY     "/usr/local/lib/xpexeso/pexset-eng"
#define NAPOVEDA "/usr/local/lib/xpexeso/pexdoc-eng"
#define ATRIBUTY "attribs-eng.h"
#define TEXTY    "phrases-eng.h"
#define HRACI    "You @Computer"   

#endif

/*
 * Default values of the program follows. These values are changeable
 * by options in command line and in dialog window of the program.
 */

#define DEEPH 6            /* 2times of the exact memory of comp-player */
#define DEEPM 20           /* 2times of the all memory of comp-player */
#define TIMEWAIT 4         /* the time between two cards */
#define PRETIMEWAIT 8      /* the preparation time */
#define LONGTIMEWAIT 35    /* the time where two cards are shown */
#define KECANI 0           /* the talk level */
#define ZLOMYSLNY 0        /* the game strategy of automat (no spite) */
#define ODEBRAT 1          /* removing cards after succesfull move */
#define POCETSLOUPCU 8     /* the number of columns */
#define POCETRADKU 8       /* the number of rows */
#define DEFAULTSET 1       /* default of -defaultset value */

/*
 * Default dimensions of pictures. It is recommended (but not explicitly 
 * need) to set these values according to default picture card.
 */

#define PICWIDTH  56
#define PICHEIGHT 56

/*
 * Limits.
 */

#define MAXSADA 50        /* maximal number of picture sets */
#define MAXPOCETKARET 128 /* maximal number of cards */
#define MAXMEM 1000       /* maximal lenght of memory of comp-player */
#define MAXPLAYER  10     /* maximal number of players */
#define DELKABUFF 260     /* maximal length of buffer and temp strings */
#define VSECHNYSOUBORY 5*MAXPOCETKARET
                          /* the buffer for all xpm filenames
			     without directory and extension:  
			     (average_length+1) * MAXPOCETKARET/2  */ 
#define DELKAPRIPONY 10   /* maximal file extension is ".xpm.gz" */





