/* program xpexeso */
/* Petr Olsak      */

/* V tomto modulu jsou na prostredi nezavisle algoritmy programu */
/*****************************************************************/

#include "config.h"
#include "common.h"
#include TEXTY

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

struct MEMPAIR {
  int poloha, hodnota ;
} MEMPAIR;            /* pole pro pamatovane karticky */
struct MEMPAIR mem[MAXMEM];  
int numM;             /* pocet aktualne pamatovanych karticek */

int stav[MAXPOCETKARET], 
    hodnota[MAXPOCETKARET];  /* stav a hodnota karticky */

int deepM[2] = { DEEPM, DEEPM };       /* vychozi hodnoty nastaveni */
int deepH[2] = { DEEPH, DEEPH };
int pretimewait = PRETIMEWAIT;
int timewait = TIMEWAIT;
int longtimewait = LONGTIMEWAIT;
int kecani = KECANI;
int zlomyslny[2] = { ZLOMYSLNY, ZLOMYSLNY };
int odebrat = ODEBRAT;
int pocetsloupcu = POCETSLOUPCU;
int pocetradku = POCETRADKU;

int body[MAXPLAYER], bodyS, cislotahu, zp;
int ng, cg, lock, hrajepocitac, reset, state;
int pocetkaret;

int prvni_poloha, prvni_hodnota, druha_poloha;

/* na prostredi (X Window System) zavisle funkce v modulu xpexeso.o: */
/*********************************************************************/


void Piskni (),          /* piskne */ 
     UkazBody (),        /* zobrazi aktualni bodove skore */
     KonecHry (),        /* konec hry, zobrazi polohy vsech karticek */
     Pockej PP(int ds),  /* sleep na desetiny sekundy */
     NovyTah (),         /* zobrazi ++cislotahu */
     NovyHrac PP(int n), /* prosviti jmeno nasledujiciho hrace pri n = -1
			   nebo jmeno n-teho hrace. Ten bude nadale hrat */
     UkazStav (),        /* zobrazi aktualni nastaveni pameti automatu */
     Kecej PP((int level, char* text)),  /* zobrazi text, pokud je 
					    kecani >= level */
     Jmenuj PP(int num), /* zobrazi nazev obrazku pomoci Kecej() */
     Ukaz PP(int p),     /* zobrazi hodnotu karticky na poloze p */
     Zakryj PP(int p),   /* zakryje karticku na poloze p */
     Odstran PP(int p);  /* odstrani karticku na poloze p, pokud je
 			    odebrat>=1, jinak pouze stav[p]=ODSTRANENA */


/* pomocne funkce: */
/*******************/

void Pamatuj (p, h)  /* Pocitac si vsechny otocene karticky pamatuje */
int p, h;
{
  int i;
  if (p == zp) return;  /* zlomyslnou pozici si nebudeme pamatovat znovu */
  mem[numM].poloha  = p;
  mem[numM].hodnota = h;
  numM++;
  if (numM == MAXMEM) {
    numM = deepM[0];
    if (deepM[1]>numM) numM = deepM[1];
    for (i=0; i<numM; i++) {
      mem[i].poloha = mem[i+MAXMEM-numM].poloha;
      mem[i].hodnota = mem[i+MAXMEM-numM].hodnota;
    }
  }
  if (zp >= 0) mem[numM].poloha = zp, mem[numM].hodnota = hodnota[zp];
  else         mem[numM].poloha = -1, mem[numM].hodnota = 0;
}

void Poznamenej (h)  /* Hrac vzal dvojici, poznamename si to do pameti */
int h;
{
  int i;
  for (i=0; i<=numM; i++)
    if (mem[i].hodnota == h) mem[i].hodnota = 0;
  if (hodnota[zp] == h) zp = -1;
}

int Volkartu (hrac)   /* najde nahodnou kartu, ktera nebyla tazena */
int hrac;
{
  int i, k, p, deep;

  deep = MIN (numM, deepH[hrac]);
  k=0;
  do {
    k++;
    p = RANDOM(pocetkaret);
    if (stav[p] != ZAKRYTA) p = -1;
    else
      if (k < MAXMEM)  /* muze se stat, ze jsme se tu omylem, chceme ven */
	for (i = 0; i <= deep; i++)
	  if (p == mem[numM-i].poloha) p = -1;
  }
  while (p == -1);
  return p;
}

int Nepresne (p, hrac)  /* jsme zapometlivi nebo mame roztresenou ruku */
int p;            /* funkce priblizi pocitac cloveku: misto presne
                     polohy p muze vybrat nahodne z osmi sousednich karticek.
                     Primo sousedni s pravdepodobnosti 2/16, uhlopricne
                     sousedni s pravd. 1/16. Muze ponechat skutecnou
                     karticku s pravd. 4/16.  */
{
  int i, test, r, s, pp, deep;

  deep = MIN (numM, deepH[hrac]);
  r = p / pocetsloupcu;
  s = p % pocetsloupcu;
  while (1) {
    pp = -1;
    test = RANDOM(16);
    switch (test) {
    case 0: case 1: case 2: case 3:  /* nahodou jsme se strefili */
                 return p;
    case 4: case 5:    /* jedna vpravo */
                 if (s < pocetsloupcu-1 && stav[p+1] == ZAKRYTA) pp = p+1;
                 break;
    case 6: case 7:    /* jedna vlevo */
                 if (s > 0 && stav[p-1] == ZAKRYTA) pp = p-1;
                 break;
    case 8: case 9:    /* jedna nahoru */
                 if (r > 0 && stav[p-pocetsloupcu] == ZAKRYTA)
                   pp = p - pocetsloupcu;
                 break;
    case 10: case 11:  /* jedna dolu */
                 if (r < pocetradku-1 && stav[p+pocetsloupcu] == ZAKRYTA) 
		   pp = p + pocetsloupcu;
                 break;
    case 12:     /* vpravo nahoru */
                 if (s < pocetsloupcu-1 && r > 0 && 
		     stav[p-pocetsloupcu+1] == ZAKRYTA) 
		   pp = p - pocetsloupcu + 1;
                 break;
    case 13:     /* vpravo dolu */
                 if (s < pocetsloupcu-1 && r < pocetradku-1 && 
		     stav[p+pocetsloupcu+1] == ZAKRYTA)
                   pp = p + pocetsloupcu + 1;
                 break;
    case 14:     /* vlevo nahoru */
                 if (s > 0 && r > 0 && stav[p-pocetsloupcu-1] == ZAKRYTA)
                   pp = p - pocetsloupcu - 1;
                 break;
    case 15:     /* vlevo dolu */
                 if (s > 0 && r < pocetradku-1 && 
		     stav[p+pocetsloupcu-1] == ZAKRYTA)
                   pp = p + pocetsloupcu - 1;
                 break;
    }
    if (pp >= 0) 
      for (i=0; i<=deep; i++) 
	if (mem[numM-i].poloha == pp) pp = -1;
    if (pp >= 0)  return pp;
  }
}

void HrajePocitac(hrac)  /* Jsme na tahu */
int hrac;
{
  int i, j, p, pp, deep;

  if (state) { lock =0; return; }
  reset = 0;
  Pockej (pretimewait);
  if (reset) return;

  /* Nejprve sejmeme vse, co si pamatujeme */
  hrajepocitac = 1;
  deep = MIN (numM, deepM[hrac]);
  for (i = 0; i < deep; i++ ) 
    for (j = i+1; j <= deep; j++) 
      if (mem[numM-i].hodnota && 
	  mem[numM-i].hodnota == mem[numM-j].hodnota &&
	  mem[numM-i].poloha  != mem[numM-j].poloha) {
        if (j > deepH[hrac]) Kecej (KOMENT, KECY11);
	else Kecej (KOMENT, KECY12);
        p = mem[numM-j].poloha;
        if (j > deepH[hrac])  p = Nepresne (mem[numM-j].poloha, hrac);
        Ukaz (p);
        Pockej (timewait);
        if (p != mem[numM-j].poloha) Kecej (KOMENT, KECY13);
        if (p != mem[numM-j].poloha) goto nespravne;
        Ukaz (mem[numM-i].poloha);
        Pockej (longtimewait);
        body[cg]++; bodyS++;
        Odstran (mem[numM-j].poloha);
        Odstran (mem[numM-i].poloha);
	Poznamenej (mem[numM-j].hodnota);
        UkazBody ();
        mem[numM-i].hodnota = mem[numM-j].hodnota = 0;
        if (bodyS == pocetkaret/2) {
          KonecHry ();
          return;
        }
        NovyTah ();
      }

  /* Nyni otocime nahodne karticku, ktera nebyla tazena */
  do {
    Kecej (KOMENT, KECY14);
    p = Volkartu(hrac);
    Ukaz (p);  
    Pockej (timewait);
  nespravne:
    /* Projdeme nasi pamet */
    pp = -1;
    deep = MIN (numM, deepM[hrac]);
    for (i = 0; i <= deep; i++)
      if (hodnota[p] == mem[numM-i].hodnota && p != mem[numM-i].poloha) {
        pp = mem[numM-i].poloha;
        if (i > deepH[hrac]) Kecej (KOMENT, KECY15);
	else Kecej (KOMENT, KECY16);
        if (i > deepH[hrac]) pp = Nepresne (mem[numM-i].poloha, hrac);
	break;
      }
    j = 0;
    if (pp == -1) {  /* druhou nevime */
      j = 1; 
      if (zlomyslny[hrac]) {
	if (zp < 0) {
	  deep = MIN (numM, deepM[hrac]);
	  for (i = 1; i <= deep; i++) {
	    if (stav[mem[numM-i].poloha] == ZAKRYTA) {
	      zp = mem[numM-i].poloha;
	      break;
	    }
	  }
	  if (zp < 0) zp = pp = Volkartu (hrac);
	  else {
	    pp = zp;
	    Kecej (KOMENT, KECY17);
	  }
	}
	else {
	  pp = zp;
	  Kecej (KOMENT, KECY18);
	}
      }
      else pp = Volkartu(hrac);
    }
    Ukaz (pp);
    if (j && hodnota[p] == hodnota[pp])  Kecej (KOMENT, KECY19);
    Pockej (longtimewait);
    if (hodnota[p] == hodnota[pp]) {
      body[cg]++; bodyS++;
      Odstran (p);
      Odstran (pp);
      Poznamenej (hodnota[p]);
      UkazBody ();
      if (bodyS == pocetkaret/2) {
	KonecHry ();
	return;
      }
      NovyTah ();
    } 
  }
  while (hodnota[p] == hodnota[pp]);

  Kecej (KOMENT, KECY10);

  /* Nebyli jsme uspesni, predame rizeni uzivateli */
  Pamatuj (p, hodnota[p]);
  Pamatuj (pp, hodnota[pp]);
  Zakryj (p);
  Pockej (timewait); 
  Zakryj (pp);
  NovyTah ();
  NovyHrac (-1);
  hrajepocitac = 0;
}

void Komentuj (pultah, p)     /* Kibicujeme hrani lidskeho hrace */
int pultah, p;
{
  int deep, i, j, k;

  deep = MIN (deepM[0], numM);

  if (pultah == 1) {
    j = -1;
    for (i=0; i<=deep; i++) {
      if (mem[numM-i].hodnota == hodnota[p] && 
	  mem[numM-i].poloha != p) { 
	j = i;  
	break; 
      }
    }
    if (j == -1) {
      k = -1;
      for (i=0; i<=deep; i++) {
	if (mem[numM-i].poloha == p) {
	  k = i;
	  break;
	}
      }
      if (k == -1)        Kecej (KIBIC, KECY20);
      else                Kecej (KIBIC, KECY21);
    }
    else { 
      if (j <= deepH[0])  Kecej (KIBIC, KECY22);
      else                Kecej (KIBIC, KECY23);
    }
  }
  else {  /* druhy pultah */
    j = -1;
    for (i=0; i<=deep; i++) {
      if (mem[numM-i].poloha == p) {
	j = i;
	break;
      }
    }
    if (hodnota[p] == prvni_hodnota) {
      if (j == -1)        Kecej (KIBIC, KECY24);
      else {
	if (j <= deepH[0]) Kecej (KIBIC, KECY25);
	else              Kecej (KIBIC, KECY26);
      }
    }
    else { 
      if (j == -1) {
	k = -1;
	for (i=0; i<=deep; i++) {
	  if (mem[numM-i].hodnota == hodnota[p] && 
	  mem[numM-i].poloha != p) { 
	    k = i;  
	    break; 
	  }
	}
	if (k == -1)      Kecej (KIBIC, KECY27);
	else {
	  if (k <= deepH[0]) Kecej (KIBIC, KECY28);
	  else            Kecej (KIBIC, KECY29);
	}
      } 
      else                Kecej (KIBIC, KECY21);
    }
  }
}

  
void VolbaKarty (numC) /* Asynchronni zpracovani udalosti "klik na kartu" */
int numC;
{
  if (lock || stav[numC] == ODSTRANENA) { 
    if (bodyS == pocetkaret/2) Jmenuj (numC);
    else Piskni (); 
  return; 
  }

  lock = 1;

  /* pri inicializaci je state = 0 */
  switch (state) {
  case 0:   /* zadna karticka neni otocena */
       Ukaz (numC);
       Komentuj (1, numC);
       prvni_poloha  = numC;
       prvni_hodnota = hodnota[numC];
       state = 1;
       break;
  case 1:   /* jedna karticka otocena */
       if (stav[numC] == VIDITELNA) { Piskni(); break; }
       Ukaz (numC);
       Komentuj (2, numC);
       Pockej (timewait);
       if (prvni_hodnota == hodnota[numC]) {
	 Poznamenej (hodnota[numC]);
         druha_poloha = numC;
         state = 4;
	 if (!odebrat) goto neodeber;
         break;
       }
       Pamatuj (prvni_poloha, prvni_hodnota);
       Pamatuj (numC, hodnota[numC]);
       state = 2;
       break;
  case 2:   /* dve karticky jsou otoceny, je treba otocit zpet */
       if (stav[numC] == ZAKRYTA) { Piskni(); break; }
       Zakryj (numC);
       state = 3;
       break;
  case 3:   /* je treba zakryt posledni karticku */
       if (stav[numC] == ZAKRYTA)  { Piskni(); break; }
       Zakryj (numC);
       NovyTah ();
       NovyHrac (-1);
       state = 0;
       break;
  case 4:  /* hrac si kliknul k odebrani karet */
  neodeber:
       body[cg]++; bodyS++;
       UkazBody ();
       Odstran (prvni_poloha);
       Odstran (druha_poloha);
       if (bodyS == pocetkaret/2) {
	 KonecHry ();
	 break;
       }
       NovyTah ();
       state = 0;
       break;
  }
  lock = 0;
  return;
}

void RozdejHru ()      /* namichame a rozdame novou hru */
{
  int p, h;

  for (p=0; p<pocetkaret; p++) stav[p] = ODSTRANENA;

  RANDOMIZE ;
  for (h=0; h<pocetkaret; h++) {
    do {
      p = RANDOM(pocetkaret);
    }
    while (stav[p] == ZAKRYTA);
    stav[p] = ZAKRYTA;
    hodnota[p] = h/2+1; 
  }
  if (pocetkaret % 2) {     /* aby nebyla sama vzdy ta posledni */
    p = RANDOM(pocetkaret+1) ;
    if (p<pocetkaret) hodnota[p] = pocetkaret/2+1;
  }
  lock = state = 0;
  bodyS = 0;
  numM = 0;  zp = -1;  mem[0].hodnota = 0;   mem[0].poloha = -1;
  for (cg=0; cg < MAXPLAYER; cg++) body[cg] = 0;
  cislotahu = cg = 0;
  NovyTah ();
  NovyHrac (0);
  UkazBody ();
}


