% EncTeX,  Petr Olsak, September 1997, December 2002

% This is all changes in tex.ch of the encTeX extension.
% If you have the web2c v 7.3 implementation, do not use
% this file. Use patch <enctex.patch instead.

% See the encdoc.tex (Czech) or encdoc-e.tex (English) for more information 


@x [2.20] l.579 - encTeX: declaration of xprn array
@!xchr: array [ASCII_code] of text_char;
  {specifies conversion of output characters}
@y
xchr: array [ASCII_code] of text_char;
   { specifies conversion of output characters }
xprn: array [ASCII_code] of ASCII_code;
   { non zero iff character is printable }
mubyte_read: array [ASCII_code] of pointer;
   { non zero iff character begins the multi byte code }
mubyte_write: array [ASCII_code] of str_number;
   { non zero iff character expands to multi bytes in log and write files }
mubyte_skip: integer;  { the number of bytes to skip in |buffer| }
mubyte_keep: integer; { the number of chars we need to keep unchanged }
keep_byte_sequence: integer; { if param is used in mubyte primitive }
mubyte_start: integer; { we are making the token at the start of the line }
mubyte_token: pointer; { the token returned by |read_buffer| }
mubyte_stoken: pointer; { saved first token in mubyte primitive }
@z


@x [2.23] l.723 - encTeX: printable chars, array initialisation.
for i:=0 to @'37 do xchr[i]:=' ';
for i:=@'177 to @'377 do xchr[i]:=' ';
@y
for i:=0 to @'37 do xchr[i]:=i;
for i:=@'177 to @'377 do xchr[i]:=i;
for i:=0 to 255 do xprn[i]:=0;
for i:=32 to 126 do xprn[i]:=1;
for i:=0 to 255 do mubyte_read[i]:=null;
for i:=0 to 255 do mubyte_write[i]:=0;
mubyte_keep := 0; mubyte_start := 0;
@z


% ATTENTION: we need not any changes in [2.24]. 


% ATTENTION: some distributions sets its own code in [4.49]. Remove it!
% We need the default code from tex.web here.
%
%@x [4.49] l.1295
%@<Character |k| cannot be printed@>=
%  (k<" ")or(k>"~")
%@y
%@<Character |k| cannot be printed@>=
%   not is_printable[k]
%@z


@x [5.59] l.1516 - encTeX: printable characters do print directly
    if (@<Character |s| is the current new-line character@>) then
      if selector<pseudo then
        begin print_ln; return;
        end;
@y
    if (@<Character |s| is the current new-line character@>) then
      if selector<pseudo then
        begin print_ln; return;
        end;
    if (mubyte_out>0) and (mubyte_write[s]>0) then
      s := mubyte_write [s]
    else if xprn[s]>0 then begin print_char(s); return; end;
@z


% ATTENTION: This code may be different in various TeX distributions.

@x [5.61] l.1556 - encTeX: the banner as a cecond line on the terminal
if format_ident=0 then wterm_ln(' (no format preloaded)')
else  begin slow_print(format_ident); print_ln;
  end;
@y
if format_ident=0 then wterm_ln(' (no format preloaded)')
else  begin slow_print(format_ident); print_ln;
  end;
wterm_ln ('encTeX v. Dec. 2002, the reencoding enabled');
@z


@x [5.71] encTeX - native buffer printing
if last<>first then for k:=first to last-1 do print(buffer[k]);
@y
if last<>first then
  if mubyte_in > 0 then for k:=first to last-1 do print_char(buffer[k])
  else for k:=first to last-1 do print(buffer[k]);
@z


@x [17.230] l.4725 - encTeX: xord_code_base, xchr_code_base, prn_code_base,
@d math_font_base=cur_font_loc+1 {table of 48 math font numbers}
@y
@d xord_code_base=cur_font_loc+1
@d xchr_code_base=xord_code_base+1
@d xprn_code_base=xchr_code_base+1
@d math_font_base=xprn_code_base+1
@z


% ATTENTION: this code is somewhat different in web2c distribution 
% where MLTeX is added too. Some different constants are used here.

@x [17.236] l.4954 - encTeX: \mubytein, \mubyteout
@d int_pars=55 {total number of integer parameters}
@y
@d mubyte_in_code=55 {if positive then reading mubytes is active}
@d mubyte_out_code=56 {if positive then printing mubytes is active}
@d int_pars=57 {total number of integer parameters}
@z


% ATTENTION: this code is somewhat different in web2c distribution. 

@x [17.236] l.5016 - encTeX: \mubytein, \mubyteout
@d error_context_lines==int_par(error_context_lines_code)
@y
@d error_context_lines==int_par(error_context_lines_code)
@d mubyte_in==int_par(mubyte_in_code)
@d mubyte_out==int_par(mubyte_out_code)
@z


% ATTENTION: this code is somewhat different in web2c distribution.

@x [17.238] l.5200 - encTeX: \mubytein, \mubyteout
@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
@y
@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
  primitive("mubytein",assign_int,int_base+mubyte_in_code);@/
@!@:mubyte_in_}{\.{\\mubytein} primitive@>
  primitive("mubyteout",assign_int,int_base+mubyte_out_code);@/
@!@:mubyte_out_}{\.{\\mubyteout} primitive@>
@z


@x [18.265] - encTeX: \endmubyte primitive
primitive("endcsname",end_cs_name,0);@/
@!@:end_cs_name_}{\.{\\endcsname} primitive@>
@y
primitive("endcsname",end_cs_name,0);@/
@!@:end_cs_name_}{\.{\\endcsname} primitive@>
primitive("endmubyte",end_cs_name,10);@/
@!@:end_mubyte_}{\.{\\endmubyte} primitive@>
@z


@x [18.266] - encTeX: \endmubyte primitive
end_cs_name: print_esc("endcsname");
@y
end_cs_name: if chr_code = 10 then print_esc("endmubyte") 
             else print_esc("endcsname");
@z


@x [22.318] encTeX - native buffer printing
  print(buffer[i]);
@y
  if mubyte_in > 0 then print_char(buffer[i]) else print(buffer[i]);
@z


@x [24.332] encTeX: the main new code
appear on that line. (There might not be any tokens at all, if the
|end_line_char| has |ignore| as its catcode.)
@y
appear on that line. (There might not be any tokens at all, if the
|end_line_char| has |ignore| as its catcode.)

The three auxiliary functions for encTeX (by Petr Olsak, see enctex.doc)
follows. These functions implement the \.{\\mubyte} code to convert
the multibytes in |buffer| to one byte or to one control
sequence. These functions manipulates with a mubyte tree: each node of
this tree is token list with n+1 tokens (first token consist the byte
from byte sequence itself and the other tokens points to the
branches). If you travel from root of the tree to the leaf then you
find exactly one byte sequence which we have to convert to one byte or
control sequence. The link part of the leaf includes the token to
which we have to convert.  The inversion: one byte to multi byte (for
log printing and \.{\\write} printing) is implemented via pool. Each
multibyte sequence is stored in pool as a string and
|mubyte_write|[{\it printed char\/}] points to this string.

@d new_mubyte_node == 
  link (p) := get_avail; p := link (p); info (p) := get_avail; p := info (p)

@p function read_buffer(var i: pointer):ASCII_code; 
                        { reads buffer[i] and convert multibyte }
var p: pointer;
begin
  mubyte_skip := 0; mubyte_token := 0; 
  read_buffer := buffer[i];
  if mubyte_in = 0 then
  begin
    if mubyte_keep > 0 then mubyte_keep := 0;
    return ;
  end;
  if (i = start) and (mubyte_start = 0) and (mubyte_keep = 0) and
     (end_line_char >= 0) and (end_line_char < 256) then
    if mubyte_read [end_line_char] <> null then
    begin
      mubyte_start := 1; mubyte_skip := -1;
      p := mubyte_read [end_line_char];
      goto continue;
    end;
restart:
  mubyte_start := 0;
  if (mubyte_read [buffer[i]] = null) or (mubyte_keep > 0) then 
  begin
    if mubyte_keep > 0 then 
      if mubyte_in = 1 then decr (mubyte_keep) else mubyte_keep := 0;
    return ;
  end;
  p := mubyte_read [buffer[i]];
continue:
  if info (p) >= 256 then { multibyte does match }
    if link (p) < 256 then
    begin
      if mubyte_skip >= 0 then mubyte_start := 0;
      read_buffer := link (p); { multibyte to one byte }
      return;
    end else begin
      if mubyte_skip >= 0 then mubyte_start := 0;
      read_buffer := 0; { multibyte to control sequence }
      mubyte_token := link (p);
      if info (p) >= 512 then { keep byte sequence }
      begin
        mubyte_keep := mubyte_skip + 1;
        mubyte_skip := -1;
      end;
      return;
    end;
  incr (mubyte_skip);
  if i + mubyte_skip > limit then
  begin
    mubyte_skip := 0;
    if mubyte_start > 0 then goto restart;
    return;
  end;
  repeat
    p := link (p);
    if info (info(p)) mod 256 = buffer [i+mubyte_skip] then
    begin
      p := info (p); goto continue;
    end;
  until link (p) = null;
  mubyte_skip := 0;
  if mubyte_start > 0 then goto restart;
exit: end;
@#
procedure mubyte_update; { saves new string to mubyte tree }
var j: pool_pointer;
    p: pointer;
    in_mutree: integer;
begin
  wake_up_terminal;
  j := str_start [str_ptr];
  if mubyte_read [str_pool[j]] = null then
  begin
    in_mutree := 0;    
    p := get_avail;
    mubyte_read [str_pool[j]] := p;
    info (p) := str_pool[j];
  end else begin
    in_mutree := 1;
    p := mubyte_read [str_pool[j]];
  end;
  incr (j);
  while j < pool_ptr do 
  begin
    if in_mutree = 0 then 
    begin
      new_mubyte_node; info (p) := str_pool[j];
    end else { |in_mutree| = 1 }
      if info (p) >= 256 then 
      begin
        info (p) := info (p) mod 256;
        new_mubyte_node; info (p) := str_pool[j];
        in_mutree := 0;
      end else begin
        repeat
          p := link (p);
          if info (info(p)) mod 256 = str_pool[j] then
          begin
            p := info (p); 
            goto continue;
          end;
        until link (p) = null;
        new_mubyte_node; info (p) := str_pool[j];
        in_mutree := 0;
      end;
continue: 
    incr (j);
  end; 
  info (p) := info (p) + 256;
  if keep_byte_sequence = 1 then info (p) := info (p) + 256;
  link (p) := mubyte_stoken;
exit: end;
@#
procedure dispose_munode (var p: pointer); { frees a mu subtree recursivelly }
var q: pointer;
begin
  if info (p) >= 256 then free_avail (p)
  else begin
    q := link (p);
    free_avail (p);
    p := q;
    while p <> null do
    begin
      dispose_munode (info (p));
      q := link (p);
      free_avail (p);
      p := q;
    end;
  end;     
end;
@z


@x [24.341] - encTeX: more declarations in expand processor
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@y
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!i,@!j: 0..buf_size; {more indexes for encTeX}
@!mubyte_incs: integer; {the total |mubyte_skip| in control sequence}
@z


@x [24.343] - encTeX: the buffer accessing via read_buffer
  begin cur_chr:=buffer[loc]; incr(loc);
@y
  begin
    cur_chr := read_buffer (loc); incr (loc); loc := loc + mubyte_skip;
    if (mubyte_token > 0) then
    begin
      state := mid_line;
      cur_cs := mubyte_token - cs_token_flag;
      goto found;
    end;
@z


@x [24.354] - encTeX: the buffer accessing via read_buffer
else  begin start_cs: k:=loc; cur_chr:=buffer[k]; cat:=cat_code(cur_chr);
  incr(k);
@y
else  begin start_cs:
   mubyte_incs := 0; k := loc;
   cur_chr := read_buffer (k); cat := cat_code (cur_chr);
   incr (k); 
   k := k + mubyte_skip; mubyte_incs := mubyte_incs + mubyte_skip;
   if mubyte_token > 0 then
   begin
     state := mid_line;
     cur_cs := mubyte_token - cs_token_flag;
     goto found;
   end;
@z  


@x [24.356] - encTeX: the buffer accessing via read_buffer
begin repeat cur_chr:=buffer[k]; cat:=cat_code(cur_chr); incr(k);
until (cat<>letter)or(k>limit);
@<If an expanded...@>;
if cat<>letter then decr(k);
  {now |k| points to first nonletter}
if k>loc+1 then {multiletter control sequence has been scanned}
  begin cur_cs:=id_lookup(loc,k-loc); loc:=k; goto found;
  end;
end
@y
begin 
  repeat cur_chr := read_buffer (k); cat := cat_code (cur_chr);
    incr (k);
    k := k + mubyte_skip; mubyte_incs := mubyte_incs + mubyte_skip;
  until (cat <> letter) or (k > limit) or (mubyte_token > 0);
  @<If an expanded...@>;
  if cat <> letter then 
  begin 
    decr (k); k := k - mubyte_skip; mubyte_keep := 0;
  end;
  if k > loc + 1 then { multiletter control sequence has been scanned }
  begin
    if mubyte_incs > 0 then { multibyte in csname occurrs }
    begin
      i := loc; j := first;
      if j - loc + k - mubyte_incs > max_buf_stack then
      begin
        max_buf_stack := j - loc + k - mubyte_incs;
        if max_buf_stack >= buf_size then
        begin
          max_buf_stack := buf_size;
          overflow ("buffer size", buf_size);
        end;
      end;
      while i < k do
      begin
        buffer [j] := read_buffer (i);
        incr (i); i := i + mubyte_skip; incr (j);
      end;
      cur_cs := id_lookup (first, j-first);
    end else cur_cs := id_lookup (loc, k-loc) ;
    loc := k;
    goto found;
  end;
end
@z


@x [24.363] encTeX - native buffer printing
  if start<limit then for k:=start to limit-1 do print(buffer[k]);
@y
  if start<limit then
    if mubyte_in > 0 then for k:=start to limit-1 do print_char(buffer[k])
    else for k:=start to limit-1 do print(buffer[k]);
@z


@x [25.372] - encTeX: we need to distinguish \endcsname and \endmubyte
if cur_cmd<>end_cs_name then @<Complain about missing \.{\\endcsname}@>;
@y
if (cur_cmd<>end_cs_name) or (cur_chr<>0) then @<Complain about missing \.{\\endcsname}@>;
@z


@x [26.414] l.8358 - encTeX: accessing the xord/xchr
if m=math_code_base then scanned_result(ho(math_code(cur_val)))(int_val)
@y
if m=xord_code_base then scanned_result(xord[cur_val])(int_val)
else if m=xchr_code_base then scanned_result(xchr[cur_val])(int_val)
else if m=xprn_code_base then scanned_result(xprn[cur_val])(int_val)
else if m=math_code_base then scanned_result(ho(math_code(cur_val)))(int_val)
@z


@x [29.534] l.10293 - encTeX banner to log file
@<Print the banner line, including the date and time@>;
@y
@<Print the banner line, including the date and time@>;
wlog_cr; wlog('encTeX v. Dec. 2002, the reencoding enabled');
@z


@x [29.534] encTeX - native buffer printing
for k:=1 to l do print(buffer[k]);
@y
if mubyte_in > 0 then for k:=1 to l do print_char(buffer[k])
else for k:=1 to l do print(buffer[k]);
@z


@x [49.1211] - encTeX: declarations for \mubyte primitive
@!p,@!q:pointer; {for temporary short-term use}
@!n:integer; {ditto}
@!e:boolean; {should a definition be expanded? or was \.{\\let} not done?}
@y
@!p,@!q,@!r:pointer; {for temporary short-term use}
@!s:str_number; {string pionter}
@!n:integer; {ditto}
@!e:boolean; {should a definition be expanded? or was \.{\\let} not done?}
@z


@x [49.1219] - encTeX: \mubyte primitive
primitive("futurelet",let,normal+1);@/
@!@:future_let_}{\.{\\futurelet} primitive@>
@y
primitive("futurelet",let,normal+1);@/
@!@:future_let_}{\.{\\futurelet} primitive@>
primitive("mubyte",let,normal+10);@/
@!@:mubyte_}{\.{\\mubyte} primitive@>
@z


@x [49.1220] - encTeX: \mubyte primitive
let: if chr_code<>normal then print_esc("futurelet")@+else print_esc("let");
@y
let: if chr_code<>normal then 
      if chr_code = normal+10 then print_esc("mubyte")
      else print_esc("futurelet")
  else print_esc("let");
@z


@x [49.1221] - encTeX: \mubyte primitive
let:  begin n:=cur_chr;
@y
let:  if cur_chr = normal+10 then
      begin
        selector:=term_and_log; 
        get_token;
        mubyte_stoken := cur_tok;
        if cur_tok <= cs_token_flag then mubyte_stoken := cur_tok mod 256;
        get_x_token;
        if cur_cmd = spacer then get_x_token
        else if (mubyte_stoken > cs_token_flag) and (cur_cmd = mac_param) then 
             begin
               keep_byte_sequence := 1;
               get_x_token;
             end;
        r := get_avail; p := r;
        while cur_cs = 0 do begin store_new_token (cur_tok); get_x_token; end;
        if (cur_cmd <> end_cs_name) or (cur_chr <> 10) then
        begin
          print_err("Missing "); print_esc("endmubyte"); print(" inserted");
          help2("The control sequence marked <to be read again> should")@/
("not appear in <byte sequence> between \mubyte and \endmubyte.");
          back_error;
        end;
        p := link(r);
        if p = null then
        begin
          print_err("The empty <byte sequence>, "); 
          print_esc("mubyte"); print(" ignored");
          help2("The <byte sequence> in")@/
("\mubyte <token> <byte sequence>\endmubyte should not be empty.");
          error;
        end else begin         
          while p <> null do 
          begin 
            append_char (info(p) mod 256);
            p := link (p);
          end;
          flush_list (r);
          if (str_start [str_ptr] + 1 = pool_ptr) and 
            (str_pool [pool_ptr-1] = mubyte_stoken) then
          begin
            if mubyte_read [mubyte_stoken] <> null then  { clearing data }
              dispose_munode (mubyte_read [mubyte_stoken]);
            mubyte_read [mubyte_stoken] := null; 
            mubyte_write [mubyte_stoken] := 0;
            pool_ptr := str_start [str_ptr];
          end else begin
            mubyte_update;    { updating data }
            if mubyte_stoken > cs_token_flag then 
              pool_ptr := str_start [str_ptr]
            else begin
              mubyte_write [mubyte_stoken] := make_string;
              s := 1; { we spend a time to save the pool size }
              while s < str_ptr - 1 do
              begin
                if str_eq_str (s, mubyte_write [mubyte_stoken]) then
                begin
                  mubyte_write [mubyte_stoken] := s;
                  flush_string; {we need not the string in pool twice}
                  s := str_ptr; {leave the loop}
                end;
                incr (s);
              end;
            end;
          end;
        end;
      end else begin
        n:=cur_chr;
@z


@x [49.1230] l.22936 - encTeX: \xordcode, \xchrcode, \xprncode primitives
primitive("catcode",def_code,cat_code_base);
@!@:cat_code_}{\.{\\catcode} primitive@>
@y
primitive("xordcode",def_code,xord_code_base);
@!@:cat_code_}{\.{\\xordcode} primitive@>
primitive("xchrcode",def_code,xchr_code_base);
@!@:cat_code_}{\.{\\xchrcode} primitive@>
primitive("xprncode",def_code,xprn_code_base);
@!@:cat_code_}{\.{\\xprncode} primitive@>
primitive("catcode",def_code,cat_code_base);
@!@:cat_code_}{\.{\\catcode} primitive@>
@z


@x [49.1231] l.22956 - encTeX: \xordcode, \xchrcode primitives
def_code: if chr_code=cat_code_base then print_esc("catcode")
@y
def_code: if chr_code=xord_code_base then print_esc("xordcode")
  else if chr_code=xchr_code_base then print_esc("xchrcode")
  else if chr_code=xprn_code_base then print_esc("xprncode")
  else if chr_code=cat_code_base then print_esc("catcode")
@z


@x [49.1232] l.22969 - encTeX: setting a new value to xchr/xord
  p:=cur_chr; scan_char_num; p:=p+cur_val; scan_optional_equals;
  scan_int;
@y
  p:=cur_chr; scan_char_num; 
  if p=xord_code_base then p:=cur_val
  else if p=xchr_code_base then p:=cur_val+256
  else if p=xprn_code_base then p:=cur_val+512
  else p:=p+cur_val; 
  scan_optional_equals;
  scan_int;
@z


@x [49.1232] l.22980 - encTeX: setting a new value to xchr/xord
  if p<math_code_base then define(p,data,cur_val)
@y
  if p<256 then xord[p]:=cur_val
  else if p<512 then xchr[p-256]:=cur_val
  else if p<768 then xprn[p-512]:=cur_val
  else if p<math_code_base then define(p,data,cur_val)
@z


% May be you will need to use another function because dump_things is
% web2c specific.

@x [50.1307] l. 23784 encTeX: xord/xchr/xprn/mubyte dumping
dump_int(hyph_size)
@y  23784
dump_int(hyph_size);
dump_things(xord[0], 256);
dump_things(xchr[0], 256);
dump_things(xprn[0], 256);
dump_things(mubyte_read[0], 256);
dump_things(mubyte_write[0], 256)
@z


% May be you will need to use another function because undump_things is
% web2c specific.

@x [50.1308] l. 23804, encTeX: xord/xchr/xprn/mubyte undumping
if x<>hyph_size then goto bad_fmt
@y  23804
if x<>hyph_size then goto bad_fmt;
undump_things(xord[0], 256);
undump_things(xchr[0], 256);
undump_things(xprn[0], 256);
undump_things(mubyte_read[0], 256);
undump_things(mubyte_write[0], 256)
@z




