# Makefile for LaTeX ??? lines per inch fonts,
# by Pierre A. MacKay;
# 	based on the gf300.makefile
# 	contributed by John Ramsdell of the MITRE Corp., Bedford, MA.
#
# This Makefile requires that you have the following special LaTeX files
# available in your CMINPUTS directory (not path, directory, in this
# case) lasy*.mf lcircle*.mf line*.mf cmssqb8.mf (NOT lcmssqb8.mf)
#  
# You also need some of the files from the canonical Computer Modern set
# (default location: /usr/local/lib/texmf/fonts/public/cm/src).
#
#
# Copy this Makefile to the directory where you want the gf files to appear.  
#
# All the required regular files will be linked, and all the odd-ball
# parameter files needed by SliTeX will be created when you
# make isl_src
#
#      NOTE: If you want dvips to make fonts for you on the run,
#           then add all the special parameter mf files generated
#           by this makefile to the CMINPUTS path
#
# Then you can generate fonts via METAFONT
# at a wide range of magsteps for use with LaTeX and SliTeX.
#
# You can change the resolution for all magsteps with a single line
# modeled on "make depend":
#		 make magsteps "DPI=nnn"
# where nnn is the DPI resolution of your printer.
#
#	For example, if you wish to generate 120dpi fonts 
#	for a previewing program, type the following at
#	your prompt:
#		make magsteps "DPI=120"
#	When you check this Makefile again, you will see that
#	the values given below for the lines 
#		DPI     =  300
#		DPI_MAGHALF     =  329
#		DPI_MAGONE      =  360
#		DPI_MAGHALFONE  =  394
#		DPI_MAGTWO      =  432 
# 	 	... ... etc.
#	will have been re-evaluated for 120dpi.
#	
# This should be done, if necessary, as a first step.
# Note that this feature enables you to use this same Makefile
# over and over again to generate these fonts at any dpi.
#
# 	NOTE: If you have only the fonts for a LaTeX 10pt style, and you
# 	want to be sure of *ALL* the magnifications necessary for a
# 	12pt style ( == magstep1), simply increase the DPI value,
# 	alter the base value for MAGSTEP, and run a make.  For example, 
#	if the base resolution for your mode_def is 300dpi,
# 	and you want to generate fonts for 12pt style (i.e., 10pt at magstep1), 
#	begin with
#		make magsteps DPI=360
#	edit the MAGSTEP value (in the section below) so that
#		MAGSTEP = 1.0
# 	and then make all.
#
#	For 11pt: make magsteps DPI=329; 
#		  edit the MAGSTEP = line below so that the value is 0.5; 
#		  make all. 
#
# Check the following lines out for compatibility with your system.
# Edit where necessary to reflect what is the case on your machine.

TEXHOME = /usr/local
TEX	= $(TEXHOME)/bin
TEXBIN	= $(TEX)
LINK	= ln -s
# if you don't have symbolic links, cp will do here.
MAGSTEP = 0.0
MF	= mf
MODE	= localfont
# MFBASE  = $(TEXHOME)/lib/mf/bases
MFBASE  = $(TEXHOME)/lib/texmf/ini
# CMINPUTS  = $(TEXHOME)/lib/mf/inputs/cm
CMINPUTS = $(TEXHOME)/lib/texmf/fonts/public/cm/src
OPT	= 
CMDLINE	= MFBASES=${MFBASE} ; export MFBASES ; $(TEXBIN)/$(MF) '\mode:=$(MODE);' '$(OPT);'

# This Makefile may also be used with local variants of mf (but make certain 
# that your variant does not use a base in which cmbase has been preloaded); 
# and it may be used with mode_defs other than that defined as "localfont" 
# in your modes.mf file.  The following command line
#
#	make "MF=mymf" "MODE=mymode"
#
# will invoke this Makefile and generate fonts using "mymf" (i.e., your variant 
# of mf) and "mymode" (whatever mode_def you wish to substitute for "localfont").
# For instance, to invoke the default mf program to make gf300w fonts for a 
# write-white device, the call would be:
#
#	make all "MODE=RicohFourZeroEightZero"
#
# This assumes, of course, that "localfonts" in your mode_defs file 
# is defined as something other than RicohFourZeroEightZero.  
# If is IS RicohFourZeroEightZero, simply typing "make all" would suffice.
#
# For purposes of this script, "mf.base" is assumed to include
# the |mode_def| file "modes.mf" (or whatever you are using at your site).
# (We encourage the use of "modes.mf" to ensure consistency in the fonts
# generated between sites.)

# BEGIN MAGSTEPS DO NOT DELETE THIS LINE
# OR THIS LINE--the following macros are generated by make magsteps
DPI		=  300
DPI_MAGHALF	=  329
DPI_MAGONE	=  360
DPI_MAGHALFONE	=  394
DPI_MAGTWO	=  432
DPI_MAGTHREE	=  518
DPI_MAGFOUR	=  622
DPI_MAGFIVE	=  746
DPI_MAGSIX	=  895
DPI_MAGSEVEN	=  1074
DPI_MAGEIGHT	=  1289
DPI_MAGNINE	=  1547
TEN_AT_NINE	=  270
TEN_AT_EIGHT	=  240
SVN_AT_SIX	=  257
SVN_AT_FIVE	=  214
# END MAGSTEPS DO NOT DELETE THIS LINE EITHER

.SUFFIXES: .mf .${DPI}gf 
.SUFFIXES: .${DPI_MAGHALF}gf .${DPI_MAGONE}gf .${DPI_MAGHALFONE}gf .${DPI_MAGTWO}gf .${DPI_MAGTHREE}gf .${DPI_MAGFOUR}gf .${DPI_MAGFIVE}gf
.SUFFIXES: .${DPI_MAGSIX}gf .${DPI_MAGSEVEN}gf .${DPI_MAGEIGHT}gf .${DPI_MAGNINE}gf
.SUFFIXES: .$(TEN_AT_NINE)gf .$(SVN_AT_SIX)gf .$(TEN_AT_EIGHT)gf .$(SVN_AT_FIVE)gf

.mf.${DPI}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP));' input $*

.mf.${DPI_MAGHALF}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 0.5);' input $*

.mf.${DPI_MAGONE}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 1.0);' input $*

.mf.${DPI_MAGTWO}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 2.0);' input $*

.mf.${DPI_MAGTHREE}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 3.0);' input $*

.mf.${DPI_MAGFOUR}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 4.0);' input $*

.mf.${DPI_MAGFIVE}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 5.0);' input $*

.mf.${DPI_MAGSIX}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 6.0);' input $*

.mf.${DPI_MAGSEVEN}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 7.0);' input $*

.mf.${DPI_MAGEIGHT}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 8.0);' input $*

.mf.${DPI_MAGNINE}gf: cmsy8.mf
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 9.0);' input $*

CM_SRC	= cmcsc10.mf cmmi8.mf cmsy8.mf cmtt8.mf cmex10.mf

L_SRC	= lasy10.mf lasy5.mf lasy6.mf lasy7.mf lasy8.mf \
	lasy9.mf lasyb10.mf lcircle10.mf lcirclew10.mf \
	line10.mf linew10.mf

LCM_SRC = lcmss8.mf lcmssi8.mf lcmssb8.mf

SL_SRC	= $(L_SRC) $(LCM_SRC) $(CM_SRC)

ISL_SRC = lasy8.mf $(LCM_SRC) $(CM_SRC)

NOMAG	= lasy10.${DPI}gf lasy5.${DPI}gf lasy6.${DPI}gf lasy7.${DPI}gf lasy8.${DPI}gf \
	lasy9.${DPI}gf lasyb10.${DPI}gf lcircle10.${DPI}gf lcirclew10.${DPI}gf \
	line10.${DPI}gf linew10.${DPI}gf

MAGHALF	= lasy10.${DPI_MAGHALF}gf lasy5.${DPI_MAGHALF}gf lasy7.${DPI_MAGHALF}gf lasyb10.${DPI_MAGHALF}gf

MAGONE	= lasy10.${DPI_MAGONE}gf lasy5.${DPI_MAGONE}gf lasy7.${DPI_MAGONE}gf lasyb10.${DPI_MAGONE}gf

MAGTWO	= lasy10.${DPI_MAGTWO}gf lasy5.${DPI_MAGTWO}gf lasy7.${DPI_MAGTWO}gf lasyb10.${DPI_MAGTWO}gf cmcsc10.${DPI_MAGTWO}gf 

IMAGTWO = icmcsc10.${DPI_MAGTWO}gf

MAGTHREE = lasy10.${DPI_MAGTHREE}gf lasy5.${DPI_MAGTHREE}gf lasy7.${DPI_MAGTHREE}gf lasy8.${DPI_MAGTHREE}gf lasyb10.${DPI_MAGTHREE}gf \
	lcmss8.${DPI_MAGTHREE}gf lcmssi8.${DPI_MAGTHREE}gf lcmssb8.${DPI_MAGTHREE}gf \
	cmcsc10.${DPI_MAGTHREE}gf cmmi8.${DPI_MAGTHREE}gf cmsy8.${DPI_MAGTHREE}gf cmtt8.${DPI_MAGTHREE}gf cmex10.${DPI_MAGTHREE}gf 

IMAGTHREE = ilcmss8.${DPI_MAGTHREE}gf ilcmssi8.${DPI_MAGTHREE}gf ilcmssb8.${DPI_MAGTHREE}gf \
	icmcsc10.${DPI_MAGTHREE}gf icmmi8.${DPI_MAGTHREE}gf icmsy8.${DPI_MAGTHREE}gf icmtt8.${DPI_MAGTHREE}gf icmex10.${DPI_MAGTHREE}gf ilasy8.${DPI_MAGTHREE}gf

MAGFOUR = lasy10.${DPI_MAGFOUR}gf lasy5.${DPI_MAGFOUR}gf lasy7.${DPI_MAGFOUR}gf lasy8.${DPI_MAGFOUR}gf lasyb10.${DPI_MAGFOUR}gf \
	lcmss8.${DPI_MAGFOUR}gf lcmssi8.${DPI_MAGFOUR}gf lcmssb8.${DPI_MAGFOUR}gf \
	cmcsc10.${DPI_MAGFOUR}gf cmmi8.${DPI_MAGFOUR}gf cmsy8.${DPI_MAGFOUR}gf cmtt8.${DPI_MAGFOUR}gf

IMAGFOUR = ilcmss8.${DPI_MAGFOUR}gf ilcmssi8.${DPI_MAGFOUR}gf ilcmssb8.${DPI_MAGFOUR}gf \
	icmcsc10.${DPI_MAGFOUR}gf icmmi8.${DPI_MAGFOUR}gf icmsy8.${DPI_MAGFOUR}gf icmtt8.${DPI_MAGFOUR}gf ilasy8.${DPI_MAGFOUR}gf

MAGFIVE = lasy10.${DPI_MAGFIVE}gf lasy5.${DPI_MAGFIVE}gf lasy7.${DPI_MAGFIVE}gf lasy8.${DPI_MAGFIVE}gf lasyb10.${DPI_MAGFIVE}gf \
	lcmss8.${DPI_MAGFIVE}gf lcmssi8.${DPI_MAGFIVE}gf lcmssb8.${DPI_MAGFIVE}gf \
	cmcsc10.${DPI_MAGFIVE}gf cmmi8.${DPI_MAGFIVE}gf cmsy8.${DPI_MAGFIVE}gf cmtt8.${DPI_MAGFIVE}gf

IMAGFIVE = ilcmss8.${DPI_MAGFIVE}gf ilcmssi8.${DPI_MAGFIVE}gf ilcmssb8.${DPI_MAGFIVE}gf \
	icmcsc10.${DPI_MAGFIVE}gf icmmi8.${DPI_MAGFIVE}gf icmsy8.${DPI_MAGFIVE}gf icmtt8.${DPI_MAGFIVE}gf ilasy8.${DPI_MAGFIVE}gf

MAGSIX	= lasy8.${DPI_MAGSIX}gf \
	lcmss8.${DPI_MAGSIX}gf lcmssi8.${DPI_MAGSIX}gf lcmssb8.${DPI_MAGSIX}gf \
	cmcsc10.${DPI_MAGSIX}gf cmmi8.${DPI_MAGSIX}gf cmsy8.${DPI_MAGSIX}gf cmtt8.${DPI_MAGSIX}gf

IMAGSIX = ilcmss8.${DPI_MAGSIX}gf ilcmssi8.${DPI_MAGSIX}gf ilcmssb8.${DPI_MAGSIX}gf \
	icmcsc10.${DPI_MAGSIX}gf icmmi8.${DPI_MAGSIX}gf icmsy8.${DPI_MAGSIX}gf icmtt8.${DPI_MAGSIX}gf ilasy8.${DPI_MAGSIX}gf

MAGSEVEN = lasy8.${DPI_MAGSEVEN}gf \
	lcmss8.${DPI_MAGSEVEN}gf lcmssi8.${DPI_MAGSEVEN}gf lcmssb8.${DPI_MAGSEVEN}gf \
	cmcsc10.${DPI_MAGSEVEN}gf cmmi8.${DPI_MAGSEVEN}gf cmsy8.${DPI_MAGSEVEN}gf cmtt8.${DPI_MAGSEVEN}gf

IMAGSEVEN = ilcmss8.${DPI_MAGSEVEN}gf ilcmssi8.${DPI_MAGSEVEN}gf ilcmssb8.${DPI_MAGSEVEN}gf \
	icmcsc10.${DPI_MAGSEVEN}gf icmmi8.${DPI_MAGSEVEN}gf icmsy8.${DPI_MAGSEVEN}gf icmtt8.${DPI_MAGSEVEN}gf ilasy8.${DPI_MAGSEVEN}gf

MAGEIGHT = lasy8.${DPI_MAGEIGHT}gf \
	lcmss8.${DPI_MAGEIGHT}gf lcmssi8.${DPI_MAGEIGHT}gf lcmssb8.${DPI_MAGEIGHT}gf \
	cmmi8.${DPI_MAGEIGHT}gf cmsy8.${DPI_MAGEIGHT}gf cmtt8.${DPI_MAGEIGHT}gf

IMAGEIGHT = ilcmss8.${DPI_MAGEIGHT}gf ilcmssi8.${DPI_MAGEIGHT}gf ilcmssb8.${DPI_MAGEIGHT}gf \
	icmmi8.${DPI_MAGEIGHT}gf icmsy8.${DPI_MAGEIGHT}gf icmtt8.${DPI_MAGEIGHT}gf ilasy8.${DPI_MAGEIGHT}gf

MAGNINE = lcmss8.${DPI_MAGNINE}gf 
IMAGNINE = ilcmss8.${DPI_MAGNINE}gf

SLIDELOGO = logo8.${DPI_MAGTHREE}gf logo8.${DPI_MAGFOUR}gf logo8.${DPI_MAGFIVE}gf logo8.${DPI_MAGSIX}gf logo8.${DPI_MAGSEVEN}gf logo8.${DPI_MAGEIGHT}gf 

ISLIDELOGO = ilogo8.${DPI_MAGTHREE}gf ilogo8.${DPI_MAGFOUR}gf ilogo8.${DPI_MAGFIVE}gf ilogo8.${DPI_MAGSIX}gf ilogo8.${DPI_MAGSEVEN}gf ilogo8.${DPI_MAGEIGHT}gf

VIS_FONTS = $(NOMAG) $(MAGHALF) $(MAGONE) $(MAGTWO) $(MAGTHREE) $(MAGFOUR) \
	$(MAGFIVE) $(MAGSIX) $(MAGSEVEN) $(MAGEIGHT) $(MAGNINE)

INVIS_FONTS = $(IMAGTWO) $(IMAGTHREE) $(IMAGFOUR) \
	$(IMAGFIVE) $(IMAGSIX) $(IMAGSEVEN) $(IMAGEIGHT) $(IMAGNINE)

FONTS	= $(VIS_FONTS) $(INVIS_FONTS)

all:	isl_src $(FONTS)

logo:   $(SLIDELOGO)

#
# Note that cmssqb is not part of the official Computer
# Modern font set, but is created only for slitex. That
# is why the parameter file is local, and not in CMINPUTS
#
lcm_src:
	cp $(CMINPUTS)/roman.mf ./sroman.mf
	cp $(CMINPUTS)/cmssq8.mf ./lcmss8.mf ;
	cp $(CMINPUTS)/cmssqi8.mf ./lcmssi8.mf ;
	cp ./cmssqb8.mf ./lcmssb8.mf ;
	echo "/input romanu/s/romanu/sromanu/ | wq " | ex - ./sroman.mf
	for i in $(LCM_SRC) ; \
	do \
		echo "/CMSSQ/s/CMSSQ/CMSS/ | wq " | ex ./$$i ; \
		echo "/font_identifier/s/:=\"/:=\"L/ | wq " | ex - ./$$i ; \
		echo "/generate/s/roman/sroman/ | wq " | ex - ./$$i ; \
	done

l_src: 
	for i in $(L_SRC) ; \
	do \
		if test ! -r $$i ; then \
		$(LINK) $(CMINPUTS)/$$i ./$$i ; \
	        fi ; \
	done

sl_src: lcm_src
	for i in $(SL_SRC) ; \
	do \
		if test ! -r $$i ; then \
		$(LINK) $(CMINPUTS)/$$i ./$$i ; \
	        fi ; \
	done

isl_src: cmscript sl_src
	for i in $(ISL_SRC) ; \
	do \
		if test -r $$i ; then \
		cp ./$$i ./i$$i ; \
		ex - ./i$$i < cmscript ; \
	        fi ; \
	done

cmscript:
	echo "/generate/i" > cmscript
	echo "" >> cmscript
	echo "string ifid; ifid:=\"I\" & font_identifier_;" >> cmscript
	echo "font_identifier ifid;" >> cmscript;
	echo "extra_endchar := extra_endchar & \"clearit;\"; " >> cmscript
	echo "." >> cmscript
	echo "wq" >> cmscript

logo8.mf:
	if test ! -r ./logo8.mf; then \
	$(LINK) $(CMINPUTS)/logo8.mf ./logo8.mf;\
	fi ;

ilogo8.mf: logo8.mf cmscript
	echo "/generate/s/generate/input/ | wq " | ex cmscript
	cp ./logo8.mf ./ilogo8.mf
	ex ./ilogo8.mf < cmscript
	echo "/input/s/input/generate/ | wq " | ex cmscript


# Nice bit of self-reference here, as DPI uses itself to recreate itself
#
magsteps:
	(base=$(DPI) ; \
	echo "DPI		= " $$base > magvals ; \
	i=`/bin/expr $$base \* 95445` ; \
	j=`/bin/expr $$base \* 1000000 + $$i + 500000` ; \
	maghalf=`/bin/expr $$j / 1000000` ; \
	echo "DPI_MAGHALF	= " $$maghalf >> magvals ; \
	i=`/bin/expr  $$base \* 2` ; j=`/bin/expr $$base \* 10 + $$i + 5` ; magone=`/bin/expr $$j / 10` ; \
	echo "DPI_MAGONE	= " $$magone >> magvals ; \
	i=`/bin/expr  $$magone \* 95445` ; j=`/bin/expr $$magone \* 1000000 + $$i + 500000` ; \
	maghalfone=`/bin/expr $$j / 1000000` ; \
	echo "DPI_MAGHALFONE	= " $$maghalfone >> magvals ; \
	i=`/bin/expr  $$magone \* 2` ; j=`/bin/expr $$magone \* 10 + $$i + 5` ; \
	magtwo=`/bin/expr $$j / 10` ; echo "DPI_MAGTWO	= " $$magtwo >> magvals ; \
	i=`/bin/expr  $$magtwo \* 2` ; j=`/bin/expr $$magtwo \* 10 + $$i + 5` ; \
	magthree=`/bin/expr $$j / 10` ; echo "DPI_MAGTHREE	= " $$magthree >> magvals ; \
	i=`/bin/expr  $$magthree \* 2` ; j=`/bin/expr $$magthree \* 10 + $$i + 5` ; \
	magfour=`/bin/expr $$j / 10` ; echo "DPI_MAGFOUR	= " $$magfour >> magvals ; \
	i=`/bin/expr  $$magfour \* 2` ; j=`/bin/expr $$magfour \* 10 + $$i + 5` ; \
	magfive=`/bin/expr $$j / 10` ; echo "DPI_MAGFIVE	= " $$magfive >> magvals ; \
	i=`/bin/expr  $$magfive \* 2` ; j=`/bin/expr $$magfive \* 10 + $$i + 5` ; \
	magsix=`/bin/expr $$j / 10` ; echo "DPI_MAGSIX	= " $$magsix >> magvals ; \
	i=`/bin/expr  $$magsix \* 2` ; j=`/bin/expr $$magsix \* 10 + $$i + 5` ; \
	magseven=`/bin/expr $$j / 10` ; echo "DPI_MAGSEVEN	= " $$magseven >> magvals ; \
	i=`/bin/expr  $$magseven \* 2` ; j=`/bin/expr $$magseven \* 10 + $$i + 5` ; \
	mageight=`/bin/expr $$j / 10` ; echo "DPI_MAGEIGHT	= " $$mageight >> magvals ; \
	i=`/bin/expr  $$mageight \* 2` ; j=`/bin/expr $$mageight \* 10 + $$i + 5` ; \
	magnine=`/bin/expr $$j / 10` ; echo "DPI_MAGNINE	= " $$magnine >> magvals ; \
	i=`/bin/expr $$base \* 900` ; \
	tenatnine=`/bin/expr $$i / 1000` ; \
	echo "TEN_AT_NINE	= " $$tenatnine >> magvals ; \
	i=`/bin/expr $$base \* 800` ; \
	tenateight=`/bin/expr $$i / 1000` ; \
	echo "TEN_AT_EIGHT	= " $$tenateight >> magvals ; \
	i=`/bin/expr $$base \* 600` ; \
	svnatsix=`/bin/expr $$i / 700` ; \
	echo "SVN_AT_SIX	= " $$svnatsix >> magvals ; \
	i=`/bin/expr $$base \* 500` ; \
	svnatfive=`/bin/expr $$i / 700` ; \
	echo "SVN_AT_FIVE	= " $$svnatfive >> magvals ; \
	echo "# END MAGSTEPS DO NOT DELETE THIS LINE EITHER" >> magvals)
	cp Makefile Makefile.bak
	echo '/^# BEGIN MAGSTEPS/+2,/^# END MAGSTEPS/d|-1r magvals |w' | ex Makefile
#	Here is some boilerplate for additional dependencies. Try your hand.
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d|w' | ex Makefile

#	echo '# GENERATED DEPENDENCIES MUST BE AT EOF' >> Makefile
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile

clean:
	rm -f *~ \#*\# cm*.mf icm*.mf *logo8.mf cmscript *.log

veryclean: clean
	rm -f *.*gf *.tfm

# DO NOT DELETE THIS LINE
# OR THIS LINE--the following rules are generated by make depend
# GENERATED DEPENDENCIES MUST BE AT EOF
# IF YOU PUT STUFF HERE IT WILL GO AWAY
===================================================================
# Makefile for the plain.tex, lplain.tex and webmac.tex fonts in the
# Computer Modern family.
# Based on the gf300.makefile
# contributed by John Ramsdell of the MITRE Corp., Bedford, MA.

# You can change the resolution for all magsteps with a single line
# modeled on make depend.
#		 make magsteps "DPI=nnn"
# where nnn is the DPI resolution
# of your printer.
# The *.mf files must be present in or linked in this directory.
# Sorry about that.
#
# Check the following lines out for compatibility with your system
# Invoke this with make "MF=mymf" "MODE=mymode" to get special
# effects.  For instance, to make the gf300w fonts, the
# call would be:    make all "MODE=RicohFourZeroEightZero"

TEX	= /usr/local
TEXBIN	= $(TEX)/bin
MAGSTEP = 0.0
MF	= cmmf
MODE	= localfont
# MFBASE	= /usr/local/lib/mf/bases
MFBASE	= /usr/local/lib/texmf/ini
CMDLINE	= MFBASES=${MFBASE} ; export MFBASES ; $(TEXBIN)/$(MF) '\mode:=$(MODE);' 'batchmode;'


# BEGIN MAGSTEPS DO NOT DELETE THIS LINE
# OR THIS LINE--the following macros are generated by make magsteps
DPI	=  300
DPI_MAGHALF	=  329
DPI_MAGONE	=  360
DPI_MAGHALFONE	=  394
DPI_MAGTWO	=  432
DPI_MAGTHREE	=  518
DPI_MAGFOUR	=  622
DPI_MAGFIVE	=  746
TEN_AT_NINE	=  270
TEN_AT_EIGHT	=  240
SVN_AT_SIX	=  257
SVN_AT_FIVE	=  214
# END MAGSTEPS DO NOT DELETE THIS LINE EITHER

.SUFFIXES: .mf .${DPI}gf 
.SUFFIXES: .${DPI_MAGHALF}gf .${DPI_MAGONE}gf .${DPI_MAGTWO}gf .${DPI_MAGTHREE}gf .${DPI_MAGFOUR}gf .${DPI_MAGFIVE}gf
.SUFFIXES: .$(TEN_AT_NINE)gf .$(SVN_AT_SIX)gf .$(TEN_AT_EIGHT)gf .$(SVN_AT_FIVE)gf


.mf.${DPI}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP));' input $*

.mf.${DPI_MAGHALF}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 0.5);' input $*

.mf.${DPI_MAGONE}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 1.0);' input $*

.mf.${DPI_MAGTWO}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 2.0);' input $*

.mf.${DPI_MAGTHREE}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 3.0);' input $*

.mf.${DPI_MAGFOUR}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 4.0);' input $*

.mf.${DPI_MAGFIVE}gf:
	$(CMDLINE) '\mag:=magstep($(MAGSTEP) + 5.0);' input $*

.mf.$(TEN_AT_NINE)gf:
	$(CMDLINE) '\mag:=9/10;' input $*

.mf.$(SVN_AT_SIX)gf:
	$(CMDLINE) '\mag:=6/7;' input $*

.mf.$(TEN_AT_EIGHT)gf:
	$(CMDLINE) '\mag:=8/10;' input $*

.mf.$(SVN_AT_FIVE)gf:
	$(CMDLINE) '\mag:=5/7;' input $*

NOMAG	= cmbsy10.${DPI}gf \
		cmbx10.${DPI}gf cmbx12.${DPI}gf \
		cmbx5.${DPI}gf cmbx6.${DPI}gf cmbx7.${DPI}gf cmbx8.${DPI}gf cmbx9.${DPI}gf \
		cmcsc10.${DPI}gf \
		cmdunh10.${DPI}gf cmex10.${DPI}gf \
		cmmi10.${DPI}gf cmmi12.${DPI}gf \
		cmmi5.${DPI}gf cmmi6.${DPI}gf cmmi7.${DPI}gf cmmi8.${DPI}gf cmmi9.${DPI}gf \
		cmmib10.${DPI}gf \
		cmr10.${DPI}gf cmr12.${DPI}gf cmr17.${DPI}gf \
		cmr5.${DPI}gf cmr6.${DPI}gf cmr7.${DPI}gf cmr8.${DPI}gf cmr9.${DPI}gf \
		cmsl10.${DPI}gf cmsl12.${DPI}gf cmsl8.${DPI}gf cmsl9.${DPI}gf \
		cmsltt10.${DPI}gf \
		cmss10.${DPI}gf cmss12.${DPI}gf cmss17.${DPI}gf cmssbx10.${DPI}gf \
		cmssi10.${DPI}gf cmssi12.${DPI}gf cmssi17.${DPI}gf \
		cmssq8.${DPI}gf cmssqi8.${DPI}gf \
		cmsy10.${DPI}gf \
		cmsy5.${DPI}gf cmsy6.${DPI}gf cmsy7.${DPI}gf cmsy8.${DPI}gf cmsy9.${DPI}gf \
		cmtex10.${DPI}gf cmtex9.${DPI}gf \
		cmti10.${DPI}gf cmti12.${DPI}gf cmti7.${DPI}gf cmti8.${DPI}gf cmti9.${DPI}gf \
		cmtt10.${DPI}gf cmtt12.${DPI}gf cmtt8.${DPI}gf cmtt9.${DPI}gf \
		cmu10.${DPI}gf 

MAGHALF	= cmbx10.${DPI_MAGHALF}gf cmmi10.${DPI_MAGHALF}gf cmr10.${DPI_MAGHALF}gf cmsl10.${DPI_MAGHALF}gf \
		cmss10.${DPI_MAGHALF}gf cmsy10.${DPI_MAGHALF}gf cmti10.${DPI_MAGHALF}gf cmtt10.${DPI_MAGHALF}gf 

MAGONE	= cmsy10.${DPI_MAGONE}gf 

MAGTWO	= cmbx10.${DPI_MAGTWO}gf cmmi10.${DPI_MAGTWO}gf cmr10.${DPI_MAGTWO}gf cmssbx10.${DPI_MAGTWO}gf \
		cmsy10.${DPI_MAGTWO}gf cmtt10.${DPI_MAGTWO}gf 

MAGTHREE = cmbx10.${DPI_MAGTHREE}gf cmsy10.${DPI_MAGTHREE}gf

MAGFOUR = cmbx10.${DPI_MAGFOUR}gf cmmi10.${DPI_MAGFOUR}gf cmr10.${DPI_MAGFOUR}gf cmr7.${DPI_MAGFOUR}gf cmsy10.${DPI_MAGFOUR}gf 

MAGFIVE	= cmbx10.${DPI_MAGFIVE}gf cmr10.${DPI_MAGFIVE}gf

FONTS = $(NOMAG) $(MAGHALF) $(MAGONE) $(MAGTWO) $(MAGTHREE) $(MAGFOUR) \
	$(MAGFIVE) 

all:	$(FONTS)

# Nice bit of self-reference here, as DPI uses itself to recreate itself
#
magsteps:
	(base=$(DPI) ; \
	echo "DPI	= " $$base > magvals ; \
	i=`/bin/expr $$base \* 95445` ; \
	j=`/bin/expr $$base \* 1000000 + $$i + 500000` ; \
	maghalf=`/bin/expr $$j / 1000000` ; \
	echo "DPI_MAGHALF	= " $$maghalf >> magvals ; \
	i=`/bin/expr  $$base \* 2` ; j=`/bin/expr $$base \* 10 + $$i + 5` ; magone=`/bin/expr $$j / 10` ; \
	echo "DPI_MAGONE	= " $$magone >> magvals ; \
	i=`/bin/expr  $$magone \* 95445` ; j=`/bin/expr $$magone \* 1000000 + $$i + 500000` ; \
	maghalfone=`/bin/expr $$j / 1000000` ; \
	echo "DPI_MAGHALFONE	= " $$maghalfone >> magvals ; \
	i=`/bin/expr  $$magone \* 2` ; j=`/bin/expr $$magone \* 10 + $$i + 5` ; \
	magtwo=`/bin/expr $$j / 10` ; echo "DPI_MAGTWO	= " $$magtwo >> magvals ; \
	i=`/bin/expr  $$magtwo \* 2` ; j=`/bin/expr $$magtwo \* 10 + $$i + 5` ; \
	magthree=`/bin/expr $$j / 10` ; echo "DPI_MAGTHREE	= " $$magthree >> magvals ; \
	i=`/bin/expr  $$magthree \* 2` ; j=`/bin/expr $$magthree \* 10 + $$i + 5` ; \
	magfour=`/bin/expr $$j / 10` ; echo "DPI_MAGFOUR	= " $$magfour >> magvals ; \
	i=`/bin/expr  $$magfour \* 2` ; j=`/bin/expr $$magfour \* 10 + $$i + 5` ; \
	magfive=`/bin/expr $$j / 10` ; echo "DPI_MAGFIVE	= " $$magfive >> magvals ; \
	i=`/bin/expr $$base \* 900` ; \
	tenatnine=`/bin/expr $$i / 1000` ; \
	echo "TEN_AT_NINE	= " $$tenatnine >> magvals ; \
	i=`/bin/expr $$base \* 800` ; \
	tenateight=`/bin/expr $$i / 1000` ; \
	echo "TEN_AT_EIGHT	= " $$tenateight >> magvals ; \
	i=`/bin/expr $$base \* 600` ; \
	svnatsix=`/bin/expr $$i / 700` ; \
	echo "SVN_AT_SIX	= " $$svnatsix >> magvals ; \
	i=`/bin/expr $$base \* 500` ; \
	svnatfive=`/bin/expr $$i / 700` ; \
	echo "SVN_AT_FIVE	= " $$svnatfive >> magvals ; \
	echo "# END MAGSTEPS DO NOT DELETE THIS LINE EITHER" >> magvals)
	cp Makefile Makefile.bak
	echo '/^# BEGIN MAGSTEPS/+2,/^# END MAGSTEPS/d|-1r magvals |w' | ex Makefile
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d|w' | ex Makefile
#	echo '# GENERATED DEPENDENCIES MUST BE AT EOF' >> Makefile
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile

# DO NOT DELETE THIS LINE
# OR THIS LINE--the following rules are generated by make depend
# GENERATED DEPENDENCIES MUST BE AT EOF
# IF YOU PUT STUFF HERE IT WILL GO AWAY
