program cstocs2;

{TurboPascal 5.5, Josef Tkadlec, 24.11.1996, 21.1.1998}

uses  dos,ouunit,strings;

const  PROGRAMNAME = 'CSTOCS2';            {name of this program}
       NFTNAME     = PROGRAMNAME+'.#$-';   {name of temporary file if needed}

const fileexists :Boolean = true;          {output file exists}
      warning    :Boolean = false;         {there are non-converted chars >127}
      sequences  :array[1..2] of Boolean
                 = (false,false);          {input/output qiven in sequences}
      ci         :byte    = 255;           {index of input code}
      co         :byte    = 255;           {index of output code}
      lastind    :integer = nocharsalw;    {index of the last converted char.}

var  escchar     :char;    {escape character in sequences}
     nfi,nfo,nft :string;  {names of input/output/temporary files}
     fi,fo       :text;    {input/output files}

procedure Info (haltcode:integer);
{********************************}
begin;
writeln;
case haltcode of
  1 :writeln('Bad number of parameters.');
  2 :writeln('Bad code page.');
  3 :writeln('Bad input file.');
  end;
writeln;writeln(
PROGRAMNAME+' - converts Czech and Slovak letters.');writeln(
'Josef Tkadlec, November 24, 1996; January 21, 1998.');
writeln;writeln(
'  '+PROGRAMNAME+' [options] input_file [options] [output_file] [options]');
writeln;
writeln('Options:');
writeln('  -in  n is the code of input file (obligatory!)');
writeln('  -om  m is the code of output file             ');
writeln('  -s   convert also no-break space, dashes, single quotation marks');
writeln('  -w   as -s and double quotation marks');
writeln('!!! -s/-w converts "''", "`", ",," to another in win, mac (not from sequences)');
writeln;
writeln('Codes: (not case sensitive)');
writeln('       asc - 7bit ASCII             il1 - ISO 8859-1 (ISO Latin 1)');
writeln('       us  - cp437 (US)             il2 - ISO 8859-2 (ISO Latin 2)');
writeln('       kam - keybcs2 (Kamenicti)    win - cp1250 (WINDOWS)        ');
writeln('       pl1 - cp850 (PC Latin 1)     mac - macce (Macintosh CE)    ');
writeln('       pl2 - cp852 (PC Latin 2)     t1  - T1 (Cork)               ');
writeln('       ibm - IBM852 (???)           tex - TeX sequences           ');
writeln('       koi - KOI8-CS                htm - HTML sequences          ');
halt(haltcode)
end;

function EmptyChar (ch :char) :Boolean;
{-------------------------------------}
begin EmptyChar := (ch=' ') or (ch=^M) or (ch=^J) end;

function Letter (z:char) :Boolean;
{--------------------------------}
begin
Letter:= ((ord(z)>=65) and (ord(z)<=90)) or ((ord(z)>=97) and (ord(z)<=122))
end;

procedure TransformCode (s:string; var c:byte; j:byte);
{*****************************************************}
var  i :byte;                  {find index of a given code for input or output}
begin
for i:=1 to length(s) do s[i]:=UpCase(s[i]);
i:=1;while (i<=nocodes) and (s<>tables[i,0]) do Inc(i);
if i<=nocodes then c:=i else
  begin
  i:=1;while (i<=nocodesseq) and (s<>tablesseq[i,0]) do Inc(i);
  if i>nocodesseq then Info(2) else
    begin
    c:=i;sequences[j]:=true;
    end;
  end;
end;

procedure CommandLine (var ci,co:byte; var nfi,nfo:string);
{*********************************************************}
var i,j     : integer;                  {indices and names of input and output}
    dir     : dirstr;
    name    : namestr;
    ext     : extstr;
    found   : searchrec;
    option  : string;
    optstr  : string;
begin;  j := paramcount;
if j = 0 then Info(1);                               {bad number of parameters}
nfi := ''; nfo := '';
i := 1;
while (i <= j) do
  if commandstr(i,option) then
    begin;
    if length(option) = 0 then Info(2);
    fsplit(option,dir,name,ext);
    findfirst(dir+name+ext,anyfile,found);
    if (doserror <> 0) and (length(nfi) = 0) then Info(3);
    if (length(nfi) > 0) then
      if (doserror <> 0) then fileexists := false else fileexists := true;
    option := dir+name+ext;
    if length(nfo) > 0 then Info(1)
    else
      if length(nfi) > 0 then nfo := option
      else nfi := option;
    end;
if length(nfi) = 0 then Info(1);
if length(nfo) = 0 then nfo := nfi;
i := 1;
while (i <= j) do
 if commandopt(i,option,optstr) then
   begin;
   if length(option) = 1 then
     case option[1] of
       's': lastind:=lastsingle;
       'w': lastind:=nochars;
       'i': TransformCode(optstr,ci,1);
       'o': TransformCode(optstr,co,2);
       else Info(1);
       end;
  end;
nft := dir+NFTNAME;
if ci=255 then ci := co;
if co=255 then co := ci;
end;

procedure Output (i:integer);
{***************************}
begin
if sequences[2]
  then write(fo,tablesseq[co,i])
  else case tables[co,2,i] of
    '0' :;
    '1' :write(fo,' ');
    '2' :write(fo,tables2[co,i]);
    else write(fo,tables[co,2,i]);
    end;
end;

procedure GTabInput;
{******************}
var  nacteno :Boolean;
     z,zz    :char;
     i       :integer;
     to1     :array[lastsingle..nochars] of Boolean; {which chars are by 2}
     s       :set of char;  {first chars of such expansions}
procedure Write1;
  begin
  i:=1;while (i<=lastind) and (z<>tables[ci,1,i]) do Inc(i);
  if (i<=lastind) then Output(i) else
    begin write(fo,z);if ord(z)>127 then warning:=true end;
  end;
begin                                          {find conversions 2chars->1char}
s:=[];for i:=lastsingle+1 to lastind do
  if (tables[ci,2,i]<>'2') or (not sequences[2] and (tables[co,1,i]='0'))
    then to1[i]:=false
    else begin to1[i]:=true;s:=s+[tables2[ci,i,1]] end;
nacteno:=false;
while (not eof(fi)) or nacteno do
  begin
  if not nacteno then read(fi,z);nacteno:=false;
  if z='0' then write(fo,z) else if (not(z in s)) or eof(fi) then Write1 else
    begin
    read(fi,zz);i:=lastsingle+1;
    while (i<=lastind) and (not to1[i] or (z+zz<>tables2[ci,i])) do Inc(i);
    if i<=lastind then Output(i) else
      begin Write1;z:=zz;nacteno:=true end;
    end;
  end;
end;

procedure SeqInput;
{*****************}
var  s,ss     :string;
     i,j,k    :integer;
     ind,ind2 :array[0..nocharsalw] of integer;     {indices of possible chars}
procedure ReadChar;
  begin Inc(i);read(fi,s[i]);s[0]:=chr(i) end;
procedure Original;
  var  ii :byte;  begin for ii:=1 to length(s) do write(fo,s[ii]) end;
begin
i:=0;ReadChar;if (s[i]<>escchar) or eof(fi) then begin Original;exit end;
k:=0;for j:=1 to nocharsalw do
  begin
  if s[i]=tablesseq[ci,j,i] then begin Inc(k);ind[k]:=j; end;
  ind[0]:=k;
  end;
while (ind[0]>0) and not eof(fi) do
  begin
  ReadChar;k:=0;for j:=1 to ind[0] do
    begin
    ss:=tablesseq[ci,ind[j]];
    if (i<=length(ss)) and (s[i]=ss[i])
      then if i=length(ss)
        then if tables[co,1,ind[j]]<>'0'
          then begin Output(ind[j]);exit end
          else begin Original;exit end
        else begin Inc(k);ind2[k]:=ind[j] end;
    end;
  ind2[0]:=k;ind:=ind2;
  end;
Original;
end;

procedure Input;
{**************}
var i,j,k :integer;
begin                                  {transform to UpCase - case insensitive}
for i:=1 to nocodes do for j:=1 to length(tables[i,0]) do
  tables[i,0,j]:=UpCase(tables[i,0,j]);
for i:=1 to nocodesseq do for j:=1 to length(tablesseq[i,0]) do
  tablesseq[i,0,j]:=UpCase(tablesseq[i,0,j]);
if not sequences[1] then GTabInput else
  begin  escchar:=tablesseq[ci,-1,1];while not eof(fi) do SeqInput  end;
end;

{program}
{*******}
begin
CommandLine(ci,co,nfi,nfo);            {fileexists = true if output file exists}
assign(fi,nfi);  {$I-} reset(fi);   {$I+}
if IOresult > 0 then
  begin writeln('Read device error - cannot read the input file.');halt(6) end;
assign(fo,nft);  {$I-} rewrite(fo); {$I+}
if IOresult > 0 then
  begin
  writeln('Write device error - cannot create the output file.');halt(6);
  end;
Input;
close(fi);close(fo);
if not fileexists then rename (fo,nfo) else if warning
  then writeln('Output in the file ',nftname,'.')
  else begin assign(fi,nfo);erase(fi);rename(fo,nfo) end;
if warning then
  begin
  writeln('There are non-converted characters with ASCII > 127.');halt(5)
  end
end.

