/* Some my favourite key sequences are defined here -pm- */


-- CTRL/Y deletes line
def C_Y = 
deleteline; .col=1


-- Alt-Z margins for e-mailed documents, TeX files and programs
def A_Z =
ma4='ma 1 1599 1'; ma3='ma 1 82 1'; ma2='ma 1 74 1'
s=entrybox('Set margins','/OK/'ma2'/'ma3'/'ma4,'ma '.margins,30,30)
if     s=4 then s=ma4
elseif s=3 then s=ma3
elseif s='' then s=ma2
endif
s


-- Alt-Q produces quickly \begin{equation} \end{equation} environment
-- with two comment lines above and below
def A_Q = 
  if .col>1 then .line=.line+1; endif
  insertline '%'; insertline '\begin{equation}'
  insertline ''
  insertline '\end{equation}'; insertline '%'
  .line=.line-3
  .col=1

-- The following macro redefines default Ctrl-Q of EPM
-- If \begin{..} or \end{..} is the only text on the line (where 
-- ..=equation,eqnarray or align), it changes the line to the next environment 
-- in this list. Useful if you add one more equation into an \begin{equation}
-- Note: this could be more powerful if this command would change both 
-- \begin{..} and \end{..} simultaneously.
def C_Q = 
getline S
B='\begin{'; E='\end{'
s1='equation}'; s2='eqnarray}'; s3='align}'
if	S=B''s1	then	S=B''s2
elseif	S=B''s2	then	S=B''s3
elseif	S=B''s3	then	S=B''s1
elseif	S=E''s1	then	S=E''s2
elseif	S=E''s2	then	S=E''s3
elseif	S=E''s3	then	S=E''s1
else 
s1='equation*}'; s2='eqnarray*}'; s3='align*}'
if	S=B''s1	then	S=B''s2
elseif	S=B''s2	then	S=B''s3
elseif	S=B''s3	then	S=B''s1
elseif	S=E''s1	then	S=E''s2
elseif	S=E''s2	then	S=E''s3
elseif	S=E''s3	then	S=E''s1
else return;
endif
endif
replaceline S
