unit fordviout;

INTERFACE

const RECMAX = 1000;

type  rsbr      = array[1..RECMAX] of
                  record
                    ni, no       : string[8];
                    ch1          : longint;
                    ch3          : longint;
                    chksum       : array[1..4] of byte;
                  end;

var   sbr          : rsbr;
      nrec         : integer;            { number of substitution records }

procedure defaultsub(var nrec:integer; var sbr:rsbr; csfonts:boolean);
procedure convsbr(nrec:integer; var sbr:rsbr);

IMPLEMENTATION

procedure defaultsub(var nrec:integer; var sbr:rsbr; csfonts:boolean);
var i    : integer;
    auxn : longint;
    auxs : string[8];
begin; nrec := 66;
with sbr[ 1] do begin; ni:='csb10';    no:='cmb10';    ch3:= -1329684621; ch1:= -770990554; end;
with sbr[ 2] do begin; ni:='csbx10';   no:='cmbx10';   ch3:=   837807344; ch1:=  452076118; end;
with sbr[ 3] do begin; ni:='csbx12';   no:='cmbx12';   ch3:=  1622814210; ch1:=-1026142560; end;
with sbr[ 4] do begin; ni:='csbx5';    no:='cmbx5';    ch3:= -1331672915; ch1:=-1423078296; end;
with sbr[ 5] do begin; ni:='csbx6';    no:='cmbx6';    ch3:=   308680498; ch1:=-2142912396; end;
with sbr[ 6] do begin; ni:='csbx7';    no:='cmbx7';    ch3:=  1453769692; ch1:= 1712792792; end;
with sbr[ 7] do begin; ni:='csbx8';    no:='cmbx8';    ch3:=   353197525; ch1:=  851919049; end;
with sbr[ 8] do begin; ni:='csbx9';    no:='cmbx9';    ch3:= -1505750599; ch1:= 1946978618; end;
with sbr[ 9] do begin; ni:='csbxsl10'; no:='cmbxsl10'; ch3:= -1089982986; ch1:=-1907513578; end;
with sbr[10] do begin; ni:='csbxti10'; no:='cmbxti10'; ch3:=  1931088707; ch1:= 1175274390; end;
with sbr[11] do begin; ni:='cscsc10';  no:='cmcsc10';  ch3:=  2069654384; ch1:=-1943144428; end;
with sbr[12] do begin; ni:='csdunh10'; no:='cmdunh10'; ch3:=  1870154566; ch1:= 1274110073; end;
with sbr[13] do begin; ni:='csff10';   no:='cmff10';   ch3:= -1532275037; ch1:=-1927996437; end;
with sbr[14] do begin; ni:='csfi10';   no:='cmfi10';   ch3:=   487989921; ch1:=  319521934; end;
with sbr[15] do begin; ni:='csfib8';   no:='cmfib8';   ch3:=  1605312125; ch1:= -844143043; end;
with sbr[16] do begin; ni:='csitt10';  no:='cmitt10';  ch3:=  1505158146; ch1:= -538297224; end;
with sbr[17] do begin; ni:='csinch';   no:='cminch';   ch3:=  1928148046; ch1:= -566337077; end;
with sbr[18] do begin; ni:='csr10';    no:='cmr10';    ch3:=  1870154566; ch1:= 1274110073; end;
with sbr[19] do begin; ni:='csr12';    no:='cmr12';    ch3:=  1040247683; ch1:= 1487622411; end;
with sbr[20] do begin; ni:='csr17';    no:='cmr17';    ch3:=   695296362; ch1:= 1154739572; end;
with sbr[21] do begin; ni:='csr5';     no:='cmr5';     ch3:= -1767545120; ch1:=-2046583974; end;
with sbr[22] do begin; ni:='csr6';     no:='cmr6';     ch3:= -1094532475; ch1:=-1186897496; end;
with sbr[23] do begin; ni:='csr7';     no:='cmr7';     ch3:=   295006555; ch1:= -644636590; end;
with sbr[24] do begin; ni:='csr8';     no:='cmr8';     ch3:=   803865204; ch1:= 2088458503; end;
with sbr[25] do begin; ni:='csr9';     no:='cmr9';     ch3:=  1774737029; ch1:= 1874103239; end;
with sbr[26] do begin; ni:='cssl10';   no:='cmsl10';   ch3:=   347259249; ch1:= 1890463818; end;
with sbr[27] do begin; ni:='cssl12';   no:='cmsl12';   ch3:=  -499489106; ch1:= 2103976403; end;
with sbr[28] do begin; ni:='cssl8';    no:='cmsl8';    ch3:=  -752387937; ch1:=-1590154801; end;
with sbr[29] do begin; ni:='cssl9';    no:='cmsl9';    ch3:=   235261104; ch1:=-1804510312; end;
with sbr[30] do begin; ni:='cssltt10'; no:='cmsltt10'; ch3:=  1505158146; ch1:= -538297224; end;
with sbr[31] do begin; ni:='csss10';   no:='cmss10';   ch3:=  1449167522; ch1:= 1831058770; end;
with sbr[32] do begin; ni:='csss12';   no:='cmss12';   ch3:=  2030999935; ch1:=-2100407754; end;
with sbr[33] do begin; ni:='csss17';   no:='cmss17';   ch3:=  1329211173; ch1:=   97961503; end;
with sbr[34] do begin; ni:='csss8';    no:='cmss8';    ch3:=  -686833121; ch1:= -965527919; end;
with sbr[35] do begin; ni:='csss9';    no:='cmss9';    ch3:=  -769916687; ch1:= -764426377; end;
with sbr[36] do begin; ni:='csssbx10'; no:='cmssbx10'; ch3:=  1170697833; ch1:= -244629176; end;
with sbr[37] do begin; ni:='csssdc10'; no:='cmssdc10'; ch3:= -2034858421; ch1:= 1893393257; end;
with sbr[38] do begin; ni:='csssi10';  no:='cmssi10';  ch3:=  1638270379; ch1:= -984248855; end;
with sbr[39] do begin; ni:='csssi12';  no:='cmssi12';  ch3:= -2074864504; ch1:= -637328691; end;
with sbr[40] do begin; ni:='csssi17';  no:='cmssi17';  ch3:= -1029608311; ch1:=-1601180043; end;
with sbr[41] do begin; ni:='csssi8';   no:='cmssi8';   ch3:=    54967633; ch1:=  542250684; end;
with sbr[42] do begin; ni:='csssi9';   no:='cmssi9';   ch3:=  -580749821; ch1:=  732010263; end;
with sbr[43] do begin; ni:='csssq8';   no:='cmssq8';   ch3:=  -396672806; ch1:= 1265911151; end;
with sbr[44] do begin; ni:='csssqi8';  no:='cmssqi8';  ch3:=   864689846; ch1:=-1660616191; end;
with sbr[45] do begin; ni:='cstcsc10'; no:='cmtcsc10'; ch3:=  -672413762; ch1:= -751363667; end;
with sbr[46] do begin; ni:='csti10';   no:='cmti10';   ch3:= -1298790787; ch1:=  -50321606; end;
with sbr[47] do begin; ni:='csti12';   no:='cmti12';   ch3:=   789457525; ch1:=-1682208704; end;
with sbr[48] do begin; ni:='csti7';    no:='cmti7';    ch3:= -1154155886; ch1:= 1954372810; end;
with sbr[49] do begin; ni:='csti8';    no:='cmti8';    ch3:=   619432240; ch1:=  600925840; end;
with sbr[50] do begin; ni:='csti9';    no:='cmti9';    ch3:=   539433676; ch1:=-1133866567; end;
with sbr[51] do begin; ni:='cstt10';   no:='cmtt10';   ch3:=  1505158146; ch1:= -538297224; end;
with sbr[52] do begin; ni:='cstt12';   no:='cmtt12';   ch3:=   273499847; ch1:= -544819884; end;
with sbr[53] do begin; ni:='cstt8';    no:='cmtt8';    ch3:= -1846048110; ch1:= -549205389; end;
with sbr[54] do begin; ni:='cstt9';    no:='cmtt9';    ch3:=   468413184; ch1:= -542880256; end;
with sbr[55] do begin; ni:='csu10';    no:='cmu10';    ch3:= -1690553656; ch1:=  320884962; end;
with sbr[56] do begin; ni:='csvtt10';  no:='cmvtt10';  ch3:=  -622408585; ch1:=-1029646951; end;
with sbr[57] do begin; ni:='icstt8';   no:='icmtt8';   ch3:= -1846048110; ch1:= -549205389; end;
with sbr[58] do begin; ni:='icscsc10'; no:='icmcsc10'; ch3:=  2069654384; ch1:=-1943144428; end;
with sbr[59] do begin; ni:='ilcsss8';  no:='ilcmss8';  ch3:=  -396672806; ch1:= 1265911151; end;
with sbr[60] do begin; ni:='ilcsssb8'; no:='ilcmssb8'; ch3:=  -625488383; ch1:=-1006040475; end;
with sbr[61] do begin; ni:='ilcsssi8'; no:='ilcmssi8'; ch3:=   864689846; ch1:=-1660616191; end;
with sbr[62] do begin; ni:='lcsss8';   no:='lcmss8';   ch3:=  -396672806; ch1:= 1265911151; end;
with sbr[63] do begin; ni:='lcsssb8';  no:='lcmssb8';  ch3:=  -625488383; ch1:=-1006040475; end;
with sbr[64] do begin; ni:='lcsssi8';  no:='lcmssi8';  ch3:=   864689846; ch1:=-1660616191; end;
with sbr[65] do begin; ni:='cscsc8';   no:='cmcsc8';   ch3:=   777301638; ch1:=   39041353; end;
with sbr[66] do begin; ni:='cscsc9';   no:='cmcsc9';   ch3:=  -724688718; ch1:=-1660616191; end;
if csfonts then
  for i := 1 to nrec do
    with sbr[i] do
      begin; auxs := ni;  ni := no; no := auxs;
      auxn := ch1; ch1 := ch3; ch3 := auxn;
      end;
end;

procedure convsbr(nrec:integer; var sbr:rsbr);
var j     : integer;
		p			: byte;
begin;
for j := 1 to nrec do
  with sbr[j] do
		begin; move(ch1,chksum[1],4);
		p := chksum[1]; chksum[1] := chksum[4]; chksum[4] := p;
		p := chksum[3]; chksum[3] := chksum[2]; chksum[2] := p;
    end;
end;

end.
