# Generated by default/object.tt
package Paws::CodeGuruProfiler::FrameMetric;
  use Moose;
  has FrameName => (is => 'ro', isa => 'Str', request_name => 'frameName', traits => ['NameInRequest'], required => 1);
  has ThreadStates => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'threadStates', traits => ['NameInRequest'], required => 1);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::FrameMetric

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::FrameMetric object:

  $service_obj->Method(Att1 => { FrameName => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::FrameMetric object:

  $result = $service_obj->Method(...);
  $result->Att1->FrameName

=head1 DESCRIPTION

The frame name, metric type, and thread states. These are used to
derive the value of the metric for the frame.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FrameName => Str

Name of the method common across the multiple occurrences of a frame in
an application profile.


=head2 B<REQUIRED> ThreadStates => ArrayRef[Str|Undef]

List of application runtime thread states used to get the counts for a
frame a derive a metric value.


=head2 B<REQUIRED> Type => Str

A type of aggregation that specifies how a metric for a frame is
analyzed. The supported value C<AggregatedRelativeTotalTime> is an
aggregation of the metric value for one frame that is calculated across
the occurrences of all frames in a profile.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

