######################################################################
#
# 2182_jef9p_by_utf8jp.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x80\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\xF3\xB0\x80\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\xF3\xB0\x80\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\xF3\xB0\x80\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\xF3\xB0\x80\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\xF3\xB0\x80\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\xF3\xB0\x80\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\xF3\xB0\x80\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\xF3\xB0\x80\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\xF3\xB0\x80\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\xF3\xB0\x80\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\xF3\xB0\x80\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\xF3\xB0\x80\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\xF3\xB0\x80\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\xF3\xB0\x80\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\xF3\xB0\x80\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\xF3\xB0\x80\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\xF3\xB0\x80\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\xF3\xB0\x80\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\xF3\xB0\x80\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\xF3\xB0\x80\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\xF3\xB0\x80\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\xF3\xB0\x80\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\xF3\xB0\x80\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\xF3\xB0\x80\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\xF3\xB0\x80\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\xF3\xB0\x80\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\xF3\xB0\x80\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\xF3\xB0\x80\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\xF3\xB0\x80\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\xF3\xB0\x80\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\xF3\xB0\x80\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\xF3\xB0\x80\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\xF3\xB0\x80\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\xF3\xB0\x80\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F"],
        ["\xF3\xB0\x80\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\xF3\xB0\x80\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0"],
        ["\xF3\xB0\x80\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\xF3\xB0\x80\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\xF3\xB0\x80\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\xF3\xB0\x80\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\xF3\xB0\x80\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\xF3\xB0\x80\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\xF3\xB0\x80\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\xF3\xB0\x80\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\xF3\xB0\x80\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\xF3\xB0\x80\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\xF3\xB0\x80\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\xF3\xB0\x80\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0"],
        ["\xF3\xB0\x80\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1"],
        ["\xF3\xB0\x80\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2"],
        ["\xF3\xB0\x80\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3"],
        ["\xF3\xB0\x80\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4"],
        ["\xF3\xB0\x80\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5"],
        ["\xF3\xB0\x80\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6"],
        ["\xF3\xB0\x80\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7"],
        ["\xF3\xB0\x80\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8"],
        ["\xF3\xB0\x80\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9"],
        ["\xF3\xB0\x80\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\xF3\xB0\x80\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\xF3\xB0\x80\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\xF3\xB0\x80\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\xF3\xB0\x80\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\xF3\xB0\x80\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\xF3\xB0\x81\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\xF3\xB0\x81\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1"],
        ["\xF3\xB0\x81\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2"],
        ["\xF3\xB0\x81\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3"],
        ["\xF3\xB0\x81\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4"],
        ["\xF3\xB0\x81\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5"],
        ["\xF3\xB0\x81\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6"],
        ["\xF3\xB0\x81\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7"],
        ["\xF3\xB0\x81\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8"],
        ["\xF3\xB0\x81\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9"],
        ["\xF3\xB0\x81\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1"],
        ["\xF3\xB0\x81\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2"],
        ["\xF3\xB0\x81\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3"],
        ["\xF3\xB0\x81\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4"],
        ["\xF3\xB0\x81\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5"],
        ["\xF3\xB0\x81\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6"],
        ["\xF3\xB0\x81\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7"],
        ["\xF3\xB0\x81\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8"],
        ["\xF3\xB0\x81\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9"],
        ["\xF3\xB0\x81\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2"],
        ["\xF3\xB0\x81\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3"],
        ["\xF3\xB0\x81\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4"],
        ["\xF3\xB0\x81\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5"],
        ["\xF3\xB0\x81\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6"],
        ["\xF3\xB0\x81\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7"],
        ["\xF3\xB0\x81\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8"],
        ["\xF3\xB0\x81\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9"],
        ["\xF3\xB0\x81\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\xF3\xB0\x81\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\xF3\xB0\x81\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\xF3\xB0\x81\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\xF3\xB0\x81\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\xF3\xB0\x81\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\xF3\xB0\x81\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\xF3\xB0\x81\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\xF3\xB0\x81\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\xF3\xB0\x81\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\xF3\xB0\x81\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\xF3\xB0\x81\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\xF3\xB0\x81\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\xF3\xB0\x81\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\xF3\xB0\x81\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\xF3\xB0\x81\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\xF3\xB0\x81\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\xF3\xB0\x81\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\xF3\xB0\x81\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\xF3\xB0\x81\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\xF3\xB0\x81\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\xF3\xB0\x81\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\xF3\xB0\x81\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\xF3\xB0\x81\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\xF3\xB0\x81\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80"],
        ["\xF3\xB0\x81\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B"],
        ["\xF3\xB0\x81\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B"],
        ["\xF3\xB0\x81\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C"],
        ["\xF3\xB0\x81\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA0"],
        ["\xF3\xB0\x81\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAB"],
        ["\xF3\xB0\x81\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0"],
        ["\xF3\xB0\x81\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1"],
        ["\xF3\xB0\x81\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0"],
        ["\xF3\xB0\x81\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\xF3\xB0\x81\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0"],
        ["\xF3\xB0\x81\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1"],
        ["\xF3\xB0\x81\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\xF3\xB0\x82\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\xF3\xB0\x82\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\xF3\xB0\x82\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\xF3\xB0\x82\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\xF3\xB0\x82\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\xF3\xB0\x82\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\xF3\xB0\x82\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\xF3\xB0\x82\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\xF3\xB0\x82\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\xF3\xB0\x82\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\xF3\xB0\x82\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\xF3\xB0\x82\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\xF3\xB0\x82\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\xF3\xB0\x82\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\xF3\xB0\x82\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\xF3\xB0\x82\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\xF3\xB0\x82\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\xF3\xB0\x82\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\xF3\xB0\x82\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\xF3\xB0\x82\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\xF3\xB0\x82\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\xF3\xB0\x82\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\xF3\xB0\x82\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\xF3\xB0\x82\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\xF3\xB0\x82\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\xF3\xB0\x82\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\xF3\xB0\x82\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\xF3\xB0\x82\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\xF3\xB0\x82\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\xF3\xB0\x82\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\xF3\xB0\x82\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\xF3\xB0\x82\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1"],
        ["\xF3\xB0\x82\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\xF3\xB0\x82\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xF3\xB0\x82\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xF3\xB0\x82\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xF3\xB0\x82\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xF3\xB0\x82\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xF3\xB0\x82\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xF3\xB0\x82\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xF3\xB0\x82\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xF3\xB0\x82\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xF3\xB0\x82\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xF3\xB0\x82\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xF3\xB0\x82\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xF3\xB0\x82\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xF3\xB0\x82\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xF3\xB0\x82\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xF3\xB0\x82\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xF3\xB0\x82\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81"],
        ["\xF3\xB0\x82\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82"],
        ["\xF3\xB0\x82\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83"],
        ["\xF3\xB0\x82\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84"],
        ["\xF3\xB0\x82\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85"],
        ["\xF3\xB0\x82\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86"],
        ["\xF3\xB0\x82\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87"],
        ["\xF3\xB0\x82\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88"],
        ["\xF3\xB0\x82\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89"],
        ["\xF3\xB0\x82\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A"],
        ["\xF3\xB0\x82\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C"],
        ["\xF3\xB0\x82\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D"],
        ["\xF3\xB0\x82\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E"],
        ["\xF3\xB0\x82\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F"],
        ["\xF3\xB0\x82\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90"],
        ["\xF3\xB0\x83\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91"],
        ["\xF3\xB0\x83\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92"],
        ["\xF3\xB0\x83\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93"],
        ["\xF3\xB0\x83\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94"],
        ["\xF3\xB0\x83\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95"],
        ["\xF3\xB0\x83\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96"],
        ["\xF3\xB0\x83\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97"],
        ["\xF3\xB0\x83\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98"],
        ["\xF3\xB0\x83\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99"],
        ["\xF3\xB0\x83\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A"],
        ["\xF3\xB0\x83\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D"],
        ["\xF3\xB0\x83\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E"],
        ["\xF3\xB0\x83\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F"],
        ["\xF3\xB0\x83\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xF3\xB0\x83\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xF3\xB0\x83\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xF3\xB0\x83\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xF3\xB0\x83\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xF3\xB0\x83\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xF3\xB0\x83\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xF3\xB0\x83\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xF3\xB0\x83\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xF3\xB0\x83\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xF3\xB0\x83\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xF3\xB0\x83\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xF3\xB0\x83\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xF3\xB0\x83\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xF3\xB0\x83\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xF3\xB0\x83\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xF3\xB0\x83\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xF3\xB0\x83\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xF3\xB0\x83\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xF3\xB0\x83\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2"],
        ["\xF3\xB0\x83\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3"],
        ["\xF3\xB0\x83\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4"],
        ["\xF3\xB0\x83\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5"],
        ["\xF3\xB0\x83\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6"],
        ["\xF3\xB0\x83\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7"],
        ["\xF3\xB0\x83\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8"],
        ["\xF3\xB0\x83\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9"],
        ["\xF3\xB0\x83\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA"],
        ["\xF3\xB0\x83\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB"],
        ["\xF3\xB0\x83\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC"],
        ["\xF3\xB0\x83\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD"],
        ["\xF3\xB0\x83\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE"],
        ["\xF3\xB0\x83\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF"],
        ["\xF3\xB0\x83\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA"],
        ["\xF3\xB0\x83\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB"],
        ["\xF3\xB0\x83\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC"],
        ["\xF3\xB0\x83\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD"],
        ["\xF3\xB0\x83\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE"],
        ["\xF3\xB0\x83\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF"],
        ["\xF3\xB0\x83\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA"],
        ["\xF3\xB0\x83\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB"],
        ["\xF3\xB0\x83\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC"],
        ["\xF3\xB0\x83\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED"],
        ["\xF3\xB0\x83\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE"],
        ["\xF3\xB0\x83\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF"],
        ["\xF3\xB0\x83\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA"],
        ["\xF3\xB0\x83\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB"],
        ["\xF3\xB0\x83\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC"],
        ["\xF3\xB0\x83\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFD"],
        ["\xF3\xB0\x83\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFE"],
        ["\xF3\xB0\x83\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFF"],
        ["\xF3\xB0\x84\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],
        ["\xF3\xB0\x84\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\xF3\xB0\x84\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\xF3\xB0\x84\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\xF3\xB0\x84\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\xF3\xB0\x84\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\xF3\xB0\x84\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\xF3\xB0\x84\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\xF3\xB0\x84\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\xF3\xB0\x84\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\xF3\xB0\x84\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\xF3\xB0\x84\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\xF3\xB0\x84\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\xF3\xB0\x84\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\xF3\xB0\x84\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\xF3\xB0\x84\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\xF3\xB0\x84\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\xF3\xB0\x84\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\xF3\xB0\x84\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\xF3\xB0\x84\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\xF3\xB0\x84\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\xF3\xB0\x84\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\xF3\xB0\x84\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\xF3\xB0\x84\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\xF3\xB0\x84\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\xF3\xB0\x84\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\xF3\xB0\x84\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\xF3\xB0\x84\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\xF3\xB0\x84\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\xF3\xB0\x84\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\xF3\xB0\x84\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\xF3\xB0\x84\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],
        ["\xF3\xB0\x84\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\xF3\xB0\x84\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],
        ["\xF3\xB0\x84\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\xF3\xB0\x84\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\xF3\xB0\x84\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\xF3\xB0\x84\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\xF3\xB0\x84\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\xF3\xB0\x84\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\xF3\xB0\x84\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\xF3\xB0\x84\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\xF3\xB0\x84\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\xF3\xB0\x84\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\xF3\xB0\x84\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\xF3\xB0\x84\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\xF3\xB0\x84\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\xF3\xB0\x84\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\xF3\xB0\x84\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\xF3\xB0\x84\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\xF3\xB0\x84\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\xF3\xB0\x84\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\xF3\xB0\x84\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\xF3\xB0\x84\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\xF3\xB0\x84\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\xF3\xB0\x84\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\xF3\xB0\x84\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\xF3\xB0\x84\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\xF3\xB0\x84\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\xF3\xB0\x84\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\xF3\xB0\x84\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],
        ["\xF3\xB0\x84\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\xF3\xB0\x84\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\xF3\xB0\x84\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\xF3\xB0\x85\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\xF3\xB0\x85\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\xF3\xB0\x85\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\xF3\xB0\x85\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\xF3\xB0\x85\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\xF3\xB0\x85\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\xF3\xB0\x85\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\xF3\xB0\x85\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\xF3\xB0\x85\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\xF3\xB0\x85\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\xF3\xB0\x85\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\xF3\xB0\x85\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\xF3\xB0\x85\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\xF3\xB0\x85\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\xF3\xB0\x85\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\xF3\xB0\x85\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\xF3\xB0\x85\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],
        ["\xF3\xB0\x85\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],
        ["\xF3\xB0\x85\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\xF3\xB0\x85\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\xF3\xB0\x85\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\xF3\xB0\x85\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\xF3\xB0\x85\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\xF3\xB0\x85\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\xF3\xB0\x85\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\xF3\xB0\x85\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\xF3\xB0\x85\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\xF3\xB0\x85\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\xF3\xB0\x85\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\xF3\xB0\x85\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\xF3\xB0\x85\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\xF3\xB0\x85\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xF3\xB0\x85\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xF3\xB0\x85\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\xF3\xB0\x85\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\xF3\xB0\x85\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\xF3\xB0\x85\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xF3\xB0\x85\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\xF3\xB0\x85\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\xF3\xB0\x85\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\xF3\xB0\x85\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\xF3\xB0\x85\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\xF3\xB0\x85\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\xF3\xB0\x85\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF3\xB0\x85\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD0"],
        ["\xF3\xB0\x85\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD1"],
        ["\xF3\xB0\x85\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD2"],
        ["\xF3\xB0\x85\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD3"],
        ["\xF3\xB0\x85\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD4"],
        ["\xF3\xB0\x85\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD5"],
        ["\xF3\xB0\x85\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD6"],
        ["\xF3\xB0\x85\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD7"],
        ["\xF3\xB0\x86\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD8"],
        ["\xF3\xB0\x86\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD9"],
        ["\xF3\xB0\x86\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA7"],
        ["\xF3\xB0\x86\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDA"],
        ["\xF3\xB0\x86\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDB"],
        ["\xF3\xB0\x86\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDC"],
        ["\xF3\xB0\x86\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDD"],
        ["\xF3\xB0\x86\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDE"],
        ["\xF3\xB0\x86\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDF"],
        ["\xF3\xB0\x86\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],
        ["\xF3\xB0\x86\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE1"],
        ["\xF3\xB0\x86\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE2"],
        ["\xF3\xB0\x86\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xAA"],
        ["\xF3\xB0\x86\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA9"],
        ["\xF3\xB0\x86\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE3"],
        ["\xF3\xB0\x86\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE4"],
        ["\xF3\xB0\x86\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE5"],
        ["\xF3\xB0\x86\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE6"],
        ["\xF3\xB0\x86\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE7"],
        ["\xF3\xB0\x86\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA8"],
        ["\xF3\xB0\x86\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE8"],
        ["\xF3\xB0\x86\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE9"],
        ["\xF3\xB0\x86\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD1"],
        ["\xF3\xB0\x86\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD3"],
        ["\xF3\xB0\x86\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEA"],
        ["\xF3\xB0\x86\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEB"],
        ["\xF3\xB0\x86\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEC"],
        ["\xF3\xB0\x86\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xED"],
        ["\xF3\xB0\x86\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEE"],
        ["\xF3\xB0\x86\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEF"],
        ["\xF3\xB0\x86\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xF0"],
        ["\xF3\xB0\x87\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\xF3\xB0\x87\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\xF3\xB0\x87\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\xF3\xB0\x87\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\xF3\xB0\x87\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\xF3\xB0\x87\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\xF3\xB0\x87\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\xF3\xB0\x87\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\xF3\xB0\x87\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\xF3\xB0\x87\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\xF3\xB0\x87\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\xF3\xB0\x87\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\xF3\xB0\x87\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\xF3\xB0\x87\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\xF3\xB0\x87\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\xF3\xB0\x87\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\xF3\xB0\x87\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\xF3\xB0\x87\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\xF3\xB0\x87\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\xF3\xB0\x87\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\xF3\xB0\x87\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\xF3\xB0\x87\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\xF3\xB0\x87\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\xF3\xB0\x87\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\xF3\xB0\x87\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\xF3\xB0\x87\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\xF3\xB0\x87\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\xF3\xB0\x87\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\xF3\xB0\x87\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\xF3\xB0\x87\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\xF3\xB0\x87\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\xF3\xB0\x87\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\xF3\xB0\x87\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\xF3\xB0\x87\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\xF3\xB0\x87\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\xF3\xB0\x87\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\xF3\xB0\x87\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\xF3\xB0\x87\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\xF3\xB0\x87\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\xF3\xB0\x87\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\xF3\xB0\x88\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\xF3\xB0\x88\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\xF3\xB0\x88\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\xF3\xB0\x88\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\xF3\xB0\x88\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\xF3\xB0\x88\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\xF3\xB0\x88\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xF3\xB0\x88\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xF3\xB0\x88\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xF3\xB0\x88\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xF3\xB0\x88\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\xF3\xB0\x88\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\xF3\xB0\x88\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\xF3\xB0\x88\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\xF3\xB0\x88\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\xF3\xB0\x88\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\xF3\xB0\x88\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\xF3\xB0\x88\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\xF3\xB0\x88\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\xF3\xB0\x88\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\xF3\xB0\x88\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xF3\xB0\x88\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xF3\xB0\x88\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\xF3\xB0\x88\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\xF3\xB0\x88\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\xF3\xB0\x88\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\xF3\xB0\x88\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xF3\xB0\x88\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xF3\xB0\x88\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xF3\xB0\x88\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\xF3\xB0\x88\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\xF3\xB0\x88\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\xF3\xB0\x88\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\xF3\xB0\x88\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xF3\xB0\x88\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\xF3\xB0\x88\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\xF3\xB0\x88\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\xF3\xB0\x88\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\xF3\xB0\x88\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\xF3\xB0\x88\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\xF3\xB0\x88\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\xF3\xB0\x88\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\xF3\xB0\x88\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xF3\xB0\x88\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\xF3\xB0\x88\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\xF3\xB0\x88\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xF3\xB0\x88\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\xF3\xB0\x88\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\xF3\xB0\x88\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xF3\xB0\x88\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xF3\xB0\x88\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xF3\xB0\x88\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xF3\xB0\x88\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xF3\xB0\x88\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xF3\xB0\x88\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xF3\xB0\x88\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xF3\xB0\x88\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xF3\xB0\x88\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xF3\xB0\x88\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xF3\xB0\x88\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xF3\xB0\x89\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xF3\xB0\x89\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xF3\xB0\x89\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xF3\xB0\x89\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xF3\xB0\x89\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\xF3\xB0\x89\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\xF3\xB0\x89\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\xF3\xB0\x89\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xF3\xB0\x89\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\xF3\xB0\x89\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\xF3\xB0\x89\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\xF3\xB0\x89\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\xF3\xB0\x89\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\xF3\xB0\x89\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\xF3\xB0\x89\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\xF3\xB0\x89\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\xF3\xB0\x89\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\xF3\xB0\x89\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\xF3\xB0\x89\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\xF3\xB0\x89\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\xF3\xB0\x89\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\xF3\xB0\x89\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\xF3\xB0\x89\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xF3\xB0\x89\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\xF3\xB0\x89\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xF3\xB0\x89\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\xF3\xB0\x89\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\xF3\xB0\x89\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\xF3\xB0\x89\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\xF3\xB0\x89\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\xF3\xB0\x89\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\xF3\xB0\x89\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\xF3\xB0\x89\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\xF3\xB0\x89\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\xF3\xB0\x89\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\xF3\xB0\x89\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\xF3\xB0\x89\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\xF3\xB0\x89\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\xF3\xB0\x89\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\xF3\xB0\x89\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\xF3\xB0\x89\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\xF3\xB0\x89\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\xF3\xB0\x89\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\xF3\xB0\x89\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\xF3\xB0\x89\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\xF3\xB0\x89\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\xF3\xB0\x89\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xF3\xB0\x89\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\xF3\xB0\x89\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\xF3\xB0\x89\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\xF3\xB0\x89\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\xF3\xB0\x89\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\xF3\xB0\x89\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\xF3\xB0\x8A\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xF3\xB0\x8A\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\xF3\xB0\x8A\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\xF3\xB0\x8A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\xF3\xB0\x8A\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\xF3\xB0\x8A\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xF3\xB0\x8A\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\xF3\xB0\x8A\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\xF3\xB0\x8A\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\xF3\xB0\x8A\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\xF3\xB0\x8A\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\xF3\xB0\x8A\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xF3\xB0\x8A\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\xF3\xB0\x8A\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\xF3\xB0\x8A\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\xF3\xB0\x8A\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\xF3\xB0\x8A\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\xF3\xB0\x8A\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\xF3\xB0\x8A\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\xF3\xB0\x8A\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\xF3\xB0\x8A\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\xF3\xB0\x8A\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\xF3\xB0\x8A\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\xF3\xB0\x8A\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\xF3\xB0\x8A\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\xF3\xB0\x8A\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\xF3\xB0\x8A\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\xF3\xB0\x8A\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\xF3\xB0\x8A\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\xF3\xB0\x8A\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\xF3\xB0\x8A\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\xF3\xB0\x8A\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\xF3\xB0\x8A\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\xF3\xB0\x8A\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xF3\xB0\x8A\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\xF3\xB0\x8A\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\xF3\xB0\x8A\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\xF3\xB0\x8A\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\xF3\xB0\x8A\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\xF3\xB0\x8A\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xF3\xB0\x8A\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xF3\xB0\x8A\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xF3\xB0\x8A\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xF3\xB0\x8A\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xF3\xB0\x8A\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xF3\xB0\x8A\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\xF3\xB0\x8A\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\xF3\xB0\x8A\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\xF3\xB0\x8A\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\xF3\xB0\x8A\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\xF3\xB0\x8A\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\xF3\xB0\x8A\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xF3\xB0\x8A\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xF3\xB0\x8A\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\xF3\xB0\x8A\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\xF3\xB0\x8A\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\xF3\xB0\x8A\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xF3\xB0\x8A\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xF3\xB0\x8A\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\xF3\xB0\x8A\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\xF3\xB0\x8A\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\xF3\xB0\x8A\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\xF3\xB0\x8A\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xF3\xB0\x8A\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xF3\xB0\x8B\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\xF3\xB0\x8B\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xF3\xB0\x8B\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\xF3\xB0\x8B\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\xF3\xB0\x8B\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\xF3\xB0\x8B\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xF3\xB0\x8B\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xF3\xB0\x8B\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xF3\xB0\x8B\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\xF3\xB0\x8B\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\xF3\xB0\x8B\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\xF3\xB0\x8B\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\xF3\xB0\x8B\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\xF3\xB0\x8B\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\xF3\xB0\x8B\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\xF3\xB0\x8B\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\xF3\xB0\x8B\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\xF3\xB0\x8B\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\xF3\xB0\x8B\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\xF3\xB0\x8B\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\xF3\xB0\x8B\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\xF3\xB0\x8B\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\xF3\xB0\x8B\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\xF3\xB0\x8B\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\xF3\xB0\x8B\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\xF3\xB0\x8B\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\xF3\xB0\x8B\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\xF3\xB0\x8B\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\xF3\xB0\x8B\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\xF3\xB0\x8B\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\xF3\xB0\x8B\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\xF3\xB0\x8B\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\xF3\xB0\x8B\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\xF3\xB0\x8B\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\xF3\xB0\x8B\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\xF3\xB0\x8B\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\xF3\xB0\x8B\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\xF3\xB0\x8B\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\xF3\xB0\x8B\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\xF3\xB0\x8B\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\xF3\xB0\x8B\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\xF3\xB0\x8B\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\xF3\xB0\x8B\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\xF3\xB0\x8B\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\xF3\xB0\x8B\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\xF3\xB0\x8B\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\xF3\xB0\x8B\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\xF3\xB0\x8B\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\xF3\xB0\x8C\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\xF3\xB0\x8C\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\xF3\xB0\x8C\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\xF3\xB0\x8C\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\xF3\xB0\x8C\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\xF3\xB0\x8C\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\xF3\xB0\x8C\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\xF3\xB0\x8C\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\xF3\xB0\x8C\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\xF3\xB0\x8C\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\xF3\xB0\x8C\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\xF3\xB0\x8C\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\xF3\xB0\x8C\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\xF3\xB0\x8C\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\xF3\xB0\x8C\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\xF3\xB0\x8C\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\xF3\xB0\x8C\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\xF3\xB0\x8C\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\xF3\xB0\x8C\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\xF3\xB0\x8C\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\xF3\xB0\x8C\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\xF3\xB0\x8C\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\xF3\xB0\x8C\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\xF3\xB0\x8C\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\xF3\xB0\x8C\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\xF3\xB0\x8C\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\xF3\xB0\x8D\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\xF3\xB0\x8D\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\xF3\xB0\x8D\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\xF3\xB0\x8D\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\xF3\xB0\x8D\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\xF3\xB0\x8D\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\xF3\xB0\x8D\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\xF3\xB0\x8D\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\xF3\xB0\x8D\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\xF3\xB0\x8D\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\xF3\xB0\x8D\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\xF3\xB0\x8D\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\xF3\xB0\x8D\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\xF3\xB0\x8D\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\xF3\xB0\x8D\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\xF3\xB0\x8D\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\xF3\xB0\x8D\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\xF3\xB0\x8D\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\xF3\xB0\x8D\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\xF3\xB0\x8D\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\xF3\xB0\x8D\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\xF3\xB0\x8D\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\xF3\xB0\x8D\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\xF3\xB0\x8D\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\xF3\xB0\x8D\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\xF3\xB0\x8D\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\xF3\xB0\x8D\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\xF3\xB0\x8D\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\xF3\xB0\x8D\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\xF3\xB0\x8D\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\xF3\xB0\x8D\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\xF3\xB0\x8D\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\xF3\xB0\x8D\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\xF3\xB0\x8D\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\xF3\xB0\x8D\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\xF3\xB0\x8D\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\xF3\xB0\x8D\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\xF3\xB0\x8D\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\xF3\xB0\x8D\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\xF3\xB0\x8D\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\xF3\xB0\x8D\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\xF3\xB0\x8D\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\xF3\xB0\x8D\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\xF3\xB0\x8D\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\xF3\xB0\x8D\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\xF3\xB0\x8D\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\xF3\xB0\x8D\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\xF3\xB0\x8D\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\xF3\xB0\x8D\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\xF3\xB0\x8E\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\xF3\xB0\x8E\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\xF3\xB0\x8E\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\xF3\xB0\x8E\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\xF3\xB0\x8E\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\xF3\xB0\x8E\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],
        ["\xF3\xB0\x8E\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],
        ["\xF3\xB0\x8E\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],
        ["\xF3\xB0\x8E\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],
        ["\xF3\xB0\x8E\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],
        ["\xF3\xB0\x8E\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],
        ["\xF3\xB0\x8E\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],
        ["\xF3\xB0\x8E\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],
        ["\xF3\xB0\x8E\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],
        ["\xF3\xB0\x8E\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],
        ["\xF3\xB0\x8E\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],
        ["\xF3\xB0\x8E\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],
        ["\xF3\xB0\x8E\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],
        ["\xF3\xB0\x8E\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],
        ["\xF3\xB0\x8E\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],
        ["\xF3\xB0\x8E\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],
        ["\xF3\xB0\x8E\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],
        ["\xF3\xB0\x8E\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],
        ["\xF3\xB0\x8E\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],
        ["\xF3\xB0\x8E\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],
        ["\xF3\xB0\x8E\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],
        ["\xF3\xB0\x8E\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],
        ["\xF3\xB0\x8E\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCA"],
        ["\xF3\xB0\x8E\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCB"],
        ["\xF3\xB0\x8E\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCC"],
        ["\xF3\xB0\x8E\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],
        ["\xF3\xB0\x8E\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCE"],
        ["\xF3\xB0\x8E\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA2"],
        ["\xF3\xB0\x8E\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA3"],
        ["\xF3\xB0\x8E\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA4"],
        ["\xF3\xB0\x8E\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA1"],
        ["\xF3\xB0\x8E\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCD"],
        ["\xF3\xB0\x95\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"],
        ["\xF3\xB0\x95\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCA"],
        ["\xF3\xB0\x95\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCB"],
        ["\xF3\xB0\x95\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCC"],
        ["\xF3\xB0\x95\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCD"],
        ["\xF3\xB0\x95\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCE"],
        ["\xF3\xB0\x95\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCF"],
        ["\xF3\xB0\x95\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"],
        ["\xF3\xB0\x95\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"],
        ["\xF3\xB0\x95\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"],
        ["\xF3\xB0\x95\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"],
        ["\xF3\xB0\x95\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],
        ["\xF3\xB0\x95\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"],
        ["\xF3\xB0\x95\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"],
        ["\xF3\xB0\x95\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"],
        ["\xF3\xB0\x95\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"],
        ["\xF3\xB0\x95\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"],
        ["\xF3\xB0\x95\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDA"],
        ["\xF3\xB0\x95\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDB"],
        ["\xF3\xB0\x95\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDC"],
        ["\xF3\xB0\x95\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDE"],
        ["\xF3\xB0\x95\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDF"],
        ["\xF3\xB0\x95\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"],
        ["\xF3\xB0\x95\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE1"],
        ["\xF3\xB0\x96\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"],
        ["\xF3\xB0\x96\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"],
        ["\xF3\xB0\x96\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"],
        ["\xF3\xB0\x96\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"],
        ["\xF3\xB0\x96\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"],
        ["\xF3\xB0\x96\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"],
        ["\xF3\xB0\x96\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDA"],
        ["\xF3\xB0\x96\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDC"],
        ["\xF3\xB0\x96\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDB"],
        ["\xF3\xB0\x96\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"],
        ["\xF3\xB0\x96\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDE"],
        ["\xF3\xB0\x96\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"],
        ["\xF3\xB0\x96\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"],
        ["\xF3\xB0\x96\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],
        ["\xF3\xB0\x96\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],
        ["\xF3\xB0\x96\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],
        ["\xF3\xB0\x96\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],
        ["\xF3\xB0\x96\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],
        ["\xF3\xB0\x96\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],
        ["\xF3\xB0\x96\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],
        ["\xF3\xB0\x96\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"],
        ["\xF3\xB0\x96\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xBC"],
        ["\xF3\xB0\x96\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xBD"],
        ["\xF3\xB0\x96\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xBE"],
        ["\xF3\xB0\x96\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"],
        ["\xF3\xB0\x96\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"],
        ["\xF3\xB0\x96\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"],
        ["\xF3\xB0\x96\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"],
        ["\xF3\xB0\x96\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"],
        ["\xF3\xB0\x96\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],
        ["\xF3\xB0\x96\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],
        ["\xF3\xB0\x96\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"],
        ["\xF3\xB0\x96\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xCF"],
        ["\xF3\xB0\x96\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xCB"],
        ["\xF3\xB0\x9A\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\xF3\xB0\x9A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\xF3\xB0\x9A\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\xF3\xB0\x9A\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\xF3\xB0\x9A\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\xF3\xB0\x9A\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\xF3\xB0\x9A\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\xF3\xB0\x9A\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\xF3\xB0\x9A\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\xF3\xB0\x9A\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\xF3\xB0\x9A\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\xF3\xB0\x9A\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\xF3\xB0\x9A\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\xF3\xB0\x9A\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\xF3\xB0\x9A\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\xF3\xB0\x9A\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\xF3\xB0\x9A\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\xF3\xB0\x9A\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\xF3\xB0\x9A\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xF3\xB0\x9A\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\xF3\xB0\x9A\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\xF3\xB0\x9A\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\xF3\xB0\x9A\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\xF3\xB0\x9A\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\xF3\xB0\x9A\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\xF3\xB0\x9A\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\xF3\xB0\x9A\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\xF3\xB0\x9A\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\xF3\xB0\x9A\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\xF3\xB0\x9A\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\xF3\xB0\x9A\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\xF3\xB0\x9A\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\xF3\xB0\x9A\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\xF3\xB0\x9A\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\xF3\xB0\x9A\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\xF3\xB0\x9A\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\xF3\xB0\x9A\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\xF3\xB0\x9A\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\xF3\xB0\x9A\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\xF3\xB0\x9A\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\xF3\xB0\x9A\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\xF3\xB0\x9A\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\xF3\xB0\x9A\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\xF3\xB0\x9A\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\xF3\xB0\x9A\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\xF3\xB0\x9A\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\xF3\xB0\x9A\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\xF3\xB0\x9A\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\xF3\xB0\x9A\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\xF3\xB0\x9A\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\xF3\xB0\x9A\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\xF3\xB0\x9A\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\xF3\xB0\x9A\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\xF3\xB0\x9A\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\xF3\xB0\x9A\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\xF3\xB0\x9A\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\xF3\xB0\x9A\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\xF3\xB0\x9A\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\xF3\xB0\x9A\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\xF3\xB0\x9A\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\xF3\xB0\x9A\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\xF3\xB0\x9A\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\xF3\xB0\x9B\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\xF3\xB0\x9B\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\xF3\xB0\x9B\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\xF3\xB0\x9B\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\xF3\xB0\x9B\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\xF3\xB0\x9B\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\xF3\xB0\x9B\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\xF3\xB0\x9B\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\xF3\xB0\x9B\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\xF3\xB0\x9B\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\xF3\xB0\x9B\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\xF3\xB0\x9B\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\xF3\xB0\x9B\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\xF3\xB0\x9B\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\xF3\xB0\x9B\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\xF3\xB0\x9B\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\xF3\xB0\x9B\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\xF3\xB0\x9B\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\xF3\xB0\x9B\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\xF3\xB0\x9B\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\xF3\xB0\x9B\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\xF3\xB0\x9B\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\xF3\xB0\x9B\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\xF3\xB0\x9B\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\xF3\xB0\x9B\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\xF3\xB0\x9B\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\xF3\xB0\x9B\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\xF3\xB0\x9B\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\xF3\xB0\x9B\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\xF3\xB0\x9B\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\xF3\xB0\x9B\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\xF3\xB0\x9B\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\xF3\xB0\x9B\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\xF3\xB0\x9B\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\xF3\xB0\x9B\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\xF3\xB0\x9B\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\xF3\xB0\x9B\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\xF3\xB0\x9B\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\xF3\xB0\x9B\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\xF3\xB0\x9B\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\xF3\xB0\x9B\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\xF3\xB0\x9B\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\xF3\xB0\x9B\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\xF3\xB0\x9B\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\xF3\xB0\x9B\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\xF3\xB0\x9B\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\xF3\xB0\x9B\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\xF3\xB0\x9B\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\xF3\xB0\x9B\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\xF3\xB0\x9B\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\xF3\xB0\x9B\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\xF3\xB0\x9B\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\xF3\xB0\x9B\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\xF3\xB0\x9B\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\xF3\xB0\x9B\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\xF3\xB0\x9B\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\xF3\xB0\x9B\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\xF3\xB0\x9B\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\xF3\xB0\x9B\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\xF3\xB0\x9B\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\xF3\xB0\x9B\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\xF3\xB0\x9B\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\xF3\xB0\x9B\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\xF3\xB0\x9B\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\xF3\xB0\x9C\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\xF3\xB0\x9C\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\xF3\xB0\x9C\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\xF3\xB0\x9C\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\xF3\xB0\x9C\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\xF3\xB0\x9C\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\xF3\xB0\x9C\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\xF3\xB0\x9C\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\xF3\xB0\x9C\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\xF3\xB0\x9C\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\xF3\xB0\x9C\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\xF3\xB0\x9C\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\xF3\xB0\x9C\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\xF3\xB0\x9C\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\xF3\xB0\x9C\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\xF3\xB0\x9C\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\xF3\xB0\x9C\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\xF3\xB0\x9C\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\xF3\xB0\x9C\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\xF3\xB0\x9C\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\xF3\xB0\x9C\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\xF3\xB0\x9C\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\xF3\xB0\x9C\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\xF3\xB0\x9C\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\xF3\xB0\x9C\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\xF3\xB0\x9C\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\xF3\xB0\x9C\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\xF3\xB0\x9C\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\xF3\xB0\x9C\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\xF3\xB0\x9C\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\xF3\xB0\x9C\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\xF3\xB0\x9C\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\xF3\xB0\x9C\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\xF3\xB0\x9C\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\xF3\xB0\x9C\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\xF3\xB0\x9C\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\xF3\xB0\x9C\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\xF3\xB0\x9C\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\xF3\xB0\x9C\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\xF3\xB0\x9C\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\xF3\xB0\x9C\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\xF3\xB0\x9C\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\xF3\xB0\x9C\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\xF3\xB0\x9C\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\xF3\xB0\x9C\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\xF3\xB0\x9C\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\xF3\xB0\x9C\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\xF3\xB0\x9C\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\xF3\xB0\x9C\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\xF3\xB0\x9C\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\xF3\xB0\x9C\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\xF3\xB0\x9C\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\xF3\xB0\x9C\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\xF3\xB0\x9C\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\xF3\xB0\x9C\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\xF3\xB0\x9C\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\xF3\xB0\x9C\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\xF3\xB0\x9C\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\xF3\xB0\x9C\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\xF3\xB0\x9C\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\xF3\xB0\x9C\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\xF3\xB0\x9C\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\xF3\xB0\x9C\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xF3\xB0\x9C\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\xF3\xB0\x9D\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\xF3\xB0\x9D\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\xF3\xB0\x9D\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\xF3\xB0\x9D\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\xF3\xB0\x9D\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xF3\xB0\x9D\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\xF3\xB0\x9D\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF3\xB0\x9D\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\xF3\xB0\x9D\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xF3\xB0\x9D\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xF3\xB0\x9D\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xF3\xB0\x9D\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\xF3\xB0\x9D\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xF3\xB0\x9D\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\xF3\xB0\x9D\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\xF3\xB0\x9D\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\xF3\xB0\x9D\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\xF3\xB0\x9D\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xF3\xB0\x9D\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\xF3\xB0\x9D\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\xF3\xB0\x9D\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\xF3\xB0\x9D\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\xF3\xB0\x9D\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\xF3\xB0\x9D\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\xF3\xB0\x9D\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xF3\xB0\x9D\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\xF3\xB0\x9D\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\xF3\xB0\x9D\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\xF3\xB0\x9D\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xF3\xB0\x9D\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\xF3\xB0\x9D\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\xF3\xB0\x9D\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xF3\xB0\x9D\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\xF3\xB0\x9D\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\xF3\xB0\x9D\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\xF3\xB0\x9D\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xF3\xB0\x9D\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\xF3\xB0\x9D\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xF3\xB0\x9D\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\xF3\xB0\x9D\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\xF3\xB0\x9D\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\xF3\xB0\x9D\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xF3\xB0\x9D\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xF3\xB0\x9D\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xF3\xB0\x9D\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\xF3\xB0\x9D\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xF3\xB0\x9D\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\xF3\xB0\x9D\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xF3\xB0\x9D\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xF3\xB0\x9D\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xF3\xB0\x9D\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xF3\xB0\x9D\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xF3\xB0\x9D\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xF3\xB0\x9D\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\xF3\xB0\x9D\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\xF3\xB0\x9D\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\xF3\xB0\x9D\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xF3\xB0\x9D\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\xF3\xB0\x9D\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\xF3\xB0\x9D\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xF3\xB0\x9D\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\xF3\xB0\x9D\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xF3\xB0\x9D\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xF3\xB0\x9D\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\xF3\xB0\x9E\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\xF3\xB0\x9E\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\xF3\xB0\x9E\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\xF3\xB0\x9E\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\xF3\xB0\x9E\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xF3\xB0\x9E\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\xF3\xB0\x9E\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xF3\xB0\x9E\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xF3\xB0\x9E\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xF3\xB0\x9E\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\xF3\xB0\x9E\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\xF3\xB0\x9E\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xF3\xB0\x9E\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\xF3\xB0\x9E\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xF3\xB0\x9E\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xF3\xB0\x9E\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xF3\xB0\x9E\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\xF3\xB0\x9E\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xF3\xB0\x9E\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xF3\xB0\x9E\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xF3\xB0\x9E\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\xF3\xB0\x9E\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\xF3\xB0\x9E\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xF3\xB0\x9E\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\xF3\xB0\x9E\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\xF3\xB0\x9E\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\xF3\xB0\x9E\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\xF3\xB0\x9E\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xF3\xB0\x9E\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xF3\xB0\x9E\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xF3\xB0\x9E\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xF3\xB0\x9E\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xF3\xB0\x9E\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xF3\xB0\x9E\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xF3\xB0\x9E\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xF3\xB0\x9E\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xF3\xB0\x9E\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xF3\xB0\x9E\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xF3\xB0\x9E\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xF3\xB0\x9E\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xF3\xB0\x9E\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xF3\xB0\x9E\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xF3\xB0\x9E\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xF3\xB0\x9E\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xF3\xB0\x9E\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xF3\xB0\x9E\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xF3\xB0\x9E\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xF3\xB0\x9E\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xF3\xB0\x9E\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xF3\xB0\x9E\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xF3\xB0\x9E\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xF3\xB0\x9E\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xF3\xB0\x9E\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xF3\xB0\x9E\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xF3\xB0\x9E\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xF3\xB0\x9E\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xF3\xB0\x9E\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xF3\xB0\x9E\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xF3\xB0\x9E\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xF3\xB0\x9E\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xF3\xB0\x9E\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xF3\xB0\x9E\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xF3\xB0\x9E\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xF3\xB0\x9E\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xF3\xB0\x9F\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xF3\xB0\x9F\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xF3\xB0\x9F\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xF3\xB0\x9F\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xF3\xB0\x9F\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xF3\xB0\x9F\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xF3\xB0\x9F\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xF3\xB0\x9F\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xF3\xB0\x9F\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xF3\xB0\x9F\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xF3\xB0\x9F\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xF3\xB0\x9F\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xF3\xB0\x9F\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xF3\xB0\x9F\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xF3\xB0\x9F\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xF3\xB0\x9F\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xF3\xB0\x9F\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xF3\xB0\x9F\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xF3\xB0\x9F\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xF3\xB0\x9F\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xF3\xB0\x9F\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xF3\xB0\x9F\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xF3\xB0\x9F\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xF3\xB0\x9F\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xF3\xB0\x9F\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xF3\xB0\x9F\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xF3\xB0\x9F\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xF3\xB0\x9F\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xF3\xB0\x9F\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xF3\xB0\x9F\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xF3\xB0\x9F\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xF3\xB0\x9F\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xF3\xB0\x9F\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xF3\xB0\x9F\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xF3\xB0\x9F\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xF3\xB0\x9F\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xF3\xB0\x9F\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xF3\xB0\x9F\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xF3\xB0\x9F\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xF3\xB0\x9F\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xF3\xB0\x9F\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xF3\xB0\x9F\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xF3\xB0\x9F\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xF3\xB0\x9F\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xF3\xB0\x9F\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xF3\xB0\x9F\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xF3\xB0\x9F\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xF3\xB0\x9F\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xF3\xB0\x9F\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xF3\xB0\x9F\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xF3\xB0\x9F\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xF3\xB0\x9F\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xF3\xB0\x9F\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xF3\xB0\x9F\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xF3\xB0\x9F\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xF3\xB0\x9F\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xF3\xB0\x9F\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xF3\xB0\x9F\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xF3\xB0\x9F\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xF3\xB0\x9F\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xF3\xB0\x9F\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xF3\xB0\x9F\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xF3\xB0\x9F\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xF3\xB0\x9F\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xF3\xB0\xA0\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xF3\xB0\xA0\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xF3\xB0\xA0\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xF3\xB0\xA0\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xF3\xB0\xA0\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xF3\xB0\xA0\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xF3\xB0\xA0\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xF3\xB0\xA0\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xF3\xB0\xA0\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xF3\xB0\xA0\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xF3\xB0\xA0\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xF3\xB0\xA0\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xF3\xB0\xA0\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xF3\xB0\xA0\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xF3\xB0\xA0\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xF3\xB0\xA0\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xF3\xB0\xA0\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xF3\xB0\xA0\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xF3\xB0\xA0\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xF3\xB0\xA0\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xF3\xB0\xA0\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xF3\xB0\xA0\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xF3\xB0\xA0\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xF3\xB0\xA0\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xF3\xB0\xA0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xF3\xB0\xA0\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xF3\xB0\xA0\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xF3\xB0\xA0\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xF3\xB0\xA0\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\xF3\xB0\xA0\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xF3\xB0\xA0\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xF3\xB0\xA0\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xF3\xB0\xA0\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xF3\xB0\xA0\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xF3\xB0\xA0\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xF3\xB0\xA0\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xF3\xB0\xA0\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xF3\xB0\xA0\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xF3\xB0\xA0\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xF3\xB0\xA0\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xF3\xB0\xA0\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xF3\xB0\xA0\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xF3\xB0\xA0\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xF3\xB0\xA0\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xF3\xB0\xA0\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xF3\xB0\xA0\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xF3\xB0\xA0\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xF3\xB0\xA0\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xF3\xB0\xA0\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xF3\xB0\xA0\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xF3\xB0\xA0\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xF3\xB0\xA0\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xF3\xB0\xA0\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xF3\xB0\xA0\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xF3\xB0\xA0\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xF3\xB0\xA0\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xF3\xB0\xA0\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xF3\xB0\xA0\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xF3\xB0\xA0\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xF3\xB0\xA0\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xF3\xB0\xA0\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xF3\xB0\xA0\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xF3\xB0\xA0\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xF3\xB0\xA0\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xF3\xB0\xA1\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xF3\xB0\xA1\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xF3\xB0\xA1\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xF3\xB0\xA1\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xF3\xB0\xA1\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xF3\xB0\xA1\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xF3\xB0\xA1\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xF3\xB0\xA1\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xF3\xB0\xA1\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xF3\xB0\xA1\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xF3\xB0\xA1\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xF3\xB0\xA1\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xF3\xB0\xA1\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xF3\xB0\xA1\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xF3\xB0\xA1\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xF3\xB0\xA1\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xF3\xB0\xA1\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xF3\xB0\xA1\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xF3\xB0\xA1\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xF3\xB0\xA1\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xF3\xB0\xA1\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xF3\xB0\xA1\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xF3\xB0\xA1\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xF3\xB0\xA1\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xF3\xB0\xA1\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xF3\xB0\xA1\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xF3\xB0\xA1\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xF3\xB0\xA1\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xF3\xB0\xA1\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xF3\xB0\xA1\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xF3\xB0\xA1\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xF3\xB0\xA1\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xF3\xB0\xA1\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xF3\xB0\xA1\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xF3\xB0\xA1\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xF3\xB0\xA1\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xF3\xB0\xA1\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xF3\xB0\xA1\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xF3\xB0\xA1\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xF3\xB0\xA1\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xF3\xB0\xA1\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xF3\xB0\xA1\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xF3\xB0\xA1\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xF3\xB0\xA1\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xF3\xB0\xA1\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xF3\xB0\xA1\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xF3\xB0\xA1\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xF3\xB0\xA1\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xF3\xB0\xA1\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xF3\xB0\xA1\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xF3\xB0\xA1\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xF3\xB0\xA1\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xF3\xB0\xA1\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xF3\xB0\xA1\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xF3\xB0\xA1\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xF3\xB0\xA1\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xF3\xB0\xA1\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xF3\xB0\xA1\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xF3\xB0\xA1\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xF3\xB0\xA1\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xF3\xB0\xA1\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xF3\xB0\xA1\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xF3\xB0\xA1\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xF3\xB0\xA1\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xF3\xB0\xA2\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xF3\xB0\xA2\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xF3\xB0\xA2\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xF3\xB0\xA2\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xF3\xB0\xA2\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xF3\xB0\xA2\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xF3\xB0\xA2\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xF3\xB0\xA2\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xF3\xB0\xA2\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xF3\xB0\xA2\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xF3\xB0\xA2\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xF3\xB0\xA2\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xF3\xB0\xA2\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xF3\xB0\xA2\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xF3\xB0\xA2\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xF3\xB0\xA2\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xF3\xB0\xA2\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xF3\xB0\xA2\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xF3\xB0\xA2\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xF3\xB0\xA2\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xF3\xB0\xA2\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xF3\xB0\xA2\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xF3\xB0\xA2\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xF3\xB0\xA2\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xF3\xB0\xA2\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xF3\xB0\xA2\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xF3\xB0\xA2\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xF3\xB0\xA2\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xF3\xB0\xA2\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xF3\xB0\xA2\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xF3\xB0\xA2\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xF3\xB0\xA2\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xF3\xB0\xA2\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xF3\xB0\xA2\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xF3\xB0\xA2\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xF3\xB0\xA2\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xF3\xB0\xA2\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xF3\xB0\xA2\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xF3\xB0\xA2\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xF3\xB0\xA2\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xF3\xB0\xA2\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xF3\xB0\xA2\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xF3\xB0\xA2\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xF3\xB0\xA2\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xF3\xB0\xA2\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xF3\xB0\xA2\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xF3\xB0\xA2\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xF3\xB0\xA2\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xF3\xB0\xA2\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xF3\xB0\xA2\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xF3\xB0\xA2\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xF3\xB0\xA2\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xF3\xB0\xA2\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xF3\xB0\xA2\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xF3\xB0\xA2\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xF3\xB0\xA2\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xF3\xB0\xA2\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xF3\xB0\xA2\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xF3\xB0\xA2\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xF3\xB0\xA2\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xF3\xB0\xA2\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xF3\xB0\xA2\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xF3\xB0\xA2\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xF3\xB0\xA2\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xF3\xB0\xA3\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xF3\xB0\xA3\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xF3\xB0\xA3\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xF3\xB0\xA3\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xF3\xB0\xA3\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xF3\xB0\xA3\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xF3\xB0\xA3\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xF3\xB0\xA3\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xF3\xB0\xA3\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xF3\xB0\xA3\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xF3\xB0\xA3\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xF3\xB0\xA3\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xF3\xB0\xA3\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xF3\xB0\xA3\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xF3\xB0\xA3\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xF3\xB0\xA3\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xF3\xB0\xA3\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xF3\xB0\xA3\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xF3\xB0\xA3\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xF3\xB0\xA3\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xF3\xB0\xA3\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xF3\xB0\xA3\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xF3\xB0\xA3\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xF3\xB0\xA3\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xF3\xB0\xA3\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xF3\xB0\xA3\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xF3\xB0\xA3\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xF3\xB0\xA3\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\xF3\xB0\xA3\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xF3\xB0\xA3\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xF3\xB0\xA3\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xF3\xB0\xA3\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xF3\xB0\xA3\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xF3\xB0\xA3\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xF3\xB0\xA3\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xF3\xB0\xA3\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xF3\xB0\xA3\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xF3\xB0\xA3\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xF3\xB0\xA3\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xF3\xB0\xA3\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xF3\xB0\xA3\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xF3\xB0\xA3\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xF3\xB0\xA3\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xF3\xB0\xA3\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xF3\xB0\xA3\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xF3\xB0\xA3\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xF3\xB0\xA3\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xF3\xB0\xA3\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xF3\xB0\xA3\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xF3\xB0\xA3\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xF3\xB0\xA3\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xF3\xB0\xA3\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xF3\xB0\xA3\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xF3\xB0\xA3\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xF3\xB0\xA3\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xF3\xB0\xA3\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xF3\xB0\xA3\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xF3\xB0\xA3\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xF3\xB0\xA3\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xF3\xB0\xA3\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xF3\xB0\xA3\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xF3\xB0\xA3\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xF3\xB0\xA3\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xF3\xB0\xA3\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xF3\xB0\xA4\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xF3\xB0\xA4\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xF3\xB0\xA4\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xF3\xB0\xA4\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xF3\xB0\xA4\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xF3\xB0\xA4\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xF3\xB0\xA4\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\xF3\xB0\xA4\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xF3\xB0\xA4\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xF3\xB0\xA4\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xF3\xB0\xA4\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xF3\xB0\xA4\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xF3\xB0\xA4\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xF3\xB0\xA4\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xF3\xB0\xA4\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xF3\xB0\xA4\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xF3\xB0\xA4\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xF3\xB0\xA4\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\xF3\xB0\xA4\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xF3\xB0\xA4\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xF3\xB0\xA4\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xF3\xB0\xA4\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xF3\xB0\xA4\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xF3\xB0\xA4\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xF3\xB0\xA4\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xF3\xB0\xA4\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xF3\xB0\xA4\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\xF3\xB0\xA4\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xF3\xB0\xA4\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xF3\xB0\xA4\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xF3\xB0\xA4\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xF3\xB0\xA4\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xF3\xB0\xA4\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xF3\xB0\xA4\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xF3\xB0\xA4\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xF3\xB0\xA4\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xF3\xB0\xA4\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xF3\xB0\xA4\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xF3\xB0\xA4\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xF3\xB0\xA4\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xF3\xB0\xA4\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xF3\xB0\xA4\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xF3\xB0\xA4\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xF3\xB0\xA4\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xF3\xB0\xA4\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xF3\xB0\xA4\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xF3\xB0\xA4\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xF3\xB0\xA4\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xF3\xB0\xA4\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xF3\xB0\xA4\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xF3\xB0\xA4\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xF3\xB0\xA4\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xF3\xB0\xA4\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xF3\xB0\xA4\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xF3\xB0\xA4\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xF3\xB0\xA4\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xF3\xB0\xA4\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xF3\xB0\xA4\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xF3\xB0\xA4\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xF3\xB0\xA4\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xF3\xB0\xA4\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xF3\xB0\xA4\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xF3\xB0\xA4\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xF3\xB0\xA4\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xF3\xB0\xA5\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xF3\xB0\xA5\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xF3\xB0\xA5\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xF3\xB0\xA5\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xF3\xB0\xA5\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\xF3\xB0\xA5\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\xF3\xB0\xA5\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xF3\xB0\xA5\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\xF3\xB0\xA5\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\xF3\xB0\xA5\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\xF3\xB0\xA5\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xF3\xB0\xA5\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xF3\xB0\xA5\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\xF3\xB0\xA5\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\xF3\xB0\xA5\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF3\xB0\xA5\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xF3\xB0\xA5\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\xF3\xB0\xA5\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xF3\xB0\xA5\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xF3\xB0\xA5\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\xF3\xB0\xA5\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\xF3\xB0\xA5\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\xF3\xB0\xA5\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xF3\xB0\xA5\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xF3\xB0\xA5\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xF3\xB0\xA5\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xF3\xB0\xA5\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\xF3\xB0\xA5\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\xF3\xB0\xA5\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xF3\xB0\xA5\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xF3\xB0\xA5\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xF3\xB0\xA5\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xF3\xB0\xA5\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\xF3\xB0\xA5\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xF3\xB0\xA5\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xF3\xB0\xA5\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\xF3\xB0\xA5\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xF3\xB0\xA5\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xF3\xB0\xA5\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xF3\xB0\xA5\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\xF3\xB0\xA5\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\xF3\xB0\xA5\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\xF3\xB0\xA5\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xF3\xB0\xA5\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xF3\xB0\xA5\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\xF3\xB0\xA5\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\xF3\xB0\xA5\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xF3\xB0\xA5\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\xF3\xB0\xA5\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xF3\xB0\xA5\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xF3\xB0\xA5\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\xF3\xB0\xA5\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xF3\xB0\xA5\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xF3\xB0\xA5\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xF3\xB0\xA5\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\xF3\xB0\xA5\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\xF3\xB0\xA5\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\xF3\xB0\xA5\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\xF3\xB0\xA5\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xF3\xB0\xA5\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\xF3\xB0\xA5\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\xF3\xB0\xA5\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xF3\xB0\xA5\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xF3\xB0\xA5\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xF3\xB0\xA6\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xF3\xB0\xA6\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xF3\xB0\xA6\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xF3\xB0\xA6\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xF3\xB0\xA6\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xF3\xB0\xA6\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xF3\xB0\xA6\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\xF3\xB0\xA6\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\xF3\xB0\xA6\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xF3\xB0\xA6\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\xF3\xB0\xA6\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xF3\xB0\xA6\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xF3\xB0\xA6\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xF3\xB0\xA6\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xF3\xB0\xA6\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xF3\xB0\xA6\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\xF3\xB0\xA6\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\xF3\xB0\xA6\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xF3\xB0\xA6\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xF3\xB0\xA6\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xF3\xB0\xA6\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\xF3\xB0\xA6\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xF3\xB0\xA6\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\xF3\xB0\xA6\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xF3\xB0\xA6\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\xF3\xB0\xA6\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xF3\xB0\xA6\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xF3\xB0\xA6\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xF3\xB0\xA6\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\xF3\xB0\xA6\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xF3\xB0\xA6\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xF3\xB0\xA6\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xF3\xB0\xA6\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xF3\xB0\xA6\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\xF3\xB0\xA6\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\xF3\xB0\xA6\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\xF3\xB0\xA6\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xF3\xB0\xA6\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xF3\xB0\xA6\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\xF3\xB0\xA6\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xF3\xB0\xA6\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xF3\xB0\xA6\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\xF3\xB0\xA6\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\xF3\xB0\xA6\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\xF3\xB0\xA6\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\xF3\xB0\xA6\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xF3\xB0\xA6\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xF3\xB0\xA6\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\xF3\xB0\xA6\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xF3\xB0\xA6\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\xF3\xB0\xA6\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\xF3\xB0\xA6\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\xF3\xB0\xA6\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xF3\xB0\xA6\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\xF3\xB0\xA6\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xF3\xB0\xA6\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\xF3\xB0\xA6\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\xF3\xB0\xA6\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\xF3\xB0\xA6\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\xF3\xB0\xA6\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xF3\xB0\xA6\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xF3\xB0\xA6\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xF3\xB0\xA6\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\xF3\xB0\xA6\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xF3\xB0\xA7\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\xF3\xB0\xA7\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\xF3\xB0\xA7\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\xF3\xB0\xA7\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xF3\xB0\xA7\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\xF3\xB0\xA7\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xF3\xB0\xA7\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xF3\xB0\xA7\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\xF3\xB0\xA7\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xF3\xB0\xA7\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xF3\xB0\xA7\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xF3\xB0\xA7\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\xF3\xB0\xA7\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xF3\xB0\xA7\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xF3\xB0\xA7\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xF3\xB0\xA7\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xF3\xB0\xA7\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xF3\xB0\xA7\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xF3\xB0\xA7\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xF3\xB0\xA7\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xF3\xB0\xA7\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xF3\xB0\xA7\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xF3\xB0\xA7\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\xF3\xB0\xA7\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\xF3\xB0\xA7\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xF3\xB0\xA7\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\xF3\xB0\xA7\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xF3\xB0\xA7\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xF3\xB0\xA7\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\xF3\xB0\xA7\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\xF3\xB0\xA7\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\xF3\xB0\xA7\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xF3\xB0\xA7\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xF3\xB0\xA7\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\xF3\xB0\xA7\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\xF3\xB0\xA7\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xF3\xB0\xA7\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xF3\xB0\xA7\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\xF3\xB0\xA7\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\xF3\xB0\xA7\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xF3\xB0\xA7\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\xF3\xB0\xA7\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xF3\xB0\xA7\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\xF3\xB0\xA7\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\xF3\xB0\xA7\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xF3\xB0\xA7\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\xF3\xB0\xA7\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\xF3\xB0\xA7\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xF3\xB0\xA7\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xF3\xB0\xA7\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xF3\xB0\xA7\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\xF3\xB0\xA7\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\xF3\xB0\xA7\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\xF3\xB0\xA7\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xF3\xB0\xA7\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xF3\xB0\xA7\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\xF3\xB0\xA7\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xF3\xB0\xA7\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\xF3\xB0\xA7\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xF3\xB0\xA7\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\xF3\xB0\xA7\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xF3\xB0\xA7\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xF3\xB0\xA7\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\xF3\xB0\xA7\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xF3\xB0\xA8\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\xF3\xB0\xA8\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xF3\xB0\xA8\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xF3\xB0\xA8\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\xF3\xB0\xA8\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xF3\xB0\xA8\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\xF3\xB0\xA8\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xF3\xB0\xA8\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\xF3\xB0\xA8\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xF3\xB0\xA8\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xF3\xB0\xA8\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\xF3\xB0\xA8\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xF3\xB0\xA8\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xF3\xB0\xA8\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\xF3\xB0\xA8\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\xF3\xB0\xA8\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xF3\xB0\xA8\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\xF3\xB0\xA8\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\xF3\xB0\xA8\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xF3\xB0\xA8\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\xF3\xB0\xA8\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\xF3\xB0\xA8\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\xF3\xB0\xA8\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xF3\xB0\xA8\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xF3\xB0\xA8\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xF3\xB0\xA8\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\xF3\xB0\xA8\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xF3\xB0\xA8\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xF3\xB0\xA8\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],
        ["\xF3\xB0\xA8\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\xF3\xB0\xA8\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xF3\xB0\xA8\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xF3\xB0\xA8\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xF3\xB0\xA8\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\xF3\xB0\xA8\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\xF3\xB0\xA8\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\xF3\xB0\xA8\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xF3\xB0\xA8\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xF3\xB0\xA8\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\xF3\xB0\xA8\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xF3\xB0\xA8\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\xF3\xB0\xA8\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xF3\xB0\xA8\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\xF3\xB0\xA8\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\xF3\xB0\xA8\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\xF3\xB0\xA8\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\xF3\xB0\xA8\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\xF3\xB0\xA8\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\xF3\xB0\xA8\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\xF3\xB0\xA8\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\xF3\xB0\xA8\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\xF3\xB0\xA8\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\xF3\xB0\xA8\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xF3\xB0\xA8\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\xF3\xB0\xA8\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xF3\xB0\xA8\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xF3\xB0\xA8\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\xF3\xB0\xA8\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xF3\xB0\xA8\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\xF3\xB0\xA8\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\xF3\xB0\xA8\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\xF3\xB0\xA8\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\xF3\xB0\xA8\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\xF3\xB0\xA8\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\xF3\xB0\xA9\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\xF3\xB0\xA9\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xF3\xB0\xA9\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xF3\xB0\xA9\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xF3\xB0\xA9\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\xF3\xB0\xA9\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\xF3\xB0\xA9\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xF3\xB0\xA9\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xF3\xB0\xA9\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xF3\xB0\xA9\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xF3\xB0\xA9\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\xF3\xB0\xA9\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xF3\xB0\xA9\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\xF3\xB0\xA9\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\xF3\xB0\xA9\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\xF3\xB0\xA9\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\xF3\xB0\xA9\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\xF3\xB0\xA9\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\xF3\xB0\xA9\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xF3\xB0\xA9\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\xF3\xB0\xA9\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xF3\xB0\xA9\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\xF3\xB0\xA9\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\xF3\xB0\xA9\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\xF3\xB0\xA9\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xF3\xB0\xA9\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\xF3\xB0\xA9\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xF3\xB0\xA9\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\xF3\xB0\xA9\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xF3\xB0\xA9\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xF3\xB0\xA9\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\xF3\xB0\xA9\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\xF3\xB0\xA9\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\xF3\xB0\xA9\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\xF3\xB0\xA9\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\xF3\xB0\xA9\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xF3\xB0\xA9\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xF3\xB0\xA9\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\xF3\xB0\xA9\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\xF3\xB0\xA9\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xF3\xB0\xA9\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\xF3\xB0\xA9\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\xF3\xB0\xA9\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\xF3\xB0\xA9\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xF3\xB0\xA9\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\xF3\xB0\xA9\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xF3\xB0\xA9\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\xF3\xB0\xA9\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\xF3\xB0\xA9\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\xF3\xB0\xA9\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\xF3\xB0\xA9\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xF3\xB0\xA9\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\xF3\xB0\xA9\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\xF3\xB0\xA9\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xF3\xB0\xA9\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\xF3\xB0\xA9\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\xF3\xB0\xA9\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\xF3\xB0\xA9\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xF3\xB0\xA9\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xF3\xB0\xA9\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xF3\xB0\xA9\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\xF3\xB0\xA9\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\xF3\xB0\xA9\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\xF3\xB0\xA9\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\xF3\xB0\xAA\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xF3\xB0\xAA\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\xF3\xB0\xAA\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\xF3\xB0\xAA\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\xF3\xB0\xAA\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\xF3\xB0\xAA\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xF3\xB0\xAA\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xF3\xB0\xAA\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\xF3\xB0\xAA\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\xF3\xB0\xAA\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\xF3\xB0\xAA\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\xF3\xB0\xAA\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\xF3\xB0\xAA\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xF3\xB0\xAA\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\xF3\xB0\xAA\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\xF3\xB0\xAA\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\xF3\xB0\xAA\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\xF3\xB0\xAA\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\xF3\xB0\xAA\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\xF3\xB0\xAA\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\xF3\xB0\xAA\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\xF3\xB0\xAA\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xF3\xB0\xAA\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\xF3\xB0\xAA\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xF3\xB0\xAA\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xF3\xB0\xAA\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\xF3\xB0\xAA\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\xF3\xB0\xAA\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\xF3\xB0\xAA\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xF3\xB0\xAA\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\xF3\xB0\xAA\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xF3\xB0\xAA\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\xF3\xB0\xAA\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xF3\xB0\xAA\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\xF3\xB0\xAA\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\xF3\xB0\xAA\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\xF3\xB0\xAA\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xF3\xB0\xAA\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\xF3\xB0\xAA\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\xF3\xB0\xAA\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xF3\xB0\xAA\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\xF3\xB0\xAA\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\xF3\xB0\xAA\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\xF3\xB0\xAA\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xF3\xB0\xAA\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\xF3\xB0\xAA\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xF3\xB0\xAA\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xF3\xB0\xAA\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xF3\xB0\xAA\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\xF3\xB0\xAA\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\xF3\xB0\xAA\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\xF3\xB0\xAA\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xF3\xB0\xAA\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\xF3\xB0\xAA\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xF3\xB0\xAA\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\xF3\xB0\xAA\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\xF3\xB0\xAA\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\xF3\xB0\xAA\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xF3\xB0\xAA\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\xF3\xB0\xAA\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xF3\xB0\xAA\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\xF3\xB0\xAA\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xF3\xB0\xAA\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\xF3\xB0\xAA\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xF3\xB0\xAB\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xF3\xB0\xAB\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\xF3\xB0\xAB\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xF3\xB0\xAB\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xF3\xB0\xAB\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\xF3\xB0\xAB\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\xF3\xB0\xAB\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\xF3\xB0\xAB\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\xF3\xB0\xAB\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\xF3\xB0\xAB\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\xF3\xB0\xAB\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xF3\xB0\xAB\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xF3\xB0\xAB\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\xF3\xB0\xAB\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\xF3\xB0\xAB\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\xF3\xB0\xAB\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\xF3\xB0\xAB\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\xF3\xB0\xAB\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\xF3\xB0\xAB\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\xF3\xB0\xAB\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\xF3\xB0\xAB\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xF3\xB0\xAB\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xF3\xB0\xAB\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\xF3\xB0\xAB\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xF3\xB0\xAB\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xF3\xB0\xAB\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xF3\xB0\xAB\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xF3\xB0\xAB\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\xF3\xB0\xAB\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xF3\xB0\xAB\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\xF3\xB0\xAB\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\xF3\xB0\xAB\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\xF3\xB0\xAB\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\xF3\xB0\xAB\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\xF3\xB0\xAB\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xF3\xB0\xAB\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\xF3\xB0\xAB\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\xF3\xB0\xAB\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\xF3\xB0\xAB\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\xF3\xB0\xAB\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xF3\xB0\xAB\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xF3\xB0\xAB\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\xF3\xB0\xAB\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\xF3\xB0\xAB\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xF3\xB0\xAB\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\xF3\xB0\xAB\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\xF3\xB0\xAB\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xF3\xB0\xAB\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xF3\xB0\xAB\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\xF3\xB0\xAB\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xF3\xB0\xAB\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xF3\xB0\xAB\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\xF3\xB0\xAB\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\xF3\xB0\xAB\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xF3\xB0\xAB\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\xF3\xB0\xAB\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\xF3\xB0\xAB\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\xF3\xB0\xAB\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\xF3\xB0\xAB\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xF3\xB0\xAB\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\xF3\xB0\xAB\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xF3\xB0\xAB\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xF3\xB0\xAB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xF3\xB0\xAB\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\xF3\xB0\xAC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\xF3\xB0\xAC\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xF3\xB0\xAC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\xF3\xB0\xAC\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xF3\xB0\xAC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xF3\xB0\xAC\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\xF3\xB0\xAC\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xF3\xB0\xAC\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\xF3\xB0\xAC\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xF3\xB0\xAC\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\xF3\xB0\xAC\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\xF3\xB0\xAC\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\xF3\xB0\xAC\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\xF3\xB0\xAC\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xF3\xB0\xAC\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xF3\xB0\xAC\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xF3\xB0\xAC\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xF3\xB0\xAC\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\xF3\xB0\xAC\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xF3\xB0\xAC\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xF3\xB0\xAC\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\xF3\xB0\xAC\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\xF3\xB0\xAC\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xF3\xB0\xAC\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\xF3\xB0\xAC\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xF3\xB0\xAC\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xF3\xB0\xAC\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\xF3\xB0\xAC\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\xF3\xB0\xAC\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\xF3\xB0\xAC\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\xF3\xB0\xAC\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xF3\xB0\xAC\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xF3\xB0\xAC\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xF3\xB0\xAC\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\xF3\xB0\xAC\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xF3\xB0\xAC\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\xF3\xB0\xAC\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xF3\xB0\xAC\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xF3\xB0\xAC\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\xF3\xB0\xAC\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xF3\xB0\xAC\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\xF3\xB0\xAC\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xF3\xB0\xAC\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xF3\xB0\xAC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xF3\xB0\xAC\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\xF3\xB0\xAC\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xF3\xB0\xAC\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xF3\xB0\xAC\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xF3\xB0\xAC\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\xF3\xB0\xAC\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\xF3\xB0\xAC\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\xF3\xB0\xAC\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\xF3\xB0\xAC\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\xF3\xB0\xAC\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\xF3\xB0\xAC\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\xF3\xB0\xAC\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xF3\xB0\xAC\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\xF3\xB0\xAC\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\xF3\xB0\xAC\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xF3\xB0\xAC\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\xF3\xB0\xAC\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\xF3\xB0\xAC\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\xF3\xB0\xAC\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\xF3\xB0\xAC\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\xF3\xB0\xAD\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\xF3\xB0\xAD\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\xF3\xB0\xAD\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\xF3\xB0\xAD\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\xF3\xB0\xAD\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\xF3\xB0\xAD\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xF3\xB0\xAD\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\xF3\xB0\xAD\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\xF3\xB0\xAD\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\xF3\xB0\xAD\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xF3\xB0\xAD\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\xF3\xB0\xAD\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\xF3\xB0\xAD\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\xF3\xB0\xAD\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\xF3\xB0\xAD\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\xF3\xB0\xAD\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xF3\xB0\xAD\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xF3\xB0\xAD\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xF3\xB0\xAD\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\xF3\xB0\xAD\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\xF3\xB0\xAD\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\xF3\xB0\xAD\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\xF3\xB0\xAD\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xF3\xB0\xAD\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\xF3\xB0\xAD\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xF3\xB0\xAD\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xF3\xB0\xAD\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xF3\xB0\xAD\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\xF3\xB0\xAD\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xF3\xB0\xAD\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xF3\xB0\xAD\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\xF3\xB0\xAD\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\xF3\xB0\xAD\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xF3\xB0\xAD\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xF3\xB0\xAD\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xF3\xB0\xAD\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xF3\xB0\xAD\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xF3\xB0\xAD\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\xF3\xB0\xAD\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xF3\xB0\xAD\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xF3\xB0\xAD\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\xF3\xB0\xAD\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\xF3\xB0\xAD\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xF3\xB0\xAD\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xF3\xB0\xAD\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\xF3\xB0\xAD\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\xF3\xB0\xAD\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\xF3\xB0\xAD\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xF3\xB0\xAD\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xF3\xB0\xAD\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\xF3\xB0\xAD\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\xF3\xB0\xAD\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xF3\xB0\xAD\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\xF3\xB0\xAD\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\xF3\xB0\xAD\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xF3\xB0\xAD\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xF3\xB0\xAD\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xF3\xB0\xAD\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xF3\xB0\xAD\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\xF3\xB0\xAD\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\xF3\xB0\xAD\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xF3\xB0\xAD\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\xF3\xB0\xAD\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\xF3\xB0\xAD\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\xF3\xB0\xAE\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xF3\xB0\xAE\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\xF3\xB0\xAE\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xF3\xB0\xAE\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xF3\xB0\xAE\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\xF3\xB0\xAE\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\xF3\xB0\xAE\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\xF3\xB0\xAE\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xF3\xB0\xAE\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xF3\xB0\xAE\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xF3\xB0\xAE\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xF3\xB0\xAE\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\xF3\xB0\xAE\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\xF3\xB0\xAE\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\xF3\xB0\xAE\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xF3\xB0\xAE\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\xF3\xB0\xAE\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\xF3\xB0\xAE\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\xF3\xB0\xAE\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\xF3\xB0\xAE\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\xF3\xB0\xAE\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\xF3\xB0\xAE\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xF3\xB0\xAE\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\xF3\xB0\xAE\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xF3\xB0\xAE\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xF3\xB0\xAE\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xF3\xB0\xAE\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\xF3\xB0\xAE\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xF3\xB0\xAE\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xF3\xB0\xAE\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\xF3\xB0\xAE\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xF3\xB0\xAE\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\xF3\xB0\xAE\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\xF3\xB0\xAE\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\xF3\xB0\xAE\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\xF3\xB0\xAE\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\xF3\xB0\xAE\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\xF3\xB0\xAE\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xF3\xB0\xAE\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xF3\xB0\xAE\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xF3\xB0\xAE\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\xF3\xB0\xAE\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\xF3\xB0\xAE\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\xF3\xB0\xAE\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xF3\xB0\xAE\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xF3\xB0\xAE\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xF3\xB0\xAE\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\xF3\xB0\xAE\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\xF3\xB0\xAE\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xF3\xB0\xAE\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\xF3\xB0\xAE\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\xF3\xB0\xAE\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xF3\xB0\xAE\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\xF3\xB0\xAE\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\xF3\xB0\xAE\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xF3\xB0\xAE\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\xF3\xB0\xAE\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\xF3\xB0\xAE\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xF3\xB0\xAE\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xF3\xB0\xAE\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xF3\xB0\xAE\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xF3\xB0\xAE\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\xF3\xB0\xAE\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\xF3\xB0\xAE\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xF3\xB0\xAF\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xF3\xB0\xAF\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\xF3\xB0\xAF\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\xF3\xB0\xAF\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\xF3\xB0\xAF\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\xF3\xB0\xAF\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\xF3\xB0\xAF\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\xF3\xB0\xAF\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xF3\xB0\xAF\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xF3\xB0\xAF\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xF3\xB0\xAF\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\xF3\xB0\xAF\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\xF3\xB0\xAF\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\xF3\xB0\xAF\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xF3\xB0\xAF\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xF3\xB0\xAF\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xF3\xB0\xAF\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\xF3\xB0\xAF\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\xF3\xB0\xAF\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xF3\xB0\xAF\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\xF3\xB0\xAF\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\xF3\xB0\xAF\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\xF3\xB0\xAF\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\xF3\xB0\xAF\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xF3\xB0\xAF\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\xF3\xB0\xAF\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xF3\xB0\xAF\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\xF3\xB0\xAF\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\xF3\xB0\xAF\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xF3\xB0\xAF\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\xF3\xB0\xAF\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\xF3\xB0\xAF\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\xF3\xB0\xAF\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\xF3\xB0\xAF\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xF3\xB0\xAF\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\xF3\xB0\xAF\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\xF3\xB0\xAF\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\xF3\xB0\xAF\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\xF3\xB0\xAF\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\xF3\xB0\xAF\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\xF3\xB0\xAF\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xF3\xB0\xAF\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xF3\xB0\xAF\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xF3\xB0\xAF\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xF3\xB0\xAF\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\xF3\xB0\xAF\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\xF3\xB0\xAF\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\xF3\xB0\xAF\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\xF3\xB0\xAF\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xF3\xB0\xAF\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xF3\xB0\xAF\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\xF3\xB0\xAF\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xF3\xB0\xAF\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\xF3\xB0\xAF\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xF3\xB0\xAF\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xF3\xB0\xAF\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\xF3\xB0\xAF\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\xF3\xB0\xAF\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\xF3\xB0\xAF\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\xF3\xB0\xAF\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\xF3\xB0\xAF\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xF3\xB0\xAF\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\xF3\xB0\xAF\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xF3\xB0\xAF\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\xF3\xB0\xB0\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xF3\xB0\xB0\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\xF3\xB0\xB0\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\xF3\xB0\xB0\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\xF3\xB0\xB0\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\xF3\xB0\xB0\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\xF3\xB0\xB0\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\xF3\xB0\xB0\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xF3\xB0\xB0\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\xF3\xB0\xB0\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\xF3\xB0\xB0\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\xF3\xB0\xB0\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xF3\xB0\xB0\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\xF3\xB0\xB0\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xF3\xB0\xB0\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\xF3\xB0\xB0\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\xF3\xB0\xB0\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\xF3\xB0\xB0\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\xF3\xB0\xB0\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\xF3\xB0\xB0\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\xF3\xB0\xB0\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\xF3\xB0\xB0\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xF3\xB0\xB0\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\xF3\xB0\xB0\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\xF3\xB0\xB0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\xF3\xB0\xB0\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\xF3\xB0\xB0\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xF3\xB0\xB0\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\xF3\xB0\xB0\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xF3\xB0\xB0\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xF3\xB0\xB0\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xF3\xB0\xB0\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xF3\xB0\xB0\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xF3\xB0\xB0\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\xF3\xB0\xB0\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xF3\xB0\xB0\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xF3\xB0\xB0\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\xF3\xB0\xB0\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\xF3\xB0\xB0\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\xF3\xB0\xB0\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xF3\xB0\xB0\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\xF3\xB0\xB0\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xF3\xB0\xB0\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\xF3\xB0\xB0\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xF3\xB0\xB0\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\xF3\xB0\xB0\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xF3\xB0\xB0\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\xF3\xB0\xB0\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xF3\xB0\xB0\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\xF3\xB0\xB0\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xF3\xB0\xB0\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xF3\xB0\xB0\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\xF3\xB0\xB0\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xF3\xB0\xB0\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\xF3\xB0\xB0\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\xF3\xB0\xB0\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\xF3\xB0\xB0\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\xF3\xB0\xB0\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\xF3\xB0\xB0\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\xF3\xB0\xB0\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xF3\xB0\xB0\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF3\xB0\xB0\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\xF3\xB0\xB0\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\xF3\xB0\xB0\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xF3\xB0\xB1\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xF3\xB0\xB1\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\xF3\xB0\xB1\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xF3\xB0\xB1\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\xF3\xB0\xB1\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\xF3\xB0\xB1\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\xF3\xB0\xB1\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xF3\xB0\xB1\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xF3\xB0\xB1\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\xF3\xB0\xB1\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\xF3\xB0\xB1\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xF3\xB0\xB1\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\xF3\xB0\xB1\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xF3\xB0\xB1\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\xF3\xB0\xB1\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\xF3\xB0\xB1\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xF3\xB0\xB1\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\xF3\xB0\xB1\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\xF3\xB0\xB1\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\xF3\xB0\xB1\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xF3\xB0\xB1\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\xF3\xB0\xB1\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\xF3\xB0\xB1\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\xF3\xB0\xB1\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\xF3\xB0\xB1\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\xF3\xB0\xB1\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\xF3\xB0\xB1\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\xF3\xB0\xB1\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xF3\xB0\xB1\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xF3\xB0\xB1\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xF3\xB0\xB1\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\xF3\xB0\xB1\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xF3\xB0\xB1\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xF3\xB0\xB1\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xF3\xB0\xB1\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\xF3\xB0\xB1\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\xF3\xB0\xB1\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xF3\xB0\xB1\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\xF3\xB0\xB1\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\xF3\xB0\xB1\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xF3\xB0\xB1\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xF3\xB0\xB1\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xF3\xB0\xB1\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\xF3\xB0\xB1\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xF3\xB0\xB1\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\xF3\xB0\xB1\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\xF3\xB0\xB1\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xF3\xB0\xB1\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xF3\xB0\xB1\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xF3\xB0\xB1\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xF3\xB0\xB1\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\xF3\xB0\xB1\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xF3\xB0\xB1\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xF3\xB0\xB1\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\xF3\xB0\xB1\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xF3\xB0\xB1\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\xF3\xB0\xB1\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\xF3\xB0\xB1\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\xF3\xB0\xB1\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xF3\xB0\xB1\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\xF3\xB0\xB1\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\xF3\xB0\xB1\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xF3\xB0\xB1\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xF3\xB0\xB1\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xF3\xB0\xB2\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\xF3\xB0\xB2\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\xF3\xB0\xB2\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\xF3\xB0\xB2\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\xF3\xB0\xB2\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\xF3\xB0\xB2\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xF3\xB0\xB2\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xF3\xB0\xB2\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xF3\xB0\xB2\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xF3\xB0\xB2\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\xF3\xB0\xB2\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\xF3\xB0\xB2\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\xF3\xB0\xB2\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xF3\xB0\xB2\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\xF3\xB0\xB2\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\xF3\xB0\xB2\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\xF3\xB0\xB2\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\xF3\xB0\xB2\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xF3\xB0\xB2\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\xF3\xB0\xB2\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xF3\xB0\xB2\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\xF3\xB0\xB2\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xF3\xB0\xB2\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\xF3\xB0\xB2\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xF3\xB0\xB2\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\xF3\xB0\xB2\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xF3\xB0\xB2\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xF3\xB0\xB2\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\xF3\xB0\xB2\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\xF3\xB0\xB2\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\xF3\xB0\xB2\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xF3\xB0\xB2\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\xF3\xB0\xB2\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\xF3\xB0\xB2\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xF3\xB0\xB2\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xF3\xB0\xB2\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xF3\xB0\xB2\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xF3\xB0\xB2\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\xF3\xB0\xB2\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xF3\xB0\xB2\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\xF3\xB0\xB2\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\xF3\xB0\xB2\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xF3\xB0\xB2\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xF3\xB0\xB2\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xF3\xB0\xB2\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xF3\xB0\xB2\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\xF3\xB0\xB2\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\xF3\xB0\xB2\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\xF3\xB0\xB2\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\xF3\xB0\xB2\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xF3\xB0\xB2\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\xF3\xB0\xB2\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xF3\xB0\xB2\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\xF3\xB0\xB2\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xF3\xB0\xB2\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xF3\xB0\xB2\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\xF3\xB0\xB2\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xF3\xB0\xB2\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\xF3\xB0\xB2\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\xF3\xB0\xB2\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\xF3\xB0\xB2\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\xF3\xB0\xB2\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xF3\xB0\xB2\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\xF3\xB0\xB2\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xF3\xB0\xB3\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xF3\xB0\xB3\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xF3\xB0\xB3\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\xF3\xB0\xB3\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xF3\xB0\xB3\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\xF3\xB0\xB3\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xF3\xB0\xB3\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xF3\xB0\xB3\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xF3\xB0\xB3\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xF3\xB0\xB3\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xF3\xB0\xB3\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xF3\xB0\xB3\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\xF3\xB0\xB3\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xF3\xB0\xB3\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xF3\xB0\xB3\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xF3\xB0\xB3\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xF3\xB0\xB3\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xF3\xB0\xB3\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xF3\xB0\xB3\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\xF3\xB0\xB3\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xF3\xB0\xB3\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xF3\xB0\xB3\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xF3\xB0\xB3\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xF3\xB0\xB3\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xF3\xB0\xB3\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\xF3\xB0\xB3\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xF3\xB0\xB3\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xF3\xB0\xB3\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\xF3\xB0\xB3\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xF3\xB0\xB3\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\xF3\xB0\xB3\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xF3\xB0\xB3\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xF3\xB0\xB3\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xF3\xB0\xB3\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xF3\xB0\xB3\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xF3\xB0\xB3\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xF3\xB0\xB3\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xF3\xB0\xB3\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xF3\xB0\xB3\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xF3\xB0\xB3\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xF3\xB0\xB3\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xF3\xB0\xB3\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xF3\xB0\xB3\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xF3\xB0\xB3\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xF3\xB0\xB3\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xF3\xB0\xB3\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xF3\xB0\xB3\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xF3\xB0\xB3\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xF3\xB0\xB3\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xF3\xB0\xB3\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xF3\xB0\xB3\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xF3\xB0\xB3\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xF3\xB0\xB3\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xF3\xB0\xB3\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xF3\xB0\xB3\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xF3\xB0\xB3\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xF3\xB0\xB3\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xF3\xB0\xB3\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\xF3\xB0\xB3\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xF3\xB0\xB3\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xF3\xB0\xB3\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xF3\xB0\xB3\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xF3\xB0\xB3\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xF3\xB0\xB3\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xF3\xB0\xB4\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xF3\xB0\xB4\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xF3\xB0\xB4\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xF3\xB0\xB4\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xF3\xB0\xB4\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xF3\xB0\xB4\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xF3\xB0\xB4\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xF3\xB0\xB4\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xF3\xB0\xB4\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xF3\xB0\xB4\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xF3\xB0\xB4\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\xF3\xB0\xB4\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\xF3\xB0\xB4\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xF3\xB0\xB4\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\xF3\xB0\xB4\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xF3\xB0\xB4\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xF3\xB0\xB4\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xF3\xB0\xB4\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xF3\xB0\xB4\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xF3\xB0\xB4\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xF3\xB0\xB4\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xF3\xB0\xB4\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xF3\xB0\xB4\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xF3\xB0\xB4\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xF3\xB0\xB4\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xF3\xB0\xB4\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\xF3\xB0\xB4\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xF3\xB0\xB4\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\xF3\xB0\xB4\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xF3\xB0\xB4\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xF3\xB0\xB4\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xF3\xB0\xB4\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xF3\xB0\xB4\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xF3\xB0\xB4\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xF3\xB0\xB4\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xF3\xB0\xB4\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xF3\xB0\xB4\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xF3\xB0\xB4\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xF3\xB0\xB4\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xF3\xB0\xB4\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xF3\xB0\xB4\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xF3\xB0\xB4\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xF3\xB0\xB4\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xF3\xB0\xB4\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xF3\xB0\xB4\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xF3\xB0\xB4\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xF3\xB0\xB4\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xF3\xB0\xB4\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xF3\xB0\xB4\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xF3\xB0\xB4\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xF3\xB0\xB4\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xF3\xB0\xB4\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xF3\xB0\xB4\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xF3\xB0\xB4\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xF3\xB0\xB4\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xF3\xB0\xB4\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xF3\xB0\xB4\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xF3\xB0\xB4\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xF3\xB0\xB4\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xF3\xB0\xB4\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xF3\xB0\xB4\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xF3\xB0\xB4\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xF3\xB0\xB4\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xF3\xB0\xB4\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xF3\xB0\xB5\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xF3\xB0\xB5\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xF3\xB0\xB5\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xF3\xB0\xB5\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xF3\xB0\xB5\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xF3\xB0\xB5\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xF3\xB0\xB5\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xF3\xB0\xB5\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xF3\xB0\xB5\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\xF3\xB0\xB5\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\xF3\xB0\xB5\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xF3\xB0\xB5\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xF3\xB0\xB5\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xF3\xB0\xB5\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xF3\xB0\xB5\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xF3\xB0\xB5\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xF3\xB0\xB5\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xF3\xB0\xB5\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xF3\xB0\xB5\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xF3\xB0\xB5\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xF3\xB0\xB5\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xF3\xB0\xB5\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xF3\xB0\xB5\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xF3\xB0\xB5\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xF3\xB0\xB5\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xF3\xB0\xB5\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\xF3\xB0\xB5\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\xF3\xB0\xB5\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\xF3\xB0\xB5\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xF3\xB0\xB5\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xF3\xB0\xB5\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xF3\xB0\xB5\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xF3\xB0\xB5\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xF3\xB0\xB5\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xF3\xB0\xB5\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xF3\xB0\xB5\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xF3\xB0\xB5\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xF3\xB0\xB5\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xF3\xB0\xB5\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xF3\xB0\xB5\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xF3\xB0\xB5\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\xF3\xB0\xB5\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xF3\xB0\xB5\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\xF3\xB0\xB5\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xF3\xB0\xB5\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xF3\xB0\xB5\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xF3\xB0\xB5\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xF3\xB0\xB5\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xF3\xB0\xB5\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xF3\xB0\xB5\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xF3\xB0\xB5\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xF3\xB0\xB5\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xF3\xB0\xB5\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xF3\xB0\xB5\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xF3\xB0\xB5\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xF3\xB0\xB5\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xF3\xB0\xB5\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xF3\xB0\xB5\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xF3\xB0\xB5\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xF3\xB0\xB5\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xF3\xB0\xB5\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xF3\xB0\xB5\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xF3\xB0\xB5\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xF3\xB0\xB5\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xF3\xB0\xB6\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xF3\xB0\xB6\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xF3\xB0\xB6\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xF3\xB0\xB6\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xF3\xB0\xB6\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xF3\xB0\xB6\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xF3\xB0\xB6\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xF3\xB0\xB6\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xF3\xB0\xB6\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xF3\xB0\xB6\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xF3\xB0\xB6\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xF3\xB0\xB6\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xF3\xB0\xB6\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xF3\xB0\xB6\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xF3\xB0\xB6\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xF3\xB0\xB6\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xF3\xB0\xB6\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xF3\xB0\xB6\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xF3\xB0\xB6\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xF3\xB0\xB6\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xF3\xB0\xB6\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xF3\xB0\xB6\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xF3\xB0\xB6\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xF3\xB0\xB6\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xF3\xB0\xB6\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xF3\xB0\xB6\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xF3\xB0\xB6\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xF3\xB0\xB6\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xF3\xB0\xB6\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xF3\xB0\xB6\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xF3\xB0\xB6\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xF3\xB0\xB6\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xF3\xB0\xB6\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xF3\xB0\xB6\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xF3\xB0\xB6\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xF3\xB0\xB6\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xF3\xB0\xB6\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xF3\xB0\xB6\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xF3\xB0\xB6\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\xF3\xB0\xB6\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\xF3\xB0\xB6\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\xF3\xB0\xB6\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xF3\xB0\xB6\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xF3\xB0\xB6\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xF3\xB0\xB6\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xF3\xB0\xB6\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xF3\xB0\xB6\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xF3\xB0\xB6\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xF3\xB0\xB6\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xF3\xB0\xB6\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xF3\xB0\xB6\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xF3\xB0\xB6\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xF3\xB0\xB6\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xF3\xB0\xB6\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xF3\xB0\xB6\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xF3\xB0\xB6\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xF3\xB0\xB6\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xF3\xB0\xB6\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xF3\xB0\xB6\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xF3\xB0\xB6\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xF3\xB0\xB6\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xF3\xB0\xB6\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xF3\xB0\xB6\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xF3\xB0\xB6\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xF3\xB0\xB7\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xF3\xB0\xB7\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xF3\xB0\xB7\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xF3\xB0\xB7\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xF3\xB0\xB7\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xF3\xB0\xB7\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xF3\xB0\xB7\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xF3\xB0\xB7\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xF3\xB0\xB7\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\xF3\xB0\xB7\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xF3\xB0\xB7\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xF3\xB0\xB7\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xF3\xB0\xB7\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xF3\xB0\xB7\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xF3\xB0\xB7\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xF3\xB0\xB7\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xF3\xB0\xB7\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xF3\xB0\xB7\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xF3\xB0\xB7\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xF3\xB0\xB7\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xF3\xB0\xB7\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xF3\xB0\xB7\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xF3\xB0\xB7\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xF3\xB0\xB7\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xF3\xB0\xB7\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\xF3\xB0\xB7\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xF3\xB0\xB7\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xF3\xB0\xB7\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\xF3\xB0\xB7\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xF3\xB0\xB7\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xF3\xB0\xB7\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xF3\xB0\xB7\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xF3\xB0\xB7\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xF3\xB0\xB7\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xF3\xB0\xB7\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xF3\xB0\xB7\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xF3\xB0\xB7\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xF3\xB0\xB7\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xF3\xB0\xB7\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\xF3\xB0\xB7\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xF3\xB0\xB7\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\xF3\xB0\xB7\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xF3\xB0\xB7\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xF3\xB0\xB7\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xF3\xB0\xB7\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xF3\xB0\xB7\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xF3\xB0\xB7\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xF3\xB0\xB7\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xF3\xB0\xB7\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xF3\xB0\xB7\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xF3\xB0\xB7\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xF3\xB0\xB7\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xF3\xB0\xB7\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xF3\xB0\xB7\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xF3\xB0\xB7\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xF3\xB0\xB7\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xF3\xB0\xB7\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xF3\xB0\xB7\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xF3\xB0\xB7\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xF3\xB0\xB7\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xF3\xB0\xB7\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xF3\xB0\xB7\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xF3\xB0\xB7\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xF3\xB0\xB7\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xF3\xB0\xB8\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xF3\xB0\xB8\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xF3\xB0\xB8\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xF3\xB0\xB8\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xF3\xB0\xB8\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xF3\xB0\xB8\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\xF3\xB0\xB8\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\xF3\xB0\xB8\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\xF3\xB0\xB8\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\xF3\xB0\xB8\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xF3\xB0\xB8\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xF3\xB0\xB8\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xF3\xB0\xB8\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xF3\xB0\xB8\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xF3\xB0\xB8\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xF3\xB0\xB8\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xF3\xB0\xB8\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xF3\xB0\xB8\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xF3\xB0\xB8\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xF3\xB0\xB8\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xF3\xB0\xB8\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xF3\xB0\xB8\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xF3\xB0\xB8\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xF3\xB0\xB8\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\xF3\xB0\xB8\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xF3\xB0\xB8\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xF3\xB0\xB8\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xF3\xB0\xB8\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xF3\xB0\xB8\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xF3\xB0\xB8\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xF3\xB0\xB8\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xF3\xB0\xB8\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xF3\xB0\xB8\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xF3\xB0\xB8\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xF3\xB0\xB8\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xF3\xB0\xB8\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xF3\xB0\xB8\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xF3\xB0\xB8\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xF3\xB0\xB8\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xF3\xB0\xB8\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xF3\xB0\xB8\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xF3\xB0\xB8\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xF3\xB0\xB8\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xF3\xB0\xB8\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xF3\xB0\xB8\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xF3\xB0\xB8\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xF3\xB0\xB8\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xF3\xB0\xB8\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xF3\xB0\xB8\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xF3\xB0\xB8\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xF3\xB0\xB8\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xF3\xB0\xB8\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xF3\xB0\xB8\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xF3\xB0\xB8\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xF3\xB0\xB8\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xF3\xB0\xB8\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\xF3\xB0\xB8\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xF3\xB0\xB8\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xF3\xB0\xB8\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xF3\xB0\xB8\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xF3\xB0\xB8\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xF3\xB0\xB8\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xF3\xB0\xB8\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xF3\xB0\xB8\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xF3\xB0\xB9\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xF3\xB0\xB9\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xF3\xB0\xB9\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xF3\xB0\xB9\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xF3\xB0\xB9\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xF3\xB0\xB9\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xF3\xB0\xB9\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xF3\xB0\xB9\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xF3\xB0\xB9\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xF3\xB0\xB9\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\xF3\xB0\xB9\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xF3\xB0\xB9\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xF3\xB0\xB9\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xF3\xB0\xB9\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\xF3\xB0\xB9\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xF3\xB0\xB9\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xF3\xB0\xB9\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xF3\xB0\xB9\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xF3\xB0\xB9\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xF3\xB0\xB9\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xF3\xB0\xB9\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xF3\xB0\xB9\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xF3\xB0\xB9\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xFC"],
        ["\xF3\xB0\xB9\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xF3\xB0\xB9\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xF3\xB0\xB9\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xF3\xB0\xB9\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xF3\xB0\xB9\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xF3\xB0\xB9\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xF3\xB0\xB9\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xF3\xB0\xB9\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xF3\xB0\xB9\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xF3\xB0\xB9\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xF3\xB0\xB9\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xF3\xB0\xB9\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xF3\xB0\xB9\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xF3\xB0\xB9\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xF3\xB0\xB9\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xF3\xB0\xB9\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xF3\xB0\xB9\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xF3\xB0\xB9\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xF3\xB0\xB9\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xF3\xB0\xB9\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xF3\xB0\xB9\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xF3\xB0\xB9\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xF3\xB0\xB9\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xF3\xB0\xB9\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xF3\xB0\xB9\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xF3\xB0\xB9\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xF3\xB0\xB9\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xF3\xB0\xB9\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xF3\xB0\xB9\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xF3\xB0\xB9\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xF3\xB0\xB9\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\xF3\xB0\xB9\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xF3\xB0\xB9\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xF3\xB0\xB9\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xF3\xB0\xB9\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xF3\xB0\xB9\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xF3\xB0\xB9\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xF3\xB0\xB9\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xF3\xB0\xB9\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xF3\xB0\xB9\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xF3\xB0\xB9\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xF3\xB0\xBA\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xF3\xB0\xBA\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xF3\xB0\xBA\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xF3\xB0\xBA\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xF3\xB0\xBA\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\xF3\xB0\xBA\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\xF3\xB0\xBA\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xF3\xB0\xBA\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xF3\xB0\xBA\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xF3\xB0\xBA\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xF3\xB0\xBA\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\xF3\xB0\xBA\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xF3\xB0\xBA\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xF3\xB0\xBA\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xF3\xB0\xBA\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xF3\xB0\xBA\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xF3\xB0\xBA\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xF3\xB0\xBA\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xF3\xB0\xBA\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xF3\xB0\xBA\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\xF3\xB0\xBA\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xF3\xB0\xBA\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xF3\xB0\xBA\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xF3\xB0\xBA\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xF3\xB0\xBA\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\xF3\xB0\xBA\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xF3\xB0\xBA\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xF3\xB0\xBA\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xF3\xB0\xBA\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xF3\xB0\xBA\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xF3\xB0\xBA\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\xF3\xB0\xBA\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xF3\xB0\xBA\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xF3\xB0\xBA\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xF3\xB0\xBA\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\xF3\xB0\xBA\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xF3\xB0\xBA\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xF3\xB0\xBA\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xF3\xB0\xBA\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xF3\xB0\xBA\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\xF3\xB0\xBA\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\xF3\xB0\xBA\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xF3\xB0\xBA\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xF3\xB0\xBA\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xF3\xB0\xBA\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xF3\xB0\xBA\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xF3\xB0\xBA\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xF3\xB0\xBA\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xF3\xB0\xBA\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xF3\xB0\xBA\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\xF3\xB0\xBA\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xF3\xB0\xBA\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\xF3\xB0\xBA\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xF3\xB0\xBA\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xF3\xB0\xBA\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xF3\xB0\xBA\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xF3\xB0\xBA\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xF3\xB0\xBA\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xF3\xB0\xBA\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xF3\xB0\xBA\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xF3\xB0\xBA\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xF3\xB0\xBA\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xF3\xB0\xBA\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xF3\xB0\xBA\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\xF3\xB0\xBB\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\xF3\xB0\xBB\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xF3\xB0\xBB\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\xF3\xB0\xBB\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xF3\xB0\xBB\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xF3\xB0\xBB\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xF3\xB0\xBB\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xF3\xB0\xBB\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xF3\xB0\xBB\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xF3\xB0\xBB\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xF3\xB0\xBB\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xF3\xB0\xBB\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xF3\xB0\xBB\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xF3\xB0\xBB\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xF3\xB0\xBB\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xF3\xB0\xBB\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xF3\xB0\xBB\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xF3\xB0\xBB\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xF3\xB0\xBB\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xF3\xB0\xBB\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\xF3\xB0\xBB\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xF3\xB0\xBB\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xF3\xB0\xBB\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xF3\xB0\xBB\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xF3\xB0\xBB\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xF3\xB0\xBB\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xF3\xB0\xBB\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xF3\xB0\xBB\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xF3\xB0\xBB\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xF3\xB0\xBB\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xF3\xB0\xBB\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xF3\xB0\xBB\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\xF3\xB0\xBB\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xF3\xB0\xBB\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\xF3\xB0\xBB\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xF3\xB0\xBB\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\xF3\xB0\xBB\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\xF3\xB0\xBB\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xF3\xB0\xBB\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xF3\xB0\xBB\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xF3\xB0\xBB\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xF3\xB0\xBB\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xF3\xB0\xBB\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xF3\xB0\xBB\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xF3\xB0\xBB\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xF3\xB0\xBB\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xF3\xB0\xBB\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xF3\xB0\xBB\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xF3\xB0\xBB\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xF3\xB0\xBB\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xF3\xB0\xBB\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xF3\xB0\xBB\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xF3\xB0\xBB\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xF3\xB0\xBB\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\xF3\xB0\xBB\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xF3\xB0\xBB\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\xF3\xB0\xBB\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xF3\xB0\xBB\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xF3\xB0\xBB\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xF3\xB0\xBB\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\xF3\xB0\xBB\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\xF3\xB0\xBB\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xF3\xB0\xBB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xF3\xB0\xBB\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\xF3\xB0\xBC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xF3\xB0\xBC\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\xF3\xB0\xBC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xF3\xB0\xBC\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xF3\xB0\xBC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xF3\xB0\xBC\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xF3\xB0\xBC\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xF3\xB0\xBC\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xF3\xB0\xBC\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\xF3\xB0\xBC\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xF3\xB0\xBC\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xF3\xB0\xBC\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xF3\xB0\xBC\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xF3\xB0\xBC\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xF3\xB0\xBC\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xF3\xB0\xBC\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\xF3\xB0\xBC\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xF3\xB0\xBC\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xF3\xB0\xBC\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\xF3\xB0\xBC\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xF3\xB0\xBC\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xF3\xB0\xBC\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xF3\xB0\xBC\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xF3\xB0\xBC\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xF3\xB0\xBC\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xF3\xB0\xBC\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xF3\xB0\xBC\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xF3\xB0\xBC\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xF3\xB0\xBC\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xF3\xB0\xBC\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xF3\xB0\xBC\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xF3\xB0\xBC\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xF3\xB0\xBC\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xF3\xB0\xBC\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\xF3\xB0\xBC\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\xF3\xB0\xBC\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xF3\xB0\xBC\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xF3\xB0\xBC\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xF3\xB0\xBC\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xF3\xB0\xBC\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xF3\xB0\xBC\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xF3\xB0\xBC\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xF3\xB0\xBC\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xF3\xB0\xBC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xF3\xB0\xBC\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xF3\xB0\xBC\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\xF3\xB0\xBC\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xF3\xB0\xBC\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\xF3\xB0\xBC\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\xF3\xB0\xBC\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xF3\xB0\xBC\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xF3\xB0\xBC\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xF3\xB0\xBC\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xF3\xB0\xBC\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xF3\xB0\xBC\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xF3\xB0\xBC\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xF3\xB0\xBC\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xF3\xB0\xBC\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xF3\xB0\xBC\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xF3\xB0\xBC\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xF3\xB0\xBC\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xF3\xB0\xBC\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\xF3\xB0\xBC\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\xF3\xB0\xBC\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xF3\xB0\xBD\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xF3\xB0\xBD\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xF3\xB0\xBD\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xF3\xB0\xBD\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xF3\xB0\xBD\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xF3\xB0\xBD\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xF3\xB0\xBD\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xF3\xB0\xBD\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xF3\xB0\xBD\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xF3\xB0\xBD\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xF3\xB0\xBD\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xF3\xB0\xBD\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xF3\xB0\xBD\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xF3\xB0\xBD\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\xF3\xB0\xBD\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\xF3\xB0\xBD\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\xF3\xB0\xBD\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xF3\xB0\xBD\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xF3\xB0\xBD\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xF3\xB0\xBD\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\xF3\xB0\xBD\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xF3\xB0\xBD\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xF3\xB0\xBD\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xF3\xB0\xBD\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xF3\xB0\xBD\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xF3\xB0\xBD\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xF3\xB0\xBD\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xF3\xB0\xBD\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xF3\xB0\xBD\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xF3\xB0\xBD\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xF3\xB0\xBD\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\xF3\xB0\xBD\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xF3\xB0\xBD\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xF3\xB0\xBD\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xF3\xB0\xBD\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xF3\xB0\xBD\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xF3\xB0\xBD\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xF3\xB0\xBD\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xF3\xB0\xBD\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xF3\xB0\xBD\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xF3\xB0\xBD\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xF3\xB0\xBD\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\xF3\xB0\xBD\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xF3\xB0\xBD\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xF3\xB0\xBD\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xF3\xB0\xBD\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xF3\xB0\xBD\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\xF3\xB0\xBD\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\xF3\xB0\xBD\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xF3\xB0\xBD\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xF3\xB0\xBD\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xF3\xB0\xBD\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xF3\xB0\xBD\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xF3\xB0\xBD\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xF3\xB0\xBD\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xF3\xB0\xBD\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xF3\xB0\xBD\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xF3\xB0\xBD\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xF3\xB0\xBD\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xF3\xB0\xBD\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xF3\xB0\xBD\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xF3\xB0\xBD\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\xF3\xB0\xBD\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xF3\xB0\xBD\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\xF3\xB0\xBE\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xF3\xB0\xBE\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xF3\xB0\xBE\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xF3\xB0\xBE\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xF3\xB0\xBE\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xF3\xB0\xBE\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xF3\xB0\xBE\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xF3\xB0\xBE\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xF3\xB0\xBE\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xF3\xB0\xBE\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xF3\xB0\xBE\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xF3\xB0\xBE\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xF3\xB0\xBE\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xF3\xB0\xBE\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xF3\xB0\xBE\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xF3\xB0\xBE\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xF3\xB0\xBE\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xF3\xB0\xBE\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xF3\xB0\xBE\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xF3\xB0\xBE\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xF3\xB0\xBE\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xF3\xB0\xBE\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xF3\xB0\xBE\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xF3\xB0\xBE\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xF3\xB0\xBE\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xF3\xB0\xBE\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xF3\xB0\xBE\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xF3\xB0\xBE\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\xF3\xB0\xBE\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\xF3\xB0\xBE\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xF3\xB0\xBE\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\xF3\xB0\xBE\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xF3\xB0\xBE\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\xF3\xB0\xBE\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xF3\xB0\xBE\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xF3\xB0\xBE\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xF3\xB0\xBE\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xF3\xB0\xBE\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xF3\xB0\xBE\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xF3\xB0\xBE\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xF3\xB0\xBE\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xF3\xB0\xBE\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xF3\xB0\xBE\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xF3\xB0\xBE\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\xF3\xB0\xBE\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xF3\xB0\xBE\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xF3\xB0\xBE\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\xF3\xB0\xBE\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\xF3\xB0\xBE\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xF3\xB0\xBE\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\xF3\xB0\xBE\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xF3\xB0\xBE\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xF3\xB0\xBE\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xF3\xB0\xBE\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xF3\xB0\xBE\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xF3\xB0\xBE\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xF3\xB0\xBE\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\xF3\xB0\xBE\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xF3\xB0\xBE\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xF3\xB0\xBE\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xF3\xB0\xBE\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xF3\xB0\xBE\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xF3\xB0\xBE\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xF3\xB0\xBE\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\xF3\xB0\xBF\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xF3\xB0\xBF\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xF3\xB0\xBF\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xF3\xB0\xBF\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xF3\xB0\xBF\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xF3\xB0\xBF\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xF3\xB0\xBF\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\xF3\xB0\xBF\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xF3\xB0\xBF\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xF3\xB0\xBF\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xF3\xB0\xBF\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xF3\xB0\xBF\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xF3\xB0\xBF\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xF3\xB0\xBF\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xF3\xB0\xBF\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\xF3\xB0\xBF\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xF3\xB0\xBF\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xF3\xB0\xBF\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xF3\xB0\xBF\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xF3\xB0\xBF\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xF3\xB0\xBF\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xF3\xB0\xBF\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xF3\xB0\xBF\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xF3\xB0\xBF\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xF3\xB0\xBF\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xF3\xB0\xBF\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\xF3\xB0\xBF\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\xF3\xB0\xBF\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xF3\xB0\xBF\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xF3\xB0\xBF\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xF3\xB0\xBF\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\xF3\xB0\xBF\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xF3\xB0\xBF\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xF3\xB0\xBF\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xF3\xB0\xBF\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xF3\xB0\xBF\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xF3\xB0\xBF\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xF3\xB0\xBF\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xF3\xB0\xBF\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xF3\xB0\xBF\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xF3\xB0\xBF\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xF3\xB0\xBF\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\xF3\xB0\xBF\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xF3\xB0\xBF\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xF3\xB0\xBF\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xF3\xB0\xBF\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xF3\xB0\xBF\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xF3\xB0\xBF\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xF3\xB0\xBF\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\xF3\xB0\xBF\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xF3\xB0\xBF\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xF3\xB0\xBF\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xF3\xB0\xBF\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xF3\xB0\xBF\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xF3\xB0\xBF\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xF3\xB0\xBF\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xF3\xB0\xBF\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xF3\xB0\xBF\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xF3\xB0\xBF\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xF3\xB0\xBF\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xF3\xB0\xBF\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xF3\xB0\xBF\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xF3\xB0\xBF\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xF3\xB0\xBF\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xF3\xB1\x80\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xF3\xB1\x80\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xF3\xB1\x80\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xF3\xB1\x80\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xF3\xB1\x80\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xF3\xB1\x80\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xF3\xB1\x80\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xF3\xB1\x80\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xF3\xB1\x80\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xF3\xB1\x80\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xF3\xB1\x80\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xF3\xB1\x80\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xF3\xB1\x80\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xF3\xB1\x80\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xF3\xB1\x80\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xF3\xB1\x80\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xF3\xB1\x80\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xF3\xB1\x80\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xF3\xB1\x80\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xF3\xB1\x80\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xF3\xB1\x80\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xF3\xB1\x80\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xF3\xB1\x80\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\xF3\xB1\x80\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xF3\xB1\x80\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xF3\xB1\x80\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\xF3\xB1\x80\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xF3\xB1\x80\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\xF3\xB1\x80\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xF3\xB1\x80\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xF3\xB1\x80\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\xF3\xB1\x80\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\xF3\xB1\x80\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\xF3\xB1\x80\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xF3\xB1\x80\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xF3\xB1\x80\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xF3\xB1\x80\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xF3\xB1\x80\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xF3\xB1\x80\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xF3\xB1\x80\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\xF3\xB1\x80\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\xF3\xB1\x80\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xF3\xB1\x80\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xF3\xB1\x80\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\xF3\xB1\x80\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xF3\xB1\x80\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xF3\xB1\x80\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xF3\xB1\x80\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\xF3\xB1\x80\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xF3\xB1\x80\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\xF3\xB1\x80\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xF3\xB1\x80\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\xF3\xB1\x80\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\xF3\xB1\x80\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xF3\xB1\x80\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xF3\xB1\x80\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\xF3\xB1\x80\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\xF3\xB1\x80\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xF3\xB1\x80\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xF3\xB1\x80\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xF3\xB1\x80\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\xF3\xB1\x80\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\xF3\xB1\x80\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xF3\xB1\x80\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\xF3\xB1\x81\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xF3\xB1\x81\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xF3\xB1\x81\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\xF3\xB1\x81\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xF3\xB1\x81\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\xF3\xB1\x81\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\xF3\xB1\x81\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xF3\xB1\x81\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xF3\xB1\x81\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xF3\xB1\x81\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\xF3\xB1\x81\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xF3\xB1\x81\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xF3\xB1\x81\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xF3\xB1\x81\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xF3\xB1\x81\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xF3\xB1\x81\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xF3\xB1\x81\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\xF3\xB1\x81\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xF3\xB1\x81\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xF3\xB1\x81\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xF3\xB1\x81\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\xF3\xB1\x81\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xF3\xB1\x81\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xF3\xB1\x81\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\xF3\xB1\x81\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\xF3\xB1\x81\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\xF3\xB1\x81\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xF3\xB1\x81\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xF3\xB1\x81\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xF3\xB1\x81\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xF3\xB1\x81\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xF3\xB1\x81\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xF3\xB1\x81\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xF3\xB1\x81\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xF3\xB1\x81\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\xF3\xB1\x81\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xF3\xB1\x81\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\xF3\xB1\x81\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xF3\xB1\x81\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\xF3\xB1\x81\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xF3\xB1\x81\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xF3\xB1\x81\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xF3\xB1\x81\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xF3\xB1\x81\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xF3\xB1\x81\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\xF3\xB1\x81\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xF3\xB1\x81\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xF3\xB1\x81\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xF3\xB1\x81\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xF3\xB1\x81\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xF3\xB1\x81\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xF3\xB1\x81\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xF3\xB1\x81\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xF3\xB1\x81\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\xF3\xB1\x81\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xF3\xB1\x81\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xF3\xB1\x81\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xF3\xB1\x81\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\xF3\xB1\x81\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xF3\xB1\x81\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xF3\xB1\x81\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\xF3\xB1\x81\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xF3\xB1\x81\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\xF3\xB1\x81\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xF3\xB1\x82\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xF3\xB1\x82\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\xF3\xB1\x82\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\xF3\xB1\x82\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xF3\xB1\x82\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\xF3\xB1\x82\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xF3\xB1\x82\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\xF3\xB1\x82\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\xF3\xB1\x82\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\xF3\xB1\x82\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\xF3\xB1\x82\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xF3\xB1\x82\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xF3\xB1\x82\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xF3\xB1\x82\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xF3\xB1\x82\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xF3\xB1\x82\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\xF3\xB1\x82\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xF3\xB1\x82\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\xF3\xB1\x82\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xF3\xB1\x82\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\xF3\xB1\x82\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xF3\xB1\x82\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\xF3\xB1\x82\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xF3\xB1\x82\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\xF3\xB1\x82\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xF3\xB1\x82\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xF3\xB1\x82\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xF3\xB1\x82\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xF3\xB1\x82\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\xF3\xB1\x82\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\xF3\xB1\x82\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xF3\xB1\x82\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xF3\xB1\x82\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xF3\xB1\x82\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xF3\xB1\x82\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\xF3\xB1\x82\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\xF3\xB1\x82\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xF3\xB1\x82\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xF3\xB1\x82\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xF3\xB1\x82\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xF3\xB1\x82\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\xF3\xB1\x82\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xF3\xB1\x82\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\xF3\xB1\x82\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xF3\xB1\x82\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xF3\xB1\x82\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xF3\xB1\x82\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xF3\xB1\x82\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xF3\xB1\x82\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\xF3\xB1\x82\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\xF3\xB1\x82\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xF3\xB1\x82\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xF3\xB1\x82\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xF3\xB1\x82\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\xF3\xB1\x82\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\xF3\xB1\x82\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\xF3\xB1\x82\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\xF3\xB1\x82\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\xF3\xB1\x82\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xF3\xB1\x82\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\xF3\xB1\x82\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\xF3\xB1\x82\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\xF3\xB1\x82\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xF3\xB1\x82\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xF3\xB1\x83\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xF3\xB1\x83\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\xF3\xB1\x83\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xF3\xB1\x83\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xF3\xB1\x83\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\xF3\xB1\x83\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xF3\xB1\x83\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xF3\xB1\x83\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xF3\xB1\x83\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xF3\xB1\x83\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\xF3\xB1\x83\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xF3\xB1\x83\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\xF3\xB1\x83\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xF3\xB1\x83\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xF3\xB1\x83\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xF3\xB1\x83\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\xF3\xB1\x83\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\xF3\xB1\x83\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\xF3\xB1\x83\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xF3\xB1\x83\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xF3\xB1\x83\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xF3\xB1\x83\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xF3\xB1\x83\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xF3\xB1\x83\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xF3\xB1\x83\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xF3\xB1\x83\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xF3\xB1\x83\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\xF3\xB1\x83\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xF3\xB1\x83\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\xF3\xB1\x83\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xF3\xB1\x83\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xF3\xB1\x83\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xF3\xB1\x83\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xF3\xB1\x83\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\xF3\xB1\x83\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xF3\xB1\x83\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xF3\xB1\x83\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xF3\xB1\x83\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xF3\xB1\x83\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xF3\xB1\x83\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xF3\xB1\x83\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\xF3\xB1\x83\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\xF3\xB1\x83\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\xF3\xB1\x83\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xF3\xB1\x83\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xF3\xB1\x83\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\xF3\xB1\x83\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xF3\xB1\x83\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xF3\xB1\x83\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\xF3\xB1\x83\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xF3\xB1\x83\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xF3\xB1\x83\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xF3\xB1\x83\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\xF3\xB1\x83\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\xF3\xB1\x83\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],
        ["\xF3\xB1\x83\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\xF3\xB1\x83\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\xF3\xB1\x83\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\xF3\xB1\x83\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\xF3\xB1\x83\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\xF3\xB1\x83\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xF3\xB1\x83\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\xF3\xB1\x83\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\xF3\xB1\x83\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\xF3\xB1\x84\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\xF3\xB1\x84\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\xF3\xB1\x84\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xF3\xB1\x84\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\xF3\xB1\x84\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\xF3\xB1\x84\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xF3\xB1\x84\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\xF3\xB1\x84\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xF3\xB1\x84\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xF3\xB1\x84\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\xF3\xB1\x84\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\xF3\xB1\x84\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\xF3\xB1\x84\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\xF3\xB1\x84\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xF3\xB1\x84\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\xF3\xB1\x84\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\xF3\xB1\x84\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\xF3\xB1\x84\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\xF3\xB1\x84\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xF3\xB1\x84\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xF3\xB1\x84\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xF3\xB1\x84\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\xF3\xB1\x84\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xF3\xB1\x84\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xF3\xB1\x84\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xF3\xB1\x84\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xF3\xB1\x84\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\xF3\xB1\x84\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\xF3\xB1\x84\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\xF3\xB1\x84\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xF3\xB1\x84\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xF3\xB1\x84\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xF3\xB1\x84\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xF3\xB1\x84\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xF3\xB1\x84\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xF3\xB1\x84\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\xF3\xB1\x84\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\xF3\xB1\x84\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xF3\xB1\x84\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xF3\xB1\x84\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xF3\xB1\x84\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xF3\xB1\x84\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\xF3\xB1\x84\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xF3\xB1\x84\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xF3\xB1\x84\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\xF3\xB1\x84\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\xF3\xB1\x84\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\xF3\xB1\x84\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xF3\xB1\x84\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xF3\xB1\x84\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xF3\xB1\x84\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xF3\xB1\x84\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\xF3\xB1\x84\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\xF3\xB1\x84\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xF3\xB1\x84\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\xF3\xB1\x84\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\xF3\xB1\x84\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\xF3\xB1\x84\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\xF3\xB1\x84\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\xF3\xB1\x84\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\xF3\xB1\x84\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\xF3\xB1\x84\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\xF3\xB1\x84\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\xF3\xB1\x84\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\xF3\xB1\x85\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xF3\xB1\x85\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xF3\xB1\x85\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\xF3\xB1\x85\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xF3\xB1\x85\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\xF3\xB1\x85\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\xF3\xB1\x85\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xF3\xB1\x85\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\xF3\xB1\x85\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xF3\xB1\x85\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xF3\xB1\x85\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\xF3\xB1\x85\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\xF3\xB1\x85\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xF3\xB1\x85\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\xF3\xB1\x85\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xF3\xB1\x85\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xF3\xB1\x85\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\xF3\xB1\x85\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\xF3\xB1\x85\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\xF3\xB1\x85\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xF3\xB1\x85\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xF3\xB1\x85\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xF3\xB1\x85\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\xF3\xB1\x85\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xF3\xB1\x85\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\xF3\xB1\x85\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xF3\xB1\x85\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xF3\xB1\x85\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xF3\xB1\x85\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xF3\xB1\x85\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xF3\xB1\x85\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\xF3\xB1\x85\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xF3\xB1\x85\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xF3\xB1\x85\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xEB"],
        ["\xF3\xB1\x85\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\xF3\xB1\x85\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\xF3\xB1\x85\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xF3\xB1\x85\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xF3\xB1\x85\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xF3\xB1\x85\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xF3\xB1\x85\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\xF3\xB1\x85\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xF3\xB1\x85\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xF3\xB1\x85\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\xF3\xB1\x85\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xF3\xB1\x85\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xF3\xB1\x85\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xF3\xB1\x85\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xF3\xB1\x85\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\xF3\xB1\x85\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\xF3\xB1\x85\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\xF3\xB1\x85\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xF3\xB1\x85\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xF3\xB1\x85\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xF3\xB1\x85\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\xF3\xB1\x85\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\xF3\xB1\x85\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xF3\xB1\x85\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xF3\xB1\x85\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\xF3\xB1\x85\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xF3\xB1\x85\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\xF3\xB1\x85\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xF3\xB1\x85\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\xF3\xB1\x85\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xF3\xB1\x86\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xF3\xB1\x86\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\xF3\xB1\x86\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\xF3\xB1\x86\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xF3\xB1\x86\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xF3\xB1\x86\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xF3\xB1\x86\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xF3\xB1\x86\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xF3\xB1\x86\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xF3\xB1\x86\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xF3\xB1\x86\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xF3\xB1\x86\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xF3\xB1\x86\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xF3\xB1\x86\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xF3\xB1\x86\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xF3\xB1\x86\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\xF3\xB1\x86\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\xF3\xB1\x86\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xF3\xB1\x86\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xF3\xB1\x86\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\xF3\xB1\x86\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\xF3\xB1\x86\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xF3\xB1\x86\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xF3\xB1\x86\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xF3\xB1\x86\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xF3\xB1\x86\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xF3\xB1\x86\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xF3\xB1\x86\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xF3\xB1\x86\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xF3\xB1\x86\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xF3\xB1\x86\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xF3\xB1\x86\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xF3\xB1\x86\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xF3\xB1\x86\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xF3\xB1\x86\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xF3\xB1\x86\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xF3\xB1\x86\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xF3\xB1\x86\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\xF3\xB1\x86\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xF3\xB1\x86\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\xF3\xB1\x86\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\xF3\xB1\x86\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\xF3\xB1\x86\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xF3\xB1\x86\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\xF3\xB1\x86\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\xF3\xB1\x86\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\xF3\xB1\x86\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xF3\xB1\x86\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xF3\xB1\x86\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xF3\xB1\x86\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\xF3\xB1\x86\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\xF3\xB1\x86\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xF3\xB1\x86\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\xF3\xB1\x86\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\xF3\xB1\x86\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xF3\xB1\x86\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xF3\xB1\x86\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xF3\xB1\x86\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\xF3\xB1\x86\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\xF3\xB1\x86\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\xF3\xB1\x86\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xF3\xB1\x86\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\xF3\xB1\x86\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xF3\xB1\x86\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xF3\xB1\x87\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xF3\xB1\x87\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\xF3\xB1\x87\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xF3\xB1\x87\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xF3\xB1\x87\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xF3\xB1\x87\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\xF3\xB1\x87\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\xF3\xB1\x87\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xF3\xB1\x87\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xF3\xB1\x87\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xF3\xB1\x87\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\xF3\xB1\x87\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\xF3\xB1\x87\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\xF3\xB1\x87\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\xF3\xB1\x87\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\xF3\xB1\x87\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xF3\xB1\x87\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xF3\xB1\x87\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xF3\xB1\x87\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xF3\xB1\x87\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\xF3\xB1\x87\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xF3\xB1\x87\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\xF3\xB1\x87\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\xF3\xB1\x87\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\xF3\xB1\x87\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\xF3\xB1\x87\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\xF3\xB1\x87\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xF3\xB1\x87\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xF3\xB1\x87\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xF3\xB1\x87\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xF3\xB1\x87\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\xF3\xB1\x87\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\xF3\xB1\x87\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\xF3\xB1\x87\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\xF3\xB1\x87\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\xF3\xB1\x87\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xF3\xB1\x87\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xF3\xB1\x87\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\xF3\xB1\x87\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xF3\xB1\x87\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\xF3\xB1\x87\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xF3\xB1\x87\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xF3\xB1\x87\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xF3\xB1\x87\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\xF3\xB1\x87\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xF3\xB1\x87\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xF3\xB1\x87\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\xF3\xB1\x87\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\xF3\xB1\x87\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xF3\xB1\x87\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\xF3\xB1\x87\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\xF3\xB1\x87\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\xF3\xB1\x87\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xF3\xB1\x87\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\xF3\xB1\x87\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\xF3\xB1\x87\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\xF3\xB1\x87\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xF3\xB1\x87\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xF3\xB1\x87\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xF3\xB1\x87\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xF3\xB1\x87\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xF3\xB1\x87\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\xF3\xB1\x87\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xF3\xB1\x87\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xF3\xB1\x88\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\xF3\xB1\x88\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xF3\xB1\x88\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\xF3\xB1\x88\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\xF3\xB1\x88\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\xF3\xB1\x88\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xF3\xB1\x88\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\xF3\xB1\x88\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\xF3\xB1\x88\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xF3\xB1\x88\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xF3\xB1\x88\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xF3\xB1\x88\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xF3\xB1\x88\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\xF3\xB1\x88\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\xF3\xB1\x88\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\xF3\xB1\x88\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\xF3\xB1\x88\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\xF3\xB1\x88\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\xF3\xB1\x88\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\xF3\xB1\x88\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xF3\xB1\x88\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xF3\xB1\x88\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xF3\xB1\x88\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xF3\xB1\x89\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xF3\xB1\x89\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xF3\xB1\x89\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xF3\xB1\x89\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xF3\xB1\x89\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xF3\xB1\x89\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xF3\xB1\x89\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xF3\xB1\x89\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xF3\xB1\x89\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xF3\xB1\x89\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xF3\xB1\x89\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xF3\xB1\x89\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xF3\xB1\x89\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xF3\xB1\x89\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xF3\xB1\x89\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xF3\xB1\x89\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xF3\xB1\x89\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xF3\xB1\x89\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xF3\xB1\x89\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xF3\xB1\x89\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xF3\xB1\x89\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xF3\xB1\x89\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xF3\xB1\x89\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xF3\xB1\x89\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xF3\xB1\x89\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xF3\xB1\x89\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xF3\xB1\x89\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xF3\xB1\x89\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xF3\xB1\x89\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xF3\xB1\x89\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xF3\xB1\x89\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xF3\xB1\x89\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\xF3\xB1\x89\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xF3\xB1\x89\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xF3\xB1\x89\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\xF3\xB1\x89\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xF3\xB1\x89\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\xF3\xB1\x89\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\xF3\xB1\x89\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\xF3\xB1\x89\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\xF3\xB1\x89\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\xF3\xB1\x89\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\xF3\xB1\x89\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\xF3\xB1\x89\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\xF3\xB1\x89\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xF3\xB1\x89\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xF3\xB1\x89\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\xF3\xB1\x89\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\xF3\xB1\x89\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\xF3\xB1\x89\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\xF3\xB1\x89\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\xF3\xB1\x89\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xF3\xB1\x89\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\xF3\xB1\x89\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xF3\xB1\x89\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\xF3\xB1\x89\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xF3\xB1\x89\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\xF3\xB1\x89\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\xF3\xB1\x89\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\xF3\xB1\x89\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\xF3\xB1\x89\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\xF3\xB1\x89\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\xF3\xB1\x8A\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\xF3\xB1\x8A\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xF3\xB1\x8A\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xF3\xB1\x8A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xF3\xB1\x8A\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\xF3\xB1\x8A\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xF3\xB1\x8A\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\xF3\xB1\x8A\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\xF3\xB1\x8A\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\xF3\xB1\x8A\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xF3\xB1\x8A\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xF3\xB1\x8A\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xF3\xB1\x8A\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\xF3\xB1\x8A\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xF3\xB1\x8A\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xF3\xB1\x8A\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\xF3\xB1\x8A\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xF3\xB1\x8A\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xF3\xB1\x8A\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\xF3\xB1\x8A\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xF3\xB1\x8A\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xF3\xB1\x8A\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xF3\xB1\x8A\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\xF3\xB1\x8A\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\xF3\xB1\x8A\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\xF3\xB1\x8A\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xF3\xB1\x8A\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xF3\xB1\x8A\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xF3\xB1\x8A\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xF3\xB1\x8A\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xF3\xB1\x8A\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\xF3\xB1\x8A\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xF3\xB1\x8A\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xF3\xB1\x8A\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xF3\xB1\x8A\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\xF3\xB1\x8A\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\xF3\xB1\x8A\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\xF3\xB1\x8A\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\xF3\xB1\x8A\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\xF3\xB1\x8A\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\xF3\xB1\x8A\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\xF3\xB1\x8A\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\xF3\xB1\x8A\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xF3\xB1\x8A\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\xF3\xB1\x8A\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xF3\xB1\x8A\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\xF3\xB1\x8A\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xF3\xB1\x8A\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xF3\xB1\x8A\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\xF3\xB1\x8A\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\xF3\xB1\x8A\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\xF3\xB1\x8A\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xF3\xB1\x8A\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\xF3\xB1\x8A\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\xF3\xB1\x8A\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xF3\xB1\x8A\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xF3\xB1\x8A\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xF3\xB1\x8A\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\xF3\xB1\x8A\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xF3\xB1\x8A\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xF3\xB1\x8A\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xF3\xB1\x8A\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xF3\xB1\x8A\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\xF3\xB1\x8A\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xF3\xB1\x8B\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xF3\xB1\x8B\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xF3\xB1\x8B\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xF3\xB1\x8B\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xF3\xB1\x8B\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xF3\xB1\x8B\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xF3\xB1\x8B\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xF3\xB1\x8B\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xF3\xB1\x8B\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xF3\xB1\x8B\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\xF3\xB1\x8B\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xF3\xB1\x8B\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xF3\xB1\x8B\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xF3\xB1\x8B\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\xF3\xB1\x8B\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\xF3\xB1\x8B\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xF3\xB1\x8B\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xF3\xB1\x8B\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xF3\xB1\x8B\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xF3\xB1\x8B\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xF3\xB1\x8B\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xF3\xB1\x8B\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xF3\xB1\x8B\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xF3\xB1\x8B\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xF3\xB1\x8B\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xF3\xB1\x8B\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xF3\xB1\x8B\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xF3\xB1\x8B\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xF3\xB1\x8B\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xF3\xB1\x8B\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\xF3\xB1\x8B\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\xF3\xB1\x8B\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xF3\xB1\x8B\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\xF3\xB1\x8B\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xF3\xB1\x8B\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xF3\xB1\x8B\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xF3\xB1\x8B\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xF3\xB1\x8B\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xF3\xB1\x8B\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xF3\xB1\x8B\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xF3\xB1\x8B\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xF3\xB1\x8B\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\xF3\xB1\x8B\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xF3\xB1\x8B\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xF3\xB1\x8B\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xF3\xB1\x8B\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xF3\xB1\x8B\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xF3\xB1\x8B\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xF3\xB1\x8B\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xF3\xB1\x8B\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xF3\xB1\x8B\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xF3\xB1\x8B\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xF3\xB1\x8B\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xF3\xB1\x8B\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xF3\xB1\x8B\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xF3\xB1\x8B\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xF3\xB1\x8B\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xF3\xB1\x8B\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\xF3\xB1\x8B\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\xF3\xB1\x8B\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\xF3\xB1\x8B\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\xF3\xB1\x8B\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xF3\xB1\x8B\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xF3\xB1\x8B\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\xF3\xB1\x8C\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xF3\xB1\x8C\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xF3\xB1\x8C\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\xF3\xB1\x8C\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xF3\xB1\x8C\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xF3\xB1\x8C\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\xF3\xB1\x8C\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xF3\xB1\x8C\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\xF3\xB1\x8C\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xF3\xB1\x8C\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\xF3\xB1\x8C\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\xF3\xB1\x8C\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\xF3\xB1\x8C\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xF3\xB1\x8C\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xF3\xB1\x8C\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xF3\xB1\x8C\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xF3\xB1\x8C\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xF3\xB1\x8C\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xF3\xB1\x8C\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xF3\xB1\x8C\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xF3\xB1\x8C\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xF3\xB1\x8C\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xF3\xB1\x8C\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xF3\xB1\x8C\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\xF3\xB1\x8C\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xF3\xB1\x8C\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\xF3\xB1\x8C\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xF3\xB1\x8C\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\xF3\xB1\x8C\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\xF3\xB1\x8C\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xF3\xB1\x8C\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xF3\xB1\x8C\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xF3\xB1\x8C\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xF3\xB1\x8C\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xF3\xB1\x8C\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xF3\xB1\x8C\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xF3\xB1\x8C\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xF3\xB1\x8C\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xF3\xB1\x8C\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xF3\xB1\x8C\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\xF3\xB1\x8C\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\xF3\xB1\x8C\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\xF3\xB1\x8C\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xF3\xB1\x8C\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\xF3\xB1\x8C\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\xF3\xB1\x8C\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xF3\xB1\x8C\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xF3\xB1\x8C\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xF3\xB1\x8C\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xF3\xB1\x8C\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xF3\xB1\x8C\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xF3\xB1\x8C\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xF3\xB1\x8C\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xF3\xB1\x8C\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xF3\xB1\x8C\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xF3\xB1\x8C\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xF3\xB1\x8C\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\xF3\xB1\x8C\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\xF3\xB1\x8C\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\xF3\xB1\x8C\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\xF3\xB1\x8C\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xF3\xB1\x8C\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xF3\xB1\x8C\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\xF3\xB1\x8C\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xF3\xB1\x8D\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xF3\xB1\x8D\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xF3\xB1\x8D\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xF3\xB1\x8D\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xF3\xB1\x8D\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xF3\xB1\x8D\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xF3\xB1\x8D\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xF3\xB1\x8D\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xF3\xB1\x8D\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\xF3\xB1\x8D\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xF3\xB1\x8D\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xF3\xB1\x8D\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xF3\xB1\x8D\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\xF3\xB1\x8D\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xF3\xB1\x8D\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xF3\xB1\x8D\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xF3\xB1\x8D\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xF3\xB1\x8D\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xF3\xB1\x8D\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xF3\xB1\x8D\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xF3\xB1\x8D\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xF3\xB1\x8D\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xF3\xB1\x8D\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xF3\xB1\x8D\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xF3\xB1\x8D\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xF3\xB1\x8D\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xF3\xB1\x8D\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xF3\xB1\x8D\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xF3\xB1\x8D\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xF3\xB1\x8D\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xF3\xB1\x8D\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\xF3\xB1\x8D\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\xF3\xB1\x8D\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xF3\xB1\x8D\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xF3\xB1\x8D\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xF3\xB1\x8D\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\xF3\xB1\x8D\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\xF3\xB1\x8D\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xF3\xB1\x8D\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xF3\xB1\x8D\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\xF3\xB1\x8D\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\xF3\xB1\x8D\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\xF3\xB1\x8D\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\xF3\xB1\x8D\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xF3\xB1\x8D\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xF3\xB1\x8D\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xF3\xB1\x8D\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xF3\xB1\x8D\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\xF3\xB1\x8D\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xF3\xB1\x8D\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\xF3\xB1\x8D\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xF3\xB1\x8D\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xF3\xB1\x8D\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xF3\xB1\x8D\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\xF3\xB1\x8D\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xF3\xB1\x8D\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\xF3\xB1\x8D\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xF3\xB1\x8D\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xF3\xB1\x8D\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\xF3\xB1\x8D\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xF3\xB1\x8D\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xF3\xB1\x8D\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xF3\xB1\x8D\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xF3\xB1\x8D\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xF3\xB1\x8E\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xF3\xB1\x8E\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xF3\xB1\x8E\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xF3\xB1\x8E\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xF3\xB1\x8E\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xF3\xB1\x8E\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xF3\xB1\x8E\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xF3\xB1\x8E\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xF3\xB1\x8E\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xF3\xB1\x8E\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\xF3\xB1\x8E\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xF3\xB1\x8E\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xF3\xB1\x8E\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xF3\xB1\x8E\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xF3\xB1\x8E\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xF3\xB1\x8E\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xF3\xB1\x8E\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xF3\xB1\x8E\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xF3\xB1\x8E\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xF3\xB1\x8E\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xF3\xB1\x8E\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xF3\xB1\x8E\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\xF3\xB1\x8E\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xF3\xB1\x8E\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xF3\xB1\x8E\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xF3\xB1\x8E\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xF3\xB1\x8E\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xF3\xB1\x8E\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xF3\xB1\x8E\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xF3\xB1\x8E\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xF3\xB1\x8E\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xF3\xB1\x8E\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xF3\xB1\x8E\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xF3\xB1\x8E\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xF3\xB1\x8E\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xF3\xB1\x8E\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xF3\xB1\x8E\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xF3\xB1\x8E\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\xF3\xB1\x8E\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xF3\xB1\x8E\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xF3\xB1\x8E\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xF3\xB1\x8E\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\xF3\xB1\x8E\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xF3\xB1\x8E\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xF3\xB1\x8E\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xF3\xB1\x8E\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xF3\xB1\x8E\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xF3\xB1\x8E\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xF3\xB1\x8E\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xF3\xB1\x8E\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xF3\xB1\x8E\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xF3\xB1\x8E\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xF3\xB1\x8E\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xF3\xB1\x8E\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xF3\xB1\x8E\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\xF3\xB1\x8E\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xF3\xB1\x8E\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xF3\xB1\x8E\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xF3\xB1\x8E\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xF3\xB1\x8E\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xF3\xB1\x8E\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xF3\xB1\x8E\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xF3\xB1\x8E\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xF3\xB1\x8E\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xF3\xB1\x8F\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\xF3\xB1\x8F\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xF3\xB1\x8F\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xF3\xB1\x8F\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\xF3\xB1\x8F\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xF3\xB1\x8F\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\xF3\xB1\x8F\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xF3\xB1\x8F\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\xF3\xB1\x8F\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xF3\xB1\x8F\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xF3\xB1\x8F\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xF3\xB1\x8F\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xF3\xB1\x8F\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xF3\xB1\x8F\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xF3\xB1\x8F\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xF3\xB1\x8F\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\xF3\xB1\x8F\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xF3\xB1\x8F\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xF3\xB1\x8F\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xF3\xB1\x8F\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xF3\xB1\x8F\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\xF3\xB1\x8F\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\xF3\xB1\x8F\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\xF3\xB1\x8F\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xF3\xB1\x8F\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\xF3\xB1\x8F\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xF3\xB1\x8F\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xF3\xB1\x8F\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xF3\xB1\x8F\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xF3\xB1\x8F\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xF3\xB1\x8F\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xF3\xB1\x8F\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xF3\xB1\x8F\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xF3\xB1\x8F\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xF3\xB1\x8F\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xF3\xB1\x8F\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xF3\xB1\x8F\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xF3\xB1\x8F\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xF3\xB1\x8F\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xF3\xB1\x8F\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xF3\xB1\x8F\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\xF3\xB1\x8F\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xF3\xB1\x8F\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xF3\xB1\x8F\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xF3\xB1\x8F\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xF3\xB1\x8F\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xF3\xB1\x8F\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xF3\xB1\x8F\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xF3\xB1\x8F\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xF3\xB1\x8F\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xF3\xB1\x8F\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xF3\xB1\x8F\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xF3\xB1\x8F\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\xF3\xB1\x8F\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xF3\xB1\x8F\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\xF3\xB1\x8F\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xF3\xB1\x8F\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\xF3\xB1\x8F\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xF3\xB1\x8F\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xF3\xB1\x8F\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xF3\xB1\x8F\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xF3\xB1\x8F\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xF3\xB1\x8F\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xF3\xB1\x8F\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xF3\xB1\x90\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xF3\xB1\x90\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xF3\xB1\x90\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xF3\xB1\x90\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xF3\xB1\x90\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xF3\xB1\x90\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xF3\xB1\x90\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xF3\xB1\x90\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xF3\xB1\x90\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xF3\xB1\x90\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xF3\xB1\x90\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xF3\xB1\x90\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xF3\xB1\x90\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xF3\xB1\x90\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xF3\xB1\x90\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xF3\xB1\x90\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xF3\xB1\x90\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xF3\xB1\x90\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xF3\xB1\x90\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xF3\xB1\x90\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xF3\xB1\x90\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xF3\xB1\x90\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xF3\xB1\x90\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\xF3\xB1\x90\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\xF3\xB1\x90\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xF3\xB1\x90\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\xF3\xB1\x90\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\xF3\xB1\x90\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\xF3\xB1\x90\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xF3\xB1\x90\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\xF3\xB1\x90\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\xF3\xB1\x90\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xF3\xB1\x90\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xF3\xB1\x90\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xF3\xB1\x90\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xF3\xB1\x90\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\xF3\xB1\x90\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xF3\xB1\x90\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\xF3\xB1\x90\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xF3\xB1\x90\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xF3\xB1\x90\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xF3\xB1\x90\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\xF3\xB1\x90\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xF3\xB1\x90\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xF3\xB1\x90\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\xF3\xB1\x90\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xF3\xB1\x90\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xF3\xB1\x90\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\xF3\xB1\x90\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xF3\xB1\x90\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\xF3\xB1\x90\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xF3\xB1\x90\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xF3\xB1\x90\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xF3\xB1\x90\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xF3\xB1\x90\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xF3\xB1\x90\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xF3\xB1\x90\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xF3\xB1\x90\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xF3\xB1\x90\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xF3\xB1\x90\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xF3\xB1\x90\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xF3\xB1\x90\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xF3\xB1\x90\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xF3\xB1\x90\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xF3\xB1\x91\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xF3\xB1\x91\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xF3\xB1\x91\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\xF3\xB1\x91\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xF3\xB1\x91\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xF3\xB1\x91\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\xF3\xB1\x91\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xF3\xB1\x91\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xF3\xB1\x91\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xF3\xB1\x91\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xF3\xB1\x91\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xF3\xB1\x91\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xF3\xB1\x91\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xF3\xB1\x91\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xF3\xB1\x91\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xF3\xB1\x91\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xF3\xB1\x91\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xF3\xB1\x91\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xF3\xB1\x91\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\xF3\xB1\x91\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xF3\xB1\x91\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xF3\xB1\x91\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\xF3\xB1\x91\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\xF3\xB1\x91\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xF3\xB1\x91\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\xF3\xB1\x91\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xF3\xB1\x91\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xF3\xB1\x91\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xF3\xB1\x91\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xF3\xB1\x91\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xF3\xB1\x91\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xF3\xB1\x91\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xF3\xB1\x91\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xF3\xB1\x91\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\xF3\xB1\x91\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xF3\xB1\x91\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\xF3\xB1\x91\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\xF3\xB1\x91\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\xF3\xB1\x91\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xF3\xB1\x91\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xF3\xB1\x91\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xF3\xB1\x91\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xF3\xB1\x91\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xF3\xB1\x91\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xF3\xB1\x91\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xF3\xB1\x91\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xF3\xB1\x91\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xF3\xB1\x91\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xF3\xB1\x91\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xF3\xB1\x91\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\xF3\xB1\x91\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\xF3\xB1\x91\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\xF3\xB1\x91\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\xF3\xB1\x91\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\xF3\xB1\x91\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\xF3\xB1\x91\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\xF3\xB1\x91\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\xF3\xB1\x91\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\xF3\xB1\x91\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\xF3\xB1\x91\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\xF3\xB1\x91\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\xF3\xB1\x91\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\xF3\xB1\x91\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\xF3\xB1\x91\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\xF3\xB1\x92\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\xF3\xB1\x92\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\xF3\xB1\x92\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\xF3\xB1\x92\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\xF3\xB1\x92\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\xF3\xB1\x92\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\xF3\xB1\x92\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\xF3\xB1\x92\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\xF3\xB1\x92\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\xF3\xB1\x92\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\xF3\xB1\x92\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\xF3\xB1\x92\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\xF3\xB1\x92\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\xF3\xB1\x92\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xF3\xB1\x92\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xF3\xB1\x92\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xF3\xB1\x92\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xF3\xB1\x92\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xF3\xB1\x92\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xF3\xB1\x92\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xF3\xB1\x92\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xF3\xB1\x92\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xF3\xB1\x92\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xF3\xB1\x92\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xF3\xB1\x92\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xF3\xB1\x92\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xF3\xB1\x92\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xF3\xB1\x92\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xF3\xB1\x92\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xF3\xB1\x92\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xF3\xB1\x92\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xF3\xB1\x92\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xF3\xB1\x92\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xF3\xB1\x92\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\xF3\xB1\x92\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\xF3\xB1\x92\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\xF3\xB1\x92\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\xF3\xB1\x92\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xF3\xB1\x92\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xF3\xB1\x92\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xF3\xB1\x92\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xF3\xB1\x92\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xF3\xB1\x92\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xF3\xB1\x92\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xF3\xB1\x92\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xF3\xB1\x92\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xF3\xB1\x92\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xF3\xB1\x92\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\xF3\xB1\x92\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\xF3\xB1\x92\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xF3\xB1\x92\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xF3\xB1\x92\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\xF3\xB1\x92\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xF3\xB1\x92\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xF3\xB1\x92\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\xF3\xB1\x92\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xF3\xB1\x92\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xF3\xB1\x92\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\xF3\xB1\x92\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\xF3\xB1\x92\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xF3\xB1\x92\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\xF3\xB1\x92\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\xF3\xB1\x92\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\xF3\xB1\x92\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\xF3\xB1\x93\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\xF3\xB1\x93\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xF3\xB1\x93\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xF3\xB1\x93\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\xF3\xB1\x93\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\xF3\xB1\x93\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xF3\xB1\x93\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xF3\xB1\x93\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xF3\xB1\x93\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xF3\xB1\x93\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xF3\xB1\x93\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xF3\xB1\x93\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xF3\xB1\x93\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xF3\xB1\x93\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xF3\xB1\x93\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xF3\xB1\x93\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xF3\xB1\x93\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xF3\xB1\x93\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xF3\xB1\x93\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\xF3\xB1\x93\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\xF3\xB1\x93\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xF3\xB1\x93\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\xF3\xB1\x93\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\xF3\xB1\x93\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\xF3\xB1\x93\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\xF3\xB1\x93\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\xF3\xB1\x93\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\xF3\xB1\x93\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\xF3\xB1\x93\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\xF3\xB1\x93\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\xF3\xB1\x93\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xF3\xB1\x93\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\xF3\xB1\x93\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\xF3\xB1\x93\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\xF3\xB1\x93\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\xF3\xB1\x93\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xF3\xB1\x93\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\xF3\xB1\x93\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\xF3\xB1\x93\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\xF3\xB1\x93\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\xF3\xB1\x93\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\xF3\xB1\x93\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\xF3\xB1\x93\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\xF3\xB1\x93\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\xF3\xB1\x93\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\xF3\xB1\x93\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\xF3\xB1\x93\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\xF3\xB1\x93\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\xF3\xB1\x93\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\xF3\xB1\x93\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\xF3\xB1\x93\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xF3\xB1\x93\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xF3\xB1\x93\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xF3\xB1\x93\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xF3\xB1\x93\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xF3\xB1\x93\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xF3\xB1\x93\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xF3\xB1\x93\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xF3\xB1\x93\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xF3\xB1\x93\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xF3\xB1\x93\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\xF3\xB1\x93\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\xF3\xB1\x93\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\xF3\xB1\x94\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\xF3\xB1\x94\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\xF3\xB1\x94\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\xF3\xB1\x94\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xF3\xB1\x94\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xF3\xB1\x94\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xF3\xB1\x94\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xF3\xB1\x94\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xF3\xB1\x94\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xF3\xB1\x94\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xF3\xB1\x94\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xF3\xB1\x94\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xF3\xB1\x94\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xF3\xB1\x94\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\xF3\xB1\x94\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\xF3\xB1\x94\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\xF3\xB1\x94\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\xF3\xB1\x94\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\xF3\xB1\x94\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\xF3\xB1\x94\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xF3\xB1\x94\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\xF3\xB1\x94\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xF3\xB1\x94\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xF3\xB1\x94\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xF3\xB1\x94\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xF3\xB1\x94\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xF3\xB1\x94\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xF3\xB1\x94\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xF3\xB1\x94\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xF3\xB1\x94\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\xF3\xB1\x94\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\xF3\xB1\x94\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\xF3\xB1\x94\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\xF3\xB1\x94\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\xF3\xB1\x94\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\xF3\xB1\x94\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xF3\xB1\x94\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xF3\xB1\x94\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xF3\xB1\x94\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xF3\xB1\x94\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xF3\xB1\x94\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xF3\xB1\x94\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xF3\xB1\x94\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xF3\xB1\x94\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xF3\xB1\x94\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xF3\xB1\x94\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\xF3\xB1\x94\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\xF3\xB1\x94\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\xF3\xB1\x94\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\xF3\xB1\x94\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\xF3\xB1\x94\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xF3\xB1\x94\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xF3\xB1\x94\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xF3\xB1\x94\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xF3\xB1\x94\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\xF3\xB1\x94\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\xF3\xB1\x94\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\xF3\xB1\x94\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xF3\xB1\x94\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xF3\xB1\x94\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xF3\xB1\x94\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xF3\xB1\x94\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xF3\xB1\x94\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xF3\xB1\x94\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xF3\xB1\x95\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xF3\xB1\x95\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xF3\xB1\x95\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xF3\xB1\x95\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\xF3\xB1\x95\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\xF3\xB1\x95\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\xF3\xB1\x95\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xF3\xB1\x95\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xF3\xB1\x95\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xF3\xB1\x95\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\xF3\xB1\x95\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xF3\xB1\x95\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xF3\xB1\x95\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\xF3\xB1\x95\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\xF3\xB1\x95\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xF3\xB1\x95\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xF3\xB1\x95\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xF3\xB1\x95\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xF3\xB1\x95\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xF3\xB1\x95\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xF3\xB1\x95\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xF3\xB1\x95\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xF3\xB1\x95\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xF3\xB1\x95\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xF3\xB1\x95\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xF3\xB1\x95\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xF3\xB1\x95\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xF3\xB1\x95\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xF3\xB1\x95\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\xF3\xB1\x95\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xF3\xB1\x95\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xF3\xB1\x95\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xF3\xB1\x95\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\xF3\xB1\x95\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xF3\xB1\x95\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xF3\xB1\x95\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xF3\xB1\x95\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xF3\xB1\x95\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xF3\xB1\x95\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xF3\xB1\x95\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xF3\xB1\x95\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xF3\xB1\x95\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xF3\xB1\x95\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xF3\xB1\x95\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\xF3\xB1\x95\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\xF3\xB1\x95\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\xF3\xB1\x95\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xF3\xB1\x95\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xF3\xB1\x95\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\xF3\xB1\x95\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xF3\xB1\x95\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\xF3\xB1\x95\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xF3\xB1\x95\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xF3\xB1\x95\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xF3\xB1\x95\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xF3\xB1\x95\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xF3\xB1\x95\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xF3\xB1\x95\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xF3\xB1\x95\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xF3\xB1\x95\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\xF3\xB1\x95\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\xF3\xB1\x95\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\xF3\xB1\x95\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xF3\xB1\x95\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xF3\xB1\x96\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\xF3\xB1\x96\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xF3\xB1\x96\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xF3\xB1\x96\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xF3\xB1\x96\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xF3\xB1\x96\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xF3\xB1\x96\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xF3\xB1\x96\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xF3\xB1\x96\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xF3\xB1\x96\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xF3\xB1\x96\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xF3\xB1\x96\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xF3\xB1\x96\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\xF3\xB1\x96\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xF3\xB1\x96\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\xF3\xB1\x96\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xF3\xB1\x96\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xF3\xB1\x96\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\xF3\xB1\x96\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\xF3\xB1\x96\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\xF3\xB1\x96\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\xF3\xB1\x96\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\xF3\xB1\x96\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\xF3\xB1\x96\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\xF3\xB1\x96\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\xF3\xB1\x96\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\xF3\xB1\x96\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xF3\xB1\x96\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\xF3\xB1\x96\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\xF3\xB1\x96\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\xF3\xB1\x96\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\xF3\xB1\x96\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xF3\xB1\x96\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\xF3\xB1\x96\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\xF3\xB1\x96\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\xF3\xB1\x96\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\xF3\xB1\x96\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\xF3\xB1\x96\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\xF3\xB1\x96\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\xF3\xB1\x96\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\xF3\xB1\x96\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\xF3\xB1\x96\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\xF3\xB1\x96\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\xF3\xB1\x96\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\xF3\xB1\x96\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\xF3\xB1\x96\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\xF3\xB1\x96\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\xF3\xB1\x96\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xF3\xB1\x96\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xF3\xB1\x96\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xF3\xB1\x96\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xF3\xB1\x96\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xF3\xB1\x96\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xF3\xB1\x96\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xF3\xB1\x96\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xF3\xB1\x96\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xF3\xB1\x96\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xF3\xB1\x96\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\xF3\xB1\x96\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\xF3\xB1\x96\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\xF3\xB1\x96\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\xF3\xB1\x96\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\xF3\xB1\x96\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\xF3\xB1\x96\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xF3\xB1\x97\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xF3\xB1\x97\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xF3\xB1\x97\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xF3\xB1\x97\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xF3\xB1\x97\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xF3\xB1\x97\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xF3\xB1\x97\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xF3\xB1\x97\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xF3\xB1\x97\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xF3\xB1\x97\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\xF3\xB1\x97\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\xF3\xB1\x97\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\xF3\xB1\x97\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\xF3\xB1\x97\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\xF3\xB1\x97\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\xF3\xB1\x97\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xF3\xB1\x97\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\xF3\xB1\x97\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xF3\xB1\x97\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xF3\xB1\x97\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xF3\xB1\x97\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xF3\xB1\x97\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xF3\xB1\x97\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xF3\xB1\x97\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xF3\xB1\x97\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xF3\xB1\x97\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\xF3\xB1\x97\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\xF3\xB1\x97\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\xF3\xB1\x97\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\xF3\xB1\x97\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\xF3\xB1\x97\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\xF3\xB1\x97\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xF3\xB1\x97\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xF3\xB1\x97\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xF3\xB1\x97\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xF3\xB1\x97\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xF3\xB1\x97\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xF3\xB1\x97\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xF3\xB1\x97\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xF3\xB1\x97\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xF3\xB1\x97\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xF3\xB1\x97\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\xF3\xB1\x97\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\xF3\xB1\x97\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\xF3\xB1\x97\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\xF3\xB1\x97\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\xF3\xB1\x97\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\xF3\xB1\x97\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\xF3\xB1\x97\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\xF3\xB1\x97\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\xF3\xB1\x97\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\xF3\xB1\x97\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\xF3\xB1\x97\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\xF3\xB1\x97\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\xF3\xB1\x97\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\xF3\xB1\x97\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\xF3\xB1\x97\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\xF3\xB1\x97\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\xF3\xB1\x97\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\xF3\xB1\x97\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\xF3\xB1\x97\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\xF3\xB1\x97\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\xF3\xB1\x97\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\xF3\xB1\x97\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\xF3\xB1\x98\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\xF3\xB1\x98\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\xF3\xB1\x98\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\xF3\xB1\x98\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\xF3\xB1\x98\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\xF3\xB1\x98\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\xF3\xB1\x98\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\xF3\xB1\x98\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\xF3\xB1\x98\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\xF3\xB1\x98\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\xF3\xB1\x98\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\xF3\xB1\x98\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\xF3\xB1\x98\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\xF3\xB1\x98\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\xF3\xB1\x98\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\xF3\xB1\x98\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\xF3\xB1\x98\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\xF3\xB1\x98\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\xF3\xB1\x98\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\xF3\xB1\x98\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\xF3\xB1\x98\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\xF3\xB1\x98\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\xF3\xB1\x98\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\xF3\xB1\x98\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\xF3\xB1\x98\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\xF3\xB1\x98\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\xF3\xB1\x98\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\xF3\xB1\x98\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\xF3\xB1\x98\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\xF3\xB1\x98\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\xF3\xB1\x98\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\xF3\xB1\x98\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\xF3\xB1\x98\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\xF3\xB1\x98\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\xF3\xB1\x98\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\xF3\xB1\x98\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\xF3\xB1\x98\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\xF3\xB1\x98\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\xF3\xB1\x98\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\xF3\xB1\x98\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\xF3\xB1\x98\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\xF3\xB1\x98\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\xF3\xB1\x98\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\xF3\xB1\x98\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xF3\xB1\x98\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xF3\xB1\x98\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\xF3\xB1\x98\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\xF3\xB1\x98\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\xF3\xB1\x98\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\xF3\xB1\x98\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\xF3\xB1\x98\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\xF3\xB1\x98\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\xF3\xB1\x98\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\xF3\xB1\x98\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\xF3\xB1\x98\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\xF3\xB1\x98\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\xF3\xB1\x98\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\xF3\xB1\x98\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\xF3\xB1\x98\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\xF3\xB1\x98\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\xF3\xB1\x98\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\xF3\xB1\x98\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\xF3\xB1\x98\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\xF3\xB1\x98\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\xF3\xB1\x99\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\xF3\xB1\x99\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\xF3\xB1\x99\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\xF3\xB1\x99\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\xF3\xB1\x99\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\xF3\xB1\x99\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\xF3\xB1\x99\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\xF3\xB1\x99\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\xF3\xB1\x99\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\xF3\xB1\x99\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\xF3\xB1\x99\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\xF3\xB1\x99\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\xF3\xB1\x99\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\xF3\xB1\x99\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\xF3\xB1\x99\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\xF3\xB1\x99\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\xF3\xB1\x99\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\xF3\xB1\x99\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\xF3\xB1\x99\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\xF3\xB1\x99\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\xF3\xB1\x99\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\xF3\xB1\x99\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\xF3\xB1\x99\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\xF3\xB1\x99\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\xF3\xB1\x99\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\xF3\xB1\x99\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\xF3\xB1\x99\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\xF3\xB1\x99\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\xF3\xB1\x99\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\xF3\xB1\x99\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\xF3\xB1\x99\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\xF3\xB1\x99\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\xF3\xB1\x99\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\xF3\xB1\x99\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\xF3\xB1\x99\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\xF3\xB1\x99\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\xF3\xB1\x99\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\xF3\xB1\x99\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\xF3\xB1\x99\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\xF3\xB1\x99\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\xF3\xB1\x99\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\xF3\xB1\x99\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\xF3\xB1\x99\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\xF3\xB1\x99\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\xF3\xB1\x99\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\xF3\xB1\x99\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\xF3\xB1\x99\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\xF3\xB1\x99\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\xF3\xB1\x99\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\xF3\xB1\x99\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\xF3\xB1\x99\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\xF3\xB1\x99\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\xF3\xB1\x99\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\xF3\xB1\x99\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\xF3\xB1\x99\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\xF3\xB1\x99\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\xF3\xB1\x99\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\xF3\xB1\x99\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\xF3\xB1\x99\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\xF3\xB1\x99\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\xF3\xB1\x99\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\xF3\xB1\x99\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\xF3\xB1\x99\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\xF3\xB1\x99\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\xF3\xB1\x9A\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\xF3\xB1\x9A\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\xF3\xB1\x9A\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\xF3\xB1\x9A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xF3\xB1\x9A\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\xF3\xB1\x9A\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\xF3\xB1\x9A\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\xF3\xB1\x9A\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\xF3\xB1\x9A\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\xF3\xB1\x9A\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\xF3\xB1\x9A\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\xF3\xB1\x9A\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\xF3\xB1\x9A\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\xF3\xB1\x9A\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\xF3\xB1\x9A\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\xF3\xB1\x9A\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\xF3\xB1\x9A\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\xF3\xB1\x9A\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\xF3\xB1\x9A\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\xF3\xB1\x9A\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\xF3\xB1\x9A\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\xF3\xB1\x9A\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\xF3\xB1\x9A\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\xF3\xB1\x9A\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\xF3\xB1\x9A\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xF3\xB1\x9A\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\xF3\xB1\x9A\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\xF3\xB1\x9A\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\xF3\xB1\x9A\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\xF3\xB1\x9A\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\xF3\xB1\x9A\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\xF3\xB1\x9A\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\xF3\xB1\x9A\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\xF3\xB1\x9A\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\xF3\xB1\x9A\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\xF3\xB1\x9A\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\xF3\xB1\x9A\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\xF3\xB1\x9A\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\xF3\xB1\x9A\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\xF3\xB1\x9A\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\xF3\xB1\x9A\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\xF3\xB1\x9A\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\xF3\xB1\x9A\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\xF3\xB1\x9A\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\xF3\xB1\x9A\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\xF3\xB1\x9A\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\xF3\xB1\x9A\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\xF3\xB1\x9A\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\xF3\xB1\x9A\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\xF3\xB1\x9A\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\xF3\xB1\x9A\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\xF3\xB1\x9A\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\xF3\xB1\x9A\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\xF3\xB1\x9A\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\xF3\xB1\x9A\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\xF3\xB1\x9A\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\xF3\xB1\x9A\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\xF3\xB1\x9A\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\xF3\xB1\x9A\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\xF3\xB1\x9A\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\xF3\xB1\x9A\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\xF3\xB1\x9A\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\xF3\xB1\x9A\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\xF3\xB1\x9A\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\xF3\xB1\x9B\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\xF3\xB1\x9B\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\xF3\xB1\x9B\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\xF3\xB1\x9B\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\xF3\xB1\x9B\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\xF3\xB1\x9B\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\xF3\xB1\x9B\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\xF3\xB1\x9B\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\xF3\xB1\x9B\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\xF3\xB1\x9B\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\xF3\xB1\x9B\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\xF3\xB1\x9B\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\xF3\xB1\x9B\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\xF3\xB1\x9B\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\xF3\xB1\x9B\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\xF3\xB1\x9B\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\xF3\xB1\x9B\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\xF3\xB1\x9B\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\xF3\xB1\x9B\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\xF3\xB1\x9B\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\xF3\xB1\x9B\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\xF3\xB1\x9B\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\xF3\xB1\x9B\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\xF3\xB1\x9B\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\xF3\xB1\x9B\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\xF3\xB1\x9B\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\xF3\xB1\x9B\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\xF3\xB1\x9B\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\xF3\xB1\x9B\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\xF3\xB1\x9B\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\xF3\xB1\x9B\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\xF3\xB1\x9B\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\xF3\xB1\x9B\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\xF3\xB1\x9B\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\xF3\xB1\x9B\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\xF3\xB1\x9B\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\xF3\xB1\x9B\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\xF3\xB1\x9B\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\xF3\xB1\x9B\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\xF3\xB1\x9B\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\xF3\xB1\x9B\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\xF3\xB1\x9B\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\xF3\xB1\x9B\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\xF3\xB1\x9B\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\xF3\xB1\x9B\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\xF3\xB1\x9B\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\xF3\xB1\x9B\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\xF3\xB1\x9B\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\xF3\xB1\x9B\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\xF3\xB1\x9B\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\xF3\xB1\x9B\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\xF3\xB1\x9B\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\xF3\xB1\x9B\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\xF3\xB1\x9B\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\xF3\xB1\x9B\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\xF3\xB1\x9B\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\xF3\xB1\x9B\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\xF3\xB1\x9B\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\xF3\xB1\x9B\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\xF3\xB1\x9B\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\xF3\xB1\x9B\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\xF3\xB1\x9B\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\xF3\xB1\x9B\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\xF3\xB1\x9B\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\xF3\xB1\x9C\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\xF3\xB1\x9C\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\xF3\xB1\x9C\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\xF3\xB1\x9C\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\xF3\xB1\x9C\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\xF3\xB1\x9C\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\xF3\xB1\x9C\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\xF3\xB1\x9C\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\xF3\xB1\x9C\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\xF3\xB1\x9C\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\xF3\xB1\x9C\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\xF3\xB1\x9C\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\xF3\xB1\x9C\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\xF3\xB1\x9C\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\xF3\xB1\x9C\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\xF3\xB1\x9C\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\xF3\xB1\x9C\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\xF3\xB1\x9C\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\xF3\xB1\x9C\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\xF3\xB1\x9C\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\xF3\xB1\x9C\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\xF3\xB1\x9C\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\xF3\xB1\x9C\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\xF3\xB1\x9C\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\xF3\xB1\x9C\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\xF3\xB1\x9C\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\xF3\xB1\x9C\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\xF3\xB1\x9C\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\xF3\xB1\x9C\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\xF3\xB1\x9C\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\xF3\xB1\x9C\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xF3\xB1\x9C\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\xF3\xB1\x9C\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\xF3\xB1\x9C\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\xF3\xB1\x9C\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\xF3\xB1\x9C\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\xF3\xB1\x9C\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\xF3\xB1\x9C\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\xF3\xB1\x9C\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\xF3\xB1\x9C\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\xF3\xB1\x9C\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\xF3\xB1\x9C\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\xF3\xB1\x9C\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\xF3\xB1\x9C\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\xF3\xB1\x9C\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\xF3\xB1\x9C\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\xF3\xB1\x9C\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\xF3\xB1\x9C\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\xF3\xB1\x9C\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\xF3\xB1\x9C\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\xF3\xB1\x9C\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\xF3\xB1\x9C\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\xF3\xB1\x9C\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\xF3\xB1\x9C\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\xF3\xB1\x9C\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\xF3\xB1\x9C\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\xF3\xB1\x9C\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\xF3\xB1\x9C\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\xF3\xB1\x9C\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\xF3\xB1\x9C\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\xF3\xB1\x9C\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\xF3\xB1\x9C\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\xF3\xB1\x9C\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\xF3\xB1\x9C\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\xF3\xB1\x9D\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\xF3\xB1\x9D\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\xF3\xB1\x9D\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\xF3\xB1\x9D\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\xF3\xB1\x9D\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\xF3\xB1\x9D\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\xF3\xB1\x9D\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\xF3\xB1\x9D\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\xF3\xB1\x9D\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\xF3\xB1\x9D\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\xF3\xB1\x9D\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\xF3\xB1\x9D\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\xF3\xB1\x9D\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\xF3\xB1\x9D\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\xF3\xB1\x9D\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\xF3\xB1\x9D\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\xF3\xB1\x9D\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\xF3\xB1\x9D\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\xF3\xB1\x9D\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\xF3\xB1\x9D\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\xF3\xB1\x9D\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\xF3\xB1\x9D\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\xF3\xB1\x9D\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\xF3\xB1\x9D\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\xF3\xB1\x9D\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\xF3\xB1\x9D\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\xF3\xB1\x9D\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\xF3\xB1\x9D\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\xF3\xB1\x9D\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\xF3\xB1\x9D\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\xF3\xB1\x9D\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\xF3\xB1\x9D\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\xF3\xB1\x9D\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\xF3\xB1\x9D\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\xF3\xB1\x9D\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\xF3\xB1\x9D\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\xF3\xB1\x9D\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\xF3\xB1\x9D\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\xF3\xB1\x9D\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\xF3\xB1\x9D\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\xF3\xB1\x9D\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\xF3\xB1\x9D\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\xF3\xB1\x9D\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\xF3\xB1\x9D\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\xF3\xB1\x9D\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\xF3\xB1\x9D\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\xF3\xB1\x9D\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\xF3\xB1\x9D\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\xF3\xB1\x9D\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\xF3\xB1\x9D\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\xF3\xB1\x9D\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\xF3\xB1\x9D\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\xF3\xB1\x9D\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\xF3\xB1\x9D\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\xF3\xB1\x9D\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\xF3\xB1\x9D\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\xF3\xB1\x9D\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\xF3\xB1\x9D\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\xF3\xB1\x9D\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\xF3\xB1\x9D\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\xF3\xB1\x9D\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\xF3\xB1\x9D\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\xF3\xB1\x9D\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xF3\xB1\x9D\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\xF3\xB1\x9E\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\xF3\xB1\x9E\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\xF3\xB1\x9E\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\xF3\xB1\x9E\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\xF3\xB1\x9E\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\xF3\xB1\x9E\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\xF3\xB1\x9E\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\xF3\xB1\x9E\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\xF3\xB1\x9E\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\xF3\xB1\x9E\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\xF3\xB1\x9E\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\xF3\xB1\x9E\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\xF3\xB1\x9E\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\xF3\xB1\x9E\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\xF3\xB1\x9E\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\xF3\xB1\x9E\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\xF3\xB1\x9E\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\xF3\xB1\x9E\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\xF3\xB1\x9E\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\xF3\xB1\x9E\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\xF3\xB1\x9E\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\xF3\xB1\x9E\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\xF3\xB1\x9E\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\xF3\xB1\x9E\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\xF3\xB1\x9E\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\xF3\xB1\x9E\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\xF3\xB1\x9E\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\xF3\xB1\x9E\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\xF3\xB1\x9E\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\xF3\xB1\x9E\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\xF3\xB1\x9E\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\xF3\xB1\x9E\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\xF3\xB1\x9E\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\xF3\xB1\x9E\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\xF3\xB1\x9E\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\xF3\xB1\x9E\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\xF3\xB1\x9E\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\xF3\xB1\x9E\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\xF3\xB1\x9E\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\xF3\xB1\x9E\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\xF3\xB1\x9E\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\xF3\xB1\x9E\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\xF3\xB1\x9E\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\xF3\xB1\x9E\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\xF3\xB1\x9E\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\xF3\xB1\x9E\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\xF3\xB1\x9E\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\xF3\xB1\x9E\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\xF3\xB1\x9E\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\xF3\xB1\x9E\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\xF3\xB1\x9E\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\xF3\xB1\x9E\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\xF3\xB1\x9E\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\xF3\xB1\x9E\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\xF3\xB1\x9E\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\xF3\xB1\x9E\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\xF3\xB1\x9E\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\xF3\xB1\x9E\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xF3\xB1\x9E\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xF3\xB1\x9E\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\xF3\xB1\x9E\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\xF3\xB1\x9E\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\xF3\xB1\x9E\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\xF3\xB1\x9E\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\xF3\xB1\x9F\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\xF3\xB1\x9F\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\xF3\xB1\x9F\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\xF3\xB1\x9F\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\xF3\xB1\x9F\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\xF3\xB1\x9F\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\xF3\xB1\x9F\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\xF3\xB1\x9F\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\xF3\xB1\x9F\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\xF3\xB1\x9F\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\xF3\xB1\x9F\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\xF3\xB1\x9F\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\xF3\xB1\x9F\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\xF3\xB1\x9F\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\xF3\xB1\x9F\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\xF3\xB1\x9F\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\xF3\xB1\x9F\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\xF3\xB1\x9F\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\xF3\xB1\x9F\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\xF3\xB1\x9F\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\xF3\xB1\x9F\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\xF3\xB1\x9F\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\xF3\xB1\x9F\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\xF3\xB1\x9F\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\xF3\xB1\x9F\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\xF3\xB1\x9F\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\xF3\xB1\x9F\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\xF3\xB1\x9F\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\xF3\xB1\x9F\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\xF3\xB1\x9F\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\xF3\xB1\x9F\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\xF3\xB1\x9F\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\xF3\xB1\x9F\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\xF3\xB1\x9F\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\xF3\xB1\x9F\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\xF3\xB1\x9F\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\xF3\xB1\x9F\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\xF3\xB1\x9F\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\xF3\xB1\x9F\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\xF3\xB1\x9F\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\xF3\xB1\x9F\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\xF3\xB1\x9F\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\xF3\xB1\x9F\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\xF3\xB1\x9F\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\xF3\xB1\x9F\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\xF3\xB1\x9F\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\xF3\xB1\x9F\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\xF3\xB1\x9F\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\xF3\xB1\x9F\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\xF3\xB1\x9F\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\xF3\xB1\x9F\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\xF3\xB1\x9F\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\xF3\xB1\x9F\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\xF3\xB1\x9F\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\xF3\xB1\x9F\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\xF3\xB1\x9F\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\xF3\xB1\x9F\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\xF3\xB1\x9F\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xF3\xB1\x9F\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\xF3\xB1\x9F\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\xF3\xB1\x9F\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\xF3\xB1\x9F\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\xF3\xB1\x9F\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\xF3\xB1\x9F\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\xF3\xB1\xA0\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\xF3\xB1\xA0\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\xF3\xB1\xA0\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\xF3\xB1\xA0\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xF3\xB1\xA0\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\xF3\xB1\xA0\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\xF3\xB1\xA0\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\xF3\xB1\xA0\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\xF3\xB1\xA0\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xF3\xB1\xA0\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\xF3\xB1\xA0\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\xF3\xB1\xA0\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xF3\xB1\xA0\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\xF3\xB1\xA0\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\xF3\xB1\xA0\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\xF3\xB1\xA0\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\xF3\xB1\xA0\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\xF3\xB1\xA0\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\xF3\xB1\xA0\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\xF3\xB1\xA0\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\xF3\xB1\xA0\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\xF3\xB1\xA0\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\xF3\xB1\xA0\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\xF3\xB1\xA0\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\xF3\xB1\xA0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\xF3\xB1\xA0\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\xF3\xB1\xA0\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\xF3\xB1\xA0\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\xF3\xB1\xA0\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\xF3\xB1\xA0\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\xF3\xB1\xA0\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\xF3\xB1\xA0\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\xF3\xB1\xA0\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\xF3\xB1\xA0\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\xF3\xB1\xA0\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xF3\xB1\xA0\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xF3\xB1\xA0\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xF3\xB1\xA0\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xF3\xB1\xA0\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xF3\xB1\xA0\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xF3\xB1\xA0\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xF3\xB1\xA0\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xF3\xB1\xA0\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xF3\xB1\xA0\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xF3\xB1\xA0\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xF3\xB1\xA0\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xF3\xB1\xA0\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xF3\xB1\xA0\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xF3\xB1\xA0\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xF3\xB1\xA0\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xF3\xB1\xA0\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xF3\xB1\xA0\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xF3\xB1\xA0\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xF3\xB1\xA0\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xF3\xB1\xA0\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xF3\xB1\xA0\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xF3\xB1\xA0\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xF3\xB1\xA0\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xF3\xB1\xA0\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xF3\xB1\xA0\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xF3\xB1\xA0\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xF3\xB1\xA0\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xF3\xB1\xA0\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xF3\xB1\xA0\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xF3\xB1\xA1\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xF3\xB1\xA1\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xF3\xB1\xA1\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xF3\xB1\xA1\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xF3\xB1\xA1\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xF3\xB1\xA1\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xF3\xB1\xA1\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xF3\xB1\xA1\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xF3\xB1\xA1\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xF3\xB1\xA1\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xF3\xB1\xA1\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xF3\xB1\xA1\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xF3\xB1\xA1\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xF3\xB1\xA1\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xF3\xB1\xA1\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xF3\xB1\xA1\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xF3\xB1\xA1\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xF3\xB1\xA1\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xF3\xB1\xA1\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xF3\xB1\xA1\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xF3\xB1\xA1\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xF3\xB1\xA1\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xF3\xB1\xA1\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xF3\xB1\xA1\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xF3\xB1\xA1\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xF3\xB1\xA1\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xF3\xB1\xA1\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xF3\xB1\xA1\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xF3\xB1\xA1\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xF3\xB1\xA1\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xF3\xB1\xA1\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xF3\xB1\xA1\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xF3\xB1\xA1\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xF3\xB1\xA1\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xF3\xB1\xA1\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xF3\xB1\xA1\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xF3\xB1\xA1\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xF3\xB1\xA1\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xF3\xB1\xA1\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xF3\xB1\xA1\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xF3\xB1\xA1\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xF3\xB1\xA1\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xF3\xB1\xA1\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xF3\xB1\xA1\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xF3\xB1\xA1\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xF3\xB1\xA1\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xF3\xB1\xA1\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xF3\xB1\xA1\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xF3\xB1\xA1\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xF3\xB1\xA1\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xF3\xB1\xA1\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xF3\xB1\xA1\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xF3\xB1\xA1\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xF3\xB1\xA1\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xF3\xB1\xA1\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xF3\xB1\xA1\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\xF3\xB1\xA1\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xF3\xB1\xA1\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xF3\xB1\xA1\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xF3\xB1\xA1\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xF3\xB1\xA1\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xF3\xB1\xA1\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xF3\xB1\xA1\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\xF3\xB1\xA1\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\xF3\xB1\xA2\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xF3\xB1\xA2\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xF3\xB1\xA2\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xF3\xB1\xA2\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xF3\xB1\xA2\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xF3\xB1\xA2\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xF3\xB1\xA2\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xF3\xB1\xA2\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xF3\xB1\xA2\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xF3\xB1\xA2\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xF3\xB1\xA2\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xF3\xB1\xA2\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xF3\xB1\xA2\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xF3\xB1\xA2\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xF3\xB1\xA2\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xF3\xB1\xA2\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xF3\xB1\xA2\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xF3\xB1\xA2\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xF3\xB1\xA2\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xF3\xB1\xA2\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xF3\xB1\xA2\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xF3\xB1\xA2\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xF3\xB1\xA2\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xF3\xB1\xA2\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xF3\xB1\xA2\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xF3\xB1\xA2\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xF3\xB1\xA2\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xF3\xB1\xA2\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xF3\xB1\xA2\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xF3\xB1\xA2\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xF3\xB1\xA2\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xF3\xB1\xA2\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xF3\xB1\xA2\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xF3\xB1\xA2\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xF3\xB1\xA2\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xF3\xB1\xA2\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xF3\xB1\xA2\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xF3\xB1\xA2\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xF3\xB1\xA2\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xF3\xB1\xA2\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xF3\xB1\xA2\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xF3\xB1\xA2\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xF3\xB1\xA2\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xF3\xB1\xA2\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xF3\xB1\xA2\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xF3\xB1\xA2\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xF3\xB1\xA2\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xF3\xB1\xA2\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xF3\xB1\xA2\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xF3\xB1\xA2\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xF3\xB1\xA2\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xF3\xB1\xA2\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xF3\xB1\xA2\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xF3\xB1\xA2\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xF3\xB1\xA2\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xF3\xB1\xA2\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xF3\xB1\xA2\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xF3\xB1\xA2\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xF3\xB1\xA2\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xF3\xB1\xA2\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xF3\xB1\xA2\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xF3\xB1\xA2\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xF3\xB1\xA2\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xF3\xB1\xA2\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xF3\xB1\xA3\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xF3\xB1\xA3\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xF3\xB1\xA3\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xF3\xB1\xA3\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xF3\xB1\xA3\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xF3\xB1\xA3\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xF3\xB1\xA3\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xF3\xB1\xA3\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xF3\xB1\xA3\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xF3\xB1\xA3\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xF3\xB1\xA3\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xF3\xB1\xA3\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xF3\xB1\xA3\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xF3\xB1\xA3\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xF3\xB1\xA3\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xF3\xB1\xA3\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xF3\xB1\xA3\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xF3\xB1\xA3\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xF3\xB1\xA3\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xF3\xB1\xA3\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xF3\xB1\xA3\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xF3\xB1\xA3\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xF3\xB1\xA3\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xF3\xB1\xA3\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xF3\xB1\xA3\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xF3\xB1\xA3\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xF3\xB1\xA3\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xF3\xB1\xA3\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xF3\xB1\xA3\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\xF3\xB1\xA3\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\xF3\xB1\xA3\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xF3\xB1\xA3\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xF3\xB1\xA3\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xF3\xB1\xA3\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xF3\xB1\xA3\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xF3\xB1\xA3\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xF3\xB1\xA3\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xF3\xB1\xA3\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xF3\xB1\xA3\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xF3\xB1\xA3\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xF3\xB1\xA3\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xF3\xB1\xA3\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xF3\xB1\xA3\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xF3\xB1\xA3\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xF3\xB1\xA3\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xF3\xB1\xA3\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xF3\xB1\xA3\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xF3\xB1\xA3\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xF3\xB1\xA3\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xF3\xB1\xA3\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xF3\xB1\xA3\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xF3\xB1\xA3\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xF3\xB1\xA3\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xF3\xB1\xA3\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xF3\xB1\xA3\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xF3\xB1\xA3\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xF3\xB1\xA3\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xF3\xB1\xA3\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xF3\xB1\xA3\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xF3\xB1\xA3\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xF3\xB1\xA3\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xF3\xB1\xA3\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xF3\xB1\xA3\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xF3\xB1\xA3\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xF3\xB1\xA4\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xF3\xB1\xA4\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xF3\xB1\xA4\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xF3\xB1\xA4\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xF3\xB1\xA4\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xF3\xB1\xA4\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xF3\xB1\xA4\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xF3\xB1\xA4\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xF3\xB1\xA4\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xF3\xB1\xA4\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xF3\xB1\xA4\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xF3\xB1\xA4\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xF3\xB1\xA4\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xF3\xB1\xA4\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xF3\xB1\xA4\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xF3\xB1\xA4\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xF3\xB1\xA4\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xF3\xB1\xA4\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xF3\xB1\xA4\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xF3\xB1\xA4\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xF3\xB1\xA4\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xF3\xB1\xA4\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xF3\xB1\xA4\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xF3\xB1\xA4\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xF3\xB1\xA4\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xF3\xB1\xA4\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xF3\xB1\xA4\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xF3\xB1\xA4\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xF3\xB1\xA4\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xF3\xB1\xA4\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xF3\xB1\xA4\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xF3\xB1\xA4\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xF3\xB1\xA4\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xF3\xB1\xA4\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xF3\xB1\xA4\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xF3\xB1\xA4\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xF3\xB1\xA4\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xF3\xB1\xA4\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\xF3\xB1\xA4\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xF3\xB1\xA4\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xF3\xB1\xA4\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xF3\xB1\xA4\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xF3\xB1\xA4\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xF3\xB1\xA4\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xF3\xB1\xA4\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xF3\xB1\xA4\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xF3\xB1\xA4\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xF3\xB1\xA4\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xF3\xB1\xA4\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xF3\xB1\xA4\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xF3\xB1\xA4\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xF3\xB1\xA4\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xF3\xB1\xA4\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xF3\xB1\xA4\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xF3\xB1\xA4\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xF3\xB1\xA4\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xF3\xB1\xA4\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xF3\xB1\xA4\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xF3\xB1\xA4\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\xF3\xB1\xA4\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\xF3\xB1\xA4\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xF3\xB1\xA4\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xF3\xB1\xA4\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xF3\xB1\xA4\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xF3\xB1\xA5\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xF3\xB1\xA5\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xF3\xB1\xA5\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xF3\xB1\xA5\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xF3\xB1\xA5\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xF3\xB1\xA5\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xF3\xB1\xA5\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xF3\xB1\xA5\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xF3\xB1\xA5\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xF3\xB1\xA5\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xF3\xB1\xA5\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xF3\xB1\xA5\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xF3\xB1\xA5\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xF3\xB1\xA5\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xF3\xB1\xA5\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xF3\xB1\xA5\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xF3\xB1\xA5\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xF3\xB1\xA5\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xF3\xB1\xA5\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xF3\xB1\xA5\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xF3\xB1\xA5\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xF3\xB1\xA5\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xF3\xB1\xA5\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xF3\xB1\xA5\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xF3\xB1\xA5\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xF3\xB1\xA5\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xF3\xB1\xA5\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xF3\xB1\xA5\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xF3\xB1\xA5\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xF3\xB1\xA5\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xF3\xB1\xA5\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xF3\xB1\xA5\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xF3\xB1\xA5\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xF3\xB1\xA5\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xF3\xB1\xA5\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xF3\xB1\xA5\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xF3\xB1\xA5\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xF3\xB1\xA5\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xF3\xB1\xA5\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xF3\xB1\xA5\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xF3\xB1\xA5\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xF3\xB1\xA5\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xF3\xB1\xA5\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xF3\xB1\xA5\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xF3\xB1\xA5\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xF3\xB1\xA5\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xF3\xB1\xA5\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xF3\xB1\xA5\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xF3\xB1\xA5\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xF3\xB1\xA5\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xF3\xB1\xA5\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xF3\xB1\xA5\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xF3\xB1\xA5\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xF3\xB1\xA5\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xF3\xB1\xA5\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xF3\xB1\xA5\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xF3\xB1\xA5\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xF3\xB1\xA5\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xF3\xB1\xA5\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xF3\xB1\xA5\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xF3\xB1\xA5\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xF3\xB1\xA5\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xF3\xB1\xA5\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xF3\xB1\xA5\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xF3\xB1\xA6\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xF3\xB1\xA6\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xF3\xB1\xA6\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xF3\xB1\xA6\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xF3\xB1\xA6\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xF3\xB1\xA6\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xF3\xB1\xA6\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xF3\xB1\xA6\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xF3\xB1\xA6\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xF3\xB1\xA6\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xF3\xB1\xA6\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xF3\xB1\xA6\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xF3\xB1\xA6\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xF3\xB1\xA6\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xF3\xB1\xA6\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xF3\xB1\xA6\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xF3\xB1\xA6\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xF3\xB1\xA6\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xF3\xB1\xA6\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xF3\xB1\xA6\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xF3\xB1\xA6\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xF3\xB1\xA6\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xF3\xB1\xA6\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xF3\xB1\xA6\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xF3\xB1\xA6\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\xF3\xB1\xA6\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\xF3\xB1\xA6\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xF3\xB1\xA6\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xF3\xB1\xA6\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xF3\xB1\xA6\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xF3\xB1\xA6\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xF3\xB1\xA6\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xF3\xB1\xA6\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xF3\xB1\xA6\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xF3\xB1\xA6\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xF3\xB1\xA6\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xF3\xB1\xA6\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xF3\xB1\xA6\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xF3\xB1\xA6\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xF3\xB1\xA6\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xF3\xB1\xA6\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xF3\xB1\xA6\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xF3\xB1\xA6\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xF3\xB1\xA6\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xF3\xB1\xA6\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xF3\xB1\xA6\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xF3\xB1\xA6\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xF3\xB1\xA6\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xF3\xB1\xA6\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xF3\xB1\xA6\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xF3\xB1\xA6\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xF3\xB1\xA6\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xF3\xB1\xA6\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xF3\xB1\xA6\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xF3\xB1\xA6\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xF3\xB1\xA6\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xF3\xB1\xA6\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xF3\xB1\xA6\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xF3\xB1\xA6\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xF3\xB1\xA6\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xF3\xB1\xA6\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xF3\xB1\xA6\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xF3\xB1\xA6\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xF3\xB1\xA6\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\xF3\xB1\xA7\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xF3\xB1\xA7\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xF3\xB1\xA7\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xF3\xB1\xA7\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xF3\xB1\xA7\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xF3\xB1\xA7\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xF3\xB1\xA7\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xF3\xB1\xA7\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xF3\xB1\xA7\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xF3\xB1\xA7\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xF3\xB1\xA7\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xF3\xB1\xA7\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xF3\xB1\xA7\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xF3\xB1\xA7\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xF3\xB1\xA7\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xF3\xB1\xA7\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xF3\xB1\xA7\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xF3\xB1\xA7\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xF3\xB1\xA7\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xF3\xB1\xA7\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xF3\xB1\xA7\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xF3\xB1\xA7\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xF3\xB1\xA7\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xF3\xB1\xA7\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xF3\xB1\xA7\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xF3\xB1\xA7\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xF3\xB1\xA7\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xF3\xB1\xA7\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xF3\xB1\xA7\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xF3\xB1\xA7\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xF3\xB1\xA7\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xF3\xB1\xA7\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xF3\xB1\xA7\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xF3\xB1\xA7\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xF3\xB1\xA7\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xF3\xB1\xA7\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xF3\xB1\xA7\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xF3\xB1\xA7\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xF3\xB1\xA7\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xF3\xB1\xA7\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xF3\xB1\xA7\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xF3\xB1\xA7\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xF3\xB1\xA7\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xF3\xB1\xA7\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xF3\xB1\xA7\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xF3\xB1\xA7\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xF3\xB1\xA7\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xF3\xB1\xA7\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xF3\xB1\xA7\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xF3\xB1\xA7\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xF3\xB1\xA7\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xF3\xB1\xA7\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xF3\xB1\xA7\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xF3\xB1\xA7\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xF3\xB1\xA7\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\xF3\xB1\xA7\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\xF3\xB1\xA7\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xF3\xB1\xA7\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xF3\xB1\xA7\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xF3\xB1\xA7\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xF3\xB1\xA7\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xF3\xB1\xA7\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xF3\xB1\xA7\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xF3\xB1\xA7\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xF3\xB1\xA8\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xF3\xB1\xA8\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xF3\xB1\xA8\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xF3\xB1\xA8\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xF3\xB1\xA8\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xF3\xB1\xA8\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xF3\xB1\xA8\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xF3\xB1\xA8\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xF3\xB1\xA8\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xF3\xB1\xA8\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xF3\xB1\xA8\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xF3\xB1\xA8\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xF3\xB1\xA8\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xF3\xB1\xA8\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xF3\xB1\xA8\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xF3\xB1\xA8\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xF3\xB1\xA8\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xF3\xB1\xA8\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xF3\xB1\xA8\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xF3\xB1\xA8\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xF3\xB1\xA8\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xF3\xB1\xA8\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xF3\xB1\xA8\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xF3\xB1\xA8\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xF3\xB1\xA8\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xF3\xB1\xA8\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xF3\xB1\xA8\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xF3\xB1\xA8\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xF3\xB1\xA8\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xF3\xB1\xA8\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xF3\xB1\xA8\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xF3\xB1\xA8\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xF3\xB1\xA8\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xF3\xB1\xA8\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xF3\xB1\xA8\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xF3\xB1\xA8\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xF3\xB1\xA8\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xF3\xB1\xA8\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xF3\xB1\xA8\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xF3\xB1\xA8\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xF3\xB1\xA8\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xF3\xB1\xA8\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xF3\xB1\xA8\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xF3\xB1\xA8\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xF3\xB1\xA8\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xF3\xB1\xA8\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xF3\xB1\xA8\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xF3\xB1\xA8\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xF3\xB1\xA8\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xF3\xB1\xA8\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xF3\xB1\xA8\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xF3\xB1\xA8\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xF3\xB1\xA8\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xF3\xB1\xA8\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xF3\xB1\xA8\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xF3\xB1\xA8\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xF3\xB1\xA8\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xF3\xB1\xA8\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xF3\xB1\xA8\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xF3\xB1\xA8\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xF3\xB1\xA8\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xF3\xB1\xA8\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xF3\xB1\xA8\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xF3\xB1\xA8\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xF3\xB1\xA9\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xF3\xB1\xA9\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xF3\xB1\xA9\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xF3\xB1\xA9\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xF3\xB1\xA9\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xF3\xB1\xA9\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xF3\xB1\xA9\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xF3\xB1\xA9\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xF3\xB1\xA9\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xF3\xB1\xA9\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xF3\xB1\xA9\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xF3\xB1\xA9\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xF3\xB1\xA9\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xF3\xB1\xA9\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xF3\xB1\xA9\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xF3\xB1\xA9\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xF3\xB1\xA9\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xF3\xB1\xA9\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xF3\xB1\xA9\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xF3\xB1\xA9\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xF3\xB1\xA9\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\xF3\xB1\xA9\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\xF3\xB1\xA9\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xF3\xB1\xA9\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xF3\xB1\xA9\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xF3\xB1\xA9\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xF3\xB1\xA9\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xF3\xB1\xA9\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xF3\xB1\xA9\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xF3\xB1\xA9\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xF3\xB1\xA9\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xF3\xB1\xA9\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xF3\xB1\xA9\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xF3\xB1\xA9\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xF3\xB1\xA9\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xF3\xB1\xA9\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xF3\xB1\xA9\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xF3\xB1\xA9\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xF3\xB1\xA9\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xF3\xB1\xA9\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xF3\xB1\xA9\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xF3\xB1\xA9\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xF3\xB1\xA9\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xF3\xB1\xA9\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xF3\xB1\xA9\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xF3\xB1\xA9\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xF3\xB1\xA9\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xF3\xB1\xA9\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xF3\xB1\xA9\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xF3\xB1\xA9\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xF3\xB1\xA9\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xF3\xB1\xA9\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xF3\xB1\xA9\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xF3\xB1\xA9\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xF3\xB1\xA9\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xF3\xB1\xA9\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xF3\xB1\xA9\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xF3\xB1\xA9\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xF3\xB1\xA9\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xF3\xB1\xA9\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xF3\xB1\xA9\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xF3\xB1\xA9\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xF3\xB1\xA9\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xF3\xB1\xA9\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xF3\xB1\xAA\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xF3\xB1\xAA\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xF3\xB1\xAA\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xF3\xB1\xAA\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xF3\xB1\xAA\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xF3\xB1\xAA\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xF3\xB1\xAA\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xF3\xB1\xAA\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xF3\xB1\xAA\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xF3\xB1\xAA\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xF3\xB1\xAA\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xF3\xB1\xAA\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xF3\xB1\xAA\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xF3\xB1\xAA\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xF3\xB1\xAA\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xF3\xB1\xAA\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xF3\xB1\xAA\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xF3\xB1\xAA\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xF3\xB1\xAA\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xF3\xB1\xAA\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xF3\xB1\xAA\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xF3\xB1\xAA\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xF3\xB1\xAA\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xF3\xB1\xAA\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xF3\xB1\xAA\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xF3\xB1\xAA\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xF3\xB1\xAA\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xF3\xB1\xAA\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xF3\xB1\xAA\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xF3\xB1\xAA\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xF3\xB1\xAA\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xF3\xB1\xAA\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xF3\xB1\xAA\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xF3\xB1\xAA\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xF3\xB1\xAA\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xF3\xB1\xAA\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xF3\xB1\xAA\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xF3\xB1\xAA\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xF3\xB1\xAA\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xF3\xB1\xAA\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xF3\xB1\xAA\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xF3\xB1\xAA\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xF3\xB1\xAA\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xF3\xB1\xAA\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xF3\xB1\xAA\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xF3\xB1\xAA\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xF3\xB1\xAA\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xF3\xB1\xAA\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xF3\xB1\xAA\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xF3\xB1\xAA\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xF3\xB1\xAA\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\xF3\xB1\xAA\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\xF3\xB1\xAA\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xF3\xB1\xAA\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xF3\xB1\xAA\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xF3\xB1\xAA\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xF3\xB1\xAA\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xF3\xB1\xAA\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xF3\xB1\xAA\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xF3\xB1\xAA\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xF3\xB1\xAA\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xF3\xB1\xAA\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xF3\xB1\xAA\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xF3\xB1\xAA\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xF3\xB1\xAB\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xF3\xB1\xAB\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xF3\xB1\xAB\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xF3\xB1\xAB\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xF3\xB1\xAB\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xF3\xB1\xAB\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xF3\xB1\xAB\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xF3\xB1\xAB\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xF3\xB1\xAB\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xF3\xB1\xAB\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xF3\xB1\xAB\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xF3\xB1\xAB\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xF3\xB1\xAB\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xF3\xB1\xAB\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xF3\xB1\xAB\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xF3\xB1\xAB\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xF3\xB1\xAB\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xF3\xB1\xAB\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xF3\xB1\xAB\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xF3\xB1\xAB\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xF3\xB1\xAB\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xF3\xB1\xAB\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xF3\xB1\xAB\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xF3\xB1\xAB\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xF3\xB1\xAB\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xF3\xB1\xAB\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xF3\xB1\xAB\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xF3\xB1\xAB\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xF3\xB1\xAB\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xF3\xB1\xAB\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xF3\xB1\xAB\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xF3\xB1\xAB\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xF3\xB1\xAB\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xF3\xB1\xAB\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xF3\xB1\xAB\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xF3\xB1\xAB\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xF3\xB1\xAB\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xF3\xB1\xAB\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xF3\xB1\xAB\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xF3\xB1\xAB\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xF3\xB1\xAB\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xF3\xB1\xAB\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xF3\xB1\xAB\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xF3\xB1\xAB\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xF3\xB1\xAB\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xF3\xB1\xAB\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xF3\xB1\xAB\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xF3\xB1\xAB\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xF3\xB1\xAB\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xF3\xB1\xAB\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xF3\xB1\xAB\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xF3\xB1\xAB\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xF3\xB1\xAB\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xF3\xB1\xAB\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xF3\xB1\xAB\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xF3\xB1\xAB\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xF3\xB1\xAB\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xF3\xB1\xAB\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xF3\xB1\xAB\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xF3\xB1\xAB\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xF3\xB1\xAB\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xF3\xB1\xAB\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xF3\xB1\xAB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xF3\xB1\xAB\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xF3\xB1\xAC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xF3\xB1\xAC\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xF3\xB1\xAC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xF3\xB1\xAC\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xF3\xB1\xAC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xF3\xB1\xAC\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xF3\xB1\xAC\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xF3\xB1\xAC\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xF3\xB1\xAC\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xF3\xB1\xAC\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xF3\xB1\xAC\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xF3\xB1\xAC\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xF3\xB1\xAC\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xF3\xB1\xAC\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xF3\xB1\xAC\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xF3\xB1\xAC\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xF3\xB1\xAC\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\xF3\xB1\xAC\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\xF3\xB1\xAC\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xF3\xB1\xAC\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xF3\xB1\xAC\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xF3\xB1\xAC\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xF3\xB1\xAC\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xF3\xB1\xAC\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xF3\xB1\xAC\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xF3\xB1\xAC\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xF3\xB1\xAC\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xF3\xB1\xAC\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xF3\xB1\xAC\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xF3\xB1\xAC\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xF3\xB1\xAC\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xF3\xB1\xAC\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xF3\xB1\xAC\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xF3\xB1\xAC\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xF3\xB1\xAC\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xF3\xB1\xAC\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xF3\xB1\xAC\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xF3\xB1\xAC\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xF3\xB1\xAC\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xF3\xB1\xAC\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xF3\xB1\xAC\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xF3\xB1\xAC\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xF3\xB1\xAC\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xF3\xB1\xAC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xF3\xB1\xAC\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xF3\xB1\xAC\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xF3\xB1\xAC\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xF3\xB1\xAC\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xF3\xB1\xAC\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xF3\xB1\xAC\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xF3\xB1\xAC\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xF3\xB1\xAC\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xF3\xB1\xAC\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xF3\xB1\xAC\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xF3\xB1\xAC\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xF3\xB1\xAC\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xF3\xB1\xAC\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xF3\xB1\xAC\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xF3\xB1\xAC\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xF3\xB1\xAC\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xF3\xB1\xAC\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xF3\xB1\xAC\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xF3\xB1\xAC\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xF3\xB1\xAC\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xF3\xB1\xAD\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xF3\xB1\xAD\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xF3\xB1\xAD\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xF3\xB1\xAD\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xF3\xB1\xAD\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xF3\xB1\xAD\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xF3\xB1\xAD\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xF3\xB1\xAD\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xF3\xB1\xAD\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xF3\xB1\xAD\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xF3\xB1\xAD\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xF3\xB1\xAD\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xF3\xB1\xAD\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xF3\xB1\xAD\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xF3\xB1\xAD\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xF3\xB1\xAD\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xF3\xB1\xAD\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xF3\xB1\xAD\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xF3\xB1\xAD\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xF3\xB1\xAD\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xF3\xB1\xAD\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xF3\xB1\xAD\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xF3\xB1\xAD\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xF3\xB1\xAD\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xF3\xB1\xAD\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xF3\xB1\xAD\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xF3\xB1\xAD\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xF3\xB1\xAD\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xF3\xB1\xAD\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xF3\xB1\xAD\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xF3\xB1\xAD\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xF3\xB1\xAD\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xF3\xB1\xAD\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xF3\xB1\xAD\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xF3\xB1\xAD\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xF3\xB1\xAD\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xF3\xB1\xAD\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xF3\xB1\xAD\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xF3\xB1\xAD\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xF3\xB1\xAD\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xF3\xB1\xAD\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xF3\xB1\xAD\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xF3\xB1\xAD\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xF3\xB1\xAD\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xF3\xB1\xAD\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xF3\xB1\xAD\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xF3\xB1\xAD\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\xF3\xB1\xAD\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xF3\xB1\xAD\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xF3\xB1\xAD\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xF3\xB1\xAD\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xF3\xB1\xAD\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xF3\xB1\xAD\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xF3\xB1\xAD\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xF3\xB1\xAD\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xF3\xB1\xAD\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xF3\xB1\xAD\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xF3\xB1\xAD\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xF3\xB1\xAD\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xF3\xB1\xAD\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xF3\xB1\xAD\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xF3\xB1\xAD\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\xF3\xB1\xAD\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xF3\xB1\xAD\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xF3\xB1\xAE\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xF3\xB1\xAE\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xF3\xB1\xAE\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xF3\xB1\xAE\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xF3\xB1\xAE\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xF3\xB1\xAE\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xF3\xB1\xAE\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xF3\xB1\xAE\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xF3\xB1\xAE\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xF3\xB1\xAE\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xF3\xB1\xAE\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xF3\xB1\xAE\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xF3\xB1\xAE\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xF3\xB1\xAE\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xF3\xB1\xAE\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xF3\xB1\xAE\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xF3\xB1\xAE\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xF3\xB1\xAE\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xF3\xB1\xAE\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xF3\xB1\xAE\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xF3\xB1\xAE\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xF3\xB1\xAE\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xF3\xB1\xAE\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xF3\xB1\xAE\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xF3\xB1\xAE\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xF3\xB1\xAE\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xF3\xB1\xAE\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xF3\xB1\xAE\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xF3\xB1\xAE\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xF3\xB1\xAE\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xF3\xB1\xAE\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xF3\xB1\xAE\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xF3\xB1\xAE\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xF3\xB1\xAE\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xF3\xB1\xAE\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xF3\xB1\xAE\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xF3\xB1\xAE\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xF3\xB1\xAE\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xF3\xB1\xAE\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xF3\xB1\xAE\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xF3\xB1\xAE\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xF3\xB1\xAE\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xF3\xB1\xAE\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xF3\xB1\xAE\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xF3\xB1\xAE\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xF3\xB1\xAE\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xF3\xB1\xAE\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xF3\xB1\xAE\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xF3\xB1\xAE\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xF3\xB1\xAE\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xF3\xB1\xAE\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xF3\xB1\xAE\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xF3\xB1\xAE\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xF3\xB1\xAE\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xF3\xB1\xAE\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xF3\xB1\xAE\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xF3\xB1\xAE\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xF3\xB1\xAE\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xF3\xB1\xAE\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xF3\xB1\xAE\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xF3\xB1\xAE\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xF3\xB1\xAE\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xF3\xB1\xAE\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xF3\xB1\xAE\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xF3\xB1\xAF\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xF3\xB1\xAF\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xF3\xB1\xAF\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xF3\xB1\xAF\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xF3\xB1\xAF\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xF3\xB1\xAF\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xF3\xB1\xAF\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xF3\xB1\xAF\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xF3\xB1\xAF\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xF3\xB1\xAF\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xF3\xB1\xAF\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xF3\xB1\xAF\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xF3\xB1\xAF\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\xF3\xB1\xAF\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\xF3\xB1\xAF\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xF3\xB1\xAF\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xF3\xB1\xAF\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xF3\xB1\xAF\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xF3\xB1\xAF\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xF3\xB1\xAF\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xF3\xB1\xAF\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xF3\xB1\xAF\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xF3\xB1\xAF\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xF3\xB1\xAF\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xF3\xB1\xAF\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xF3\xB1\xAF\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xF3\xB1\xAF\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xF3\xB1\xAF\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xF3\xB1\xAF\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xF3\xB1\xAF\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xF3\xB1\xAF\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xF3\xB1\xAF\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xF3\xB1\xAF\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xF3\xB1\xAF\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xF3\xB1\xAF\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xF3\xB1\xAF\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xF3\xB1\xAF\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xF3\xB1\xAF\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xF3\xB1\xAF\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xF3\xB1\xAF\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xF3\xB1\xAF\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xF3\xB1\xAF\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xF3\xB1\xAF\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xF3\xB1\xAF\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xF3\xB1\xAF\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xF3\xB1\xAF\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xF3\xB1\xAF\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xF3\xB1\xAF\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xF3\xB1\xAF\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xF3\xB1\xAF\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xF3\xB1\xAF\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xF3\xB1\xAF\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xF3\xB1\xAF\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xF3\xB1\xAF\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xF3\xB1\xAF\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xF3\xB1\xAF\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xF3\xB1\xAF\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xF3\xB1\xAF\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xF3\xB1\xAF\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xF3\xB1\xAF\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xF3\xB1\xAF\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xF3\xB1\xAF\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xF3\xB1\xAF\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xF3\xB1\xAF\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xF3\xB1\xB0\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xF3\xB1\xB0\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xF3\xB1\xB0\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xF3\xB1\xB0\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xF3\xB1\xB0\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xF3\xB1\xB0\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xF3\xB1\xB0\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xF3\xB1\xB0\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xF3\xB1\xB0\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xF3\xB1\xB0\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xF3\xB1\xB0\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xF3\xB1\xB0\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xF3\xB1\xB0\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xF3\xB1\xB0\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xF3\xB1\xB0\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xF3\xB1\xB0\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xF3\xB1\xB0\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xF3\xB1\xB0\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xF3\xB1\xB0\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xF3\xB1\xB0\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xF3\xB1\xB0\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xF3\xB1\xB0\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xF3\xB1\xB0\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xF3\xB1\xB0\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xF3\xB1\xB0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xF3\xB1\xB0\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xF3\xB1\xB0\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xF3\xB1\xB0\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xF3\xB1\xB0\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xF3\xB1\xB0\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xF3\xB1\xB0\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xF3\xB1\xB0\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xF3\xB1\xB0\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xF3\xB1\xB0\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xF3\xB1\xB0\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xF3\xB1\xB0\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xF3\xB1\xB0\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xF3\xB1\xB0\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xF3\xB1\xB0\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xF3\xB1\xB0\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xF3\xB1\xB0\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xF3\xB1\xB0\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xF3\xB1\xB0\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\xF3\xB1\xB0\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\xF3\xB1\xB0\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xF3\xB1\xB0\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xF3\xB1\xB0\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xF3\xB1\xB0\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xF3\xB1\xB0\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xF3\xB1\xB0\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xF3\xB1\xB0\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xF3\xB1\xB0\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xF3\xB1\xB0\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xF3\xB1\xB0\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xF3\xB1\xB0\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xF3\xB1\xB0\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xF3\xB1\xB0\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xF3\xB1\xB0\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xF3\xB1\xB0\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xF3\xB1\xB0\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xF3\xB1\xB0\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xF3\xB1\xB0\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xF3\xB1\xB0\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xF3\xB1\xB0\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xF3\xB1\xB1\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xF3\xB1\xB1\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xF3\xB1\xB1\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xF3\xB1\xB1\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xF3\xB1\xB1\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xF3\xB1\xB1\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xF3\xB1\xB1\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xF3\xB1\xB1\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xF3\xB1\xB1\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xF3\xB1\xB1\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xF3\xB1\xB1\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xF3\xB1\xB1\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xF3\xB1\xB1\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xF3\xB1\xB1\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xF3\xB1\xB1\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xF3\xB1\xB1\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xF3\xB1\xB1\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xF3\xB1\xB1\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xF3\xB1\xB1\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xF3\xB1\xB1\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xF3\xB1\xB1\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xF3\xB1\xB1\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xF3\xB1\xB1\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xF3\xB1\xB1\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xF3\xB1\xB1\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xF3\xB1\xB1\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xF3\xB1\xB1\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xF3\xB1\xB1\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xF3\xB1\xB1\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xF3\xB1\xB1\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xF3\xB1\xB1\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xF3\xB1\xB1\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xF3\xB1\xB1\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xF3\xB1\xB1\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xF3\xB1\xB1\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xF3\xB1\xB1\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xF3\xB1\xB1\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xF3\xB1\xB1\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xF3\xB1\xB1\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xF3\xB1\xB1\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xF3\xB1\xB1\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xF3\xB1\xB1\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xF3\xB1\xB1\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xF3\xB1\xB1\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xF3\xB1\xB1\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xF3\xB1\xB1\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xF3\xB1\xB1\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xF3\xB1\xB1\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xF3\xB1\xB1\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xF3\xB1\xB1\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xF3\xB1\xB1\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xF3\xB1\xB1\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xF3\xB1\xB1\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xF3\xB1\xB1\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xF3\xB1\xB1\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xF3\xB1\xB1\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xF3\xB1\xB1\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xF3\xB1\xB1\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xF3\xB1\xB1\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xF3\xB1\xB1\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xF3\xB1\xB1\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xF3\xB1\xB1\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xF3\xB1\xB1\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xF3\xB1\xB1\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xF3\xB1\xB2\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xF3\xB1\xB2\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xF3\xB1\xB2\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xF3\xB1\xB2\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xF3\xB1\xB2\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xF3\xB1\xB2\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xF3\xB1\xB2\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xF3\xB1\xB2\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xF3\xB1\xB2\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\xF3\xB1\xB2\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\xF3\xB1\xB2\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xF3\xB1\xB2\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xF3\xB1\xB2\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xF3\xB1\xB2\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xF3\xB1\xB2\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xF3\xB1\xB2\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xF3\xB1\xB2\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xF3\xB1\xB2\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xF3\xB1\xB2\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xF3\xB1\xB2\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xF3\xB1\xB2\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xF3\xB1\xB2\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xF3\xB1\xB2\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xF3\xB1\xB2\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xF3\xB1\xB2\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xF3\xB1\xB2\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xF3\xB1\xB2\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xF3\xB1\xB2\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xF3\xB1\xB2\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xF3\xB1\xB2\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xF3\xB1\xB2\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xF3\xB1\xB2\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xF3\xB1\xB2\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xF3\xB1\xB2\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xF3\xB1\xB2\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xF3\xB1\xB2\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xF3\xB1\xB2\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xF3\xB1\xB2\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xF3\xB1\xB2\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xF3\xB1\xB2\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xF3\xB1\xB2\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xF3\xB1\xB2\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xF3\xB1\xB2\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xF3\xB1\xB2\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xF3\xB1\xB2\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xF3\xB1\xB2\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xF3\xB1\xB2\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xF3\xB1\xB2\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xF3\xB1\xB2\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xF3\xB1\xB2\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xF3\xB1\xB2\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xF3\xB1\xB2\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xF3\xB1\xB2\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xF3\xB1\xB2\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xF3\xB1\xB2\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xF3\xB1\xB2\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xF3\xB1\xB2\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xF3\xB1\xB2\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xF3\xB1\xB2\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xF3\xB1\xB2\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xF3\xB1\xB2\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xF3\xB1\xB2\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xF3\xB1\xB2\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xF3\xB1\xB2\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xF3\xB1\xB3\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xF3\xB1\xB3\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xF3\xB1\xB3\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xF3\xB1\xB3\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xF3\xB1\xB3\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xF3\xB1\xB3\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xF3\xB1\xB3\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xF3\xB1\xB3\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xF3\xB1\xB3\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xF3\xB1\xB3\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xF3\xB1\xB3\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xF3\xB1\xB3\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xF3\xB1\xB3\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xF3\xB1\xB3\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xF3\xB1\xB3\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xF3\xB1\xB3\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xF3\xB1\xB3\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xF3\xB1\xB3\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xF3\xB1\xB3\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xF3\xB1\xB3\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xF3\xB1\xB3\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xF3\xB1\xB3\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xF3\xB1\xB3\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xF3\xB1\xB3\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xF3\xB1\xB3\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xF3\xB1\xB3\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xF3\xB1\xB3\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xF3\xB1\xB3\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xF3\xB1\xB3\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xF3\xB1\xB3\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xF3\xB1\xB3\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xF3\xB1\xB3\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xF3\xB1\xB3\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xF3\xB1\xB3\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xF3\xB1\xB3\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xF3\xB1\xB3\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xF3\xB1\xB3\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xF3\xB1\xB3\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xF3\xB1\xB3\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\xF3\xB1\xB3\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\xF3\xB1\xB3\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xF3\xB1\xB3\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xF3\xB1\xB3\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xF3\xB1\xB3\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xF3\xB1\xB3\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xF3\xB1\xB3\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xF3\xB1\xB3\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xF3\xB1\xB3\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xF3\xB1\xB3\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xF3\xB1\xB3\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xF3\xB1\xB3\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xF3\xB1\xB3\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xF3\xB1\xB3\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xF3\xB1\xB3\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xF3\xB1\xB3\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xF3\xB1\xB3\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xF3\xB1\xB3\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xF3\xB1\xB3\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xF3\xB1\xB3\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xF3\xB1\xB3\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xF3\xB1\xB3\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xF3\xB1\xB3\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xF3\xB1\xB3\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xF3\xB1\xB3\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xF3\xB1\xB4\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xF3\xB1\xB4\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xF3\xB1\xB4\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xF3\xB1\xB4\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xF3\xB1\xB4\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xF3\xB1\xB4\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xF3\xB1\xB4\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xF3\xB1\xB4\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xF3\xB1\xB4\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xF3\xB1\xB4\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xF3\xB1\xB4\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xF3\xB1\xB4\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xF3\xB1\xB4\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xF3\xB1\xB4\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xF3\xB1\xB4\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xF3\xB1\xB4\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xF3\xB1\xB4\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xF3\xB1\xB4\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xF3\xB1\xB4\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xF3\xB1\xB4\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xF3\xB1\xB4\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xF3\xB1\xB4\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xF3\xB1\xB4\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xF3\xB1\xB4\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xF3\xB1\xB4\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xF3\xB1\xB4\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xF3\xB1\xB4\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xF3\xB1\xB4\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xF3\xB1\xB4\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xF3\xB1\xB4\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xF3\xB1\xB4\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xF3\xB1\xB4\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xF3\xB1\xB4\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xF3\xB1\xB4\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xF3\xB1\xB4\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xF3\xB1\xB4\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xF3\xB1\xB4\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xF3\xB1\xB4\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xF3\xB1\xB4\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xF3\xB1\xB4\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xF3\xB1\xB4\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xF3\xB1\xB4\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xF3\xB1\xB4\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xF3\xB1\xB4\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xF3\xB1\xB4\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xF3\xB1\xB4\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xF3\xB1\xB4\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xF3\xB1\xB4\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xF3\xB1\xB4\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xF3\xB1\xB4\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xF3\xB1\xB4\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xF3\xB1\xB4\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xF3\xB1\xB4\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xF3\xB1\xB4\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xF3\xB1\xB4\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xF3\xB1\xB4\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\xF3\xB1\xB4\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\xF3\xB1\xB4\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\xF3\xB1\xB4\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\xF3\xB1\xB4\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\xF3\xB1\xB4\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\xF3\xB1\xB4\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\xF3\xB1\xB4\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\xF3\xB1\xB4\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\xF3\xB1\xB5\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\xF3\xB1\xB5\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\xF3\xB1\xB5\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\xF3\xB1\xB5\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\xF3\xB1\xB5\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],
        ["\xF3\xB1\xB5\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],
        ["\xF3\xB1\xB5\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\xF3\xB1\xB5\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\xF3\xB1\xB5\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\xF3\xB1\xB5\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\xF3\xB1\xB5\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\xF3\xB1\xB5\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\xF3\xB1\xB5\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\xF3\xB1\xB5\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\xF3\xB1\xB5\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\xF3\xB1\xB5\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\xF3\xB1\xB5\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\xF3\xB1\xB5\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\xF3\xB1\xB5\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\xF3\xB1\xB5\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\xF3\xB1\xB5\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\xF3\xB1\xB5\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\xF3\xB1\xB5\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\xF3\xB1\xB5\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\xF3\xB1\xB5\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\xF3\xB1\xB5\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\xF3\xB1\xB5\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\xF3\xB1\xB5\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\xF3\xB1\xB5\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\xF3\xB1\xB5\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\xF3\xB1\xB5\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\xF3\xB1\xB5\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\xF3\xB1\xB5\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\xF3\xB1\xB5\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\xF3\xB1\xB5\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\xF3\xB1\xB5\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\xF3\xB1\xB5\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\xF3\xB1\xB5\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\xF3\xB1\xB5\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\xF3\xB1\xB5\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\xF3\xB1\xB5\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\xF3\xB1\xB5\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\xF3\xB1\xB5\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\xF3\xB1\xB5\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\xF3\xB1\xB5\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\xF3\xB1\xB5\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\xF3\xB1\xB5\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\xF3\xB1\xB5\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\xF3\xB1\xB5\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\xF3\xB1\xB5\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\xF3\xB1\xB5\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\xF3\xB1\xB5\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\xF3\xB1\xB5\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\xF3\xB1\xB5\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\xF3\xB1\xB5\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\xF3\xB1\xB5\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\xF3\xB1\xB5\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\xF3\xB1\xB5\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\xF3\xB1\xB5\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\xF3\xB1\xB5\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\xF3\xB1\xB5\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\xF3\xB1\xB5\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\xF3\xB1\xB5\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\xF3\xB1\xB5\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\xF3\xB1\xB6\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\xF3\xB1\xB6\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\xF3\xB1\xB6\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\xF3\xB1\xB6\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\xF3\xB1\xB6\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\xF3\xB1\xB6\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\xF3\xB1\xB6\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\xF3\xB1\xB6\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\xF3\xB1\xB6\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\xF3\xB1\xB6\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\xF3\xB1\xB6\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\xF3\xB1\xB6\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\xF3\xB1\xB6\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\xF3\xB1\xB6\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\xF3\xB1\xB6\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\xF3\xB1\xB6\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\xF3\xB1\xB6\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\xF3\xB1\xB6\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\xF3\xB1\xB6\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\xF3\xB1\xB6\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\xF3\xB1\xB6\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\xF3\xB1\xB6\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\xF3\xB1\xB6\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\xF3\xB1\xB6\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\xF3\xB1\xB6\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\xF3\xB1\xB6\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\xF3\xB1\xB6\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\xF3\xB1\xB6\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\xF3\xB1\xB6\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\xF3\xB1\xB6\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\xF3\xB1\xB6\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\xF3\xB1\xB6\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\xF3\xB1\xB6\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\xF3\xB1\xB6\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\xF3\xB1\xB6\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],
        ["\xF3\xB1\xB6\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],
        ["\xF3\xB1\xB6\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\xF3\xB1\xB6\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\xF3\xB1\xB6\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\xF3\xB1\xB6\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\xF3\xB1\xB6\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\xF3\xB1\xB6\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\xF3\xB1\xB6\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\xF3\xB1\xB6\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\xF3\xB1\xB6\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\xF3\xB1\xB6\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\xF3\xB1\xB6\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\xF3\xB1\xB6\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\xF3\xB1\xB6\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\xF3\xB1\xB6\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\xF3\xB1\xB6\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\xF3\xB1\xB6\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\xF3\xB1\xB6\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\xF3\xB1\xB6\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\xF3\xB1\xB6\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\xF3\xB1\xB6\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\xF3\xB1\xB6\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\xF3\xB1\xB6\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\xF3\xB1\xB6\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\xF3\xB1\xB6\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\xF3\xB1\xB6\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\xF3\xB1\xB6\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\xF3\xB1\xB6\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\xF3\xB1\xB6\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\xF3\xB1\xB7\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\xF3\xB1\xB7\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\xF3\xB1\xB7\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\xF3\xB1\xB7\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\xF3\xB1\xB7\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\xF3\xB1\xB7\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\xF3\xB1\xB7\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\xF3\xB1\xB7\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\xF3\xB1\xB7\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\xF3\xB1\xB7\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\xF3\xB1\xB7\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\xF3\xB1\xB7\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\xF3\xB1\xB7\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\xF3\xB1\xB7\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\xF3\xB1\xB7\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\xF3\xB1\xB7\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\xF3\xB1\xB7\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\xF3\xB1\xB7\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\xF3\xB1\xB7\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\xF3\xB1\xB7\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\xF3\xB1\xB7\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\xF3\xB1\xB7\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\xF3\xB1\xB7\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\xF3\xB1\xB7\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\xF3\xB1\xB7\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\xF3\xB1\xB7\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\xF3\xB1\xB7\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\xF3\xB1\xB7\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\xF3\xB1\xB7\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\xF3\xB1\xB7\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\xF3\xB1\xB7\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\xF3\xB1\xB7\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\xF3\xB1\xB7\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\xF3\xB1\xB7\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\xF3\xB1\xB7\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\xF3\xB1\xB7\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\xF3\xB1\xB7\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\xF3\xB1\xB7\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\xF3\xB1\xB7\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\xF3\xB1\xB7\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\xF3\xB1\xB7\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\xF3\xB1\xB7\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\xF3\xB1\xB7\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\xF3\xB1\xB7\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\xF3\xB1\xB7\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\xF3\xB1\xB7\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\xF3\xB1\xB7\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\xF3\xB1\xB7\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\xF3\xB1\xB7\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\xF3\xB1\xB7\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\xF3\xB1\xB7\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\xF3\xB1\xB7\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\xF3\xB1\xB7\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\xF3\xB1\xB7\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\xF3\xB1\xB7\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\xF3\xB1\xB7\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\xF3\xB1\xB7\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\xF3\xB1\xB7\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\xF3\xB1\xB7\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\xF3\xB1\xB7\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\xF3\xB1\xB7\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\xF3\xB1\xB7\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\xF3\xB1\xB7\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\xF3\xB1\xB7\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\xF3\xB1\xB8\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],
        ["\xF3\xB1\xB8\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],
        ["\xF3\xB1\xB8\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xF3\xB1\xB8\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\xF3\xB1\xB8\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\xF3\xB1\xB8\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\xF3\xB1\xB8\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\xF3\xB1\xB8\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\xF3\xB1\xB8\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\xF3\xB1\xB8\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\xF3\xB1\xB8\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\xF3\xB1\xB8\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\xF3\xB1\xB8\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xF3\xB1\xB8\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\xF3\xB1\xB8\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\xF3\xB1\xB8\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\xF3\xB1\xB8\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\xF3\xB1\xB8\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xF3\xB1\xB8\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\xF3\xB1\xB8\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\xF3\xB1\xB8\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\xF3\xB1\xB8\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\xF3\xB1\xB8\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\xF3\xB1\xB8\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\xF3\xB1\xB8\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\xF3\xB1\xB8\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\xF3\xB1\xB8\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\xF3\xB1\xB8\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\xF3\xB1\xB8\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\xF3\xB1\xB8\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\xF3\xB1\xB8\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\xF3\xB1\xB8\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\xF3\xB1\xB8\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\xF3\xB1\xB8\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xF3\xB1\xB8\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xF3\xB1\xB8\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF3\xB1\xB8\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xF3\xB1\xB8\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xF3\xB1\xB8\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF3\xB1\xB8\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xF3\xB1\xB8\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF3\xB1\xB8\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF3\xB1\xB8\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xF3\xB1\xB8\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\xF3\xB1\xB8\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\xF3\xB1\xB8\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\xF3\xB1\xB8\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\xF3\xB1\xB8\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\xF3\xB1\xB8\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\xF3\xB1\xB8\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xF3\xB1\xB8\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xF3\xB1\xB8\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xF3\xB1\xB8\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xF3\xB1\xB8\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xF3\xB1\xB8\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xF3\xB1\xB8\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xF3\xB1\xB8\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],
        ["\xF3\xB1\xB8\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF3\xB1\xB8\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xF3\xB1\xB8\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\xF3\xB1\xB8\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\xF3\xB1\xB8\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\xF3\xB1\xB8\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\xF3\xB1\xB8\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\xF3\xB1\xB9\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\xF3\xB1\xB9\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xF3\xB1\xB9\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\xF3\xB1\xB9\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xF3\xB1\xB9\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF3\xB1\xB9\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xF3\xB1\xB9\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xF3\xB1\xB9\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xF3\xB1\xB9\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xF3\xB1\xB9\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xF3\xB1\xB9\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF3\xB1\xB9\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\xF3\xB1\xB9\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\xF3\xB1\xB9\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\xF3\xB1\xB9\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\xF3\xB1\xB9\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\xF3\xB1\xB9\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\xF3\xB1\xB9\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xF3\xB1\xB9\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xF3\xB1\xB9\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xF3\xB1\xB9\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xF3\xB1\xB9\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\xF3\xB1\xB9\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xF3\xB1\xB9\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xF3\xB1\xB9\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xF3\xB1\xB9\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xF3\xB1\xB9\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xF3\xB1\xB9\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\xF3\xB1\xB9\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\xF3\xB1\xB9\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\xF3\xB1\xB9\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],
        ["\xF3\xB1\xB9\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],
        ["\xF3\xB1\xB9\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xF3\xB1\xB9\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\xF3\xB1\xB9\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\xF3\xB1\xB9\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\xF3\xB1\xB9\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\xF3\xB1\xB9\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\xF3\xB1\xB9\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\xF3\xB1\xB9\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\xF3\xB1\xB9\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\xF3\xB1\xB9\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\xF3\xB1\xB9\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xF3\xB1\xB9\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\xF3\xB1\xB9\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\xF3\xB1\xB9\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\xF3\xB1\xB9\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\xF3\xB1\xB9\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xF3\xB1\xB9\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\xF3\xB1\xB9\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\xF3\xB1\xB9\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\xF3\xB1\xB9\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\xF3\xB1\xB9\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\xF3\xB1\xB9\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\xF3\xB1\xB9\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\xF3\xB1\xB9\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\xF3\xB1\xB9\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\xF3\xB1\xB9\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\xF3\xB1\xB9\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\xF3\xB1\xB9\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\xF3\xB1\xB9\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\xF3\xB1\xB9\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\xF3\xB1\xB9\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\xF3\xB1\xB9\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xF3\xB1\xBA\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xF3\xB1\xBA\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xF3\xB1\xBA\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xF3\xB1\xBA\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xF3\xB1\xBA\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xF3\xB1\xBA\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xF3\xB1\xBA\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xF3\xB1\xBA\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xF3\xB1\xBA\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xF3\xB1\xBA\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\xF3\xB1\xBA\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\xF3\xB1\xBA\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\xF3\xB1\xBA\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\xF3\xB1\xBA\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\xF3\xB1\xBA\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\xF3\xB1\xBA\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xF3\xB1\xBA\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xF3\xB1\xBA\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xF3\xB1\xBA\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xF3\xB1\xBA\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xF3\xB1\xBA\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xF3\xB1\xBA\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF3\xB1\xBA\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xF3\xB1\xBA\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xF3\xB1\xBA\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF3\xB1\xBA\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\xF3\xB1\xBA\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\xF3\xB1\xBA\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\xF3\xB1\xBA\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\xF3\xB1\xBA\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\xF3\xB1\xBA\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\xF3\xB1\xBA\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF3\xB1\xBA\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\xF3\xB1\xBA\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xF3\xB1\xBA\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xF3\xB1\xBA\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xF3\xB1\xBA\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xF3\xB1\xBA\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xF3\xB1\xBA\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF3\xB1\xBA\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF3\xB1\xBA\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xF3\xB1\xBA\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\xF3\xB1\xBA\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\xF3\xB1\xBA\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\xF3\xB1\xBA\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\xF3\xB1\xBA\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\xF3\xB1\xBA\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\xF3\xB1\xBA\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xF3\xB1\xBA\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF3\xB1\xBA\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF3\xB1\xBA\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xF3\xB1\xBA\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xF3\xB1\xBA\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xF3\xB1\xBA\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xF3\xB1\xBA\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xF3\xB1\xBA\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xF3\xB1\xBA\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xF3\xB1\xBA\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\xF3\xB1\xBA\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\xF3\xB1\xBA\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\xF3\xB1\xBA\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],
        ["\xF3\xB1\xBA\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],
        ["\xF3\xB1\xBA\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xF3\xB1\xBA\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\xF3\xB1\xBB\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\xF3\xB1\xBB\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\xF3\xB1\xBB\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\xF3\xB1\xBB\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\xF3\xB1\xBB\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\xF3\xB1\xBB\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\xF3\xB1\xBB\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\xF3\xB1\xBB\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\xF3\xB1\xBB\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xF3\xB1\xBB\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\xF3\xB1\xBB\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\xF3\xB1\xBB\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\xF3\xB1\xBB\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\xF3\xB1\xBB\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xF3\xB1\xBB\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\xF3\xB1\xBB\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\xF3\xB1\xBB\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\xF3\xB1\xBB\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\xF3\xB1\xBB\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\xF3\xB1\xBB\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\xF3\xB1\xBB\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\xF3\xB1\xBB\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\xF3\xB1\xBB\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\xF3\xB1\xBB\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\xF3\xB1\xBB\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\xF3\xB1\xBB\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\xF3\xB1\xBB\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\xF3\xB1\xBB\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\xF3\xB1\xBB\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\xF3\xB1\xBB\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xF3\xB1\xBB\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xF3\xB1\xBB\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xF3\xB1\xBB\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xF3\xB1\xBB\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xF3\xB1\xBB\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xF3\xB1\xBB\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xF3\xB1\xBB\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xF3\xB1\xBB\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xF3\xB1\xBB\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xF3\xB1\xBB\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\xF3\xB1\xBB\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\xF3\xB1\xBB\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xF3\xB1\xBB\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],
        ["\xF3\xB1\xBB\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\xF3\xB1\xBB\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\xF3\xB1\xBB\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xF3\xB1\xBB\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xF3\xB1\xBB\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xF3\xB1\xBB\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xF3\xB1\xBB\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xF3\xB1\xBB\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xF3\xB1\xBB\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xF3\xB1\xBB\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xF3\xB1\xBB\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xF3\xB1\xBB\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xF3\xB1\xBB\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\xF3\xB1\xBB\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\xF3\xB1\xBB\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\xF3\xB1\xBB\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\xF3\xB1\xBB\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\xF3\xB1\xBB\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\xF3\xB1\xBB\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xF3\xB1\xBB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\xF3\xB1\xBB\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF3\xB1\xBC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xF3\xB1\xBC\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xF3\xB1\xBC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xF3\xB1\xBC\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xF3\xB1\xBC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xF3\xB1\xBC\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xF3\xB1\xBC\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xF3\xB1\xBC\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\xF3\xB1\xBC\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\xF3\xB1\xBC\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\xF3\xB1\xBC\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\xF3\xB1\xBC\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\xF3\xB1\xBC\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\xF3\xB1\xBC\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xF3\xB1\xBC\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xF3\xB1\xBC\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xF3\xB1\xBC\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF3\xB1\xBC\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],
        ["\xF3\xB1\xBC\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xF3\xB1\xBC\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xF3\xB1\xBC\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xF3\xB1\xBC\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xF3\xB1\xBC\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xF3\xB1\xBC\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\xF3\xB1\xBC\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\xF3\xB1\xBC\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\xF3\xB1\xBC\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],
        ["\xF3\xB1\xBC\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],
        ["\xF3\xB1\xBC\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF3\xB1\xBC\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\xF3\xB1\xBC\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\xF3\xB1\xBC\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\xF3\xB1\xBC\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\xF3\xB1\xBC\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\xF3\xB1\xBC\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\xF3\xB1\xBC\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\xF3\xB1\xBC\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\xF3\xB1\xBC\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\xF3\xB1\xBC\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xF3\xB1\xBC\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\xF3\xB1\xBC\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\xF3\xB1\xBC\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\xF3\xB1\xBC\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\xF3\xB1\xBC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xF3\xB1\xBC\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\xF3\xB1\xBC\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\xF3\xB1\xBC\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\xF3\xB1\xBC\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\xF3\xB1\xBC\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\xF3\xB1\xBC\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\xF3\xB1\xBC\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\xF3\xB1\xBC\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\xF3\xB1\xBC\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\xF3\xB1\xBC\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\xF3\xB1\xBC\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\xF3\xB1\xBC\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\xF3\xB1\xBC\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\xF3\xB1\xBC\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\xF3\xB1\xBC\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\xF3\xB1\xBC\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF3\xB1\xBC\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF3\xB1\xBC\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xF3\xB1\xBC\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xF3\xB1\xBC\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF3\xB1\xBD\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xF3\xB1\xBD\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF3\xB1\xBD\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xF3\xB1\xBD\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xF3\xB1\xBD\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xF3\xB1\xBD\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\xF3\xB1\xBD\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\xF3\xB1\xBD\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\xF3\xB1\xBD\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\xF3\xB1\xBD\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\xF3\xB1\xBD\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\xF3\xB1\xBD\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xF3\xB1\xBD\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xF3\xB1\xBD\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF3\xB1\xBD\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF3\xB1\xBD\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF3\xB1\xBD\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xF3\xB1\xBD\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xF3\xB1\xBD\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xF3\xB1\xBD\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF3\xB1\xBD\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xF3\xB1\xBD\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\xF3\xB1\xBD\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\xF3\xB1\xBD\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\xF3\xB1\xBD\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\xF3\xB1\xBD\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\xF3\xB1\xBD\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\xF3\xB1\xBD\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xF3\xB1\xBD\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\xF3\xB1\xBD\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xF3\xB1\xBD\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xF3\xB1\xBD\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xF3\xB1\xBD\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xF3\xB1\xBD\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xF3\xB1\xBD\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xF3\xB1\xBD\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xF3\xB1\xBD\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xF3\xB1\xBD\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\xF3\xB1\xBD\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\xF3\xB1\xBD\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\xF3\xB1\xBD\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\xF3\xB1\xBD\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\xF3\xB1\xBD\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\xF3\xB1\xBD\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xF3\xB1\xBD\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xF3\xB1\xBD\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xF3\xB1\xBD\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xF3\xB1\xBD\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF3\xB1\xBD\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF3\xB1\xBD\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xF3\xB1\xBD\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xF3\xB1\xBD\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xF3\xB1\xBD\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xF3\xB1\xBD\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\xF3\xB1\xBD\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\xF3\xB1\xBD\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\xF3\xB1\xBD\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],
        ["\xF3\xB1\xBD\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],
        ["\xF3\xB1\xBD\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xF3\xB1\xBD\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],
        ["\xF3\xB1\xBD\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xF3\xB1\xBD\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xF3\xB1\xBD\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"],
        ["\xF3\xB1\xBD\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"],
        ["\xF3\xB2\xAB\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xEB"],
        ["\xF3\xB2\xAB\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xEC"],
        ["\xF3\xB2\xAB\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xED"],
        ["\xF3\xB2\xAB\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xEE"],
        ["\xF3\xB2\xAB\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xEF"],
        ["\xF3\xB2\xAB\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF0"],
        ["\xF3\xB2\xAB\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF1"],
        ["\xF3\xB2\xAB\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF2"],
        ["\xF3\xB2\xAB\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF3"],
        ["\xF3\xB2\xAB\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF4"],
        ["\xF3\xB2\xAB\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA1"],
        ["\xF3\xB2\xAB\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA2"],
        ["\xF3\xB2\xAB\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA3"],
        ["\xF3\xB2\xAB\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xDC"],
        ["\xF3\xB2\xAB\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\xF3\xB2\xAB\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xD9"],
        ["\xF3\xB2\xAB\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xFE"],
        ["\xF3\xB2\xAB\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\xF3\xB2\xAB\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"],
        ["\xF3\xB2\xAB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"],
        ["\xF3\xB2\xAB\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"],
        ["\xF3\xB2\xAC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xCD"],
        ["\xF3\xB2\xAC\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xC9"],
        ["\xF3\xB2\xAC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"],
        ["\xF3\xB2\xAC\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\xF3\xB2\xAC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xAC"],
        ["\xF3\xB2\xAC\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xE8"],
        ["\xF3\xB2\xAC\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\xF3\xB2\xAC\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEF"],
        ["\xF3\xB2\xAC\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xF0"],
        ["\xF3\xB2\xAC\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xFB"],
        ["\xF3\xB2\xAC\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"],
        ["\xF3\xB2\xAC\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xB5"],
        ["\xF3\xB2\xAC\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xB3"],
        ["\xF3\xB2\xAC\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xB9"],
        ["\xF3\xB2\xAC\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xB7"],
        ["\xF3\xB2\xAC\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xCA"],
        ["\xF3\xB2\xAC\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"],
        ["\xF3\xB2\xAC\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xDF"],
        ["\xF3\xB2\xAC\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"],
        ["\xF3\xB2\xAC\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xDE"],
        ["\xF3\xB2\xAC\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"],
        ["\xF3\xB2\xAC\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"],
        ["\xF3\xB2\xAC\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"],
        ["\xF3\xB2\xAC\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xFC"],
        ["\xF3\xB2\xAC\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"],
        ["\xF3\xB2\xAC\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"],
        ["\xF3\xB2\xAC\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"],
        ["\xF3\xB2\xAC\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"],
        ["\xF3\xB2\xAC\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"],
        ["\xF3\xB2\xAC\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xF7"],
        ["\xF3\xB2\xAC\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"],
        ["\xF3\xB2\xAC\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xB4"],
        ["\xF3\xB2\xAC\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xF7"],
        ["\xF3\xB2\xAC\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"],
        ["\xF3\xB2\xAC\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xFA"],
        ["\xF3\xB2\xAC\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\xF3\xB2\xAC\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"],
        ["\xF3\xB2\xAC\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\xF3\xB2\xAC\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\xF3\xB2\xAC\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"],
        ["\xF3\xB2\xAC\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\xF3\xB2\xAC\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"],
        ["\xF3\xB2\xAC\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"],
        ["\xF3\xB2\xAC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"],
        ["\xF3\xB2\xAC\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"],
        ["\xF3\xB2\xAC\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"],
        ["\xF3\xB2\xAC\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"],
        ["\xF3\xB2\xAC\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"],
        ["\xF3\xB2\xAC\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"],
        ["\xF3\xB2\xAC\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"],
        ["\xF3\xB2\xAC\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"],
        ["\xF3\xB2\xAC\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"],
        ["\xF3\xB2\xAC\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"],
        ["\xF3\xB2\xAC\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"],
        ["\xF3\xB2\xAC\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"],
        ["\xF3\xB2\xAC\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xF3\xB2\xAC\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"],
        ["\xF3\xB2\xAC\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"],
        ["\xF3\xB2\xAC\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"],
        ["\xF3\xB2\xAC\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"],
        ["\xF3\xB2\xAC\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"],
        ["\xF3\xB2\xAC\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"],
        ["\xF3\xB2\xAC\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"],
        ["\xF3\xB2\xAC\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"],
        ["\xF3\xB2\xAD\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"],
        ["\xF3\xB2\xAD\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"],
        ["\xF3\xB2\xAD\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\xF3\xB2\xAD\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"],
        ["\xF3\xB2\xAD\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\xF3\xB2\xAD\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\xF3\xB2\xAD\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\xF3\xB2\xAD\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\xF3\xB2\xAD\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\xF3\xB2\xAD\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"],
        ["\xF3\xB2\xAD\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"],
        ["\xF3\xB2\xAD\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"],
        ["\xF3\xB2\xAD\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"],
        ["\xF3\xB2\xAD\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"],
        ["\xF3\xB2\xAD\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"],
        ["\xF3\xB2\xAD\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"],
        ["\xF3\xB2\xAD\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"],
        ["\xF3\xB2\xAD\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"],
        ["\xF3\xB2\xAD\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"],
        ["\xF3\xB2\xAD\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"],
        ["\xF3\xB2\xAD\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"],
        ["\xF3\xB2\xAD\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"],
        ["\xF3\xB2\xAD\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"],
        ["\xF3\xB2\xAD\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"],
        ["\xF3\xB2\xAD\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"],
        ["\xF3\xB2\xAD\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"],
        ["\xF3\xB2\xAD\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"],
        ["\xF3\xB2\xAD\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"],
        ["\xF3\xB2\xAD\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"],
        ["\xF3\xB2\xAD\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"],
        ["\xF3\xB2\xAD\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"],
        ["\xF3\xB2\xAD\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"],
        ["\xF3\xB2\xAD\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"],
        ["\xF3\xB2\xAD\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"],
        ["\xF3\xB2\xAD\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"],
        ["\xF3\xB2\xAD\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"],
        ["\xF3\xB2\xAD\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"],
        ["\xF3\xB2\xAD\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"],
        ["\xF3\xB2\xAD\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"],
        ["\xF3\xB2\xAD\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"],
        ["\xF3\xB2\xAD\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\xF3\xB2\xAD\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"],
        ["\xF3\xB2\xAD\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"],
        ["\xF3\xB2\xAD\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],
        ["\xF3\xB2\xAD\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"],
        ["\xF3\xB2\xAD\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"],
        ["\xF3\xB2\xAD\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"],
        ["\xF3\xB2\xAD\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"],
        ["\xF3\xB2\xAD\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"],
        ["\xF3\xB2\xAD\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"],
        ["\xF3\xB2\xAD\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"],
        ["\xF3\xB2\xAD\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"],
        ["\xF3\xB2\xAD\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"],
        ["\xF3\xB2\xAD\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"],
        ["\xF3\xB2\xAD\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"],
        ["\xF3\xB2\xAD\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"],
        ["\xF3\xB2\xAD\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"],
        ["\xF3\xB2\xAD\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"],
        ["\xF3\xB2\xAD\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"],
        ["\xF3\xB2\xAD\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"],
        ["\xF3\xB2\xAD\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xCE"],
        ["\xF3\xB2\xAD\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"],
        ["\xF3\xB2\xAD\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"],
        ["\xF3\xB2\xAD\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xB4"],
        ["\xF3\xB2\xAE\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"],
        ["\xF3\xB2\xAE\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xC7"],
        ["\xF3\xB2\xAE\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"],
        ["\xF3\xB2\xAE\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],
        ["\xF3\xB2\xAE\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xED"],
        ["\xF3\xB2\xAE\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],
        ["\xF3\xB2\xAE\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"],
        ["\xF3\xB2\xAE\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD2"],
        ["\xF3\xB2\xAE\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],
        ["\xF3\xB2\xAE\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"],
        ["\xF3\xB2\xAE\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xE8"],
        ["\xF3\xB2\xAE\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"],
        ["\xF3\xB2\xAE\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"],
        ["\xF3\xB2\xAE\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xBC"],
        ["\xF3\xB2\xAE\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"],
        ["\xF3\xB2\xAE\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"],
        ["\xF3\xB2\xAE\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"],
        ["\xF3\xB2\xAE\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"],
        ["\xF3\xB2\xAE\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"],
        ["\xF3\xB2\xAE\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"],
        ["\xF3\xB2\xAE\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"],
        ["\xF3\xB2\xAE\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"],
        ["\xF3\xB2\xAE\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xA3"],
        ["\xF3\xB2\xAE\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xDE"],
        ["\xF3\xB2\xAE\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"],
        ["\xF3\xB2\xAE\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"],
        ["\xF3\xB2\xAE\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xB2"],
        ["\xF3\xB2\xAE\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"],
        ["\xF3\xB2\xAE\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"],
        ["\xF3\xB2\xAE\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"],
        ["\xF3\xB2\xAE\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"],
        ["\xF3\xB2\xAE\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"],
        ["\xF3\xB2\xAE\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"],
        ["\xF3\xB2\xAE\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"],
        ["\xF3\xB2\xAE\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"],
        ["\xF3\xB2\xAE\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"],
        ["\xF3\xB2\xAE\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xAE"],
        ["\xF3\xB2\xAE\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"],
        ["\xF3\xB2\xAE\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"],
        ["\xF3\xB2\xAE\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"],
        ["\xF3\xB2\xAE\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"],
        ["\xF3\xB2\xAE\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\xF3\xB2\xAE\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xDE"],
        ["\xF3\xB2\xAE\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"],
        ["\xF3\xB2\xAE\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"],
        ["\xF3\xB2\xAE\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\xF3\xB2\xAE\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"],
        ["\xF3\xB2\xAE\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"],
        ["\xF3\xB2\xAE\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE3"],
        ["\xF3\xB2\xAE\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\xF3\xB2\xAE\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"],
        ["\xF3\xB2\xAE\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"],
        ["\xF3\xB2\xAE\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"],
        ["\xF3\xB2\xAE\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xED"],
        ["\xF3\xB2\xAE\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"],
        ["\xF3\xB2\xAE\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"],
        ["\xF3\xB2\xAE\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"],
        ["\xF3\xB2\xAE\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"],
        ["\xF3\xB2\xAE\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\xF3\xB2\xAE\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\xF3\xB2\xAE\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\xF3\xB2\xAE\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\xF3\xB2\xAE\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\xF3\xB2\xAE\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\xF3\xB2\xAF\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\xF3\xB2\xAF\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\xF3\xB2\xAF\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"],
        ["\xF3\xB2\xAF\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"],
        ["\xF3\xB2\xAF\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\xF3\xB2\xAF\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"],
        ["\xF3\xB2\xAF\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"],
        ["\xF3\xB2\xAF\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\xF3\xB2\xAF\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\xF3\xB2\xAF\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xA4"],
        ["\xF3\xB2\xAF\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"],
        ["\xF3\xB2\xAF\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"],
        ["\xF3\xB2\xAF\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\xF3\xB2\xAF\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\xF3\xB2\xAF\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"],
        ["\xF3\xB2\xAF\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"],
        ["\xF3\xB2\xAF\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"],
        ["\xF3\xB2\xAF\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"],
        ["\xF3\xB2\xAF\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\xF3\xB2\xAF\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\xF3\xB2\xAF\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\xF3\xB2\xAF\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE5"],
        ["\xF3\xB2\xAF\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"],
        ["\xF3\xB2\xAF\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\xF3\xB2\xAF\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\xF3\xB2\xAF\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\xF3\xB2\xAF\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\xF3\xB2\xAF\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\xF3\xB2\xAF\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"],
        ["\xF3\xB2\xAF\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xE5"],
        ["\xF3\xB2\xAF\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\xF3\xB2\xAF\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\xF3\xB2\xAF\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\xF3\xB2\xAF\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xFD"],
        ["\xF3\xB2\xAF\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\xF3\xB2\xAF\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\xF3\xB2\xAF\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB6"],
        ["\xF3\xB2\xAF\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\xF3\xB2\xAF\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\xF3\xB2\xAF\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\xF3\xB2\xAF\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\xF3\xB2\xAF\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA1"],
        ["\xF3\xB2\xAF\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xD9"],
        ["\xF3\xB2\xAF\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE7"],
        ["\xF3\xB2\xAF\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xF0"],
        ["\xF3\xB2\xAF\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xFE"],
        ["\xF3\xB2\xAF\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"],
        ["\xF3\xB2\xAF\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE8"],
        ["\xF3\xB2\xAF\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"],
        ["\xF3\xB2\xAF\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\xF3\xB2\xAF\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\xF3\xB2\xAF\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\xF3\xB2\xAF\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\xF3\xB2\xAF\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\xF3\xB2\xAF\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xEA"],
        ["\xF3\xB2\xAF\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"],
        ["\xF3\xB2\xAF\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\xF3\xB2\xAF\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\xF3\xB2\xAF\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\xF3\xB2\xAF\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\xF3\xB2\xAF\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\xF3\xB2\xAF\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"],
        ["\xF3\xB2\xAF\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xEA"],
        ["\xF3\xB2\xAF\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\xF3\xB2\xB0\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xB7"],
        ["\xF3\xB2\xB0\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xB6"],
        ["\xF3\xB2\xB0\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\xF3\xB2\xB0\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\xF3\xB2\xB0\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\xF3\xB2\xB0\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\xF3\xB2\xB0\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\xF3\xB2\xB0\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"],
        ["\xF3\xB2\xB0\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],
        ["\xF3\xB2\xB0\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xED"],
        ["\xF3\xB2\xB0\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"],
        ["\xF3\xB2\xB0\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xFB"],
        ["\xF3\xB2\xB0\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xFA"],
        ["\xF3\xB2\xB0\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA6"],
        ["\xF3\xB2\xB0\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA8"],
        ["\xF3\xB2\xB0\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xDF"],
        ["\xF3\xB2\xB0\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xB0"],
        ["\xF3\xB2\xB0\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xBE"],
        ["\xF3\xB2\xB0\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xBC"],
        ["\xF3\xB2\xB0\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xBF"],
        ["\xF3\xB2\xB0\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC5"],
        ["\xF3\xB2\xB0\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC6"],
        ["\xF3\xB2\xB0\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"],
        ["\xF3\xB2\xB0\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"],
        ["\xF3\xB2\xB0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xCD"],
        ["\xF3\xB2\xB0\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD1"],
        ["\xF3\xB2\xB0\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"],
        ["\xF3\xB2\xB0\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE1"],
        ["\xF3\xB2\xB0\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE4"],
        ["\xF3\xB2\xB0\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE2"],
        ["\xF3\xB2\xB0\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"],
        ["\xF3\xB2\xB0\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xEE"],
        ["\xF3\xB2\xB0\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xEA"],
        ["\xF3\xB2\xB0\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE0"],
        ["\xF3\xB2\xB0\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD2"],
        ["\xF3\xB2\xB0\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xA7"],
        ["\xF3\xB2\xB0\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF7"],
        ["\xF3\xB2\xB0\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF8"],
        ["\xF3\xB2\xB0\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xC4"],
        ["\xF3\xB2\xB0\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xBC"],
        ["\xF3\xB2\xB0\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xBE"],
        ["\xF3\xB2\xB0\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xB8"],
        ["\xF3\xB2\xB0\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD3"],
        ["\xF3\xB2\xB0\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xBB"],
        ["\xF3\xB2\xB0\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xC2"],
        ["\xF3\xB2\xB0\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xBA"],
        ["\xF3\xB2\xB0\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xD5"],
        ["\xF3\xB2\xB0\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xD3"],
        ["\xF3\xB2\xB0\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xB3"],
        ["\xF3\xB2\xB0\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD4"],
        ["\xF3\xB2\xB0\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xD1"],
        ["\xF3\xB2\xB0\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xCA"],
        ["\xF3\xB2\xB0\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xD0"],
        ["\xF3\xB2\xB0\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xCC"],
        ["\xF3\xB2\xB0\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xE4"],
        ["\xF3\xB2\xB0\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xDE"],
        ["\xF3\xB2\xB0\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xF2"],
        ["\xF3\xB2\xB0\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xF9"],
        ["\xF3\xB2\xB0\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xA3"],
        ["\xF3\xB2\xB0\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xAE"],
        ["\xF3\xB2\xB0\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xBD"],
        ["\xF3\xB2\xB0\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC5"],
        ["\xF3\xB2\xB0\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC6"],
        ["\xF3\xB2\xB0\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE1"],
        ["\xF3\xB2\xB1\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xCC"],
        ["\xF3\xB2\xB1\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE0"],
        ["\xF3\xB2\xB1\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD4"],
        ["\xF3\xB2\xB1\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xDB"],
        ["\xF3\xB2\xB1\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xAC"],
        ["\xF3\xB2\xB1\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xAD"],
        ["\xF3\xB2\xB1\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xB0"],
        ["\xF3\xB2\xB1\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xB1"],
        ["\xF3\xB2\xB1\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xAE"],
        ["\xF3\xB2\xB1\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xB3"],
        ["\xF3\xB2\xB1\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xB5"],
        ["\xF3\xB2\xB1\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF3"],
        ["\xF3\xB2\xB1\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"],
        ["\xF3\xB2\xB1\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xB3"],
        ["\xF3\xB2\xB1\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xB4"],
        ["\xF3\xB2\xB1\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xBD"],
        ["\xF3\xB2\xB1\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xBE"],
        ["\xF3\xB2\xB1\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\xF3\xB2\xB1\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF6"],
        ["\xF3\xB2\xB1\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xA4"],
        ["\xF3\xB2\xB1\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xA7"],
        ["\xF3\xB2\xB1\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD0"],
        ["\xF3\xB2\xB1\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xEE"],
        ["\xF3\xB2\xB1\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD8"],
        ["\xF3\xB2\xB1\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xDB"],
        ["\xF3\xB2\xB1\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xEF"],
        ["\xF3\xB2\xB1\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE3"],
        ["\xF3\xB2\xB1\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA3"],
        ["\xF3\xB2\xB1\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA1"],
        ["\xF3\xB2\xB1\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xB2"],
        ["\xF3\xB2\xB1\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xAE"],
        ["\xF3\xB2\xB1\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD6"],
        ["\xF3\xB2\xB7\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xAF"],
        ["\xF3\xB2\xB7\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xAE"],
        ["\xF3\xB2\xB7\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB3"],
        ["\xF3\xB2\xB7\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB2"],
        ["\xF3\xB2\xB7\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB1"],
        ["\xF3\xB2\xB7\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB0"],
        ["\xF3\xB2\xB8\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD2"],
        ["\xF3\xB2\xB8\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC8"],
        ["\xF3\xB2\xB9\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC5"],
        ["\xF3\xB2\xBB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB7"],
        ["\xF3\xB2\xBC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB8"],
        ["\xF3\xB2\xBC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB6"],
        ["\xF3\xB2\xBC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB5"],
        ["\xF3\xB2\xBC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF9"],
        ["\xF3\xB2\xBC\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF7"],
        ["\xF3\xB3\x80\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAC"],
        ["\xF3\xB3\x80\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC0"],
        ["\xF3\xB3\x80\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD0"],
        ["\xF3\xB3\x80\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAE"],
        ["\xF3\xB3\x80\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC2"],
        ["\xF3\xB3\x80\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB0"],
        ["\xF3\xB3\x80\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC4"],
        ["\xF3\xB3\x80\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA6"],
        ["\xF3\xB3\x80\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xCA"],
        ["\xF3\xB3\x80\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB2"],
        ["\xF3\xB3\x80\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC6"],
        ["\xF3\xB3\x80\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA8"],
        ["\xF3\xB3\x80\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB4"],
        ["\xF3\xB3\x80\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC8"],
        ["\xF3\xB3\x80\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAA"],
        ["\xF3\xB3\x80\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB5"],
        ["\xF3\xB3\x80\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAB"],
        ["\xF3\xB3\x80\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xBF"],
        ["\xF3\xB3\x80\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA1"],
        ["\xF3\xB3\x80\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xCF"],
        ["\xF3\xB3\x80\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB7"],
        ["\xF3\xB3\x80\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAD"],
        ["\xF3\xB3\x80\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC1"],
        ["\xF3\xB3\x81\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA3"],
        ["\xF3\xB3\x81\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAF"],
        ["\xF3\xB3\x81\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC3"],
        ["\xF3\xB3\x81\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC9"],
        ["\xF3\xB3\x81\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB1"],
        ["\xF3\xB3\x81\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC5"],
        ["\xF3\xB3\x81\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA7"],
        ["\xF3\xB3\x81\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xBD"],
        ["\xF3\xB3\x81\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB3"],
        ["\xF3\xB3\x81\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC7"],
        ["\xF3\xB3\x81\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA9"],
        ["\xF3\xB3\x83\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD8"],
        ["\xF3\xB3\x83\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD9"],
        ["\xF3\xB3\x87\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xAD"],
        ["\xF3\xB3\x87\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCF"],
        ["\xF3\xB3\x87\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEC"],
        ["\xF3\xB3\x87\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEE"],
        ["\xF3\xB3\x87\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xF2"],
        ["\xF3\xB3\x87\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xA2"],
        ["\xF3\xB3\x87\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xA3"],
        ["\xF3\xB3\x87\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xAA"],
        ["\xF3\xB3\x87\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xB8"],
        ["\xF3\xB3\x87\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xBB"],
        ["\xF3\xB3\x87\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xD3"],
        ["\xF3\xB3\x87\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xD7"],
        ["\xF3\xB3\x87\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xDB"],
        ["\xF3\xB3\x87\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xE0"],
        ["\xF3\xB3\x87\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xE1"],
        ["\xF3\xB3\x87\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xAD"],
        ["\xF3\xB3\x87\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB6"],
        ["\xF3\xB3\x87\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB7"],
        ["\xF3\xB3\x87\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xBE"],
        ["\xF3\xB3\x88\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xC4"],
        ["\xF3\xB3\x88\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xD5"],
        ["\xF3\xB3\x88\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xD7"],
        ["\xF3\xB3\x88\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xB8"],
        ["\xF3\xB3\x88\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xA8"],
        ["\xF3\xB3\x88\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xC2"],
        ["\xF3\xB3\x88\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xC4"],
        ["\xF3\xB3\x88\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xCC"],
        ["\xF3\xB3\x88\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xE7"],
        ["\xF3\xB3\x88\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xEF"],
        ["\xF3\xB3\x88\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB1"],
        ["\xF3\xB3\x88\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xC3"],
        ["\xF3\xB3\x88\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xCB"],
        ["\xF3\xB3\x88\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDE"],
        ["\xF3\xB3\x88\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xAC"],
        ["\xF3\xB3\x88\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xB3"],
        ["\xF3\xB3\x88\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xB9"],
        ["\xF3\xB3\x88\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xBC"],
        ["\xF3\xB3\x88\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xBF"],
        ["\xF3\xB3\x88\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xC3"],
        ["\xF3\xB3\x88\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xC6"],
        ["\xF3\xB3\x88\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xD0"],
        ["\xF3\xB3\x88\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xDB"],
        ["\xF3\xB3\x88\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xDD"],
        ["\xF3\xB3\x88\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xDF"],
        ["\xF3\xB3\x88\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE3"],
        ["\xF3\xB3\x88\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE5"],
        ["\xF3\xB3\x88\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE7"],
        ["\xF3\xB3\x89\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\xF3\xB3\x89\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\xF3\xB3\x89\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xF7"],
        ["\xF3\xB3\x89\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xF8"],
        ["\xF3\xB3\x89\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\xF3\xB3\x89\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xA2"],
        ["\xF3\xB3\x89\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xA6"],
        ["\xF3\xB3\x89\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xF4"],
        ["\xF3\xB3\x89\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xAD"],
        ["\xF3\xB3\x89\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xA8"],
        ["\xF3\xB3\x89\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xA7"],
        ["\xF3\xB3\x89\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xB3"],
        ["\xF3\xB3\x89\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xB4"],
        ["\xF3\xB3\x89\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xC4"],
        ["\xF3\xB3\x89\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xE1"],
        ["\xF3\xB3\x89\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xE2"],
        ["\xF3\xB3\x89\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xEC"],
        ["\xF3\xB3\x89\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xEE"],
        ["\xF3\xB3\x89\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xFA"],
        ["\xF3\xB3\x89\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xFD"],
        ["\xF3\xB3\x89\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xA2"],
        ["\xF3\xB3\x89\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xA4"],
        ["\xF3\xB3\x89\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xD1"],
        ["\xF3\xB3\x89\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xD0"],
        ["\xF3\xB3\x89\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xA6"],
        ["\xF3\xB3\x89\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\xF3\xB3\x89\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xB9"],
        ["\xF3\xB3\x89\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xB6"],
        ["\xF3\xB3\x89\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xDC"],
        ["\xF3\xB3\x89\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xBD"],
        ["\xF3\xB3\x89\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xBF"],
        ["\xF3\xB3\x89\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xC0"],
        ["\xF3\xB3\x89\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xC1"],
        ["\xF3\xB3\x89\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xC5"],
        ["\xF3\xB3\x89\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xD1"],
        ["\xF3\xB3\x89\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xD3"],
        ["\xF3\xB3\x89\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xEC"],
        ["\xF3\xB3\x89\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xFB"],
        ["\xF3\xB3\x89\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xFE"],
        ["\xF3\xB3\x8A\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xA8"],
        ["\xF3\xB3\x8A\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xAD"],
        ["\xF3\xB3\x8A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xAE"],
        ["\xF3\xB3\x8A\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xB9"],
        ["\xF3\xB3\x8A\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xBC"],
        ["\xF3\xB3\x8A\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xC7"],
        ["\xF3\xB3\x8A\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xC8"],
        ["\xF3\xB3\x8A\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xC9"],
        ["\xF3\xB3\x8A\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD1"],
        ["\xF3\xB3\x8A\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD3"],
        ["\xF3\xB3\x8A\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD9"],
        ["\xF3\xB3\x8A\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xE6"],
        ["\xF3\xB3\xB8\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xA8"],
        ["\xF3\xB3\xB8\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xDB"],
        ["\xF3\xB3\xB8\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\xF3\xB3\xB8\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xB7"],
        ["\xF3\xB3\xB8\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xBB"],
        ["\xF3\xB3\xB8\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xC1"],
        ["\xF3\xB3\xB8\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xC2"],
        ["\xF3\xB3\xB9\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xC6"],
        ["\xF3\xB3\xB9\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xB4"],
        ["\xF3\xB3\xB9\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xDB"],
        ["\xF3\xB3\xB9\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xDC"],
        ["\xF3\xB3\xB9\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xB0"],
        ["\xF3\xB4\x83\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBB"],
        ["\xF3\xB4\xAE\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xA2"],
        ["\xF3\xB4\xAE\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xFA"],
        ["\xF3\xB4\xAE\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xA9"],
        ["\xF3\xB4\xAE\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\xF3\xB4\xAE\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xCA"],
        ["\xF3\xB4\xAE\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xDC"],
        ["\xF3\xB4\xAE\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xEC"],
        ["\xF3\xB4\xAE\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xEF"],
        ["\xF3\xB4\xAE\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\xF3\xB4\xAE\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\xF3\xB4\xAE\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xFA"],
        ["\xF3\xB4\xAE\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xA5"],
        ["\xF3\xB4\xAE\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xB0"],
        ["\xF3\xB4\xAE\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xB5"],
        ["\xF3\xB4\xAE\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xBA"],
        ["\xF3\xB4\xAE\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xBE"],
        ["\xF3\xB4\xAE\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xEC"],
        ["\xF3\xB4\xAE\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xF0"],
        ["\xF3\xB4\xAE\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xC9"],
        ["\xF3\xB4\xAE\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xF7"],
        ["\xF3\xB4\xAE\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xFA"],
        ["\xF3\xB4\xAE\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xFC"],
        ["\xF3\xB4\xAE\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xAD"],
        ["\xF3\xB4\xAE\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xB0"],
        ["\xF3\xB4\xAE\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xB1"],
        ["\xF3\xB4\xAE\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xBB"],
        ["\xF3\xB4\xAE\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xC0"],
        ["\xF3\xB4\xAF\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xCB"],
        ["\xF3\xB4\xAF\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xCD"],
        ["\xF3\xB4\xAF\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xD8"],
        ["\xF3\xB4\xAF\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xE5"],
        ["\xF3\xB4\xAF\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xE1"],
        ["\xF3\xB4\xAF\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xF5"],
        ["\xF3\xB4\xAF\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xFD"],
        ["\xF3\xB4\xAF\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\xF3\xB4\xAF\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xAC"],
        ["\xF3\xB4\xAF\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xAF"],
        ["\xF3\xB4\xAF\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xB7"],
        ["\xF3\xB4\xAF\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\xF3\xB4\xAF\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\xF3\xB4\xAF\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xCC"],
        ["\xF3\xB4\xAF\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xCE"],
        ["\xF3\xB4\xAF\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xEF"],
        ["\xF3\xB4\xAF\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xA5"],
        ["\xF3\xB4\xAF\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xA6"],
        ["\xF3\xB4\xAF\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA6"],
        ["\xF3\xB4\xAF\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xA8"],
        ["\xF3\xB4\xAF\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xB6"],
        ["\xF3\xB4\xAF\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xCA"],
        ["\xF3\xB4\xAF\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xDD"],
        ["\xF3\xB4\xAF\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xC9"],
        ["\xF3\xB4\xAF\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xCB"],
        ["\xF3\xB4\xAF\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xA2"],
        ["\xF3\xB4\xAF\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xCC"],
        ["\xF3\xB4\xB0\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xD2"],
        ["\xF3\xB4\xB0\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xD7"],
        ["\xF3\xB4\xB0\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xA7"],
        ["\xF3\xB4\xB0\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xA6"],
        ["\xF3\xB4\xB0\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xE1"],
        ["\xF3\xB4\xB0\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xAA"],
        ["\xF3\xB4\xB0\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xEE"],
        ["\xF3\xB4\xB0\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xF4"],
        ["\xF3\xB4\xB0\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xF7"],
        ["\xF3\xB4\xB0\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xC0"],
        ["\xF3\xB4\xB0\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xFC"],
        ["\xF3\xB4\xB0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xFE"],
        ["\xF3\xB4\xB0\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xA7"],
        ["\xF3\xB4\xB0\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xAB"],
        ["\xF3\xB4\xB0\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xAD"],
        ["\xF3\xB4\xB0\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xB3"],
        ["\xF3\xB4\xB0\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xB7"],
        ["\xF3\xB4\xB0\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xC3"],
        ["\xF3\xB4\xB0\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xCC"],
        ["\xF3\xB4\xB0\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xCF"],
        ["\xF3\xB4\xB0\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD0"],
        ["\xF3\xB4\xB0\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD3"],
        ["\xF3\xB4\xB0\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD7"],
        ["\xF3\xB4\xB0\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xF3"],
        ["\xF3\xB4\xB0\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xDF"],
        ["\xF3\xB4\xB0\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xE0"],
        ["\xF3\xB4\xB0\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xE1"],
        ["\xF3\xB4\xB0\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xE2"],
        ["\xF3\xB4\xB0\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xE7"],
        ["\xF3\xB4\xB0\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xE4"],
        ["\xF3\xB4\xB0\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xEA"],
        ["\xF3\xB4\xB1\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xEE"],
        ["\xF3\xB4\xB1\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xF1"],
        ["\xF3\xB4\xB1\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xF4"],
        ["\xF3\xB4\xB1\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xA2"],
        ["\xF3\xB4\xB1\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xA3"],
        ["\xF3\xB4\xB1\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xA5"],
        ["\xF3\xB4\xB1\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xF8"],
        ["\xF3\xB4\xB1\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xAA"],
        ["\xF3\xB4\xB1\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xB1"],
        ["\xF3\xB4\xB1\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xB4"],
        ["\xF3\xB4\xB1\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xB5"],
        ["\xF3\xB4\xB1\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xBE"],
        ["\xF3\xB4\xB1\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xC0"],
        ["\xF3\xB4\xB1\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xCB"],
        ["\xF3\xB4\xB1\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xCF"],
        ["\xF3\xB4\xB1\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xD1"],
        ["\xF3\xB4\xB1\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xD6"],
        ["\xF3\xB4\xB1\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xE0"],
        ["\xF3\xB4\xB1\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xE5"],
        ["\xF3\xB4\xB1\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xED"],
        ["\xF3\xB4\xB1\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xFE"],
        ["\xF3\xB4\xB1\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xA8"],
        ["\xF3\xB4\xB1\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xAD"],
        ["\xF3\xB4\xB1\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xBB"],
        ["\xF3\xB4\xB1\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xC2"],
        ["\xF3\xB4\xB2\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xCC"],
        ["\xF3\xB4\xB2\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xD1"],
        ["\xF3\xB4\xB2\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xD6"],
        ["\xF3\xB4\xB2\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xDB"],
        ["\xF3\xB4\xB2\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xDC"],
        ["\xF3\xB4\xB2\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xE2"],
        ["\xF3\xB4\xB2\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xEB"],
        ["\xF3\xB4\xB2\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xED"],
        ["\xF3\xB4\xB2\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xF0"],
        ["\xF3\xB4\xB2\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xF6"],
        ["\xF3\xB4\xB2\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xFA"],
        ["\xF3\xB4\xB2\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xA2"],
        ["\xF3\xB4\xB2\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xA6"],
        ["\xF3\xB4\xB2\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xB0"],
        ["\xF3\xB4\xB2\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xB1"],
        ["\xF3\xB4\xB2\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xB4"],
        ["\xF3\xB4\xB2\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xFB"],
        ["\xF3\xB4\xB2\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xC6"],
        ["\xF3\xB4\xB2\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xD0"],
        ["\xF3\xB4\xB2\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xDD"],
        ["\xF3\xB4\xB2\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xE1"],
        ["\xF3\xB4\xB2\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xF0"],
        ["\xF3\xB4\xB2\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xF2"],
        ["\xF3\xB4\xB2\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xF6"],
        ["\xF3\xB4\xB2\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xF7"],
        ["\xF3\xB4\xB2\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xA2"],
        ["\xF3\xB4\xB2\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xA3"],
        ["\xF3\xB4\xB2\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xA7"],
        ["\xF3\xB4\xB2\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xAF"],
        ["\xF3\xB4\xB2\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xB2"],
        ["\xF3\xB4\xB3\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\xF3\xB4\xB3\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\xF3\xB4\xB3\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\xF3\xB4\xB3\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xDD"],
        ["\xF3\xB4\xB3\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\xF3\xB4\xB3\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\xF3\xB4\xB3\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\xF3\xB4\xB3\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xE6"],
        ["\xF3\xB4\xB3\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xEF"],
        ["\xF3\xB4\xB3\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\xF3\xB4\xB3\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xCD"],
        ["\xF3\xB4\xB3\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\xF3\xB4\xB3\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xA3"],
        ["\xF3\xB4\xB3\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xFD"],
        ["\xF3\xB4\xB3\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xC1"],
        ["\xF3\xB4\xB3\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xC9"],
        ["\xF3\xB4\xB3\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xEE"],
        ["\xF3\xB4\xB3\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xF3"],
        ["\xF3\xB4\xB3\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xF7"],
        ["\xF3\xB4\xB3\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xAD"],
        ["\xF3\xB4\xB3\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB2"],
        ["\xF3\xB4\xB3\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB4"],
        ["\xF3\xB4\xB3\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xA5"],
        ["\xF3\xB4\xB3\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\xF3\xB4\xB4\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\xF3\xB4\xB4\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\xF3\xB4\xB4\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\xF3\xB4\xB4\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\xF3\xB4\xB4\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\xF3\xB4\xB4\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xDE"],
        ["\xF3\xB4\xB4\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE1"],
        ["\xF3\xB4\xB4\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\xF3\xB4\xB4\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\xF3\xB4\xB4\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\xF3\xB4\xB4\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\xF3\xB4\xB4\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\xF3\xB4\xB4\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\xF3\xB4\xB4\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xFE"],
        ["\xF3\xB4\xB4\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\xF3\xB4\xB4\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\xF3\xB4\xB4\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\xF3\xB4\xB4\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\xF3\xB4\xB4\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\xF3\xB4\xB4\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xDE"],
        ["\xF3\xB4\xB4\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\xF3\xB4\xB4\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\xF3\xB4\xB4\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\xF3\xB4\xB4\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xEC"],
        ["\xF3\xB4\xB4\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xEE"],
        ["\xF3\xB4\xB4\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\xF3\xB4\xB4\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\xF3\xB4\xB4\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\xF3\xB4\xB5\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xB4"],
        ["\xF3\xB4\xB5\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xBF"],
        ["\xF3\xB4\xB5\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\xF3\xB4\xB5\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\xF3\xB4\xB5\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC8"],
        ["\xF3\xB4\xB5\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\xF3\xB4\xB5\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\xF3\xB4\xB5\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xCF"],
        ["\xF3\xB4\xB5\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\xF3\xB4\xB5\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\xF3\xB4\xB5\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\xF3\xB4\xB5\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xA2"],
        ["\xF3\xB4\xB5\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\xF3\xB4\xB5\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xAF"],
        ["\xF3\xB4\xB5\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xB1"],
        ["\xF3\xB4\xB5\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xB7"],
        ["\xF3\xB4\xB5\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xC2"],
        ["\xF3\xB4\xB5\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xC4"],
        ["\xF3\xB4\xB5\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\xF3\xB4\xB5\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xB3"],
        ["\xF3\xB4\xB5\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\xF3\xB4\xB5\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\xF3\xB4\xB5\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD4"],
        ["\xF3\xB4\xB5\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD6"],
        ["\xF3\xB4\xB5\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD8"],
        ["\xF3\xB4\xB5\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD7"],
        ["\xF3\xB4\xB5\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xDF"],
        ["\xF3\xB4\xB5\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xD9"],
        ["\xF3\xB4\xB5\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xE2"],
        ["\xF3\xB4\xB6\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xE7"],
        ["\xF3\xB4\xB6\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xEE"],
        ["\xF3\xB4\xB6\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xB1"],
        ["\xF3\xB4\xB6\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xF9"],
        ["\xF3\xB4\xB6\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\xF3\xB4\xB6\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\xF3\xB4\xB6\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xE3"],
        ["\xF3\xB4\xB6\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xBA"],
        ["\xF3\xB4\xB6\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xBF"],
        ["\xF3\xB4\xB6\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\xF3\xB4\xB6\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\xF3\xB4\xB6\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xD3"],
        ["\xF3\xB4\xB6\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xD4"],
        ["\xF3\xB4\xB6\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xD6"],
        ["\xF3\xB4\xB6\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\xF3\xB4\xB6\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xF5"],
        ["\xF3\xB4\xB6\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xF7"],
        ["\xF3\xB4\xB6\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xFC"],
        ["\xF3\xB4\xB6\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xFD"],
        ["\xF3\xB4\xB6\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xAE"],
        ["\xF3\xB4\xB6\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xAF"],
        ["\xF3\xB4\xB6\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\xF3\xB4\xB6\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xCE"],
        ["\xF3\xB4\xB6\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\xF3\xB4\xB6\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\xF3\xB4\xB6\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\xF3\xB4\xB6\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\xF3\xB4\xB6\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xEF"],
        ["\xF3\xB4\xB6\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\xF3\xB4\xB6\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\xF3\xB4\xB6\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\xF3\xB4\xB6\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xFA"],
        ["\xF3\xB4\xB7\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\xF3\xB4\xB7\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\xF3\xB4\xB7\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB2"],
        ["\xF3\xB4\xB7\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\xF3\xB4\xB7\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\xF3\xB4\xB7\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\xF3\xB4\xB7\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xCB"],
        ["\xF3\xB4\xB7\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\xF3\xB4\xB7\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\xF3\xB4\xB7\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\xF3\xB4\xB7\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\xF3\xB4\xB7\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA2"],
        ["\xF3\xB4\xB7\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\xF3\xB4\xB7\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xAE"],
        ["\xF3\xB4\xB7\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA6"],
        ["\xF3\xB4\xB7\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA7"],
        ["\xF3\xB4\xB7\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xAD"],
        ["\xF3\xB4\xB7\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xAE"],
        ["\xF3\xB4\xB7\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\xF3\xB4\xB7\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\xF3\xB4\xB7\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\xF3\xB4\xB7\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xB8"],
        ["\xF3\xB4\xB7\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xBB"],
        ["\xF3\xB4\xB7\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xBE"],
        ["\xF3\xB4\xB7\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xC5"],
        ["\xF3\xB4\xB7\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xCF"],
        ["\xF3\xB4\xB7\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xD2"],
        ["\xF3\xB4\xB7\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xDF"],
        ["\xF3\xB4\xB7\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xE0"],
        ["\xF3\xB4\xB7\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\xF3\xB4\xB7\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xBF"],
        ["\xF3\xB4\xB7\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xC5"],
        ["\xF3\xB4\xB7\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\xF3\xB4\xB8\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xC9"],
        ["\xF3\xB4\xB8\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\xF3\xB4\xB8\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xCD"],
        ["\xF3\xB4\xB8\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xCE"],
        ["\xF3\xB4\xB8\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xD0"],
        ["\xF3\xB4\xB8\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\xF3\xB4\xB8\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xD7"],
        ["\xF3\xB4\xB8\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xD8"],
        ["\xF3\xB4\xB8\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xE8"],
        ["\xF3\xB4\xB8\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xEB"],
        ["\xF3\xB4\xB8\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xEC"],
        ["\xF3\xB4\xB8\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\xF3\xB4\xB8\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xF1"],
        ["\xF3\xB4\xB8\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xF2"],
        ["\xF3\xB4\xB8\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xF4"],
        ["\xF3\xB4\xB8\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xF5"],
        ["\xF3\xB4\xB8\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xF6"],
        ["\xF3\xB4\xB8\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xFC"],
        ["\xF3\xB4\xB8\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xFD"],
        ["\xF3\xB4\xB8\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA2"],
        ["\xF3\xB4\xB8\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\xF3\xB4\xB8\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA7"],
        ["\xF3\xB4\xB8\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xAC"],
        ["\xF3\xB4\xB8\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\xF3\xB4\xB8\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB7"],
        ["\xF3\xB4\xB8\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\xF3\xB4\xB8\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xBC"],
        ["\xF3\xB4\xB8\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xFA"],
        ["\xF3\xB4\xB8\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\xF3\xB4\xB8\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\xF3\xB4\xB8\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\xF3\xB4\xB8\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\xF3\xB4\xB8\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\xF3\xB4\xB8\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xEA"],
        ["\xF3\xB4\xB9\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xEF"],
        ["\xF3\xB4\xB9\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\xF3\xB4\xB9\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\xF3\xB4\xB9\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\xF3\xB4\xB9\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xA8"],
        ["\xF3\xB4\xB9\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\xF3\xB4\xB9\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\xF3\xB4\xB9\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\xF3\xB4\xB9\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\xF3\xB4\xB9\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xCA"],
        ["\xF3\xB4\xB9\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xCB"],
        ["\xF3\xB4\xB9\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xCD"],
        ["\xF3\xB4\xB9\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\xF3\xB4\xB9\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xA4"],
        ["\xF3\xB4\xB9\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\xF3\xB4\xB9\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\xF3\xB4\xB9\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\xF3\xB4\xB9\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\xF3\xB4\xB9\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\xF3\xB4\xB9\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\xF3\xB4\xB9\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\xF3\xB4\xB9\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\xF3\xB4\xB9\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\xF3\xB4\xB9\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\xF3\xB4\xB9\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\xF3\xB4\xB9\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\xF3\xB4\xB9\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\xF3\xB4\xB9\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\xF3\xB4\xB9\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\xF3\xB4\xB9\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\xF3\xB4\xBA\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xFD"],
        ["\xF3\xB4\xBA\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xBB"],
        ["\xF3\xB4\xBA\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\xF3\xB4\xBA\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\xF3\xB4\xBA\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],
        ["\xF3\xB4\xBA\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xCB"],
        ["\xF3\xB4\xBA\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\xF3\xB4\xBA\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\xF3\xB4\xBA\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],
        ["\xF3\xB4\xBA\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\xF3\xB4\xBA\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xAF"],
        ["\xF3\xB4\xBA\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\xF3\xB4\xBA\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],
        ["\xF3\xB4\xBA\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xCA"],
        ["\xF3\xB4\xBA\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xCB"],
        ["\xF3\xB4\xBA\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],
        ["\xF3\xB4\xBA\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xDE"],
        ["\xF3\xB4\xBA\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\xF3\xB4\xBA\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],
        ["\xF3\xB4\xBA\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],
        ["\xF3\xB4\xBA\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF9"],
        ["\xF3\xB4\xBA\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xF8"],
        ["\xF3\xB4\xBA\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xA4"],
        ["\xF3\xB4\xBA\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xB2"],
        ["\xF3\xB4\xBA\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xB3"],
        ["\xF3\xB4\xBA\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xB6"],
        ["\xF3\xB4\xBA\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC0"],
        ["\xF3\xB4\xBA\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xCE"],
        ["\xF3\xB4\xBA\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD5"],
        ["\xF3\xB4\xBA\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\xF3\xB4\xBA\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],
        ["\xF3\xB4\xBA\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA1"],
        ["\xF3\xB4\xBA\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA2"],
        ["\xF3\xB4\xBA\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA3"],
        ["\xF3\xB4\xBA\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA5"],
        ["\xF3\xB4\xBB\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xAB"],
        ["\xF3\xB4\xBB\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xAD"],
        ["\xF3\xB4\xBB\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xAF"],
        ["\xF3\xB4\xBB\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xB1"],
        ["\xF3\xB4\xBB\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xB2"],
        ["\xF3\xB4\xBB\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xB6"],
        ["\xF3\xB4\xBB\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE7"],
        ["\xF3\xB4\xBB\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF3"],
        ["\xF3\xB4\xBB\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF7"],
        ["\xF3\xB4\xBB\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC8"],
        ["\xF3\xB4\xBB\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xCF"],
        ["\xF3\xB4\xBB\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xDF"],
        ["\xF3\xB4\xBB\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE9"],
        ["\xF3\xB4\xBB\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xB5"],
        ["\xF3\xB4\xBB\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xB6"],
        ["\xF3\xB4\xBB\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xD2"],
        ["\xF3\xB4\xBB\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xDA"],
        ["\xF3\xB4\xBB\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xB5"],
        ["\xF3\xB4\xBB\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xB7"],
        ["\xF3\xB4\xBB\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xF5"],
        ["\xF3\xB4\xBB\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xA4"],
        ["\xF3\xB4\xBB\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xB3"],
        ["\xF3\xB4\xBB\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xB1"],
        ["\xF3\xB4\xBB\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xBF"],
        ["\xF3\xB4\xBC\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"],
        ["\xF3\xB4\xBC\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xAC"],
        ["\xF3\xB4\xBC\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD0"],
        ["\xF3\xB4\xBC\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xDF"],
        ["\xF3\xB4\xBC\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE3"],
        ["\xF3\xB4\xBC\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE6"],
        ["\xF3\xB4\xBC\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xEC"],
        ["\xF3\xB4\xBC\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xEF"],
        ["\xF3\xB4\xBC\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xF0"],
        ["\xF3\xB4\xBC\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC3"],
        ["\xF3\xB4\xBC\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xCB"],
        ["\xF3\xB4\xBC\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD5"],
        ["\xF3\xB4\xBC\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD6"],
        ["\xF3\xB4\xBC\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xFC"],
        ["\xF3\xB4\xBC\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xFD"],
        ["\xF3\xB4\xBC\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"],
        ["\xF3\xB4\xBC\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"],
        ["\xF3\xB4\xBC\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC8"],
        ["\xF3\xB4\xBC\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xCD"],
        ["\xF3\xB4\xBC\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xCE"],
        ["\xF3\xB4\xBC\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"],
        ["\xF3\xB4\xBC\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE9"],
        ["\xF3\xB4\xBC\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"],
        ["\xF3\xB4\xBC\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\xF3\xB4\xBC\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF5"],
        ["\xF3\xB4\xBC\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xFA"],
        ["\xF3\xB4\xBC\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xA6"],
        ["\xF3\xB4\xBC\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC7"],
        ["\xF3\xB4\xBD\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xEB"],
        ["\xF3\xB4\xBD\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xEC"],
        ["\xF3\xB4\xBD\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"],
        ["\xF3\xB4\xBD\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF3"],
        ["\xF3\xB4\xBD\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF5"],
        ["\xF3\xB4\xBD\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xFC"],
        ["\xF3\xB4\xBD\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xFD"],
        ["\xF3\xB4\xBD\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xAD"],
        ["\xF3\xB4\xBD\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xAE"],
        ["\xF3\xB4\xBD\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xB0"],
        ["\xF3\xB4\xBD\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xCE"],
        ["\xF3\xB4\xBD\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD4"],
        ["\xF3\xB4\xBD\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD6"],
        ["\xF3\xB4\xBD\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xDA"],
        ["\xF3\xB4\xBD\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE0"],
        ["\xF3\xB4\xBD\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE7"],
        ["\xF3\xB4\xBD\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xEA"],
        ["\xF3\xB4\xBD\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xEB"],
        ["\xF3\xB4\xBD\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF9"],
        ["\xF3\xB4\xBD\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xFC"],
        ["\xF3\xB4\xBD\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF1"],
        ["\xF3\xB4\xBD\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xAD"],
        ["\xF3\xB4\xBE\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xB7"],
        ["\xF3\xB4\xBE\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC0"],
        ["\xF3\xB4\xBE\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],
        ["\xF3\xB4\xBE\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\xF3\xB4\xBE\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xAA"],
        ["\xF3\xB4\xBE\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xA8"],
        ["\xF3\xB4\xBE\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xAC"],
        ["\xF3\xB4\xBE\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xA1"],
        ["\xF3\xB4\xBE\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xAF"],
        ["\xF3\xB4\xBE\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xB7"],
        ["\xF3\xB4\xBE\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xB9"],
        ["\xF3\xB4\xBE\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xD1"],
        ["\xF3\xB4\xBE\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xE5"],
        ["\xF3\xB4\xBE\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEA"],
        ["\xF3\xB4\xBE\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xFD"],
        ["\xF3\xB4\xBE\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xA7"],
        ["\xF3\xB4\xBE\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xE2"],
        ["\xF3\xB4\xBE\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xAD"],
        ["\xF3\xB4\xBF\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xBE"],
        ["\xF3\xB4\xBF\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xC3"],
        ["\xF3\xB4\xBF\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xC6"],
        ["\xF3\xB4\xBF\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xC8"],
        ["\xF3\xB4\xBF\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xCB"],
        ["\xF3\xB4\xBF\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xFE"],
        ["\xF3\xB4\xBF\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xD2"],
        ["\xF3\xB4\xBF\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xD8"],
        ["\xF3\xB4\xBF\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xD9"],
        ["\xF3\xB4\xBF\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xDD"],
        ["\xF3\xB4\xBF\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xEA"],
        ["\xF3\xB4\xBF\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xEC"],
        ["\xF3\xB4\xBF\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xF0"],
        ["\xF3\xB4\xBF\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xF2"],
        ["\xF3\xB4\xBF\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xF4"],
        ["\xF3\xB4\xBF\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xFB"],
        ["\xF3\xB4\xBF\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xFD"],
        ["\xF3\xB4\xBF\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xA2"],
        ["\xF3\xB4\xBF\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xAC"],
        ["\xF3\xB4\xBF\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xAF"],
        ["\xF3\xB4\xBF\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB1"],
        ["\xF3\xB4\xBF\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB8"],
        ["\xF3\xB4\xBF\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xA9"],
        ["\xF3\xB4\xBF\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xBE"],
        ["\xF3\xB5\x80\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xDF"],
        ["\xF3\xB5\x80\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE1"],
        ["\xF3\xB5\x80\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\xF3\xB5\x80\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xB9"],
        ["\xF3\xB5\x80\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xEE"],
        ["\xF3\xB5\x80\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xBE"],
        ["\xF3\xB5\x80\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xBF"],
        ["\xF3\xB5\x80\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\xF3\xB5\x80\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xC8"],
        ["\xF3\xB5\x80\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\xF3\xB5\x80\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xCC"],
        ["\xF3\xB5\x80\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xA4"],
        ["\xF3\xB5\x80\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xA8"],
        ["\xF3\xB5\x80\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xD6"],
        ["\xF3\xB5\x80\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xAA"],
        ["\xF3\xB5\x80\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xD8"],
        ["\xF3\xB5\x81\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xF7"],
        ["\xF3\xB5\x81\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xF9"],
        ["\xF3\xB5\x81\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xA3"],
        ["\xF3\xB5\x81\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\xFC"],
        ["\xF3\xB5\x81\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xA7"],
        ["\xF3\xB5\x81\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\xF3\xB5\x81\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xC1"],
        ["\xF3\xB5\x81\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xEC"],
        ["\xF3\xB5\x81\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xF1"],
        ["\xF3\xB5\x81\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xF6"],
        ["\xF3\xB5\x81\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xAB"],
        ["\xF3\xB5\x81\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xB2"],
        ["\xF3\xB5\x81\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xC8"],
        ["\xF3\xB5\x81\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xCB"],
        ["\xF3\xB5\x81\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xD8"],
        ["\xF3\xB5\x81\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xE1"],
        ["\xF3\xB5\x81\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xE2"],
        ["\xF3\xB5\x81\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xEA"],
        ["\xF3\xB5\x81\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\xF3\xB5\x81\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\xF3\xB5\x82\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xC2"],
        ["\xF3\xB5\x82\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xD0"],
        ["\xF3\xB5\x82\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xF1"],
        ["\xF3\xB5\x82\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xAD"],
        ["\xF3\xB5\x82\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xB1"],
        ["\xF3\xB5\x82\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xB4"],
        ["\xF3\xB5\x82\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xB7"],
        ["\xF3\xB5\x82\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xC7"],
        ["\xF3\xB5\x82\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xCA"],
        ["\xF3\xB5\x82\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xCD"],
        ["\xF3\xB5\x82\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xCF"],
        ["\xF3\xB5\x82\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xD5"],
        ["\xF3\xB5\x82\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xD6"],
        ["\xF3\xB5\x82\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xD7"],
        ["\xF3\xB5\x82\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xD9"],
        ["\xF3\xB5\x82\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE0"],
        ["\xF3\xB5\x82\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xA5"],
        ["\xF3\xB5\x82\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE2"],
        ["\xF3\xB5\x82\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE4"],
        ["\xF3\xB5\x82\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE6"],
        ["\xF3\xB5\x82\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xE8"],
        ["\xF3\xB5\x82\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xF1"],
        ["\xF3\xB5\x83\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xF0"],
        ["\xF3\xB5\x83\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xF4"],
        ["\xF3\xB5\x83\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\xF3\xB5\x83\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xA3"],
        ["\xF3\xB5\x83\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xAB"],
        ["\xF3\xB5\x83\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xAC"],
        ["\xF3\xB5\x83\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xF5"],
        ["\xF3\xB5\x83\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xB1"],
        ["\xF3\xB5\x83\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xA8"],
        ["\xF3\xB5\x83\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xC1"],
        ["\xF3\xB5\x83\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xD2"],
        ["\xF3\xB5\x83\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xE4"],
        ["\xF3\xB5\x83\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xD3"],
        ["\xF3\xB5\x83\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xEB"],
        ["\xF3\xB5\x83\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xCF"],
        ["\xF3\xB5\x83\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xED"],
        ["\xF3\xB5\x83\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xCD"],
        ["\xF3\xB5\x83\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xF5"],
        ["\xF3\xB5\x84\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xF8"],
        ["\xF3\xB5\x84\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xFC"],
        ["\xF3\xB5\x84\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xFE"],
        ["\xF3\xB5\x84\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xA3"],
        ["\xF3\xB5\x84\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xA7"],
        ["\xF3\xB5\x84\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xA9"],
        ["\xF3\xB5\x84\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xAF"],
        ["\xF3\xB5\x84\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xD9"],
        ["\xF3\xB5\x84\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xDA"],
        ["\xF3\xB5\x84\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xB8"],
        ["\xF3\xB5\x84\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xBA"],
        ["\xF3\xB5\x84\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xC4"],
        ["\xF3\xB5\x84\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xCF"],
        ["\xF3\xB5\x84\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xE7"],
        ["\xF3\xB5\x84\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xF9"],
        ["\xF3\xB5\x84\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xFA"],
        ["\xF3\xB5\x84\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xF0"],
        ["\xF3\xB5\x84\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xAA"],
        ["\xF3\xB5\x84\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xAF"],
        ["\xF3\xB5\x84\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xB1"],
        ["\xF3\xB5\x85\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xB6"],
        ["\xF3\xB5\x85\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xB7"],
        ["\xF3\xB5\x85\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xBD"],
        ["\xF3\xB5\x85\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD4"],
        ["\xF3\xB5\x85\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xC5"],
        ["\xF3\xB5\x85\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xCC"],
        ["\xF3\xB5\x85\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD0"],
        ["\xF3\xB5\x85\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD2"],
        ["\xF3\xB5\x85\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD5"],
        ["\xF3\xB5\x85\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD6"],
        ["\xF3\xB5\x85\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xF7"],
        ["\xF3\xB5\x85\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD7"],
        ["\xF3\xB5\x85\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xD8"],
        ["\xF3\xB5\x85\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xDB"],
        ["\xF3\xB5\x85\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xF8"],
        ["\xF3\xB5\x85\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xDD"],
        ["\xF3\xB5\x85\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xE0"],
        ["\xF3\xB5\x85\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xE2"],
        ["\xF3\xB5\x85\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xE5"],
        ["\xF3\xB5\x85\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xE8"],
        ["\xF3\xB5\x85\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\xF6"],
        ["\xF3\xB5\x85\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xF5"],
        ["\xF3\xB5\x85\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\xF7"],
        ["\xF3\xB5\x85\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\xF3\xB5\x85\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xA2"],
        ["\xF3\xB5\x85\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\xF3\xB5\x85\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xCB"],
        ["\xF3\xB5\x85\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xDD"],
        ["\xF3\xB5\x85\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\xF3\xB5\x85\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xA4"],
        ["\xF3\xB5\x85\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xAE"],
        ["\xF3\xB5\x86\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xB7"],
        ["\xF3\xB5\x86\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xC3"],
        ["\xF3\xB5\x86\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xEB"],
        ["\xF3\xB5\x86\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xC4"],
        ["\xF3\xB5\x86\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xED"],
        ["\xF3\xB5\x86\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xEE"],
        ["\xF3\xB5\x86\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xC8"],
        ["\xF3\xB5\x86\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xF1"],
        ["\xF3\xB5\x86\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xF2"],
        ["\xF3\xB5\x86\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xF3"],
        ["\xF3\xB5\x86\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xF8"],
        ["\xF3\xB5\x86\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xFE"],
        ["\xF3\xB5\x86\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xCE"],
        ["\xF3\xB5\x86\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xAE"],
        ["\xF3\xB5\x86\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xD3"],
        ["\xF3\xB5\x86\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xB4"],
        ["\xF3\xB5\x86\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xB5"],
        ["\xF3\xB5\x86\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xBE"],
        ["\xF3\xB5\x86\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xBF"],
        ["\xF3\xB5\x86\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xC6"],
        ["\xF3\xB5\x86\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xC7"],
        ["\xF3\xB5\x86\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xD3"],
        ["\xF3\xB5\x86\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xD5"],
        ["\xF3\xB5\x86\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xDD"],
        ["\xF3\xB5\x86\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xD9"],
        ["\xF3\xB5\x86\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xDF"],
        ["\xF3\xB5\x86\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xE2"],
        ["\xF3\xB5\x86\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\xE3"],
        ["\xF3\xB5\x86\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xDE"],
        ["\xF3\xB5\x86\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xE6"],
        ["\xF3\xB5\x86\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xF3"],
        ["\xF3\xB5\x86\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\xF6"],
        ["\xF3\xB5\x87\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA3"],
        ["\xF3\xB5\x87\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA9"],
        ["\xF3\xB5\x87\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xAA"],
        ["\xF3\xB5\x87\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xAE"],
        ["\xF3\xB5\x87\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xB1"],
        ["\xF3\xB5\x87\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xBD"],
        ["\xF3\xB5\x87\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\xF3\xB5\x87\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\xF3\xB5\x87\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA4"],
        ["\xF3\xB5\x87\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\xF3\xB5\x87\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xCD"],
        ["\xF3\xB5\x87\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xCF"],
        ["\xF3\xB5\x87\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\xF3\xB5\x87\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\xF3\xB5\x87\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\xF3\xB5\x87\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xEB"],
        ["\xF3\xB5\x87\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xEE"],
        ["\xF3\xB5\x87\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\xF3\xB5\x87\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\xF3\xB5\x87\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xFB"],
        ["\xF3\xB5\x87\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xFE"],
        ["\xF3\xB5\x87\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xA7"],
        ["\xF3\xB5\x87\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xAA"],
        ["\xF3\xB5\x87\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA8"],
        ["\xF3\xB5\x88\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xB0"],
        ["\xF3\xB5\x88\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xB4"],
        ["\xF3\xB5\x88\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xB5"],
        ["\xF3\xB5\x88\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xCC"],
        ["\xF3\xB5\x88\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xCE"],
        ["\xF3\xB5\x88\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\xF3\xB5\x88\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\xF3\xB5\x88\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xEB"],
        ["\xF3\xB5\x88\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xEE"],
        ["\xF3\xB5\x88\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xFA"],
        ["\xF3\xB5\x88\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xB0"],
        ["\xF3\xB5\x88\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xBE"],
        ["\xF3\xB5\x88\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xBF"],
        ["\xF3\xB5\x88\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xC8"],
        ["\xF3\xB5\x88\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xFE"],
        ["\xF3\xB5\x88\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xCF"],
        ["\xF3\xB5\x88\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xA5"],
        ["\xF3\xB5\x88\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xD3"],
        ["\xF3\xB5\x88\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xD6"],
        ["\xF3\xB5\x88\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xDB"],
        ["\xF3\xB5\x88\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xDC"],
        ["\xF3\xB5\x88\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xE2"],
        ["\xF3\xB5\x88\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xEA"],
        ["\xF3\xB5\x88\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xEC"],
        ["\xF3\xB5\x88\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xFA"],
        ["\xF3\xB5\x88\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\xAD"],
        ["\xF3\xB5\x89\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xAE"],
        ["\xF3\xB5\x89\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xA2"],
        ["\xF3\xB5\x89\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xA4"],
        ["\xF3\xB5\x89\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xED"],
        ["\xF3\xB5\x89\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xB8"],
        ["\xF3\xB5\x89\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xBF"],
        ["\xF3\xB5\x89\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xC4"],
        ["\xF3\xB5\x89\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xC5"],
        ["\xF3\xB5\x89\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xEF"],
        ["\xF3\xB5\x89\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xCA"],
        ["\xF3\xB5\x89\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xEA"],
        ["\xF3\xB5\x89\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD5"],
        ["\xF3\xB5\x89\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD6"],
        ["\xF3\xB5\x89\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD8"],
        ["\xF3\xB5\x89\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xD9"],
        ["\xF3\xB5\x8A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xDB"],
        ["\xF3\xB5\x8A\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xDE"],
        ["\xF3\xB5\x8A\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xEF"],
        ["\xF3\xB5\x8A\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xFA"],
        ["\xF3\xB5\x8A\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xF5"],
        ["\xF3\xB5\x8A\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xF6"],
        ["\xF3\xB5\x8A\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\xFD"],
        ["\xF3\xB5\x8A\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xA1"],
        ["\xF3\xB5\x8A\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xA4"],
        ["\xF3\xB5\x8A\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xA7"],
        ["\xF3\xB5\x8B\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xB3"],
        ["\xF3\xB5\x8B\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xBF"],
        ["\xF3\xB5\x8B\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xCC"],
        ["\xF3\xB5\x8B\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xD2"],
        ["\xF3\xB5\x8B\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xE7"],
        ["\xF3\xB5\x8B\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xE8"],
        ["\xF3\xB5\x8B\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xEE"],
        ["\xF3\xB5\x8B\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xEF"],
        ["\xF3\xB5\x8B\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xEC"],
        ["\xF3\xB5\x8B\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xA3"],
        ["\xF3\xB5\x8B\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xFD"],
        ["\xF3\xB5\x8B\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xB0"],
        ["\xF3\xB5\x8B\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xB7"],
        ["\xF3\xB5\x8B\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xBE"],
        ["\xF3\xB5\x8B\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xC4"],
        ["\xF3\xB5\x8B\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xC5"],
        ["\xF3\xB5\x8B\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xC6"],
        ["\xF3\xB5\x8B\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xB3"],
        ["\xF3\xB5\x8C\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xCB"],
        ["\xF3\xB5\x8C\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xD2"],
        ["\xF3\xB5\x8C\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xD4"],
        ["\xF3\xB5\x8C\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xDA"],
        ["\xF3\xB5\x8C\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xE1"],
        ["\xF3\xB5\x8C\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xE9"],
        ["\xF3\xB5\x8C\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xEA"],
        ["\xF3\xB5\x8C\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xEE"],
        ["\xF3\xB5\x8C\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xF3"],
        ["\xF3\xB5\x8C\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\xFA"],
        ["\xF3\xB5\x8C\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xA9"],
        ["\xF3\xB5\x8C\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xB7"],
        ["\xF3\xB5\x8C\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xC1"],
        ["\xF3\xB5\x8C\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xBD"],
        ["\xF3\xB5\x8C\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xC8"],
        ["\xF3\xB5\x8C\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xC9"],
        ["\xF3\xB5\x8C\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xCA"],
        ["\xF3\xB5\x8C\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xCB"],
        ["\xF3\xB5\x8C\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xCC"],
        ["\xF3\xB5\x8C\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xCE"],
        ["\xF3\xB5\x8C\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xD2"],
        ["\xF3\xB5\x8D\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xD8"],
        ["\xF3\xB5\x8D\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xE0"],
        ["\xF3\xB5\x8D\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xE3"],
        ["\xF3\xB5\x8D\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xEA"],
        ["\xF3\xB5\x8D\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xED"],
        ["\xF3\xB5\x8D\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xF3"],
        ["\xF3\xB5\x8D\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\xF5"],
        ["\xF3\xB5\x8D\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xA4"],
        ["\xF3\xB5\x8D\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\xF3\xB5\x8D\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xB4"],
        ["\xF3\xB5\x8D\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\xF3\xB5\x8D\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xCA"],
        ["\xF3\xB5\x8D\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xCE"],
        ["\xF3\xB5\x8D\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\xF3\xB5\x8D\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\xF3\xB5\x8D\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xDB"],
        ["\xF3\xB5\x8D\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\xF3\xB5\x8E\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\xF3\xB5\x8E\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE1"],
        ["\xF3\xB5\x8E\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\xF3\xB5\x8E\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\xF3\xB5\x8E\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\xF3\xB5\x8E\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\xF3\xB5\x8E\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xED"],
        ["\xF3\xB5\x8E\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\xF3\xB5\x8E\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\xF3\xB5\x8E\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xFA"],
        ["\xF3\xB5\x8E\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\xF3\xB5\x8E\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xA7"],
        ["\xF3\xB5\x8E\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xFB"],
        ["\xF3\xB5\x8E\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xC0"],
        ["\xF3\xB5\x8E\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xCC"],
        ["\xF3\xB5\x8E\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xD2"],
        ["\xF3\xB5\x8E\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xDB"],
        ["\xF3\xB5\x8E\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xDF"],
        ["\xF3\xB5\x8F\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xE9"],
        ["\xF3\xB5\x8F\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xEB"],
        ["\xF3\xB5\x8F\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xF5"],
        ["\xF3\xB5\x8F\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xF8"],
        ["\xF3\xB5\x8F\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\xFE"],
        ["\xF3\xB5\x8F\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xAE"],
        ["\xF3\xB5\x8F\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xAF"],
        ["\xF3\xB5\x8F\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\xF3\xB5\x8F\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB6"],
        ["\xF3\xB5\x8F\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB7"],
        ["\xF3\xB5\x8F\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB8"],
        ["\xF3\xB5\x8F\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB9"],
        ["\xF3\xB5\x8F\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xBB"],
        ["\xF3\xB5\x8F\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xBE"],
        ["\xF3\xB5\x8F\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\xF3\xB5\x8F\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\xF3\xB5\x8F\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xCA"],
        ["\xF3\xB5\x8F\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xCD"],
        ["\xF3\xB5\x8F\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\xF3\xB5\x8F\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xA6"],
        ["\xF3\xB5\x8F\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\xF3\xB5\x8F\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\xF3\xB5\x8F\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE8"],
        ["\xF3\xB5\x8F\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\xF3\xB5\x8F\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xEE"],
        ["\xF3\xB5\x8F\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\xF3\xB5\x8F\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\xF3\xB5\x8F\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\xF3\xB5\x8F\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xFC"],
        ["\xF3\xB5\x90\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA3"],
        ["\xF3\xB5\x90\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\xF3\xB5\x90\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\xF3\xB5\x90\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xB5"],
        ["\xF3\xB5\x90\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\xF3\xB5\x90\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\xF3\xB5\x90\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xCE"],
        ["\xF3\xB5\x90\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xCA"],
        ["\xF3\xB5\x90\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\xF3\xB5\x90\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\xF3\xB5\x90\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\xF3\xB5\x90\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\xF3\xB5\x90\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\xF3\xB5\x90\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\xF3\xB5\x90\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xEB"],
        ["\xF3\xB5\x91\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xED"],
        ["\xF3\xB5\x91\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xFC"],
        ["\xF3\xB5\x91\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xAA"],
        ["\xF3\xB5\x91\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\xF3\xB5\x91\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\xF3\xB5\x91\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\xF3\xB5\x91\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\xF3\xB5\x91\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\xF3\xB5\x91\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xBE"],
        ["\xF3\xB5\x91\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\xF3\xB5\x91\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xEA"],
        ["\xF3\xB5\x91\xAF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\xF3\xB5\x91\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\xF3\xB5\x91\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\xF3\xB5\x91\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],
        ["\xF3\xB5\x92\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xB5"],
        ["\xF3\xB5\x92\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\xF3\xB5\x92\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xB8"],
        ["\xF3\xB5\x92\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xBA"],
        ["\xF3\xB5\x92\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xBC"],
        ["\xF3\xB5\x92\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\xF3\xB5\x92\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xBE"],
        ["\xF3\xB5\x92\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xC5"],
        ["\xF3\xB5\x92\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xC6"],
        ["\xF3\xB5\x92\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xC8"],
        ["\xF3\xB5\x92\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xFE"],
        ["\xF3\xB5\x92\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xDE"],
        ["\xF3\xB5\x92\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xF2"],
        ["\xF3\xB5\x92\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\xF3\xB5\x92\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\xF3\xB5\x92\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xAB"],
        ["\xF3\xB5\x92\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xAF"],
        ["\xF3\xB5\x92\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xB0"],
        ["\xF3\xB5\x92\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xB9"],
        ["\xF3\xB5\x92\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xBC"],
        ["\xF3\xB5\x92\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xBD"],
        ["\xF3\xB5\x92\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xBE"],
        ["\xF3\xB5\x92\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xC0"],
        ["\xF3\xB5\x92\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xC1"],
        ["\xF3\xB5\x93\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xC3"],
        ["\xF3\xB5\x93\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xC4"],
        ["\xF3\xB5\x93\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xCF"],
        ["\xF3\xB5\x93\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xD5"],
        ["\xF3\xB5\x93\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xE2"],
        ["\xF3\xB5\x93\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\xF3\xB5\x93\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\xF3\xB5\x93\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xF8"],
        ["\xF3\xB5\x93\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\xF3\xB5\x93\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\xF3\xB5\x93\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\xFE"],
        ["\xF3\xB5\x93\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xA2"],
        ["\xF3\xB5\x93\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xAD"],
        ["\xF3\xB5\x93\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\xF3\xB5\x93\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\xF3\xB5\x93\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xB5"],
        ["\xF3\xB5\x94\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC0"],
        ["\xF3\xB5\x94\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\xF3\xB5\x94\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\xF3\xB5\x94\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\xF3\xB5\x94\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\xF3\xB5\x94\x9A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xDA"],
        ["\xF3\xB5\x94\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xEA"],
        ["\xF3\xB5\x94\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\xF3\xB5\x94\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\xF3\xB5\x94\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\xF3\xB5\x94\xA7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\xF3\xB5\x94\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xFC"],
        ["\xF3\xB5\x94\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xA6"],
        ["\xF3\xB5\x94\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xAE"],
        ["\xF3\xB5\x94\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\xF3\xB5\x94\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB3"],
        ["\xF3\xB5\x94\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\xF3\xB5\x94\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB9"],
        ["\xF3\xB5\x95\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\xF3\xB5\x95\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\xF3\xB5\x95\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xCF"],
        ["\xF3\xB5\x95\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xDA"],
        ["\xF3\xB5\x95\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xDB"],
        ["\xF3\xB5\x95\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xDD"],
        ["\xF3\xB5\x95\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xDE"],
        ["\xF3\xB5\x95\x97",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\xF3\xB5\x95\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\xF3\xB5\x95\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\xF3\xB5\x95\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xEC"],
        ["\xF3\xB5\x95\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\xF3\xB5\x95\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xEF"],
        ["\xF3\xB5\x95\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xFA"],
        ["\xF3\xB5\x95\xB0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA4"],
        ["\xF3\xB5\x95\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA8"],
        ["\xF3\xB5\x95\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\xF3\xB5\x95\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"],
        ["\xF3\xB5\x95\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xBB"],
        ["\xF3\xB5\x95\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xBC"],
        ["\xF3\xB5\x95\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC6"],
        ["\xF3\xB5\x95\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD0"],
        ["\xF3\xB5\x96\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\xF3\xB5\x96\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xB2"],
        ["\xF3\xB5\x96\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xB7"],
        ["\xF3\xB5\x96\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xB9"],
        ["\xF3\xB5\x96\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xC4"],
        ["\xF3\xB5\x96\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xCA"],
        ["\xF3\xB5\x96\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xD8"],
        ["\xF3\xB5\x96\xAA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xDF"],
        ["\xF3\xB5\x96\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\xE1"],
        ["\xF3\xB5\x96\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xA1"],
        ["\xF3\xB5\x96\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xA3"],
        ["\xF3\xB5\x96\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xA8"],
        ["\xF3\xB5\x96\xBC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\xF3\xB5\x96\xBE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xAA"],
        ["\xF3\xB5\x97\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xAB"],
        ["\xF3\xB5\x97\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xAD"],
        ["\xF3\xB5\x97\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\xF3\xB5\x97\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\xF3\xB5\x97\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\xF3\xB5\x97\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\xF3\xB5\x97\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xC7"],
        ["\xF3\xB5\x97\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xC8"],
        ["\xF3\xB5\x97\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xD3"],
        ["\xF3\xB5\x97\x99",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xDA"],
        ["\xF3\xB5\x97\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xDD"],
        ["\xF3\xB5\x97\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\xF3\xB5\x97\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA1"],
        ["\xF3\xB5\x97\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA4"],
        ["\xF3\xB5\x97\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\xF3\xB5\x97\xB2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xAD"],
        ["\xF3\xB5\x97\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\xF3\xB5\x97\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB1"],
        ["\xF3\xB5\x97\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\xF3\xB5\x97\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB4"],
        ["\xF3\xB5\x98\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB6"],
        ["\xF3\xB5\x98\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xBA"],
        ["\xF3\xB5\x98\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\xF3\xB5\x98\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\xF3\xB5\x98\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\xF3\xB5\x98\x9B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xCB"],
        ["\xF3\xB5\x98\x9C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\xF3\xB5\x98\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\xF3\xB5\x98\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\xF3\xB5\x98\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\xF3\xB5\x98\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE1"],
        ["\xF3\xB5\x98\xB3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\xF3\xB5\x98\xB4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\xF3\xB5\x98\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\xF3\xB5\x98\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\xF3\xB5\x98\xBB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\xF3\xB5\x99\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\xF3\xB5\x99\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xA7"],
        ["\xF3\xB5\x99\x8C",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\xF3\xB5\x99\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC5"],
        ["\xF3\xB5\x99\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\xF3\xB5\x99\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\xF3\xB5\x99\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xCC"],
        ["\xF3\xB5\x99\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xCE"],
        ["\xF3\xB5\x99\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xCF"],
        ["\xF3\xB5\x99\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\xF3\xB5\x9A\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\xF3\xB5\x9A\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xDA"],
        ["\xF3\xB5\x9A\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xDB"],
        ["\xF3\xB5\x9A\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\xF3\xB5\x9A\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xDC"],
        ["\xF3\xB5\x9A\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xBF"],
        ["\xF3\xB5\x9A\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\xF3\xB5\x9A\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\xF3\xB5\x9A\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\xF3\xB5\x9A\x9F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xA6"],
        ["\xF3\xB5\x9A\xA4",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\xF3\xB5\x9A\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\xF3\xB5\x9A\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\xF3\xB5\x9A\xB8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\xF3\xB5\x9A\xBA",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\xF3\xB5\x9A\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xCF"],
        ["\xF3\xB5\x9B\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\xF3\xB5\x9B\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\xF3\xB5\x9B\x86",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\xF3\xB5\x9B\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xEF"],
        ["\xF3\xB5\x9B\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF1"],
        ["\xF3\xB5\x9B\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\xF3\xB5\x9B\x8E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xB1"],
        ["\xF3\xB5\x9B\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xB9"],
        ["\xF3\xB5\x9B\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],
        ["\xF3\xB5\x9B\x94",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\xF3\xB5\x9B\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\xF3\xB5\x9B\x96",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\xF3\xB5\x9B\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xDE"],
        ["\xF3\xB5\x9B\xA1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\xF3\xB5\x9B\xA2",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\xF3\xB5\x9B\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],
        ["\xF3\xB5\x9B\xA8",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xDA"],
        ["\xF3\xB5\x9B\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE1"],
        ["\xF3\xB5\x9B\xAB",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\xF3\xB5\x9B\xB6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xFB"],
        ["\xF3\xB5\x9B\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xA6"],
        ["\xF3\xB5\x9B\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xA7"],
        ["\xF3\xB5\x9C\x81",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xBC"],
        ["\xF3\xB5\x9C\x82",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xBE"],
        ["\xF3\xB5\x9C\x83",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\xF3\xB5\x9C\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xCC"],
        ["\xF3\xB5\x9C\x91",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],
        ["\xF3\xB5\x9D\x87",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\xF3\xB5\x9E\x8B",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF3"],
        ["\xF3\xB5\x9E\x93",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xA1"],
        ["\xF3\xB5\x9E\x95",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xA3"],
        ["\xF3\xB5\x9F\x80",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\xEC"],
        ["\xF3\xB5\x9F\x9D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xDE"],
        ["\xF3\xB5\x9F\xA6",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xBA"],
        ["\xF3\xB5\x9F\xAD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xCA"],
        ["\xF3\xB5\xA0\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE1"],
        ["\xF3\xB5\xA1\xA5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"],
        ["\xF3\xB5\xA1\xB9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xAF"],
        ["\xF3\xB5\xA2\x88",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xCF"],
        ["\xF3\xB5\xA2\x8A",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD1"],
        ["\xF3\xB5\xA2\x90",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xDC"],
        ["\xF3\xB5\xA2\x98",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE1"],
        ["\xF3\xB5\xA2\xAC",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE8"],
        ["\xF3\xB5\xA2\xB5",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE9"],
        ["\xF3\xB5\xA3\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF4"],
        ["\xF3\xB5\xA3\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF5"],
        ["\xF3\xB5\xA3\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF8"],
        ["\xF3\xB5\xA3\x8F",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xFA"],
        ["\xF3\xB5\xA3\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xFD"],
        ["\xF3\xB5\xA3\x9E",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA7"],
        ["\xF3\xB5\xA3\xA0",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA8"],
        ["\xF3\xB5\xA3\xA3",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA9"],
        ["\xF3\xB5\xA3\xA9",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xAA"],
        ["\xF3\xB5\xA3\xAE",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xAB"],
        ["\xF3\xB5\xA3\xB1",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xAF"],
        ["\xF3\xB5\xA3\xB7",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xBB"],
        ["\xF3\xB5\xA3\xBD",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD7"],
        ["\xF3\xB5\xA3\xBF",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xDF"],
        ["\xF3\xB5\xA4\x84",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE8"],
        ["\xF3\xB5\xA4\x85",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xEF"],
        ["\xF3\xB5\xA4\x89",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF5"],
        ["\xF3\xB5\xA4\x8D",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xFD"],
        ["\xF3\xB5\xA4\x92",'jef9p','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xFE"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
