
#
# Copyright (C) 2001  Daemon Consulting Inc.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package SpeedyMake::mod_speedycgi;

require '../src/SpeedyMake.pl';
@ISA = 'SpeedyMake';

sub inc {'apache'}
sub clean_files_full_extra { 'mod_speedycgi_cmds' }
sub main_file_full {'mod_speedycgi'}
sub my_name_full {shift->main_file_full}

package mod_speedycgi;

use strict;
use ExtUtils::MakeMaker;

SpeedyMake::mod_speedycgi->init;

print "Writing Makefile for mod_speedycgi\n";

SpeedyMake::mod_speedycgi->make_speedy_h;
my $mm = MM->new({SpeedyMake::mod_speedycgi->mm_params});

open(F, '>Makefile');
select F;

print join("\n\n",
    "##\n## Generated by Makefile.PL\n##",
    $mm->constants,
    $mm->tools_other,
    'all: mod_speedycgi.so',
    SpeedyMake::mod_speedycgi->symlink_c_files,
    SpeedyMake::mod_speedycgi->optdefs_cmds,
    $mm->test,
    SpeedyMake::mod_speedycgi->testing_postamble,
    ''
);
foreach my $x (
    [qw(SRC_CFILES src_files_c)],
    [qw(OFILES src_files_o)],
    [qw(C_FILE_CLEAN clean_files_c)],
    [qw(CHECK_SYMS check_syms_def)],
    [qw(DEF extra_defines)],
)
{
    my($def, $method) = @$x;
    printf "${def}=%s\n\n", join(' ', SpeedyMake::mod_speedycgi->$method());
}

open(F2, 'Makefile.tmpl');
print <F2>;
close(F2);

close(F);
