package io.vertx.kotlin.ext.sql

import io.vertx.ext.sql.SQLOptions
import io.vertx.ext.sql.FetchDirection
import io.vertx.ext.sql.ResultSetConcurrency
import io.vertx.ext.sql.ResultSetType
import io.vertx.ext.sql.TransactionIsolation

/**
 * A function providing a DSL for building [io.vertx.ext.sql.SQLOptions] objects.
 *
 * Represents the options one can use to customize the unwrapped connection/statement/resultset types
 *
 * @param autoGeneratedKeys 
 * @param autoGeneratedKeysIndexes 
 * @param catalog 
 * @param fetchDirection 
 * @param fetchSize 
 * @param queryTimeout 
 * @param readOnly 
 * @param resultSetConcurrency 
 * @param resultSetType 
 * @param schema 
 * @param transactionIsolation 
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.ext.sql.SQLOptions original] using Vert.x codegen.
 */
fun SQLOptions(
  autoGeneratedKeys: Boolean? = null,
  autoGeneratedKeysIndexes: io.vertx.core.json.JsonArray? = null,
  catalog: String? = null,
  fetchDirection: FetchDirection? = null,
  fetchSize: Int? = null,
  queryTimeout: Int? = null,
  readOnly: Boolean? = null,
  resultSetConcurrency: ResultSetConcurrency? = null,
  resultSetType: ResultSetType? = null,
  schema: String? = null,
  transactionIsolation: TransactionIsolation? = null): SQLOptions = io.vertx.ext.sql.SQLOptions().apply {

  if (autoGeneratedKeys != null) {
    this.setAutoGeneratedKeys(autoGeneratedKeys)
  }
  if (autoGeneratedKeysIndexes != null) {
    this.setAutoGeneratedKeysIndexes(autoGeneratedKeysIndexes)
  }
  if (catalog != null) {
    this.setCatalog(catalog)
  }
  if (fetchDirection != null) {
    this.setFetchDirection(fetchDirection)
  }
  if (fetchSize != null) {
    this.setFetchSize(fetchSize)
  }
  if (queryTimeout != null) {
    this.setQueryTimeout(queryTimeout)
  }
  if (readOnly != null) {
    this.setReadOnly(readOnly)
  }
  if (resultSetConcurrency != null) {
    this.setResultSetConcurrency(resultSetConcurrency)
  }
  if (resultSetType != null) {
    this.setResultSetType(resultSetType)
  }
  if (schema != null) {
    this.setSchema(schema)
  }
  if (transactionIsolation != null) {
    this.setTransactionIsolation(transactionIsolation)
  }
}

