/**
 *  Copyright 2010 Wallace Wadge
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
/**
 * 
 */
package com.jolbox.bonecp;

import static org.junit.Assert.*;

import java.sql.Connection;
import java.sql.SQLException;

import org.junit.Test;

/** Tests for AbstractConnectionStrategy
 * @author wwadge
 *
 */
public class TestAbstractConnectionStrategy {

	@Test
	public void testCoverage() {
		@SuppressWarnings("serial")
		class X extends AbstractConnectionStrategy{
				public void terminateAllConnections() {
				}

				protected Connection getConnectionInternal() throws SQLException {
					return null;
				}
			}
		
		assertNull(new X().pollConnection());
	}

}
