/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.filecache;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.ReaderUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import com.mchange.v3.filecache.URLFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum URLFetchers implements URLFetcher
{
    DEFAULT{

        public InputStream openStream(URL u, MLogger logger) throws IOException {
            return u.openStream();
        }
    }
    ,
    BUFFERED_WGET{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public InputStream openStream(URL u, MLogger logger) throws IOException {
            Process p = new ProcessBuilder("wget", "-O", "-", u.toString()).start();
            BufferedInputStream is = null;
            is = new BufferedInputStream(p.getInputStream(), 0x100000);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
            int b = ((InputStream)is).read();
            while (b >= 0) {
                baos.write(b);
                b = ((InputStream)is).read();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            Object var8_8 = null;
            InputStreamUtils.attemptClose(is);
            if (logger.isLoggable(MLevel.FINER)) {
                BufferedReader errReader = null;
                try {
                    errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()), 0x100000);
                    StringWriter writer = new StringWriter(0x100000);
                    int c = ((Reader)errReader).read();
                    while (c >= 0) {
                        writer.write(c);
                        c = ((Reader)errReader).read();
                    }
                    logger.log(MLevel.FINER, "wget error stream for '" + u + "':\n " + writer.toString());
                    Object var13_18 = null;
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    ReaderUtils.attemptClose(errReader);
                    throw throwable;
                }
                ReaderUtils.attemptClose(errReader);
                {
                }
            }
            try {
                int check = p.waitFor();
                if (check != 0) {
                    throw new IOException("wget process terminated abnormally [return code: " + check + "]");
                }
            }
            catch (InterruptedException e) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "InterruptedException while waiting for wget to complete.", e);
                }
                throw new IOException("Interrupted while waiting for wget to complete: " + e);
            }
            return byteArrayInputStream;
            catch (Throwable throwable) {
                Object var8_9 = null;
                InputStreamUtils.attemptClose(is);
                if (logger.isLoggable(MLevel.FINER)) {
                    BufferedReader errReader = null;
                    try {
                        errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()), 0x100000);
                        StringWriter writer = new StringWriter(0x100000);
                        int c = ((Reader)errReader).read();
                        while (c >= 0) {
                            writer.write(c);
                            c = ((Reader)errReader).read();
                        }
                        logger.log(MLevel.FINER, "wget error stream for '" + u + "':\n " + writer.toString());
                        Object var13_20 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var13_21 = null;
                        ReaderUtils.attemptClose(errReader);
                        throw throwable2;
                    }
                    ReaderUtils.attemptClose(errReader);
                    {
                    }
                }
                try {
                    int check = p.waitFor();
                    if (check != 0) {
                        throw new IOException("wget process terminated abnormally [return code: " + check + "]");
                    }
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "InterruptedException while waiting for wget to complete.", e);
                    }
                    throw new IOException("Interrupted while waiting for wget to complete: " + e);
                }
                throw throwable;
            }
        }
    };

}

