/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.pool;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.JdbcInterceptor;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.interceptor.ConnectionState;

public class PooledConnection {
    private static final Log log = LogFactory.getLog(PooledConnection.class);
    protected static AtomicInteger counter = new AtomicInteger(1);
    public static final int VALIDATE_BORROW = 1;
    public static final int VALIDATE_RETURN = 2;
    public static final int VALIDATE_IDLE = 3;
    public static final int VALIDATE_INIT = 4;
    protected PoolConfiguration poolProperties;
    private volatile Connection connection;
    private volatile XAConnection xaConnection;
    private String abandonTrace = null;
    private volatile long timestamp;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private volatile boolean discarded = false;
    private volatile long lastConnected = -1L;
    private volatile long lastValidated = System.currentTimeMillis();
    private int instanceCount = 0;
    protected ConnectionPool parent;
    private volatile JdbcInterceptor handler = null;
    private AtomicBoolean released = new AtomicBoolean(false);
    private volatile boolean suspect = false;

    public PooledConnection(PoolConfiguration prop, ConnectionPool parent) {
        this.instanceCount = counter.addAndGet(1);
        this.poolProperties = prop;
        this.parent = parent;
    }

    public void connect() throws SQLException {
        if (this.released.get()) {
            throw new SQLException("A connection once released, can't be reestablished.");
        }
        if (this.connection != null) {
            try {
                this.disconnect(false);
            }
            catch (Exception x) {
                log.debug((Object)"Unable to disconnect previous connection.", (Throwable)x);
            }
        }
        if (this.poolProperties.getDataSource() != null || this.poolProperties.getDataSourceJNDI() != null) {
            // empty if block
        }
        if (this.poolProperties.getDataSource() != null) {
            this.connectUsingDataSource();
        } else {
            this.connectUsingDriver();
        }
        if (this.poolProperties.getJdbcInterceptors() == null || this.poolProperties.getJdbcInterceptors().indexOf(ConnectionState.class.getName()) < 0) {
            if (this.poolProperties.getDefaultReadOnly() != null) {
                this.connection.setReadOnly(this.poolProperties.getDefaultReadOnly());
            }
            if (this.poolProperties.getDefaultAutoCommit() != null) {
                this.connection.setAutoCommit(this.poolProperties.getDefaultAutoCommit());
            }
            if (this.poolProperties.getDefaultCatalog() != null) {
                this.connection.setCatalog(this.poolProperties.getDefaultCatalog());
            }
            if (this.poolProperties.getDefaultTransactionIsolation() != -1) {
                this.connection.setTransactionIsolation(this.poolProperties.getDefaultTransactionIsolation());
            }
        }
        this.discarded = false;
        this.lastConnected = System.currentTimeMillis();
    }

    protected void connectUsingDataSource() throws SQLException {
        if (this.poolProperties.getDataSource() instanceof XADataSource) {
            XADataSource xds = (XADataSource)this.poolProperties.getDataSource();
            if (this.poolProperties.getUsername() != null && this.poolProperties.getPassword() != null) {
                this.xaConnection = xds.getXAConnection(this.poolProperties.getUsername(), this.poolProperties.getPassword());
                this.connection = this.xaConnection.getConnection();
            } else {
                this.xaConnection = xds.getXAConnection();
                this.connection = this.xaConnection.getConnection();
            }
        } else if (this.poolProperties.getDataSource() instanceof DataSource) {
            DataSource ds = (DataSource)this.poolProperties.getDataSource();
            this.connection = this.poolProperties.getUsername() != null && this.poolProperties.getPassword() != null ? ds.getConnection(this.poolProperties.getUsername(), this.poolProperties.getPassword()) : ds.getConnection();
        } else if (this.poolProperties.getDataSource() instanceof ConnectionPoolDataSource) {
            ConnectionPoolDataSource ds = (ConnectionPoolDataSource)this.poolProperties.getDataSource();
            this.connection = this.poolProperties.getUsername() != null && this.poolProperties.getPassword() != null ? ds.getPooledConnection(this.poolProperties.getUsername(), this.poolProperties.getPassword()).getConnection() : ds.getPooledConnection().getConnection();
        } else {
            throw new SQLException("DataSource is of unknown class:" + (this.poolProperties.getDataSource() != null ? this.poolProperties.getDataSource().getClass() : "null"));
        }
    }

    protected void connectUsingDriver() throws SQLException {
        Driver driver = null;
        try {
            driver = (Driver)Class.forName(this.poolProperties.getDriverClassName(), true, PooledConnection.class.getClassLoader()).newInstance();
        }
        catch (Exception cn) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to instantiate JDBC driver.", (Throwable)cn);
            }
            SQLException ex = new SQLException(cn.getMessage());
            ex.initCause(cn);
            throw ex;
        }
        String driverURL = this.poolProperties.getUrl();
        String usr = this.poolProperties.getUsername();
        String pwd = this.poolProperties.getPassword();
        this.poolProperties.getDbProperties().setProperty("user", usr);
        this.poolProperties.getDbProperties().setProperty("password", pwd);
        try {
            this.connection = driver.connect(driverURL, this.poolProperties.getDbProperties());
        }
        catch (Exception x) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to connect to database.", (Throwable)x);
            }
            if (this.parent.jmxPool != null) {
                this.parent.jmxPool.notify("CONNECTION FAILED", ConnectionPool.getStackTrace(x));
            }
            if (x instanceof SQLException) {
                throw (SQLException)x;
            }
            SQLException ex = new SQLException(x.getMessage());
            ex.initCause(x);
            throw ex;
        }
        if (this.connection == null) {
            throw new SQLException("Driver:" + driver + " returned null for URL:" + driverURL);
        }
    }

    public boolean isInitialized() {
        return this.connection != null;
    }

    public void reconnect() throws SQLException {
        this.disconnect(false);
        this.connect();
    }

    private void disconnect(boolean finalize) {
        block5: {
            if (this.isDiscarded()) {
                return;
            }
            this.setDiscarded(true);
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ignore) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)"Unable to close underlying SQL connection", (Throwable)ignore);
                }
            }
        }
        this.connection = null;
        this.xaConnection = null;
        this.lastConnected = -1L;
        if (finalize) {
            this.parent.finalize(this);
        }
    }

    public long getAbandonTimeout() {
        if (this.poolProperties.getRemoveAbandonedTimeout() <= 0) {
            return Long.MAX_VALUE;
        }
        return this.poolProperties.getRemoveAbandonedTimeout() * 1000;
    }

    private boolean doValidate(int action) {
        if (action == 1 && this.poolProperties.isTestOnBorrow()) {
            return true;
        }
        if (action == 2 && this.poolProperties.isTestOnReturn()) {
            return true;
        }
        if (action == 3 && this.poolProperties.isTestWhileIdle()) {
            return true;
        }
        if (action == 4 && this.poolProperties.isTestOnConnect()) {
            return true;
        }
        return action == 4 && this.poolProperties.getInitSQL() != null;
    }

    public boolean validate(int validateAction) {
        return this.validate(validateAction, null);
    }

    public boolean validate(int validateAction, String sql) {
        String query;
        if (this.isDiscarded()) {
            return false;
        }
        if (!this.doValidate(validateAction)) {
            return true;
        }
        String string = query = 4 == validateAction && this.poolProperties.getInitSQL() != null ? this.poolProperties.getInitSQL() : sql;
        if (query == null) {
            query = this.poolProperties.getValidationQuery();
        }
        if (query == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.poolProperties.getValidationInterval() > 0L && validateAction != 4 && now - this.lastValidated < this.poolProperties.getValidationInterval()) {
            return true;
        }
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.execute(query);
            stmt.close();
            this.lastValidated = now;
            return true;
        }
        catch (Exception ignore) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to validate object:", (Throwable)ignore);
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public long getReleaseTime() {
        return this.poolProperties.getMinEvictableIdleTimeMillis();
    }

    public boolean release() {
        block2: {
            try {
                this.disconnect(true);
            }
            catch (Exception x) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Unable to close SQL connection", (Throwable)x);
            }
        }
        return this.released.compareAndSet(false, true);
    }

    public void setStackTrace(String trace) {
        this.abandonTrace = trace;
    }

    public String getStackTrace() {
        return this.abandonTrace;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setSuspect(false);
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public void setDiscarded(boolean discarded) {
        if (this.discarded && !discarded) {
            throw new IllegalStateException("Unable to change the state once the connection has been discarded");
        }
        this.discarded = discarded;
    }

    public void setLastValidated(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    public void setPoolProperties(PoolConfiguration poolProperties) {
        this.poolProperties = poolProperties;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public void lock() {
        if (this.poolProperties.getUseLock() || this.poolProperties.isPoolSweeperEnabled()) {
            this.lock.writeLock().lock();
        }
    }

    public void unlock() {
        if (this.poolProperties.getUseLock() || this.poolProperties.isPoolSweeperEnabled()) {
            this.lock.writeLock().unlock();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public XAConnection getXAConnection() {
        return this.xaConnection;
    }

    public long getLastConnected() {
        return this.lastConnected;
    }

    public JdbcInterceptor getHandler() {
        return this.handler;
    }

    public void setHandler(JdbcInterceptor handler) {
        if (this.handler != null && this.handler != handler) {
            for (JdbcInterceptor interceptor = this.handler; interceptor != null; interceptor = interceptor.getNext()) {
                interceptor.reset(null, null);
            }
        }
        this.handler = handler;
    }

    public String toString() {
        return "PooledConnection[" + (this.connection != null ? this.connection.toString() : "null") + "]";
    }

    public boolean isReleased() {
        return this.released.get();
    }
}

