/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeWrapper<E> {
    private E obj;
    private long expiryTime = 0L;
    private long accessed = System.currentTimeMillis();

    public TimeWrapper(E obj, long expiryTime) {
        this.obj = obj;
        if (expiryTime > 0L) {
            this.expiryTime = System.currentTimeMillis() + expiryTime;
        }
    }

    public E getObject() {
        return this.obj;
    }

    public synchronized boolean isExpired() {
        return this.expiryTime > 0L && System.currentTimeMillis() > this.expiryTime;
    }

    synchronized void setLiveTime(long expiryTime) {
        if (expiryTime < 0L) {
            throw new IllegalArgumentException("Invalid expiry time");
        }
        if (expiryTime > 0L) {
            this.expiryTime = System.currentTimeMillis() + expiryTime;
        } else {
            expiryTime = 0L;
        }
    }

    synchronized void updateAccessed() {
        this.accessed = System.currentTimeMillis();
    }

    long getAccessed() {
        return this.accessed;
    }
}

