/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class ThreadPerTaskAsynchronousRunner
implements AsynchronousRunner {
    static final int PRESUME_DEADLOCKED_MULTIPLE = 3;
    static final MLogger logger = MLog.getLogger(ThreadPerTaskAsynchronousRunner.class);
    final int max_task_threads;
    final long interrupt_task_delay;
    LinkedList queue = new LinkedList();
    ArrayList running = new ArrayList();
    ArrayList deadlockSnapshot = null;
    boolean still_open = true;
    Thread dispatchThread = new DispatchThread();
    Timer interruptAndDeadlockTimer;

    public ThreadPerTaskAsynchronousRunner(int max_task_threads) {
        this(max_task_threads, 0L);
    }

    public ThreadPerTaskAsynchronousRunner(int max_task_threads, long interrupt_task_delay) {
        this.max_task_threads = max_task_threads;
        this.interrupt_task_delay = interrupt_task_delay;
        if (this.hasIdTimer()) {
            this.interruptAndDeadlockTimer = new Timer(true);
            TimerTask deadlockChecker = new TimerTask(){

                public void run() {
                    ThreadPerTaskAsynchronousRunner.this.checkForDeadlock();
                }
            };
            long delay = interrupt_task_delay * 3L;
            this.interruptAndDeadlockTimer.schedule(deadlockChecker, delay, delay);
        }
        this.dispatchThread.start();
    }

    private boolean hasIdTimer() {
        return this.interrupt_task_delay > 0L;
    }

    public synchronized void postRunnable(Runnable r) {
        if (!this.still_open) {
            throw new ResourceClosedException("Attempted to use a ThreadPerTaskAsynchronousRunner in a closed or broken state.");
        }
        this.queue.add(r);
        this.notifyAll();
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean skip_remaining_tasks) {
        if (this.still_open) {
            this.still_open = false;
            if (skip_remaining_tasks) {
                this.queue.clear();
                Iterator ii = this.running.iterator();
                while (ii.hasNext()) {
                    ((Thread)ii.next()).interrupt();
                }
                this.closeThreadResources();
            }
        }
    }

    public synchronized int getRunningCount() {
        return this.running.size();
    }

    public synchronized Collection getRunningTasks() {
        return (Collection)this.running.clone();
    }

    public synchronized int getWaitingCount() {
        return this.queue.size();
    }

    public synchronized Collection getWaitingTasks() {
        return (Collection)this.queue.clone();
    }

    public synchronized boolean isClosed() {
        return !this.still_open;
    }

    public synchronized boolean isDoneAndGone() {
        return !this.dispatchThread.isAlive() && this.running.isEmpty() && this.interruptAndDeadlockTimer == null;
    }

    private synchronized void acknowledgeComplete(TaskThread tt) {
        if (!tt.isCompleted()) {
            this.running.remove(tt);
            tt.markCompleted();
            this.notifyAll();
            if (!this.still_open && this.queue.isEmpty() && this.running.isEmpty()) {
                this.closeThreadResources();
            }
        }
    }

    private synchronized void checkForDeadlock() {
        if (this.deadlockSnapshot == null) {
            if (this.running.size() == this.max_task_threads) {
                this.deadlockSnapshot = (ArrayList)this.running.clone();
            }
        } else if (this.running.size() < this.max_task_threads) {
            this.deadlockSnapshot = null;
        } else if (this.deadlockSnapshot.equals(this.running)) {
            if (logger.isLoggable(MLevel.WARNING)) {
                StringBuffer warningMsg = new StringBuffer(1024);
                warningMsg.append("APPARENT DEADLOCK! (");
                warningMsg.append(this);
                warningMsg.append(") Deadlocked threads (unresponsive to interrupt()) are being set aside as hopeless and up to ");
                warningMsg.append(this.max_task_threads);
                warningMsg.append(" may now be spawned for new tasks. If tasks continue to deadlock, you may run out of memory. Deadlocked task list: ");
                int len = this.deadlockSnapshot.size();
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        warningMsg.append(", ");
                    }
                    warningMsg.append(((TaskThread)this.deadlockSnapshot.get(i)).getTask());
                }
                logger.log(MLevel.WARNING, warningMsg.toString());
            }
            int len = this.deadlockSnapshot.size();
            for (int i = 0; i < len; ++i) {
                this.acknowledgeComplete((TaskThread)this.deadlockSnapshot.get(i));
            }
            this.deadlockSnapshot = null;
        } else {
            this.deadlockSnapshot = (ArrayList)this.running.clone();
        }
    }

    private void closeThreadResources() {
        if (this.interruptAndDeadlockTimer != null) {
            this.interruptAndDeadlockTimer.cancel();
            this.interruptAndDeadlockTimer = null;
        }
        this.dispatchThread.interrupt();
    }

    class TaskThread
    extends Thread {
        Runnable r;
        boolean completed;

        TaskThread(Runnable r) {
            super("Task-Thread-for-" + ThreadPerTaskAsynchronousRunner.this);
            this.completed = false;
            this.r = r;
        }

        Runnable getTask() {
            return this.r;
        }

        synchronized void markCompleted() {
            this.completed = true;
        }

        synchronized boolean isCompleted() {
            return this.completed;
        }

        public void run() {
            try {
                if (ThreadPerTaskAsynchronousRunner.this.hasIdTimer()) {
                    TimerTask interruptTask = new TimerTask(){

                        public void run() {
                            TaskThread.this.interrupt();
                        }
                    };
                    ThreadPerTaskAsynchronousRunner.this.interruptAndDeadlockTimer.schedule(interruptTask, ThreadPerTaskAsynchronousRunner.this.interrupt_task_delay);
                }
                this.r.run();
            }
            finally {
                ThreadPerTaskAsynchronousRunner.this.acknowledgeComplete(this);
            }
        }
    }

    class DispatchThread
    extends Thread {
        DispatchThread() {
            super("Dispatch-Thread-for-" + ThreadPerTaskAsynchronousRunner.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadPerTaskAsynchronousRunner threadPerTaskAsynchronousRunner = ThreadPerTaskAsynchronousRunner.this;
            synchronized (threadPerTaskAsynchronousRunner) {
                try {
                    while (true) {
                        if (ThreadPerTaskAsynchronousRunner.this.queue.isEmpty() || ThreadPerTaskAsynchronousRunner.this.running.size() == ThreadPerTaskAsynchronousRunner.this.max_task_threads) {
                            ThreadPerTaskAsynchronousRunner.this.wait();
                            continue;
                        }
                        Runnable next = (Runnable)ThreadPerTaskAsynchronousRunner.this.queue.remove(0);
                        TaskThread doer = new TaskThread(next);
                        doer.start();
                        ThreadPerTaskAsynchronousRunner.this.running.add(doer);
                    }
                }
                catch (InterruptedException e) {
                    if (ThreadPerTaskAsynchronousRunner.this.still_open) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, this.getName() + " unexpectedly interrupted! Shutting down!");
                        }
                        ThreadPerTaskAsynchronousRunner.this.close(false);
                    }
                }
            }
        }
    }
}

