/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.apicover.RefCounter;
import com.sun.tdk.apicover.ReportGenerator;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.PackageDescr;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ReportXML
extends ReportGenerator {
    TransformerHandler ser;
    Erasurator erasurator = new Erasurator();

    public ReportXML(RefCounter reporter) {
        super(reporter);
    }

    public void printHead() {
        this.startElement("head", new String[0]);
        for (String key : this.config.keySet()) {
            for (String value : (String[])this.config.get(key)) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "", "name", "", key);
                atts.addAttribute("", "", "value", "", value);
                this.startElement("property", atts);
                this.endElement("property");
            }
        }
        this.endElement("head");
    }

    public void print() {
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        stf.setAttribute("indent-number", 4);
        Properties outputProps = new Properties();
        outputProps.put("indent", "yes");
        outputProps.put("encoding", "UTF-8");
        try {
            this.ser = stf.newTransformerHandler();
            this.ser.getTransformer().setOutputProperties(outputProps);
            StreamResult result = new StreamResult(this.pw);
            this.ser.setResult(result);
            this.ser.startDocument();
            this.startElement("report", new String[0]);
            this.printHead();
            this.visit(this.api);
            this.endElement("report");
            this.ser.endDocument();
            this.pw.flush();
            this.pw.close();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    protected void visit(PackageDescr pd) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "", pd.getName());
        atts.addAttribute("", "", "members", "", String.valueOf(((ReportGenerator.Field)this.results.get((Object)pd.toString())).members));
        atts.addAttribute("", "", "tested", "", String.valueOf(((ReportGenerator.Field)this.results.get((Object)pd.toString())).tested));
        this.startElement("package", atts);
        super.visit(pd);
        this.endElement("package");
    }

    protected void visit(ClassDescription cd) {
        String[] modifiers;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "", this.constructClassName(cd));
        if (cd.getTypeParameters() != null) {
            atts.addAttribute("", "", "typeArgs", "", cd.getTypeParameters());
        }
        for (String modifier : modifiers = Modifier.toString(cd.getMemberType(), cd.getModifiers(), false).split(" ")) {
            if (modifier.startsWith("!") || modifier.startsWith("acc_")) continue;
            atts.addAttribute("", "", modifier, "", "true");
        }
        atts.addAttribute("", "", "members", "", String.valueOf(((ReportGenerator.Field)this.results.get((Object)cd.toString())).members));
        atts.addAttribute("", "", "tested", "", String.valueOf(((ReportGenerator.Field)this.results.get((Object)cd.toString())).tested));
        this.startElement("class", atts);
        this.erasurator.parseTypeParameters(cd);
        super.visit(cd);
        this.endElement("class");
    }

    private String constructClassName(ClassDescription cd) {
        int pos = cd.getQualifiedName().lastIndexOf(46);
        if (pos == -1) {
            return cd.getName();
        }
        return cd.getQualifiedName().substring(++pos);
    }

    protected void visit(MemberDescription x) {
        this.printMember(x, this.refCounter.isCovered(x));
    }

    private static String convertArgsToVM(String str) {
        String[] types = str.split(",");
        StringBuffer result = new StringBuffer("(");
        for (String type : types) {
            result.append(ReportXML.convertTypeToVM(type));
        }
        result.append(")");
        return result.toString();
    }

    private static String convertTypeToVM(String type) {
        String res = PrimitiveTypes.getVMPrimitiveType(type);
        if (res != null) {
            return res;
        }
        return type.length() == 0 ? "" : "L" + type.replace('.', '/') + ";";
    }

    void printMember(MemberDescription md, boolean isCovered) {
        String[] modifiers;
        String type = md.getMemberType().toString();
        String sig = md.isField() ? md.getType() : (md.isConstructor() ? "(" + md.getArgs() + ")" : "(" + md.getArgs() + ")" + md.getType());
        md = this.erasurator.processMember(md);
        String vmsig = md.isField() ? ReportXML.convertTypeToVM(md.getType()) : (md.isConstructor() ? ReportXML.convertArgsToVM(md.getArgs()) : ReportXML.convertArgsToVM(md.getArgs()) + ReportXML.convertTypeToVM(md.getType()));
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "", md.getName());
        atts.addAttribute("", "", "vmsig", "", vmsig);
        atts.addAttribute("", "", "sig", "", sig);
        for (String modifier : modifiers = Modifier.toString(md.getMemberType(), md.getModifiers(), false).split(" ")) {
            if (modifier.startsWith("!") || modifier.startsWith("acc_")) continue;
            atts.addAttribute("", "", modifier, "", "true");
        }
        atts.addAttribute("", "", "tested", "", isCovered ? "1" : "0");
        this.startElement(type, atts);
        this.endElement(type);
    }

    private void startElement(String name, AttributesImpl attrs) {
        try {
            this.ser.startElement("", "", name, attrs);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void startElement(String name, String ... attrs) {
        AttributesImpl attrImpl = new AttributesImpl();
        assert (attrs.length % 2 == 0);
        for (int i = 0; i < attrs.length; i += 2) {
            attrImpl.addAttribute("", "'", attrs[i], "", attrs[i + 1]);
        }
        try {
            this.ser.startElement("", "", name, attrImpl);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void endElement(String name) {
        try {
            this.ser.endElement("", "", name);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

