/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.parser;

import java.util.Vector;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.axis.AttributeAxis;
import jd.xml.xpath.axis.Axis;
import jd.xml.xpath.axis.AxisLibrary;
import jd.xml.xpath.axis.ChildAxis;
import jd.xml.xpath.axis.DescendantAxis;
import jd.xml.xpath.axis.DescendantOrSelfAxis;
import jd.xml.xpath.axis.NodeNameTest;
import jd.xml.xpath.axis.NodeTest;
import jd.xml.xpath.axis.NodeTestUnion;
import jd.xml.xpath.axis.NodeTypeTest;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.compare.CompareFactory;
import jd.xml.xpath.expr.function.Average;
import jd.xml.xpath.expr.function.Count;
import jd.xml.xpath.expr.function.Function;
import jd.xml.xpath.expr.function.Sum;
import jd.xml.xpath.expr.misc.Constant;
import jd.xml.xpath.expr.misc.Negate;
import jd.xml.xpath.expr.misc.ParenthesisExpression;
import jd.xml.xpath.expr.misc.VariableReference;
import jd.xml.xpath.expr.operator.Add;
import jd.xml.xpath.expr.operator.And;
import jd.xml.xpath.expr.operator.Divide;
import jd.xml.xpath.expr.operator.Modulo;
import jd.xml.xpath.expr.operator.Multiply;
import jd.xml.xpath.expr.operator.Or;
import jd.xml.xpath.expr.operator.Subtract;
import jd.xml.xpath.expr.operator.Union;
import jd.xml.xpath.expr.path.AbbreviatedPaths;
import jd.xml.xpath.expr.path.ComposedPath;
import jd.xml.xpath.expr.path.FilteredLocationStep;
import jd.xml.xpath.expr.path.LocationStep;
import jd.xml.xpath.expr.path.LocationStepChain;
import jd.xml.xpath.expr.path.PredicateExpression;
import jd.xml.xpath.expr.path.RootPath;
import jd.xml.xpath.expr.path.SimpleLocationStep;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XString;
import jd.xml.xpath.parser.Scanner;
import jd.xml.xpath.parser.TokenConstants;
import jd.xml.xpath.parser.XPathParseContext;
import jd.xml.xpath.parser.XPathParseException;

public class ExpressionParser
implements TokenConstants {
    private XPathParseContext context_;

    public ExpressionParser() {
        this(new XPathParseContext());
    }

    public ExpressionParser(XPathParseContext xPathParseContext) {
        if (xPathParseContext == null) {
            throw new IllegalArgumentException("parse context is null");
        }
        this.context_ = xPathParseContext;
    }

    public Expression parseExpression(String string) throws XPathParseException {
        Scanner scanner = new Scanner(string);
        scanner.nextToken();
        Expression expression = this.parseExpression(scanner);
        if (!scanner.matchToken(27)) {
            throw scanner.createParseException("more tokens left at end of expression (next is " + scanner.getTokenString() + ")");
        }
        return expression;
    }

    public Expression parseExpression(Scanner scanner) throws XPathParseException {
        return this.parseOrExpr(scanner);
    }

    private Expression parseOrExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parseAndExpr(scanner);
        while (scanner.consumeToken(22, "or")) {
            expression = new Or(expression, this.parseAndExpr(scanner));
        }
        return expression;
    }

    private Expression parseAndExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parseEqualityExpr(scanner);
        while (scanner.consumeToken(22, "and")) {
            expression = new And(expression, this.parseEqualityExpr(scanner));
        }
        return expression;
    }

    private Expression parseEqualityExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parseRelationalExpr(scanner);
        while (true) {
            Equality equality;
            if (scanner.consumeToken(11)) {
                equality = Equality.EQUAL;
            } else {
                if (!scanner.consumeToken(12)) break;
                equality = Equality.NOT_EQUAL;
            }
            expression = CompareFactory.createEquals(expression, equality, this.parseRelationalExpr(scanner));
        }
        return expression;
    }

    private Expression parseRelationalExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parseAdditiveExpr(scanner);
        while (true) {
            Relation relation;
            if (scanner.consumeToken(5)) {
                relation = Relation.LESS;
            } else if (scanner.consumeToken(6)) {
                relation = Relation.LESS_EQUALS;
            } else if (scanner.consumeToken(7)) {
                relation = Relation.GREATER;
            } else {
                if (!scanner.consumeToken(8)) break;
                relation = Relation.GREATER_EQUALS;
            }
            expression = CompareFactory.createRelate(expression, relation, this.parseAdditiveExpr(scanner));
        }
        return expression;
    }

    private Expression parseAdditiveExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parseMultiplicativeExpr(scanner);
        while (true) {
            if (scanner.consumeToken(14)) {
                expression = new Add(expression, this.parseMultiplicativeExpr(scanner));
                continue;
            }
            if (!scanner.consumeToken(15)) break;
            expression = new Subtract(expression, this.parseMultiplicativeExpr(scanner));
        }
        return expression;
    }

    private Expression parseMultiplicativeExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parseUnaryExpr(scanner);
        while (true) {
            String string;
            Expression expression2;
            String string2;
            if (scanner.consumeToken(16)) {
                expression = new Multiply(expression, this.parseUnaryExpr(scanner));
                continue;
            }
            if (scanner.consumeToken(22, "mod")) {
                expression = new Modulo(expression, this.parseUnaryExpr(scanner));
                continue;
            }
            if (!scanner.consumeToken(22, "div")) break;
            Expression expression3 = expression;
            Expression expression4 = this.parseUnaryExpr(scanner);
            expression = null;
            if (expression3 instanceof Sum && expression4 instanceof Count && (string2 = ((Object)(expression2 = ((Function)expression3).getArgument(0))).toString()).equals(string = ((Object)((Function)expression4).getArgument(0)).toString())) {
                Average average = new Average();
                average.setArguments(new Expression[]{expression2});
                expression = average;
            }
            if (expression != null) continue;
            expression = new Divide(expression3, expression4);
        }
        return expression;
    }

    private Expression parseUnaryExpr(Scanner scanner) throws XPathParseException {
        if (scanner.consumeToken(15)) {
            return new Negate(this.parseUnaryExpr(scanner));
        }
        return this.parseUnionExpr(scanner);
    }

    private Expression parseUnionExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parsePathExpr(scanner);
        while (scanner.consumeToken(13)) {
            Expression expression2 = this.parsePathExpr(scanner);
            if (expression instanceof SimpleLocationStep && expression2 instanceof SimpleLocationStep) {
                SimpleLocationStep simpleLocationStep = (SimpleLocationStep)expression;
                SimpleLocationStep simpleLocationStep2 = (SimpleLocationStep)expression2;
                if (simpleLocationStep.getAxis() == simpleLocationStep2.getAxis()) {
                    NodeTestUnion nodeTestUnion = new NodeTestUnion(simpleLocationStep.getNodeTest(), simpleLocationStep2.getNodeTest());
                    expression = new SimpleLocationStep(simpleLocationStep.getAxis(), nodeTestUnion);
                    continue;
                }
            }
            expression = new Union(expression, expression2);
        }
        return expression;
    }

    private Expression parsePathExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parsePossibleLocationPath(scanner);
        if (expression == null) {
            expression = this.parseFilterExpr(scanner);
        }
        while (true) {
            if (scanner.consumeToken(9)) {
                Expression expression2 = this.parseRelativeLocationPath(scanner);
                expression = this.createComposedPath(expression, expression2);
                continue;
            }
            if (!scanner.consumeToken(10)) break;
            expression = this.createComposedPath(expression, AbbreviatedPaths.DESCENDANT_OR_SELF_NODE);
            expression = this.createComposedPath(expression, this.parseRelativeLocationPath(scanner));
        }
        return expression;
    }

    private Expression createComposedPath(Expression expression, Expression expression2) {
        if (expression2 instanceof LocationStep) {
            SimpleLocationStep simpleLocationStep;
            ComposedPath composedPath;
            LocationStep locationStep = (LocationStep)expression2;
            LocationStepChain locationStepChain = LocationStepChain.create(expression, locationStep);
            if (locationStepChain != null) {
                return locationStepChain;
            }
            if (expression instanceof ComposedPath && locationStep instanceof SimpleLocationStep && (composedPath = (ComposedPath)expression).getRhs() instanceof SimpleLocationStep && (simpleLocationStep = (SimpleLocationStep)composedPath.getRhs()).getAxis() == DescendantOrSelfAxis.INSTANCE && simpleLocationStep.getNodeTest() == NodeTypeTest.ALL && locationStep.getAxis() == ChildAxis.INSTANCE) {
                expression = composedPath.getLhs();
                expression2 = new SimpleLocationStep(DescendantAxis.INSTANCE, locationStep.getNodeTest());
            }
        }
        return new ComposedPath(expression, expression2);
    }

    private Expression parseFilterExpr(Scanner scanner) throws XPathParseException {
        Expression expression = this.parsePrimaryExpr(scanner);
        return this.parsePredicates(scanner, expression, true);
    }

    private Expression parsePrimaryExpr(Scanner scanner) throws XPathParseException {
        switch (scanner.token) {
            case 24: {
                Constant constant = new Constant(new XString(scanner.value));
                scanner.nextToken();
                return constant;
            }
            case 25: {
                Constant constant = new Constant(new XNumber(XString.toNumberValue(scanner.value)));
                scanner.nextToken();
                return constant;
            }
            case 23: {
                return this.parseVariableReference(scanner);
            }
            case 22: {
                return this.parseNameExpression(scanner);
            }
            case 16: {
                return this.parseRelativeLocationPath(scanner);
            }
            case 1: {
                scanner.nextToken();
                Expression expression = this.parseExpression(scanner);
                scanner.consumeExpectedToken(2);
                return new ParenthesisExpression(expression);
            }
        }
        throw scanner.createParseException("cannot parse PrimaryExpr from token '" + scanner.getTokenString() + "'");
    }

    protected VariableReference parseVariableReference(Scanner scanner) throws XPathParseException {
        VariableName variableName;
        try {
            variableName = this.context_.getVariableName(scanner.value);
        }
        catch (Exception exception) {
            throw scanner.createParseException(exception.getMessage());
        }
        scanner.nextToken();
        return new VariableReference(variableName);
    }

    private Expression parseNameExpression(Scanner scanner) throws XPathParseException {
        String string = scanner.value;
        scanner.nextToken();
        NodeTest nodeTest = null;
        if (scanner.matchToken(1)) {
            if (NodeTypeTest.getTest(string, null) == null) {
                return this.parseFunctionCall(scanner, string);
            }
            nodeTest = this.parseNodeTypeTest(scanner, string);
        } else {
            nodeTest = this.parseNodeNameTest(scanner, string, true);
        }
        return this.parseLocationStep(scanner, ChildAxis.INSTANCE.getName(), nodeTest);
    }

    private Expression parseFunctionCall(Scanner scanner, String string) throws XPathParseException {
        scanner.consumeExpectedToken(1);
        Object[] objectArray = null;
        if (!scanner.matchToken(2)) {
            Vector<Expression> vector = new Vector<Expression>(3, 2);
            vector.addElement(this.parseExpression(scanner));
            while (scanner.consumeToken(26)) {
                vector.addElement(this.parseExpression(scanner));
            }
            objectArray = new Expression[vector.size()];
            vector.copyInto(objectArray);
        }
        scanner.consumeExpectedToken(2);
        return this.createFunction(scanner, string, (Expression[])objectArray);
    }

    protected Expression createFunction(Scanner scanner, String string, Expression[] expressionArray) throws XPathParseException {
        int n;
        Function function;
        try {
            function = this.context_.getFunctionLibrary().createFunction(string);
        }
        catch (Exception exception) {
            throw scanner.createParseException("cannot create function '" + string + "': " + exception.getMessage());
        }
        if (function == null) {
            throw scanner.createParseException("cannot create unknown function '" + string + "'");
        }
        int n2 = n = expressionArray == null ? 0 : expressionArray.length;
        if (!function.getFunctionType().checkArgumentCount(n)) {
            throw scanner.createParseException("function " + string + " does not take " + n + " arguments");
        }
        function.setArguments(expressionArray);
        return function;
    }

    private Expression parsePossibleLocationPath(Scanner scanner) throws XPathParseException {
        if (scanner.matchToken(9) || scanner.matchToken(10)) {
            Expression expression = RootPath.INSTANCE;
            if (scanner.matchToken(10)) {
                expression = this.createComposedPath(expression, AbbreviatedPaths.DESCENDANT_OR_SELF_NODE);
            }
            scanner.nextToken();
            Expression expression2 = this.parsePossibleRelativeLocationPath(scanner, true);
            if (expression2 != null) {
                return this.createComposedPath(expression, expression2);
            }
            return expression;
        }
        return this.parsePossibleRelativeLocationPath(scanner, false);
    }

    private Expression parseRelativeLocationPath(Scanner scanner) throws XPathParseException {
        Expression expression = this.parsePossibleRelativeLocationPath(scanner, true);
        if (expression == null) {
            throw scanner.createParseException("RelativeLocationPath expected");
        }
        return expression;
    }

    private Expression parsePossibleRelativeLocationPath(Scanner scanner, boolean bl) throws XPathParseException {
        if (scanner.consumeToken(19)) {
            return this.parsePredicates(scanner, AbbreviatedPaths.SELF_NODE);
        }
        if (scanner.consumeToken(20)) {
            return this.parsePredicates(scanner, AbbreviatedPaths.PARENT_NODE);
        }
        if (scanner.consumeToken(18)) {
            return this.parseLocationStep(scanner, AttributeAxis.INSTANCE.getName());
        }
        if (scanner.matchToken(21)) {
            String string = scanner.value;
            scanner.nextToken();
            return this.parseLocationStep(scanner, string);
        }
        if (bl && (scanner.matchToken(22) || scanner.matchToken(16))) {
            return this.parseLocationStep(scanner, ChildAxis.INSTANCE.getName());
        }
        return null;
    }

    private Expression parseLocationStep(Scanner scanner, String string) throws XPathParseException {
        NodeTest nodeTest = this.parseNodeTest(scanner);
        return this.parseLocationStep(scanner, string, nodeTest);
    }

    private Expression parseLocationStep(Scanner scanner, String string, NodeTest nodeTest) throws XPathParseException {
        Axis axis = AxisLibrary.INSTANCE.get(string);
        if (axis == null) {
            throw scanner.createParseException("Axis '" + string + "' unknown or invalid");
        }
        SimpleLocationStep simpleLocationStep = new SimpleLocationStep(axis, nodeTest);
        return this.parsePredicates(scanner, simpleLocationStep);
    }

    public NodeTest parseNodeTest(String string) throws XPathParseException {
        Scanner scanner = new Scanner(string);
        scanner.nextToken();
        return this.parseNodeTest(scanner);
    }

    protected NodeTest parseNodeTest(Scanner scanner) throws XPathParseException {
        NodeNameTest nodeNameTest = null;
        if (!scanner.matchToken(16)) {
            String string = scanner.value;
            scanner.consumeExpectedToken(22);
            return this.parseNodeTest(scanner, string);
        }
        nodeNameTest = this.parseNodeNameTest(scanner, null, true);
        scanner.nextToken();
        return nodeNameTest;
    }

    protected NodeTest parseNodeTest(Scanner scanner, String string) throws XPathParseException {
        return scanner.matchToken(1) ? this.parseNodeTypeTest(scanner, string) : this.parseNodeNameTest(scanner, string, true);
    }

    private NodeTest parseNodeTypeTest(Scanner scanner, String string) throws XPathParseException {
        scanner.consumeExpectedToken(1);
        String string2 = null;
        if (scanner.matchToken(24)) {
            string2 = scanner.value;
            scanner.nextToken();
        }
        scanner.consumeExpectedToken(2);
        NodeTypeTest nodeTypeTest = NodeTypeTest.getTest(string, string2);
        if (nodeTypeTest == null) {
            String string3 = "unknown node type test '" + string + "'";
            if (string2 != null) {
                string3 = string3 + " or invalid argument '" + string2 + "'";
            }
            throw scanner.createParseException(string3);
        }
        return nodeTypeTest;
    }

    public NodeNameTest parseNodeNameTest(Scanner scanner, String string, boolean bl) throws XPathParseException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string != null && !string.equals("*")) {
            int n = string.indexOf(58);
            if (n == -1) {
                string4 = string;
            } else {
                string3 = string.substring(0, n);
                string2 = this.getNamespaceUri(scanner, string3);
                string4 = string.substring(n + 1);
                if (string4.equals("*")) {
                    string4 = null;
                }
            }
        }
        NodeNamePool nodeNamePool = bl ? this.context_.getNodeNamePool() : null;
        return NodeNameTest.getTest(string2, string, string3, string4, nodeNamePool);
    }

    private Expression parsePredicates(Scanner scanner, LocationStep locationStep) throws XPathParseException {
        return this.parsePredicates(scanner, locationStep, locationStep.getAxis().isForwardAxis());
    }

    private Expression parsePredicates(Scanner scanner, Expression expression, boolean bl) throws XPathParseException {
        while (scanner.consumeToken(3)) {
            FilteredLocationStep filteredLocationStep;
            Expression expression2 = this.parseExpression(scanner);
            scanner.consumeExpectedToken(4);
            boolean bl2 = false;
            if (expression instanceof SimpleLocationStep && (filteredLocationStep = FilteredLocationStep.create((SimpleLocationStep)expression, expression2)) != null) {
                bl2 = true;
                expression = filteredLocationStep;
            }
            if (bl2) continue;
            expression = new PredicateExpression(expression, expression2, bl);
        }
        return expression;
    }

    protected String getNamespaceUri(Scanner scanner, String string) throws XPathParseException {
        String string2 = this.context_.getNamespaceUri(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = "no namespace uri defined for prefix '" + string + "'";
        if (scanner == null) {
            throw new XPathParseException(string, 0, string3);
        }
        throw scanner.createParseException(string3);
    }
}

