/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.xpath.XPathException;

public abstract class Pattern
implements Serializable {
    protected String originalText;
    private String systemId;
    private int lineNumber;

    public static Pattern make(String string, StaticContext staticContext) throws XPathException {
        Pattern pattern = new ExpressionParser().parsePattern(string, staticContext).simplify();
        pattern.setSystemId(staticContext.getSystemId());
        pattern.setLineNumber(staticContext.getLineNumber());
        pattern.setOriginalText(string);
        return pattern;
    }

    public void setOriginalText(String string) {
        this.originalText = string;
    }

    public Pattern simplify() throws XPathException {
        return this;
    }

    public Pattern typeCheck(StaticContext staticContext) throws XPathException {
        return this;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public abstract boolean matches(NodeInfo var1, Controller var2) throws XPathException;

    protected boolean internalMatches(NodeInfo nodeInfo, Controller controller) throws XPathException {
        return this.matches(nodeInfo, controller);
    }

    public int getNodeKind() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public abstract NodeTest getNodeTest();

    public double getDefaultPriority() {
        return 0.5;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return this.originalText;
    }
}

